<?php

/**
 * Vvveb
 *
 * Copyright (C) 2022  Ziadin Givan
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */

return
[
	//languages with translations first
	'zh_CN' => [
		'name'     => '简体中文 (Chinese)',
		'charset'  => 'UTF-8',
		'code'     => 'zh-cn',
		'emoji'    => '🇨🇳',
		'pack'	    => true,
	],
	'ar' => [
		'name'    => 'Arabic',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
		'pack'	   => true,
	],
	'de_DE' => [
		'name'    => 'German (Germany)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-de',
		'emoji'   => '🇩🇪',
		'pack'	   => true,
	],
	'en_US' => [
		'name'    => 'English (United States)',
		'charset' => 'UTF-8',
		'code'    => 'en-us',
		'emoji'   => '🇺🇸',
	],
	'fr_FR' => [
		'name'    => 'French (France)',
		'charset' => 'UTF-8',
		'code'    => 'fr-fr',
		'emoji'   => '🇫🇷',
		'pack'	   => true,
	],
	'it_IT' => [
		'name'    => 'Italian (Italy)',
		'charset' => 'ISO-8859-1',
		'code'    => 'it-it',
		'emoji'   => '🇮🇹',
		'pack'	   => true,
	],
	'pt_BR' => [
		'name'     => 'Portuguese (Brazil)',
		'charset'  => 'ISO-8859-1',
		'code'     => 'pt-br',
		'emoji'    => '🇵🇹',
		'pack'     => true,
	],
	'ro_RO' => [
		'name'    => 'Romanian (Romania)',
		'charset' => 'UTF-8',
		'code'    => 'ro-ro',
		'emoji'   => '🇷🇴',
		'pack'	   => true,
	],
	'ru_RU' => [
		'name'    => 'Russian (Russia)',
		'charset' => 'UTF-8',
		'code'    => 'ru-ru',
		'emoji'   => '🇷🇺',
		'pack'	   => true,
	],
	'es_ES' => [
		'name'    => 'Spanish (Spain)',
		'charset' => 'UTF-8',
		'code'    => 'es-es',
		'emoji'   => '🇪🇸',
		'pack'	   => true,
	],
	'tr_TR' => [
		'name'    => 'Turkish (Turkey)',
		'charset' => 'ISO-8859-9',
		'code'    => 'tr-tr',
		'emoji'   => '🇹🇷',
		'pack'	   => true,
	],
//---
	'af_NA' => [
		'name'    => 'Afrikaans (Namibia)',
		'charset' => 'UTF-8',
		'code'    => 'af-na',
		'emoji'   => '🇦🇫',
	],
	'af_ZA' => [
		'name'    => 'Afrikaans (South Africa)',
		'charset' => 'UTF-8',
		'code'    => 'af-za',
		'emoji'   => '🇦🇫',
	],
	'af' => [
		'name'    => 'Afrikaans',
		'charset' => 'UTF-8',
		'code'    => 'af',
		'emoji'   => '🇦🇫',
	],
	
	'ak_GH' => [
		'name'    => 'Akan (Ghana)',
		'charset' => 'UTF-8',
		'code'    => 'ak-gh',
	],
	'ak' => [
		'name'    => 'Akan',
		'charset' => 'UTF-8',
		'code'    => 'ak',
	],
	'sq_AL' => [
		'name'    => 'Albanian (Albania)',
		'charset' => 'UTF-8',
		'code'    => 'sq-al',
	],
	'sq' => [
		'name'    => 'Albanian',
		'charset' => 'UTF-8',
		'code'    => 'sq',
	],
	'am_ET' => [
		'name'    => 'Amharic (Ethiopia)',
		'charset' => 'UTF-8',
		'code'    => 'am-et',
		'emoji'   => '🇦🇲',
	],
	'am' => [
		'name'    => 'Amharic',
		'charset' => 'UTF-8',
		'code'    => 'am',
		'emoji'   => '🇦🇲',
	],
	'ar_DZ' => [
		'name'    => 'Arabic (Algeria)',
		'charset' => 'UTF-8',
		'code'    => 'ar-dz',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_BH' => [
		'name'    => 'Arabic (Bahrain)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-bh',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_EG' => [
		'name'    => 'Arabic (Egypt)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-eg',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_IQ' => [
		'name'    => 'Arabic (Iraq)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-iq',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_JO' => [
		'name'    => 'Arabic (Jordan)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-jo',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_KW' => [
		'name'    => 'Arabic (Kuwait)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-kw',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_LB' => [
		'name'    => 'Arabic (Lebanon)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-lb',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_LY' => [
		'name'    => 'Arabic (Libya)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-ly',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_MA' => [
		'name'    => 'Arabic (Morocco)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-ma',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_OM' => [
		'name'    => 'Arabic (Oman)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-om',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_QA' => [
		'name'    => 'Arabic (Qatar)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-qa',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_SA' => [
		'name'    => 'Arabic (Saudi Arabia)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-sa',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_SD' => [
		'name'    => 'Arabic (Sudan)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-sd',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_SY' => [
		'name'    => 'Arabic (Syria)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-sy',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_TN' => [
		'name'    => 'Arabic (Tunisia)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-tn',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_AE' => [
		'name'    => 'Arabic (United Arab Emirates)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-ae',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'ar_YE' => [
		'name'    => 'Arabic (Yemen)',
		'charset' => 'ISO-8859-6',
		'code'    => 'ar-ye',
		'rtl'     => true,
		'emoji'   => '🇦🇷',
	],
	'hy_AM' => [
		'name'    => 'Armenian (Armenia)',
		'charset' => 'ARMSCII-8',
		'code'    => 'hy-am',
	],
	'hy' => [
		'name'    => 'Armenian',
		'charset' => 'ARMSCII-8',
		'code'    => 'hy',
	],
	'as_IN' => [
		'name'    => 'Assamese (India)',
		'charset' => 'UTF-8',
		'code'    => 'as-in',
		'emoji'   => '🇦🇸',
	],
	'as' => [
		'name'    => 'Assamese',
		'charset' => 'UTF-8',
		'code'    => 'as',
		'emoji'   => '🇦🇸',
	],
	'asa_TZ' => [
		'name'    => 'Asu (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'asa-tz',
	],
	'asa' => [
		'name'    => 'Asu',
		'charset' => 'UTF-8',
		'code'    => 'asa',
	],
	'az_Cyrl' => [
		'name'    => 'Azerbaijani (Cyrillic, Azerbaijan)',
		'charset' => 'UTF-8',
		'code'    => 'az-cyrl',
		'emoji'   => '🇦🇿',
	],
	'az_Cyrl_AZ' => [
		'name'    => 'Azerbaijani (Cyrillic, Azerbaijan)',
		'charset' => 'UTF-8',
		'code'    => 'az-cyrl-az',
		'emoji'   => '🇦🇿',
	],
	'az_Latn' => [
		'name'    => 'Azerbaijani (Latin)',
		'charset' => 'UTF-8',
		'code'    => 'az-latn',
		'emoji'   => '🇦🇿',
	],
	'az_Latn_AZ' => [
		'name'    => 'Azerbaijani (Latin, Azerbaijan)',
		'charset' => 'UTF-8',
		'code'    => 'az-latn-az',
		'emoji'   => '🇦🇿',
	],
	'az' => [
		'name'    => 'Azerbaijani',
		'charset' => 'UTF-8',
		'code'    => 'az',
		'emoji'   => '🇦🇿',
	],
	'bm_ML' => [
		'name'    => 'Bambara (Mali)',
		'charset' => 'iso-8859-1',
		'code'    => 'bm-ml',
		'emoji'   => '🇧🇲',
	],
	'bm' => [
		'name'    => 'Bambara',
		'charset' => 'iso-8859-1',
		'code'    => 'bm',
		'emoji'   => '🇧🇲',
	],
	'eu_ES' => [
		'name'    => 'Basque (Spain)',
		'charset' => 'ISO-8859-1',
		'code'    => 'eu-es',
	],
	'eu' => [
		'name'    => 'Basque',
		'charset' => 'ISO-8859-1',
		'code'    => 'eu',
	],
	'be_BY' => [
		'name'    => 'Belarusian (Belarus)',
		'charset' => 'UTF-8',
		'code'    => 'be-by',
		'emoji'   => '🇧🇪',
	],
	'be' => [
		'name'    => 'Belarusian',
		'charset' => 'UTF-8',
		'code'    => 'be',
		'emoji'   => '🇧🇪',
	],
	'bem_ZM' => [
		'name'    => 'Bemba (Zambia)',
		'charset' => 'UTF-8',
		'code'    => 'bem-zm',
	],
	'bem' => [
		'name'    => 'Bemba',
		'charset' => 'UTF-8',
		'code'    => 'bem',
	],
	'bez_TZ' => [
		'name'    => 'Bena (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'bez-tz',
	],
	'bez' => [
		'name'    => 'Bena',
		'charset' => 'UTF-8',
		'code'    => 'bez',
	],
	'bn_BD' => [
		'name'    => 'Bengali (Bangladesh)',
		'charset' => 'UTF-8',
		'code'    => 'bn-bd',
		'emoji'   => '🇧🇳',
	],
	'bn_IN' => [
		'name'    => 'Bengali (India)',
		'charset' => 'UTF-8',
		'code'    => 'bn-in',
		'emoji'   => '🇧🇳',
	],
	'bn' => [
		'name'    => 'Bengali',
		'charset' => 'UTF-8',
		'code'    => 'bn',
		'emoji'   => '🇧🇳',
	],
	'bs_BA' => [
		'name'    => 'Bosnian (Bosnia and Herzegovina)',
		'charset' => 'UTF-8',
		'code'    => 'bs-ba',
		'emoji'   => '🇧🇸',
	],
	'bs' => [
		'name'    => 'Bosnian',
		'charset' => 'UTF-8',
		'code'    => 'bs',
		'emoji'   => '🇧🇸',
	],
	'bg_BG' => [
		'name'    => 'Bulgarian (Bulgaria)',
		'charset' => 'ISO-8859-2',
		'code'    => 'bg-bg',
		'emoji'   => '🇧🇬',
	],
	'bg' => [
		'name'    => 'Bulgarian',
		'charset' => 'ISO-8859-2',
		'code'    => 'bg',
		'emoji'   => '🇧🇬',
	],
	'my_MM' => [
		'name'    => 'Burmese (Myanmar [Burma])',
		'charset' => 'UTF-8',
		'code'    => 'my-mm',
		'emoji'   => '🇲🇾',
	],
	'my' => [
		'name'    => 'Burmese',
		'charset' => 'UTF-8',
		'code'    => 'my',
		'emoji'   => '🇲🇾',
	],
	'yue_Hant_HK' => [
		'name'    => 'Cantonese (Traditional, Hong Kong SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'yue-hant-hk',
	],
	'ca_ES' => [
		'name'    => 'Catalan (Spain)',
		'charset' => 'ISO-8859-15',
		'code'    => 'ca-es',
		'emoji'   => '🇨🇦',
	],
	'ca' => [
		'name'    => 'Catalan',
		'charset' => 'ISO-8859-15',
		'code'    => 'ca',
		'emoji'   => '🇨🇦',
	],
	'tzm_Latn' => [
		'name'    => 'Central Morocco Tamazight (Latin)',
		'charset' => 'ISO-8859-1',
		'code'    => 'tzm-latn',
	],
	'tzm_Latn_MA' => [
		'name'    => 'Central Morocco Tamazight (Latin, Morocco)',
		'charset' => 'ISO-8859-1',
		'code'    => 'tzm-latn-ma',
	],
	'tzm' => [
		'name'    => 'Central Morocco Tamazight',
		'charset' => 'ISO-8859-1',
		'code'    => 'tzm',
	],
	'chr_US' => [
		'name'    => 'Cherokee (United States)',
		'charset' => 'U+13A0',
		'code'    => 'chr-us',
	],
	'chr' => [
		'name'    => 'Cherokee',
		'charset' => 'U+13A0',
		'code'    => 'chr',
	],
	'cgg_UG' => [
		'name'    => 'Chiga (Uganda)',
		'charset' => 'ISO-8859-1',
		'code'    => 'cgg-ug',
	],
	'cgg' => [
		'name'    => 'Chiga',
		'charset' => 'ISO-8859-1',
		'code'    => 'cgg',
	],
	'zh_Hans' => [
		'name'    => 'Chinese (Simplified Han)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hans',
	],
	'zh_Hans_CN' => [
		'name'    => 'Chinese (Simplified Han, China)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hans-cn',
	],
	'zh_Hans_HK' => [
		'name'    => 'Chinese (Simplified Han, Hong Kong SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hans-hk',
	],
	'zh_Hans_MO' => [
		'name'    => 'Chinese (Simplified Han, Macau SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hans-mo',
	],
	'zh_Hans_SG' => [
		'name'    => 'Chinese (Simplified Han, Singapore)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hans-sg',
	],
	'zh_Hant' => [
		'name'    => 'Chinese (Traditional Han)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hant',
	],
	'zh_Hant_HK' => [
		'name'    => 'Chinese (Traditional Han, Hong Kong SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hant-hk',
	],
	'zh_Hant_MO' => [
		'name'    => 'Chinese (Traditional Han, Macau SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hant-mo',
	],
	'zh_Hant_TW' => [
		'name'    => 'Chinese (Traditional Han, Taiwan)',
		'charset' => 'UTF-8',
		'code'    => 'zh-hant-tw',
	],
	'zh' => [
		'name'     => 'Chinese',
		'charset'  => 'UTF-8',
		'code'     => 'zh',
		'emoji'    => '🇨🇳',
	],
	'zh_TW' => [
		'name'     => '繁體中文 (Chinese)',
		'charset'  => 'UTF-8',
		'code'     => 'zh-tw',
		'emoji'    => '🇨🇳',
	],
	'zh_HK' => [
		'name'     => '香港中文 (Chinese)',
		'charset'  => 'UTF-8',
		'code'     => 'zh-hk',
		'emoji'    => '🇨🇳',
	],
	'kw_GB' => [
		'name'    => 'Cornish (United Kingdom)',
		'charset' => 'ISO-8859-1',
		'code'    => 'kw-gb',
		'emoji'   => '🇰🇼',
	],
	'kw' => [
		'name'    => 'Cornish',
		'charset' => 'ISO-8859-1',
		'code'    => 'kw',
		'emoji'   => '🇰🇼',
	],
	'hr_HR' => [
		'name'    => 'Croatian (Croatia)',
		'charset' => 'ISO-8859-2',
		'code'    => 'hr-hr',
		'emoji'   => '🇭🇷',
	],
	'hr' => [
		'name'    => 'Croatian',
		'charset' => 'ISO-8859-2',
		'code'    => 'hr',
		'emoji'   => '🇭🇷',
	],
	'cs_CZ' => [
		'name'    => 'Czech (Czech Republic)',
		'charset' => 'ISO-8859-2',
		'code'    => 'cs-cz',
	],
	'cs' => [
		'name'    => 'Czech',
		'charset' => 'ISO-8859-2',
		'code'    => 'cs',
	],
	'da_DK' => [
		'name'    => 'Danish (Denmark)',
		'charset' => 'ISO-8859-1',
		'code'    => 'da-dk',
	],
	'da' => [
		'name'    => 'Danish',
		'charset' => 'ISO-8859-1',
		'code'    => 'da',
	],
	'nl_BE' => [
		'name'    => 'Dutch (Belgium)',
		'charset' => 'ISO-8859-15',
		'code'    => 'nl-be',
		'emoji'   => '🇳🇱',
	],
	'nl_NL' => [
		'name'    => 'Dutch (Netherlands)',
		'charset' => 'ISO-8859-15',
		'code'    => 'nl-nl',
		'emoji'   => '🇳🇱',
	],
	'nl' => [
		'name'    => 'Dutch',
		'charset' => 'ISO-8859-15',
		'code'    => 'nl',
		'emoji'   => '🇳🇱',
	],
	'ebu_KE' => [
		'name'    => 'Embu (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'ebu-ke',
	],
	'ebu' => [
		'name'    => 'Embu',
		'charset' => 'UTF-8',
		'code'    => 'ebu',
	],
	'en_AS' => [
		'name'    => 'English (American Samoa)',
		'charset' => 'UTF-8',
		'code'    => 'en-as',
		'emoji'   => '🇺🇸',
	],
	'en_AU' => [
		'name'    => 'English (Australia)',
		'charset' => 'UTF-8',
		'code'    => 'en-au',
		'emoji'   => '🇺🇸',
	],
	'en_BE' => [
		'name'    => 'English (Belgium)',
		'charset' => 'UTF-8',
		'code'    => 'en-be',
		'emoji'   => '🇺🇸',
	],
	'en_BZ' => [
		'name'    => 'English (Belize)',
		'charset' => 'UTF-8',
		'code'    => 'en-bz',
		'emoji'   => '🇺🇸',
	],
	'en_BW' => [
		'name'    => 'English (Botswana)',
		'charset' => 'UTF-8',
		'code'    => 'en-bw',
		'emoji'   => '🇺🇸',
	],
	'en_CA' => [
		'name'    => 'English (Canada)',
		'charset' => 'UTF-8',
		'code'    => 'en-ca',
		'emoji'   => '🇺🇸',
	],
	'en_GU' => [
		'name'    => 'English (Guam)',
		'charset' => 'UTF-8',
		'code'    => 'en-gu',
		'emoji'   => '🇺🇸',
	],
	'en_HK' => [
		'name'    => 'English (Hong Kong SAR China)',
		'charset' => 'UTF-8',
		'code'    => 'en-hk',
		'emoji'   => '🇺🇸',
	],
	'en_IN' => [
		'name'    => 'English (India)',
		'charset' => 'UTF-8',
		'code'    => 'en-in',
		'emoji'   => '🇺🇸',
	],
	'en_IE' => [
		'name'    => 'English (Ireland)',
		'charset' => 'UTF-8',
		'code'    => 'en-ie',
		'emoji'   => '🇺🇸',
	],
	'en_IL' => [
		'name'    => 'English (Israel)',
		'charset' => 'UTF-8',
		'code'    => 'en-il',
		'emoji'   => '🇺🇸',
	],
	'en_JM' => [
		'name'    => 'English (Jamaica)',
		'charset' => 'UTF-8',
		'code'    => 'en-jm',
		'emoji'   => '🇺🇸',
	],
	'en_MT' => [
		'name'    => 'English (Malta)',
		'charset' => 'UTF-8',
		'code'    => 'en-mt',
		'emoji'   => '🇺🇸',
	],
	'en_MH' => [
		'name'    => 'English (Marshall Islands)',
		'charset' => 'UTF-8',
		'code'    => 'en-mh',
		'emoji'   => '🇺🇸',
	],
	'en_MU' => [
		'name'    => 'English (Mauritius)',
		'charset' => 'UTF-8',
		'code'    => 'en-mu',
		'emoji'   => '🇺🇸',
	],
	'en_NA' => [
		'name'    => 'English (Namibia)',
		'charset' => 'UTF-8',
		'code'    => 'en-na',
		'emoji'   => '🇺🇸',
	],
	'en_NZ' => [
		'name'    => 'English (New Zealand)',
		'charset' => 'UTF-8',
		'code'    => 'en-nz',
		'emoji'   => '🇺🇸',
	],
	'en_MP' => [
		'name'    => 'English (Northern Mariana Islands)',
		'charset' => 'UTF-8',
		'code'    => 'en-mp',
		'emoji'   => '🇺🇸',
	],
	'en_PK' => [
		'name'    => 'English (Pakistan)',
		'charset' => 'UTF-8',
		'code'    => 'en-pk',
		'emoji'   => '🇺🇸',
	],
	'en_PH' => [
		'name'    => 'English (Philippines)',
		'charset' => 'UTF-8',
		'code'    => 'en-ph',
		'emoji'   => '🇺🇸',
	],
	'en_SG' => [
		'name'    => 'English (Singapore)',
		'charset' => 'UTF-8',
		'code'    => 'en-sg',
		'emoji'   => '🇺🇸',
	],
	'en_ZA' => [
		'name'    => 'English (South Africa)',
		'charset' => 'UTF-8',
		'code'    => 'en-za',
		'emoji'   => '🇺🇸',
	],
	'en_TT' => [
		'name'    => 'English (Trinidad and Tobago)',
		'charset' => 'UTF-8',
		'code'    => 'en-tt',
		'emoji'   => '🇺🇸',
	],
	'en_UM' => [
		'name'    => 'English (U.S. Minor Outlying Islands)',
		'charset' => 'UTF-8',
		'code'    => 'en-um',
		'emoji'   => '🇺🇸',
	],
	'en_VI' => [
		'name'    => 'English (U.S. Virgin Islands)',
		'charset' => 'UTF-8',
		'code'    => 'en-vi',
		'emoji'   => '🇺🇸',
	],
	'en_GB' => [
		'name'    => 'English (United Kingdom)',
		'charset' => 'UTF-8',
		'code'    => 'en-gb',
		'emoji'   => '🇺🇸',
	],
	'en_ZW' => [
		'name'    => 'English (Zimbabwe)',
		'charset' => 'UTF-8',
		'code'    => 'en-zw',
		'emoji'   => '🇺🇸',
	],
	'en' => [
		'name'    => 'English',
		'charset' => 'UTF-8',
		'code'    => 'en',
		'emoji'   => '🇺🇸',
	],
	'eo' => [
		'name'    => 'Esperanto',
		'charset' => 'UTF-8',
		'code'    => 'eo',
	],
	'et_EE' => [
		'name'    => 'Estonian (Estonia)',
		'charset' => 'ISO-8859-1',
		'code'    => 'et-ee',
		'emoji'   => '🇪🇹',
	],
	'et' => [
		'name'    => 'Estonian',
		'charset' => 'ISO-8859-1',
		'code'    => 'et',
		'emoji'   => '🇪🇹',
	],
	'ee_GH' => [
		'name'    => 'Ewe (Ghana)',
		'charset' => 'ISO-8859-1',
		'code'    => 'ee-gh',
		'emoji'   => '🇪🇪',
	],
	'ee_TG' => [
		'name'    => 'Ewe (Togo)',
		'charset' => 'ISO-8859-1',
		'code'    => 'ee-tg',
		'emoji'   => '🇪🇪',
	],
	'ee' => [
		'name'    => 'Ewe',
		'charset' => 'ISO-8859-1',
		'code'    => 'ee',
		'emoji'   => '🇪🇪',
	],
	'fo_FO' => [
		'name'    => 'Faroese (Faroe Islands)',
		'charset' => 'UTF-8',
		'code'    => 'fo-fo',
		'emoji'   => '🇫🇴',
	],
	'fo' => [
		'name'    => 'Faroese',
		'charset' => 'UTF-8',
		'code'    => 'fo',
		'emoji'   => '🇫🇴',
	],
	'fil_PH' => [
		'name'    => 'Filipino (Philippines)',
		'charset' => 'UTF-8',
		'code'    => 'fil-ph',
	],
	'fil' => [
		'name'    => 'Filipino',
		'charset' => 'UTF-8',
		'code'    => 'fil',
	],
	'fi_FI' => [
		'name'    => 'Finnish (Finland)',
		'charset' => 'UTF-8',
		'code'    => 'fi-fi',
		'emoji'   => '🇫🇮',
	],
	'fi' => [
		'name'    => 'Finnish',
		'charset' => 'UTF-8',
		'code'    => 'fi',
		'emoji'   => '🇫🇮',
	],
	'fr_BE' => [
		'name'    => 'French (Belgium)',
		'charset' => 'UTF-8',
		'code'    => 'fr-be',
		'emoji'   => '🇫🇷',
	],
	'fr_BJ' => [
		'name'    => 'French (Benin)',
		'charset' => 'UTF-8',
		'code'    => 'fr-bj',
		'emoji'   => '🇫🇷',
	],
	'fr_BF' => [
		'name'    => 'French (Burkina Faso)',
		'charset' => 'UTF-8',
		'code'    => 'fr-bf',
		'emoji'   => '🇫🇷',
	],
	'fr_BI' => [
		'name'    => 'French (Burundi)',
		'charset' => 'UTF-8',
		'code'    => 'fr-bi',
		'emoji'   => '🇫🇷',
	],
	'fr_CM' => [
		'name'    => 'French (Cameroon)',
		'charset' => 'UTF-8',
		'code'    => 'fr-cm',
		'emoji'   => '🇫🇷',
	],
	'fr_CA' => [
		'name'    => 'French (Canada)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ca',
		'emoji'   => '🇫🇷',
	],
	'fr_CF' => [
		'name'    => 'French (Central African Republic)',
		'charset' => 'UTF-8',
		'code'    => 'fr-cf',
		'emoji'   => '🇫🇷',
	],
	'fr_TD' => [
		'name'    => 'French (Chad)',
		'charset' => 'UTF-8',
		'code'    => 'fr-td',
		'emoji'   => '🇫🇷',
	],
	'fr_KM' => [
		'name'    => 'French (Comoros)',
		'charset' => 'UTF-8',
		'code'    => 'fr-km',
		'emoji'   => '🇫🇷',
	],
	'fr_CG' => [
		'name'    => 'French (Congo - Brazzaville)',
		'charset' => 'UTF-8',
		'code'    => 'fr-cg',
		'emoji'   => '🇫🇷',
	],
	'fr_CD' => [
		'name'    => 'French (Congo - Kinshasa)',
		'charset' => 'UTF-8',
		'code'    => 'fr-cd',
		'emoji'   => '🇫🇷',
	],
	'fr_CI' => [
		'name'    => 'French (Côte d’Ivoire)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ci',
		'emoji'   => '🇫🇷',
	],
	'fr_DJ' => [
		'name'    => 'French (Djibouti)',
		'charset' => 'UTF-8',
		'code'    => 'fr-dj',
		'emoji'   => '🇫🇷',
	],
	'fr_GQ' => [
		'name'    => 'French (Equatorial Guinea)',
		'charset' => 'UTF-8',
		'code'    => 'fr-gq',
		'emoji'   => '🇫🇷',
	],
	'fr_GA' => [
		'name'    => 'French (Gabon)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ga',
		'emoji'   => '🇫🇷',
	],
	'fr_GP' => [
		'name'    => 'French (Guadeloupe)',
		'charset' => 'UTF-8',
		'code'    => 'fr-gp',
		'emoji'   => '🇫🇷',
	],
	'fr_GN' => [
		'name'    => 'French (Guinea)',
		'charset' => 'UTF-8',
		'code'    => 'fr-gn',
		'emoji'   => '🇫🇷',
	],
	'fr_LU' => [
		'name'    => 'French (Luxembourg)',
		'charset' => 'UTF-8',
		'code'    => 'fr-lu',
		'emoji'   => '🇫🇷',
	],
	'fr_MG' => [
		'name'    => 'French (Madagascar)',
		'charset' => 'UTF-8',
		'code'    => 'fr-mg',
		'emoji'   => '🇫🇷',
	],
	'fr_ML' => [
		'name'    => 'French (Mali)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ml',
		'emoji'   => '🇫🇷',
	],
	'fr_MQ' => [
		'name'    => 'French (Martinique)',
		'charset' => 'UTF-8',
		'code'    => 'fr-mq',
		'emoji'   => '🇫🇷',
	],
	'fr_MC' => [
		'name'    => 'French (Monaco)',
		'charset' => 'UTF-8',
		'code'    => 'fr-mc',
		'emoji'   => '🇫🇷',
	],
	'fr_NE' => [
		'name'    => 'French (Niger)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ne',
		'emoji'   => '🇫🇷',
	],
	'fr_RW' => [
		'name'    => 'French (Rwanda)',
		'charset' => 'UTF-8',
		'code'    => 'fr-rw',
		'emoji'   => '🇫🇷',
	],
	'fr_RE' => [
		'name'    => 'French (Réunion)',
		'charset' => 'UTF-8',
		'code'    => 'fr-re',
		'emoji'   => '🇫🇷',
	],
	'fr_BL' => [
		'name'    => 'French (Saint Barthélemy)',
		'charset' => 'UTF-8',
		'code'    => 'fr-bl',
		'emoji'   => '🇫🇷',
	],
	'fr_MF' => [
		'name'    => 'French (Saint Martin)',
		'charset' => 'UTF-8',
		'code'    => 'fr-mf',
		'emoji'   => '🇫🇷',
	],
	'fr_SN' => [
		'name'    => 'French (Senegal)',
		'charset' => 'UTF-8',
		'code'    => 'fr-sn',
		'emoji'   => '🇫🇷',
	],
	'fr_CH' => [
		'name'    => 'French (Switzerland)',
		'charset' => 'UTF-8',
		'code'    => 'fr-ch',
		'emoji'   => '🇫🇷',
	],
	'fr_TG' => [
		'name'    => 'French (Togo)',
		'charset' => 'UTF-8',
		'code'    => 'fr-tg',
		'emoji'   => '🇫🇷',
	],
	'fr' => [
		'name'    => 'French',
		'charset' => 'UTF-8',
		'code'    => 'fr',
		'emoji'   => '🇫🇷',
	],
	'ff_SN' => [
		'name'    => 'Fulah (Senegal)',
		'charset' => 'UTF-8',
		'code'    => 'ff-sn',
	],
	'ff' => [
		'name'    => 'Fulah',
		'charset' => 'UTF-8',
		'code'    => 'ff',
	],
	'gl_ES' => [
		'name'    => 'Galician (Spain)',
		'charset' => 'ISO-8859-1',
		'code'    => 'gl-es',
		'emoji'   => '🇬🇱',
	],
	'gl' => [
		'name'    => 'Galician',
		'charset' => 'ISO-8859-1',
		'code'    => 'gl',
		'emoji'   => '🇬🇱',
	],
	'lg_UG' => [
		'name'    => 'Ganda (Uganda)',
		'charset' => 'UTF-8',
		'code'    => 'lg-ug',
	],
	'lg' => [
		'name'    => 'Ganda',
		'charset' => 'UTF-8',
		'code'    => 'lg',
	],
	'ka_GE' => [
		'name'    => 'Georgian (Georgia)',
		'charset' => 'UTF-8',
		'code'    => 'ka-ge',
	],
	'ka' => [
		'name'    => 'Georgian',
		'charset' => 'UTF-8',
		'code'    => 'ka',
	],
	'de_AT' => [
		'name'    => 'German (Austria)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-at',
		'emoji'   => '🇩🇪',
	],
	'de_BE' => [
		'name'    => 'German (Belgium)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-be',
		'emoji'   => '🇩🇪',
	],
	'de_LI' => [
		'name'    => 'German (Liechtenstein)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-li',
		'emoji'   => '🇩🇪',
	],
	'de_LU' => [
		'name'    => 'German (Luxembourg)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-lu',
		'emoji'   => '🇩🇪',
	],
	'de_CH' => [
		'name'    => 'German (Switzerland)',
		'charset' => 'ISO-8859-1',
		'code'    => 'de-ch',
		'emoji'   => '🇩🇪',
	],
	'de' => [
		'name'    => 'German',
		'charset' => 'ISO-8859-1',
		'code'    => 'de',
		'emoji'   => '🇩🇪',
	],
	'el_CY' => [
		'name'    => 'Greek (Cyprus)',
		'charset' => 'UTF-8',
		'code'    => 'el-cy',
	],
	'el_GR' => [
		'name'    => 'Greek (Greece)',
		'charset' => 'UTF-8',
		'code'    => 'el-gr',
	],
	'el' => [
		'name'    => 'Greek',
		'charset' => 'UTF-8',
		'code'    => 'el',
	],
	'gu_IN' => [
		'name'    => 'Gujarati (India)',
		'charset' => 'UTF-8',
		'code'    => 'gu-in',
		'emoji'   => '🇬🇺',
	],
	'gu' => [
		'name'    => 'Gujarati',
		'charset' => 'UTF-8',
		'code'    => 'gu',
		'emoji'   => '🇬🇺',
	],
	'guz_KE' => [
		'name'    => 'Gusii (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'guz-ke',
	],
	'guz' => [
		'name'    => 'Gusii',
		'charset' => 'UTF-8',
		'code'    => 'guz',
	],
	'ha_Latn' => [
		'name'    => 'Hausa (Latin)',
		'charset' => 'UTF-8',
		'code'    => 'ha-latn',
	],
	'ha_Latn_GH' => [
		'name'    => 'Hausa (Latin, Ghana)',
		'charset' => 'UTF-8',
		'code'    => 'ha-latn-gh',
	],
	'ha_Latn_NE' => [
		'name'    => 'Hausa (Latin, Niger)',
		'charset' => 'UTF-8',
		'code'    => 'ha-latn-ne',
	],
	'ha_Latn_NG' => [
		'name'    => 'Hausa (Latin, Nigeria)',
		'charset' => 'UTF-8',
		'code'    => 'ha-latn-ng',
	],
	'ha' => [
		'name'    => 'Hausa',
		'charset' => 'UTF-8',
		'code'    => 'ha',
	],
	'haw_US' => [
		'name'    => 'Hawaiian (United States)',
		'charset' => 'UTF-8',
		'code'    => 'haw-us',
	],
	'haw' => [
		'name'    => 'Hawaiian',
		'charset' => 'UTF-8',
		'code'    => 'haw',
	],
	'he_IL' => [
		'name'    => 'Hebrew (Israel)',
		'charset' => 'ISO-8859-8',
		'code'    => 'he-il',
		'rtl'     => true,
	],
	'he' => [
		'name'    => 'Hebrew',
		'charset' => 'ISO-8859-8',
		'code'    => 'he',
		'rtl'     => true,
	],
	'hi_IN' => [
		'name'    => 'Hindi (India)',
		'charset' => 'UTF-8',
		'code'    => 'hi-in',
	],
	'hi' => [
		'name'    => 'Hindi',
		'charset' => 'UTF-8',
		'code'    => 'hi',
	],
	'hu_HU' => [
		'name'    => 'Hungarian (Hungary)',
		'charset' => 'ISO-8859-2',
		'code'    => 'hu-hu',
		'emoji'   => '🇭🇺',
	],
	'hu' => [
		'name'    => 'Hungarian',
		'charset' => 'ISO-8859-2',
		'code'    => 'hu',
		'emoji'   => '🇭🇺',
	],
	'is_IS' => [
		'name'    => 'Icelandic (Iceland)',
		'charset' => 'ISO-8859-1',
		'code'    => 'is-is',
		'emoji'   => '🇮🇸',
	],
	'is' => [
		'name'    => 'Icelandic',
		'charset' => 'ISO-8859-1',
		'code'    => 'is',
		'emoji'   => '🇮🇸',
	],
	'ig_NG' => [
		'name'    => 'Igbo (Nigeria)',
		'charset' => 'UTF-8',
		'code'    => 'ig-ng',
	],
	'ig' => [
		'name'    => 'Igbo',
		'charset' => 'UTF-8',
		'code'    => 'ig',
	],
	'id_ID' => [
		'name'    => 'Indonesian (Indonesia)',
		'charset' => 'ISO-8859-1',
		'code'    => 'id-id',
		'emoji'   => '🇮🇩',
	],
	'id' => [
		'name'    => 'Indonesian',
		'charset' => 'ISO-8859-1',
		'code'    => 'id',
		'emoji'   => '🇮🇩',
	],
	'ga_IE' => [
		'name'    => 'Irish (Ireland)',
		'charset' => 'ISO-8859-1',
		'code'    => 'ga-ie',
		'emoji'   => '🇬🇦',
	],
	'ga' => [
		'name'    => 'Irish',
		'charset' => 'ISO-8859-1',
		'code'    => 'ga',
		'emoji'   => '🇬🇦',
	],
	'it_CH' => [
		'name'    => 'Italian (Switzerland)',
		'charset' => 'ISO-8859-1',
		'code'    => 'it-ch',
		'emoji'   => '🇮🇹',
	],
	'it' => [
		'name'    => 'Italian',
		'charset' => 'ISO-8859-1',
		'code'    => 'it',
		'emoji'   => '🇮🇹',
	],
	'ja_JP' => [
		'name'    => 'Japanese (Japan)',
		'charset' => 'UTF-8',
		'code'    => 'ja-jp',
	],
	'ja' => [
		'name'    => 'Japanese',
		'charset' => 'UTF-8',
		'code'    => 'ja',
	],
	'kea_CV' => [
		'name'    => 'Kabuverdianu (Cape Verde)',
		'charset' => 'UTF-8',
		'code'    => 'kea-cv',
	],
	'kea' => [
		'name'    => 'Kabuverdianu',
		'charset' => 'UTF-8',
		'code'    => 'kea',
	],
	'kab_DZ' => [
		'name'    => 'Kabyle (Algeria)',
		'charset' => 'UTF-8',
		'code'    => 'kab-dz',
	],
	'kab' => [
		'name'    => 'Kabyle',
		'charset' => 'UTF-8',
		'code'    => 'kab',
	],
	'kl_GL' => [
		'name'    => 'Kalaallisut (Greenland)',
		'charset' => 'ISO-8859-1',
		'code'    => 'kl-gl',
	],
	'kl' => [
		'name'    => 'Kalaallisut',
		'charset' => 'ISO-8859-1',
		'code'    => 'kl',
	],
	'kln_KE' => [
		'name'    => 'Kalenjin (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'kln-ke',
	],
	'kln' => [
		'name'    => 'Kalenjin',
		'charset' => 'UTF-8',
		'code'    => 'kln',
	],
	'kam_KE' => [
		'name'    => 'Kamba (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'kam-ke',
	],
	'kam' => [
		'name'    => 'Kamba',
		'charset' => 'UTF-8',
		'code'    => 'kam',
	],
	'kn_IN' => [
		'name'    => 'Kannada (India)',
		'charset' => 'UTF-8',
		'code'    => 'kn-in',
		'emoji'   => '🇰🇳',
	],
	'kn' => [
		'name'    => 'Kannada',
		'charset' => 'UTF-8',
		'code'    => 'kn',
		'emoji'   => '🇰🇳',
	],
	'kk_Cyrl' => [
		'name'    => 'Kazakh (Cyrillic)',
		'charset' => 'UTF-8',
		'code'    => 'kk-cyrl',
	],
	'kk_Cyrl_KZ' => [
		'name'    => 'Kazakh (Cyrillic, Kazakhstan)',
		'charset' => 'UTF-8',
		'code'    => 'kk-cyrl-kz',
	],
	'kk' => [
		'name'    => 'Kazakh',
		'charset' => 'UTF-8',
		'code'    => 'kk',
	],
	'km_KH' => [
		'name'    => 'Khmer (Cambodia)',
		'charset' => 'UTF-8',
		'code'    => 'km-kh',
		'emoji'   => '🇰🇲',
	],
	'km' => [
		'name'    => 'Khmer',
		'charset' => 'UTF-8',
		'code'    => 'km',
		'emoji'   => '🇰🇲',
	],
	'ki_KE' => [
		'name'    => 'Kikuyu (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'ki-ke',
		'emoji'   => '🇰🇮',
	],
	'ki' => [
		'name'    => 'Kikuyu',
		'charset' => 'UTF-8',
		'code'    => 'ki',
		'emoji'   => '🇰🇮',
	],
	'rw_RW' => [
		'name'    => 'Kinyarwanda (Rwanda)',
		'charset' => 'UTF-8',
		'code'    => 'rw-rw',
		'emoji'   => '🇷🇼',
	],
	'rw' => [
		'name'    => 'Kinyarwanda',
		'charset' => 'UTF-8',
		'code'    => 'rw',
		'emoji'   => '🇷🇼',
	],
	'kok_IN' => [
		'name'    => 'Konkani (India)',
		'charset' => 'UTF-8',
		'code'    => 'kok-in',
	],
	'kok' => [
		'name'    => 'Konkani',
		'charset' => 'UTF-8',
		'code'    => 'kok',
	],
	'ko_KR' => [
		'name'    => 'Korean (South Korea)',
		'charset' => 'UTF-8',
		'code'    => 'ko-kr',
	],
	'ko' => [
		'name'    => 'Korean',
		'charset' => 'UTF-8',
		'code'    => 'ko',
	],
	'khq_ML' => [
		'name'    => 'Koyra Chiini (Mali)',
		'charset' => 'UTF-8',
		'code'    => 'khq-ml',
	],
	'khq' => [
		'name'    => 'Koyra Chiini',
		'charset' => 'UTF-8',
		'code'    => 'khq',
	],
	'ses_ML' => [
		'name'    => 'Koyraboro Senni (Mali)',
		'charset' => 'UTF-8',
		'code'    => 'ses-ml',
	],
	'ses' => [
		'name'    => 'Koyraboro Senni',
		'charset' => 'UTF-8',
		'code'    => 'ses',
	],
	'lag_TZ' => [
		'name'    => 'Langi (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'lag-tz',
	],
	'lag' => [
		'name'    => 'Langi',
		'charset' => 'UTF-8',
		'code'    => 'lag',
	],
	'lv_LV' => [
		'name'    => 'Latvian (Latvia)',
		'charset' => 'UTF-8',
		'code'    => 'lv-lv',
		'emoji'   => '🇱🇻',
	],
	'lv' => [
		'name'    => 'Latvian',
		'charset' => 'UTF-8',
		'code'    => 'lv',
		'emoji'   => '🇱🇻',
	],
	'lt_LT' => [
		'name'    => 'Lithuanian (Lithuania)',
		'charset' => 'ISO-8859-13',
		'code'    => 'lt-lt',
		'emoji'   => '🇱🇹',
	],
	'lt' => [
		'name'    => 'Lithuanian',
		'charset' => 'ISO-8859-13',
		'code'    => 'lt',
		'emoji'   => '🇱🇹',
	],
	'luo_KE' => [
		'name'    => 'Luo (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'luo-ke',
	],
	'luo' => [
		'name'    => 'Luo',
		'charset' => 'UTF-8',
		'code'    => 'luo',
	],
	'luy_KE' => [
		'name'    => 'Luyia (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'luy-ke',
	],
	'luy' => [
		'name'    => 'Luyia',
		'charset' => 'UTF-8',
		'code'    => 'luy',
	],
	'mk_MK' => [
		'name'    => 'Macedonian (Macedonia)',
		'charset' => 'ISO-8859-5',
		'code'    => 'mk-mk',
		'emoji'   => '🇲🇰',
	],
	'mk' => [
		'name'    => 'Macedonian',
		'charset' => 'ISO-8859-5',
		'code'    => 'mk',
		'emoji'   => '🇲🇰',
	],
	'jmc_TZ' => [
		'name'    => 'Machame (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'jmc-tz',
	],
	'jmc' => [
		'name'    => 'Machame',
		'charset' => 'UTF-8',
		'code'    => 'jmc',
	],
	'kde_TZ' => [
		'name'    => 'Makonde (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'kde-tz',
	],
	'kde' => [
		'name'    => 'Makonde',
		'charset' => 'UTF-8',
		'code'    => 'kde',
	],
	'mg_MG' => [
		'name'    => 'Malagasy (Madagascar)',
		'charset' => 'ISO-8859-15',
		'code'    => 'mg-mg',
		'emoji'   => '🇲🇬',
	],
	'mg' => [
		'name'    => 'Malagasy',
		'charset' => 'ISO-8859-15',
		'code'    => 'mg',
		'emoji'   => '🇲🇬',
	],
	'ms_BN' => [
		'name'    => 'Malay (Brunei)',
		'charset' => 'UTF-8',
		'code'    => 'ms-bn',
		'emoji'   => '🇲🇸',
	],
	'ms_MY' => [
		'name'    => 'Malay (Malaysia)',
		'charset' => 'UTF-8',
		'code'    => 'ms-my',
		'emoji'   => '🇲🇸',
	],
	'ms' => [
		'name'    => 'Malay',
		'charset' => 'UTF-8',
		'code'    => 'ms',
		'emoji'   => '🇲🇸',
	],
	'ml_IN' => [
		'name'    => 'Malayalam (India)',
		'charset' => 'UTF-8',
		'code'    => 'ml-in',
		'emoji'   => '🇲🇱',
	],
	'ml' => [
		'name'    => 'Malayalam',
		'charset' => 'UTF-8',
		'code'    => 'ml',
		'emoji'   => '🇲🇱',
	],
	'mt_MT' => [
		'name'    => 'Maltese (Malta)',
		'charset' => 'UTF-8',
		'code'    => 'mt-mt',
		'emoji'   => '🇲🇹',
	],
	'mt' => [
		'name'    => 'Maltese',
		'charset' => 'ISO-8859-3',
		'code'    => 'mt',
		'emoji'   => '🇲🇹',
	],
	'gv_GB' => [
		'name'    => 'Manx (United Kingdom)',
		'charset' => 'ISO-8859-1',
		'code'    => 'gv-gb',
	],
	'gv' => [
		'name'    => 'Manx',
		'charset' => 'ISO-8859-1',
		'code'    => 'gv',
	],
	'mr_IN' => [
		'name'    => 'Marathi (India)',
		'charset' => 'UTF-8',
		'code'    => 'mr-in',
		'emoji'   => '🇲🇷',
	],
	'mr' => [
		'name'    => 'Marathi',
		'charset' => 'UTF-8',
		'code'    => 'mr',
		'emoji'   => '🇲🇷',
	],
	'mas_KE' => [
		'name'    => 'Masai (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'mas-ke',
	],
	'mas_TZ' => [
		'name'    => 'Masai (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'mas-tz',
	],
	'mas' => [
		'name'    => 'Masai',
		'charset' => 'UTF-8',
		'code'    => 'mas',
	],
	'mer_KE' => [
		'name'    => 'Meru (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'mer-ke',
	],
	'mer' => [
		'name'    => 'Meru',
		'charset' => 'UTF-8',
		'code'    => 'mer',
	],
	'mfe_MU' => [
		'name'    => 'Morisyen (Mauritius)',
		'charset' => 'UTF-8',
		'code'    => 'mfe-mu',
	],
	'mfe' => [
		'name'    => 'Morisyen',
		'charset' => 'UTF-8',
		'code'    => 'mfe',
	],
	'naq_NA' => [
		'name'    => 'Nama (Namibia)',
		'charset' => 'UTF-8',
		'code'    => 'naq-na',
	],
	'naq' => [
		'name'    => 'Nama',
		'charset' => 'UTF-8',
		'code'    => 'naq',
	],
	'ne_IN' => [
		'name'    => 'Nepali (India)',
		'charset' => 'UTF-8',
		'code'    => 'ne-in',
		'emoji'   => '🇳🇪',
	],
	'ne_NP' => [
		'name'    => 'Nepali (Nepal)',
		'charset' => 'UTF-8',
		'code'    => 'ne-np',
		'emoji'   => '🇳🇪',
	],
	'ne' => [
		'name'    => 'Nepali',
		'charset' => 'UTF-8',
		'code'    => 'ne',
		'emoji'   => '🇳🇪',
	],
	'nd_ZW' => [
		'name'    => 'North Ndebele (Zimbabwe)',
		'charset' => 'UTF-8',
		'code'    => 'nd-zw',
	],
	'nd' => [
		'name'    => 'North Ndebele',
		'charset' => 'UTF-8',
		'code'    => 'nd',
	],
	'nb_NO' => [
		'name'    => 'Norwegian Bokmål (Norway)',
		'charset' => 'ISO-8859-1',
		'code'    => 'nb-no',
	],
	'nb' => [
		'name'    => 'Norwegian Bokmål',
		'charset' => 'ISO-8859-1',
		'code'    => 'nb',
	],
	'nn_NO' => [
		'name'    => 'Norwegian Nynorsk (Norway)',
		'charset' => 'ISO-8859-1',
		'code'    => 'nn-no',
	],
	'nn' => [
		'name'    => 'Norwegian Nynorsk',
		'charset' => 'ISO-8859-1',
		'code'    => 'nn',
	],
	'nyn_UG' => [
		'name'    => 'Nyankole (Uganda)',
		'charset' => 'UTF-8',
		'code'    => 'nyn-ug',
	],
	'nyn' => [
		'name'    => 'Nyankole',
		'charset' => 'UTF-8',
		'code'    => 'nyn',
	],
	'or_IN' => [
		'name'    => 'Oriya (India)',
		'charset' => 'UTF-8',
		'code'    => 'or-in',
	],
	'or' => [
		'name'    => 'Oriya',
		'charset' => 'UTF-8',
		'code'    => 'or',
	],
	'om_ET' => [
		'name'    => 'Oromo (Ethiopia)',
		'charset' => 'UTF-8',
		'code'    => 'om-et',
		'emoji'   => '🇴🇲',
	],
	'om_KE' => [
		'name'    => 'Oromo (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'om-ke',
		'emoji'   => '🇴🇲',
	],
	'om' => [
		'name'    => 'Oromo',
		'charset' => 'UTF-8',
		'code'    => 'om',
		'emoji'   => '🇴🇲',
	],
	'ps_AF' => [
		'name'    => 'Pashto (Afghanistan)',
		'charset' => 'UTF-8',
		'code'    => 'ps-af',
		'emoji'   => '🇵🇸',
	],
	'ps' => [
		'name'    => 'Pashto',
		'charset' => 'UTF-8',
		'code'    => 'ps',
		'emoji'   => '🇵🇸',
	],
	'fa_AF' => [
		'name'    => 'Persian (Afghanistan)',
		'charset' => 'UTF-8',
		'code'    => 'fa-af',
	],
	'fa_IR' => [
		'name'    => 'Persian (Iran)',
		'charset' => 'UTF-8',
		'code'    => 'fa-ir',
		'rtl'     => true,
	],
	'fa' => [
		'name'    => 'Persian',
		'charset' => 'UTF-8',
		'code'    => 'fa',
		'rtl'     => true,
	],
	'pl_PL' => [
		'name'    => 'Polish (Poland)',
		'charset' => 'ISO-8859-2',
		'code'    => 'pl-pl',
		'emoji'   => '🇵🇱',
	],
	'pl' => [
		'name'    => 'Polish',
		'charset' => 'ISO-8859-2',
		'code'    => 'pl',
		'emoji'   => '🇵🇱',
	],
	'pt_GW' => [
		'name'    => 'Portuguese (Guinea-Bissau)',
		'charset' => 'ISO-8859-1',
		'code'    => 'pt-gw',
		'emoji'   => '🇵🇹',
	],
	'pt_MZ' => [
		'name'    => 'Portuguese (Mozambique)',
		'charset' => 'ISO-8859-1',
		'code'    => 'pt-mz',
		'emoji'   => '🇵🇹',
	],
	'pt_PT' => [
		'name'    => 'Portuguese (Portugal)',
		'charset' => 'ISO-8859-1',
		'code'    => 'pt-pt',
		'emoji'   => '🇵🇹',
	],
	'pt' => [
		'name'    => 'Portuguese',
		'charset' => 'ISO-8859-1',
		'code'    => 'pt',
		'emoji'   => '🇵🇹',
	],
	'pa_Arab' => [
		'name'    => 'Punjabi (Arabic)',
		'charset' => 'UTF-8',
		'code'    => 'pa-arab',
		'emoji'   => '🇵🇦',
	],
	'pa_Arab_PK' => [
		'name'    => 'Punjabi (Arabic, Pakistan)',
		'charset' => 'UTF-8',
		'code'    => 'pa-arab-pk',
		'emoji'   => '🇵🇦',
	],
	'pa_Guru' => [
		'name'    => 'Punjabi (Gurmukhi)',
		'charset' => 'UTF-8',
		'code'    => 'pa-guru',
		'emoji'   => '🇵🇦',
	],
	'pa_Guru_IN' => [
		'name'    => 'Punjabi (Gurmukhi, India)',
		'charset' => 'UTF-8',
		'code'    => 'pa-guru-in',
		'emoji'   => '🇵🇦',
	],
	'pa' => [
		'name'    => 'Punjabi',
		'charset' => 'UTF-8',
		'code'    => 'pa',
		'emoji'   => '🇵🇦',
	],
	'ro_MD' => [
		'name'    => 'Romanian (Moldova)',
		'charset' => 'UTF-8',
		'code'    => 'ro-md',
		'emoji'   => '🇷🇴',
	],
	'ro' => [
		'name'    => 'Romanian',
		'charset' => 'UTF-8',
		'code'    => 'ro',
		'emoji'   => '🇷🇴',
	],
	'rm_CH' => [
		'name'    => 'Romansh (Switzerland)',
		'charset' => 'UTF-8',
		'code'    => 'rm-ch',
	],
	'rm' => [
		'name'    => 'Romansh',
		'charset' => 'UTF-8',
		'code'    => 'rm',
	],
	'rof_TZ' => [
		'name'    => 'Rombo (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'rof-tz',
	],
	'rof' => [
		'name'    => 'Rombo',
		'charset' => 'UTF-8',
		'code'    => 'rof',
	],
	'ru_MD' => [
		'name'    => 'Russian (Moldova)',
		'charset' => 'UTF-8',
		'code'    => 'ru-md',
		'emoji'   => '🇷🇺',
	],
	'ru_UA' => [
		'name'    => 'Russian (Ukraine)',
		'charset' => 'UTF-8',
		'code'    => 'ru-ua',
		'emoji'   => '🇷🇺',
	],
	'ru' => [
		'name'    => 'Russian',
		'charset' => 'UTF-8',
		'code'    => 'ru',
		'emoji'   => '🇷🇺',
	],
	'rwk_TZ' => [
		'name'    => 'Rwa (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'rwk-tz',
	],
	'rwk' => [
		'name'    => 'Rwa',
		'charset' => 'UTF-8',
		'code'    => 'rwk',
	],
	'saq_KE' => [
		'name'    => 'Samburu (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'saq-ke',
	],
	'saq' => [
		'name'    => 'Samburu',
		'charset' => 'UTF-8',
		'code'    => 'saq',
	],
	'sg_CF' => [
		'name'    => 'Sango (Central African Republic)',
		'charset' => 'UTF-8',
		'code'    => 'sg-cf',
		'emoji'   => '🇸🇬',
	],
	'sg' => [
		'name'    => 'Sango',
		'charset' => 'UTF-8',
		'code'    => 'sg',
		'emoji'   => '🇸🇬',
	],
	'seh_MZ' => [
		'name'    => 'Sena (Mozambique)',
		'charset' => 'UTF-8',
		'code'    => 'seh-mz',
	],
	'seh' => [
		'name'    => 'Sena',
		'charset' => 'UTF-8',
		'code'    => 'seh',
	],
	'sr_Cyrl' => [
		'name'    => 'Serbian (Cyrillic)',
		'charset' => 'UTF-8',
		'code'    => 'sr-cyrl',
		'emoji'   => '🇸🇷',
	],
	'sr_Cyrl_BA' => [
		'name'    => 'Serbian (Cyrillic, Bosnia and Herzegovina)',
		'charset' => 'UTF-8',
		'code'    => 'sr-cyrl-ba',
		'emoji'   => '🇸🇷',
	],
	'sr_Cyrl_ME' => [
		'name'    => 'Serbian (Cyrillic, Montenegro)',
		'charset' => 'UTF-8',
		'code'    => 'sr-cyrl-me',
		'emoji'   => '🇸🇷',
	],
	'sr_Cyrl_RS' => [
		'name'    => 'Serbian (Cyrillic, Serbia)',
		'charset' => 'UTF-8',
		'code'    => 'sr-cyrl-rs',
		'emoji'   => '🇸🇷',
	],
	'sr_Latn' => [
		'name'    => 'Serbian (Latin)',
		'charset' => 'UTF-8',
		'code'    => 'sr-latn',
		'emoji'   => '🇸🇷',
	],
	'sr_Latn_BA' => [
		'name'    => 'Serbian (Latin, Bosnia and Herzegovina)',
		'charset' => 'UTF-8',
		'code'    => 'sr-latn-ba',
		'emoji'   => '🇸🇷',
	],
	'sr_Latn_ME' => [
		'name'    => 'Serbian (Latin, Montenegro)',
		'charset' => 'UTF-8',
		'code'    => 'sr-latn-me',
		'emoji'   => '🇸🇷',
	],
	'sr_Latn_RS' => [
		'name'    => 'Serbian (Latin, Serbia)',
		'charset' => 'UTF-8',
		'code'    => 'sr-latn-rs',
		'emoji'   => '🇸🇷',
	],
	'sr' => [
		'name'    => 'Serbian',
		'charset' => 'UTF-8',
		'code'    => 'sr',
		'emoji'   => '🇸🇷',
	],
	'sn_ZW' => [
		'name'    => 'Shona (Zimbabwe)',
		'charset' => 'UTF-8',
		'code'    => 'sn-zw',
		'emoji'   => '🇸🇳',
	],
	'sn' => [
		'name'    => 'Shona',
		'charset' => 'UTF-8',
		'code'    => 'sn',
		'emoji'   => '🇸🇳',
	],
	'ii_CN' => [
		'name'    => 'Sichuan Yi (China)',
		'charset' => 'UTF-8',
		'code'    => 'ii-cn',
	],
	'ii' => [
		'name'    => 'Sichuan Yi',
		'charset' => 'UTF-8',
		'code'    => 'ii',
	],
	'si_LK' => [
		'name'    => 'Sinhala (Sri Lanka)',
		'charset' => 'UTF-8',
		'code'    => 'si-lk',
		'emoji'   => '🇸🇮',
	],
	'si' => [
		'name'    => 'Sinhala',
		'charset' => 'UTF-8',
		'code'    => 'si',
		'emoji'   => '🇸🇮',
	],
	'sk_SK' => [
		'name'    => 'Slovak (Slovakia)',
		'charset' => 'ISO-8859-2',
		'code'    => 'sk-sk',
		'emoji'   => '🇸🇰',
	],
	'sk' => [
		'name'    => 'Slovak',
		'charset' => 'ISO-8859-2',
		'code'    => 'sk',
		'emoji'   => '🇸🇰',
	],
	'sl_SI' => [
		'name'    => 'Slovenian (Slovenia)',
		'charset' => 'ISO-8859-2',
		'code'    => 'sl-si',
		'emoji'   => '🇸🇱',
	],
	'sl' => [
		'name'    => 'Slovenian',
		'charset' => 'ISO-8859-2',
		'code'    => 'sl',
		'emoji'   => '🇸🇱',
	],
	'xog_UG' => [
		'name'    => 'Soga (Uganda)',
		'charset' => 'UTF-8',
		'code'    => 'xog-ug',
	],
	'xog' => [
		'name'    => 'Soga',
		'charset' => 'UTF-8',
		'code'    => 'xog',
	],
	'so_DJ' => [
		'name'    => 'Somali (Djibouti)',
		'charset' => 'UTF-8',
		'code'    => 'so-dj',
		'emoji'   => '🇸🇴',
	],
	'so_ET' => [
		'name'    => 'Somali (Ethiopia)',
		'charset' => 'UTF-8',
		'code'    => 'so-et',
		'emoji'   => '🇸🇴',
	],
	'so_KE' => [
		'name'    => 'Somali (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'so-ke',
		'emoji'   => '🇸🇴',
	],
	'so_SO' => [
		'name'    => 'Somali (Somalia)',
		'charset' => 'UTF-8',
		'code'    => 'so-so',
		'emoji'   => '🇸🇴',
	],
	'so' => [
		'name'    => 'Somali',
		'charset' => 'UTF-8',
		'code'    => 'so',
		'emoji'   => '🇸🇴',
	],
	'es_AR' => [
		'name'    => 'Spanish (Argentina)',
		'charset' => 'UTF-8',
		'code'    => 'es-ar',
		'emoji'   => '🇪🇸',
	],
	'es_BO' => [
		'name'    => 'Spanish (Bolivia)',
		'charset' => 'UTF-8',
		'code'    => 'es-bo',
		'emoji'   => '🇪🇸',
	],
	'es_CL' => [
		'name'    => 'Spanish (Chile)',
		'charset' => 'UTF-8',
		'code'    => 'es-cl',
		'emoji'   => '🇪🇸',
	],
	'es_CO' => [
		'name'    => 'Spanish (Colombia)',
		'charset' => 'UTF-8',
		'code'    => 'es-co',
		'emoji'   => '🇪🇸',
	],
	'es_CR' => [
		'name'    => 'Spanish (Costa Rica)',
		'charset' => 'UTF-8',
		'code'    => 'es-cr',
		'emoji'   => '🇪🇸',
	],
	'es_DO' => [
		'name'    => 'Spanish (Dominican Republic)',
		'charset' => 'UTF-8',
		'code'    => 'es-do',
		'emoji'   => '🇪🇸',
	],
	'es_EC' => [
		'name'    => 'Spanish (Ecuador)',
		'charset' => 'UTF-8',
		'code'    => 'es-ec',
		'emoji'   => '🇪🇸',
	],
	'es_SV' => [
		'name'    => 'Spanish (El Salvador)',
		'charset' => 'UTF-8',
		'code'    => 'es-sv',
		'emoji'   => '🇪🇸',
	],
	'es_GQ' => [
		'name'    => 'Spanish (Equatorial Guinea)',
		'charset' => 'UTF-8',
		'code'    => 'es-gq',
		'emoji'   => '🇪🇸',
	],
	'es_GT' => [
		'name'    => 'Spanish (Guatemala)',
		'charset' => 'UTF-8',
		'code'    => 'es-gt',
		'emoji'   => '🇪🇸',
	],
	'es_HN' => [
		'name'    => 'Spanish (Honduras)',
		'charset' => 'UTF-8',
		'code'    => 'es-hn',
		'emoji'   => '🇪🇸',
	],
	'es_419' => [
		'name'    => 'Spanish (Latin America)',
		'charset' => 'UTF-8',
		'code'    => 'es-419',
		'emoji'   => '🇪🇸',
	],
	'es_MX' => [
		'name'    => 'Spanish (Mexico)',
		'charset' => 'UTF-8',
		'code'    => 'es-mx',
		'emoji'   => '🇪🇸',
	],
	'es_NI' => [
		'name'    => 'Spanish (Nicaragua)',
		'charset' => 'UTF-8',
		'code'    => 'es-ni',
		'emoji'   => '🇪🇸',
	],
	'es_PA' => [
		'name'    => 'Spanish (Panama)',
		'charset' => 'UTF-8',
		'code'    => 'es-pa',
		'emoji'   => '🇪🇸',
	],
	'es_PY' => [
		'name'    => 'Spanish (Paraguay)',
		'charset' => 'UTF-8',
		'code'    => 'es-py',
		'emoji'   => '🇪🇸',
	],
	'es_PE' => [
		'name'    => 'Spanish (Peru)',
		'charset' => 'UTF-8',
		'code'    => 'es-pe',
		'emoji'   => '🇪🇸',
	],
	'es_PR' => [
		'name'    => 'Spanish (Puerto Rico)',
		'charset' => 'UTF-8',
		'code'    => 'es-pr',
		'emoji'   => '🇪🇸',
	],
	'es_US' => [
		'name'    => 'Spanish (United States)',
		'charset' => 'UTF-8',
		'code'    => 'es-us',
		'emoji'   => '🇪🇸',
	],
	'es_UY' => [
		'name'    => 'Spanish (Uruguay)',
		'charset' => 'UTF-8',
		'code'    => 'es-uy',
		'emoji'   => '🇪🇸',
	],
	'es_VE' => [
		'name'    => 'Spanish (Venezuela)',
		'charset' => 'UTF-8',
		'code'    => 'es-ve',
		'emoji'   => '🇪🇸',
	],
	'es' => [
		'name'    => 'Spanish',
		'charset' => 'UTF-8',
		'code'    => 'es',
		'emoji'   => '🇪🇸',
	],
	'sw_KE' => [
		'name'    => 'Swahili (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'sw-ke',
	],
	'sw_TZ' => [
		'name'    => 'Swahili (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'sw-tz',
	],
	'sw' => [
		'name'    => 'Swahili',
		'charset' => 'UTF-8',
		'code'    => 'sw',
	],
	'sv_FI' => [
		'name'    => 'Swedish (Finland)',
		'charset' => 'UTF-8',
		'code'    => 'sv-fi',
		'emoji'   => '🇸🇻',
	],
	'sv_SE' => [
		'name'    => 'Swedish (Sweden)',
		'charset' => 'UTF-8',
		'code'    => 'sv-se',
		'emoji'   => '🇸🇻',
	],
	'sv' => [
		'name'    => 'Swedish',
		'charset' => 'UTF-8',
		'code'    => 'sv',
		'emoji'   => '🇸🇻',
	],
	'gsw_CH' => [
		'name'    => 'Swiss German (Switzerland)',
		'charset' => 'UTF-8',
		'code'    => 'gsw-ch',
	],
	'gsw' => [
		'name'    => 'Swiss German',
		'charset' => 'UTF-8',
		'code'    => 'gsw',
	],
	'shi_Latn' => [
		'name'    => 'Tachelhit (Latin)',
		'charset' => 'UTF-8',
		'code'    => 'shi-latn',
	],
	'shi_Latn_MA' => [
		'name'    => 'Tachelhit (Latin, Morocco)',
		'charset' => 'UTF-8',
		'code'    => 'shi-latn-ma',
	],
	'shi_Tfng' => [
		'name'    => 'Tachelhit (Tifinagh)',
		'charset' => 'UTF-8',
		'code'    => 'shi-tfng',
	],
	'shi_Tfng_MA' => [
		'name'    => 'Tachelhit (Tifinagh, Morocco)',
		'charset' => 'UTF-8',
		'code'    => 'shi-tfng-ma',
	],
	'shi' => [
		'name'    => 'Tachelhit',
		'charset' => 'UTF-8',
		'code'    => 'shi',
	],
	'dav_KE' => [
		'name'    => 'Taita (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'dav-ke',
	],
	'dav' => [
		'name'    => 'Taita',
		'charset' => 'UTF-8',
		'code'    => 'dav',
	],
	'ta_IN' => [
		'name'    => 'Tamil (India)',
		'charset' => 'UTF-8',
		'code'    => 'ta-in',
	],
	'ta_LK' => [
		'name'    => 'Tamil (Sri Lanka)',
		'charset' => 'UTF-8',
		'code'    => 'ta-lk',
	],
	'ta' => [
		'name'    => 'Tamil',
		'charset' => 'UTF-8',
		'code'    => 'ta',
	],
	'te_IN' => [
		'name'    => 'Telugu (India)',
		'charset' => 'UTF-8',
		'code'    => 'te-in',
	],
	'te' => [
		'name'    => 'Telugu',
		'charset' => 'UTF-8',
		'code'    => 'te',
	],
	'teo_KE' => [
		'name'    => 'Teso (Kenya)',
		'charset' => 'UTF-8',
		'code'    => 'teo-ke',
	],
	'teo_UG' => [
		'name'    => 'Teso (Uganda)',
		'charset' => 'UTF-8',
		'code'    => 'teo-ug',
	],
	'teo' => [
		'name'    => 'Teso',
		'charset' => 'UTF-8',
		'code'    => 'teo',
	],
	'th_TH' => [
		'name'    => 'Thai (Thailand)',
		'charset' => 'TIS-620',
		'code'    => 'th-th',
		'emoji'   => '🇹🇭',
	],
	'th' => [
		'name'    => 'Thai',
		'charset' => 'TIS-620',
		'code'    => 'th',
		'emoji'   => '🇹🇭',
	],
	'bo_CN' => [
		'name'    => 'Tibetan (China)',
		'charset' => 'UTF-8',
		'code'    => 'bo-cn',
		'emoji'   => '🇧🇴',
	],
	'bo_IN' => [
		'name'    => 'Tibetan (India)',
		'charset' => 'UTF-8',
		'code'    => 'bo-in',
		'emoji'   => '🇧🇴',
	],
	'bo' => [
		'name'    => 'Tibetan',
		'charset' => 'UTF-8',
		'code'    => 'bo',
		'emoji'   => '🇧🇴',
	],
	'ti_ER' => [
		'name'    => 'Tigrinya (Eritrea)',
		'charset' => 'UTF-8',
		'code'    => 'ti-er',
	],
	'ti_ET' => [
		'name'    => 'Tigrinya (Ethiopia)',
		'charset' => 'UTF-8',
		'code'    => 'ti-et',
	],
	'ti' => [
		'name'    => 'Tigrinya',
		'charset' => 'UTF-8',
		'code'    => 'ti',
	],
	'to_TO' => [
		'name'    => 'Tonga (Tonga)',
		'charset' => 'UTF-8',
		'code'    => 'to-to',
		'emoji'   => '🇹🇴',
	],
	'to' => [
		'name'    => 'Tonga',
		'charset' => 'UTF-8',
		'code'    => 'to',
		'emoji'   => '🇹🇴',
	],
	'tr' => [
		'name'    => 'Turkish',
		'charset' => 'ISO-8859-9',
		'code'    => 'tr',
		'emoji'   => '🇹🇷',
	],
	'uk_UA' => [
		'name'    => 'Ukrainian (Ukraine)',
		'charset' => 'KOI8-U',
		'code'    => 'uk-ua',
	],
	'uk' => [
		'name'    => 'Ukrainian',
		'charset' => 'KOI8-U',
		'code'    => 'uk',
	],
	'ur_IN' => [
		'name'    => 'Urdu (India)',
		'charset' => 'UTF-8',
		'code'    => 'ur-in',
		'rtl'     => true,
	],
	'ur_PK' => [
		'name'    => 'Urdu (Pakistan)',
		'charset' => 'UTF-8',
		'code'    => 'ur-pk',
		'rtl'     => true,
	],
	'ur' => [
		'name'    => 'Urdu',
		'charset' => 'UTF-8',
		'code'    => 'ur',
		'rtl'     => true,
	],
	'uz_Arab' => [
		'name'    => 'Uzbek (Arabic)',
		'charset' => 'UTF-8',
		'code'    => 'uz-arab',
		'rtl'     => true,
		'emoji'   => '🇺🇿',
	],
	'uz_Arab_AF' => [
		'name'    => 'Uzbek (Arabic, Afghanistan)',
		'charset' => 'UTF-8',
		'code'    => 'uz-arab-af',
		'emoji'   => '🇺🇿',
	],
	'uz_Cyrl' => [
		'name'    => 'Uzbek (Cyrillic)',
		'charset' => 'UTF-8',
		'code'    => 'uz-cyrl',
		'emoji'   => '🇺🇿',
	],
	'uz_Cyrl_UZ' => [
		'name'    => 'Uzbek (Cyrillic, Uzbekistan)',
		'charset' => 'UTF-8',
		'code'    => 'uz-cyrl-uz',
		'emoji'   => '🇺🇿',
	],
	'uz_Latn' => [
		'name'    => 'Uzbek (Latin)',
		'charset' => 'UTF-8',
		'code'    => 'uz-latn',
		'emoji'   => '🇺🇿',
	],
	'uz_Latn_UZ' => [
		'name'    => 'Uzbek (Latin, Uzbekistan)',
		'charset' => 'UTF-8',
		'code'    => 'uz-latn-uz',
		'emoji'   => '🇺🇿',
	],
	'uz' => [
		'name'    => 'Uzbek',
		'charset' => 'UTF-8',
		'code'    => 'uz',
		'emoji'   => '🇺🇿',
	],
	'vi_VN' => [
		'name'    => 'Vietnamese (Vietnam)',
		'charset' => 'UTF-8',
		'code'    => 'vi-vn',
		'emoji'   => '🇻🇮',
	],
	'vi' => [
		'name'    => 'Vietnamese',
		'charset' => 'UTF-8',
		'code'    => 'vi',
		'emoji'   => '🇻🇮',
	],
	'vun_TZ' => [
		'name'    => 'Vunjo (Tanzania)',
		'charset' => 'UTF-8',
		'code'    => 'vun-tz',
	],
	'vun' => [
		'name'    => 'Vunjo',
		'charset' => 'UTF-8',
		'code'    => 'vun',
	],
	'cy_GB' => [
		'name'    => 'Welsh (United Kingdom)',
		'charset' => 'UTF-8',
		'code'    => 'cy-gb',
		'emoji'   => '🇨🇾',
	],
	'cy' => [
		'name'    => 'Welsh',
		'charset' => 'UTF-8',
		'code'    => 'cy',
		'emoji'   => '🇨🇾',
	],
	'yo_NG' => [
		'name'    => 'Yoruba (Nigeria)',
		'charset' => 'UTF-8',
		'code'    => 'yo-ng',
	],
	'yo' => [
		'name'    => 'Yoruba',
		'charset' => 'UTF-8',
		'code'    => 'yo',
	],
	'zu_ZA' => [
		'name'    => 'Zulu (South Africa)',
		'charset' => 'ISO-8859-1',
		'code'    => 'zu-za',
	],
	'zu' => [
		'name'    => 'Zulu',
		'charset' => 'ISO-8859-1',
		'code'    => 'zu',
	],
];
