//https://github.com/moreonion/Mergetags-TinyMCE-Plugin
var mergetags=function(c){"use strict";class h{constructor(e,t,s,i,r){this.editor=e,this.options=t,this.tokens=s,this.renderer=i,this.interactions=r}bindAll(){this.editor.on("GetContent",t=>{t.content=this.renderer.replaceTokensWithDelimiters(t.content)});const e=t=>{t.content=this.renderer.replaceDelimitersWithTokens(t.content,this.tokens)};this.editor.on("BeforeSetContent",e),this.editor.on("PastePreProcess",e),this.editor.on("PreInit",()=>{this.editor.schema.addValidElements("span[class|contenteditable|data-mt-val]")}),this.editor.on("init",()=>{const t=this.editor.getContainer();this.containerClickHandler=s=>this.interactions.activateTokenOnClick(s),t.addEventListener("click",this.containerClickHandler)}),this.editor.on("remove",()=>{const t=this.editor.getContainer();this.containerClickHandler&&t.removeEventListener("click",this.containerClickHandler)})}mount(){const e={trigger:this.options.getPrefix(),minChars:0,columns:1,matches:()=>!0,fetch:(t,s)=>Promise.resolve(this.tokens.autocomplete(t,s)),onAction:(t,s,i)=>{s&&this.editor.selection.setRng(s),this.interactions.insertByValue(String(i)),t.hide()}};this.editor.ui.registry.addIcon("mergetags",'<svg width="24" height="24" focusable="false"><path fill-rule="evenodd" clip-rule="evenodd" d="M15 5a2 2 0 0 1 1.6.8L21 12l-4.4 6.2a2 2 0 0 1-1.6.8h-3v-2h3l3.5-5L15 7H5v3H3V7c0-1.1.9-2 2-2h10Z"></path><path fill-rule="evenodd" clip-rule="evenodd" d="M6 12a1 1 0 0 0-1 1v2H3a1 1 0 1 0 0 2h2v2a1 1 0 1 0 2 0v-2h2a1 1 0 1 0 0-2H7v-2c0-.6-.4-1-1-1Z"></path></svg>'),this.editor.ui.registry.addMenuButton("mergetags",{icon:"mergetags",tooltip:"Insert merge tag",fetch:t=>t(this.tokens.buildMenuItems(this.interactions))}),this.editor.ui.registry.addNestedMenuItem("mergetags-menu",{text:"Merge tags",getSubmenuItems:()=>this.tokens.buildMenuItems(this.interactions)}),this.editor.ui.registry.addAutocompleter("mergetags",e)}}class d{constructor(e){this.editorOptions=e}register(){const{register:e}=this.editorOptions;e("mergetags_prefix",{processor:"string",default:"{{"}),e("mergetags_suffix",{processor:"string",default:"}}"}),e("mergetags_token_class",{processor:"string",default:"mce-mergetag"}),e("mergetags_brace_class",{processor:"string",default:"mce-mergetag-affix"}),e("mergetags_highlight_class",{processor:"string",default:"mt-active"}),e("mergetags_display",{processor:"string",default:"value"}),e("mergetags_keep_unknown",{processor:"boolean",default:!0}),e("mergetags_list",{processor:"array",default:[]})}getPrefix(){return this.editorOptions.get("mergetags_prefix")}getSuffix(){return this.editorOptions.get("mergetags_suffix")}getTokenClass(){return this.editorOptions.get("mergetags_token_class")}getBraceClass(){return this.editorOptions.get("mergetags_brace_class")}getActiveClass(){return this.editorOptions.get("mergetags_highlight_class")}getDisplayMode(){return this.editorOptions.get("mergetags_display")}keepUnknown(){return!!this.editorOptions.get("mergetags_keep_unknown")}getList(){return this.editorOptions.get("mergetags_list")}}class m{constructor(e,t,s,i){this.editor=e,this.tokenClass=t.getTokenClass(),this.activeClass=t.getActiveClass(),this.renderer=s,this.tokens=i}clearActiveTokens(){const e=this.editor.getBody(),{tokenClass:t,activeClass:s}=this;e.querySelectorAll(`.${t}.${s}`).forEach(i=>i.classList.remove(s))}activateToken(e){this.clearActiveTokens(),e.classList.add(this.activeClass),this.editor.selection.select(e),this.editor.selection.collapse(!1)}insertTag(e){this.editor.undoManager.transact(()=>{const t=this.renderer.createTokenElement(e);this.editor.selection.setNode(t)})}insertByValue(e){const t=this.tokens.getByValue(e);t&&this.insertTag(t)}getTokenAncestor(e){return e.closest("."+this.tokenClass)}activateTokenOnClick(e){const t=this.getTokenAncestor(e.target);if(!t)return this.clearActiveTokens();e.preventDefault(),this.activateToken(t)}}const u=n=>String(n).replace(/[.*+?^${}()|[\]\\]/g,"\\$&");class p{constructor(e){this.displayMode=e.getDisplayMode(),this.tokenClass=e.getTokenClass(),this.braceClass=e.getBraceClass(),this.prefix=e.getPrefix(),this.suffix=e.getSuffix()}#e(e){return this.displayMode==="value"?e.value:e.title||e.value}createTokenElement(e){const t=document.createElement("span");t.setAttribute("class",this.tokenClass),t.setAttribute("data-mt-val",e.value),t.setAttribute("contenteditable","false");const s=document.createElement("span");s.setAttribute("class",this.braceClass),s.textContent=this.prefix;const i=document.createTextNode(this.#e(e)),r=document.createElement("span");return r.setAttribute("class",this.braceClass),r.textContent=this.suffix,t.append(s,i,r),t}toSpanHTML(e,t){return this.createTokenElement(e,t).outerHTML}getDelimiterRegex(e="g"){const t=u(this.prefix),s=u(this.suffix);return new RegExp(`${t}([\\s\\S]*?)${s}`,e)}wrap(e){return`${this.prefix}${String(e)}${this.suffix}`}replaceTokensWithDelimiters(e){const t=document.createElement("div");t.innerHTML=e;for(const s of t.querySelectorAll(`span.${this.tokenClass}[data-mt-val]`)){const i=s.getAttribute("data-mt-val")||"";s.replaceWith(document.createTextNode(this.wrap(i)))}return t.innerHTML}replaceDelimitersWithTokens(e,t){const s=this.getDelimiterRegex("g");return e.replace(s,(i,r)=>{const o=t.getByValue(String(r));return o?this.toSpanHTML(o):i})}}class l{#e=[];#t=[];#s=new Map;static normalizeGroups(e){return Array.isArray(e)?e.map(t=>{const s=t?.menu??t?.items;return Array.isArray(s)?{title:String(t?.title??""),menu:l.normalizeGroups(s)}:typeof t?.value<"u"?{title:String(t?.title??t.value),value:String(t.value)}:null}).filter(Boolean):[]}static flatten(e,t=[]){for(const s of e)Array.isArray(s?.menu)?l.flatten(s.menu,t):typeof s?.value<"u"&&t.push({title:String(s.title??s.value),value:String(s.value)});return t}setTokens(e){this.#e=l.normalizeGroups(e??[]),this.#i()}refreshFromOptions(e){this.setTokens(e?.getList?.())}#i(){this.#t=l.flatten(this.#e,[]),this.#s=new Map(this.#t.map(e=>[e.value,e]))}autocomplete(e,t){const s=(e||"").toLowerCase(),i=this.#t,r=s?i.filter(a=>(a.title||a.value).toLowerCase().includes(s)||a.value.toLowerCase().includes(s)):i.slice(),o=Math.min(typeof t=="number"?t:10,r.length);return r.slice(0,o).map(a=>({text:a.title||a.value,value:a.value}))}buildMenuItems=e=>{if(!this.#e?.length)return[{type:"menuitem",text:"No tags",enabled:!1}];const t=s=>({type:"menuitem",text:s.title??s.value??"",onAction:()=>e.insertTag({title:s.title??s.value??"",value:s.value})});return this.#e.map(s=>Array.isArray(s.menu)?{type:"nestedmenuitem",text:s.title??"",getSubmenuItems:()=>s.menu.map(t)}:t(s))};getGroups(){return this.#e}getByValue(e){return this.#s.get(String(e))}}const g=n=>{n.PluginManager.add("mergetags",e=>{const t=new d(e.options);t.register();const s=new l;s.refreshFromOptions(t);const i=new p(t),r=new m(e,t,i,s),o=new h(e,t,s,i,r);return o.mount(),o.bindAll(),{getMetadata:()=>({name:"Merge Tags",version:"1.0.0"})}})};return(()=>{const n=typeof window<"u"&&window.tinymce?window.tinymce:null;n&&g(n)})(),c.registerMergetags=g,Object.defineProperty(c,Symbol.toStringTag,{value:"Module"}),c}({});
