DROP TABLE IF EXISTS coupon;

-- DROP SEQUENCE IF EXISTS coupon_coupon_id_seq;
-- CREATE SEQUENCE coupon_coupon_id_seq;

CREATE TABLE coupon (
  "coupon_id" int PRIMARY KEY GENERATED BY DEFAULT AS IDENTITY, -- SERIAL PRIMARY KEY
  "name" varchar(128) NOT NULL,
  "code" varchar(20) NOT NULL,
  "type" char(1) NOT NULL,
  "discount" decimal(15,4) NOT NULL,
  "total" decimal(15,4) NOT NULL,
  "limit" int check ("limit" > 0) NOT NULL,
  "limit_user" varchar(11) NOT NULL,
  "logged_in" smallint NOT NULL,
  "free_shipping" smallint NOT NULL,
  "status" smallint NOT NULL,
  "from_date" date NOT NULL DEFAULT '1000-01-01',
  "to_date" date NOT NULL DEFAULT '1000-01-01',
  "created_at" timestamp(0) NOT NULL DEFAULT now(),
  "updated_at" timestamp(0) NOT NULL DEFAULT now()
  -- PRIMARY KEY("coupon_id")
);

SELECT setval('coupon_coupon_id_seq', 3, true); -- last inserted id by sample data