Vvveb.Sections.add("hero/hero-1", {
    name: "Hero 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-1-thumb.webp",
    html: `<header class="hero-1" aria-label="hero-1">

  <div class="container">
    <div class="heading">
      <h1 class="display-1">Open Source CMS Reinvented</h1>

      <h2 class="fs-3 text-muted">Powerful and easy to use drag and drop website builder for blogs, websites or ecommerce stores.</h2>

      <div class="btns">
        <a class="btn btn-primary btn-lg btn-shadow" href="/page/download" role="button">
          <span>Create website</span>
          <i class="la la-caret-right"></i>
        </a>

        <a class="btn btn-outline-secondary btn-lg btn-shadow" href="/download.php" role="button">
          <span>Free Download</span>
          <i class="la la-arrow-down"></i>
        </a>
        <!--
				<div class="nav-item dropdown">
					<a class="btn btn-outline-primary nav-link dropdown-toggle" href="//demo.vvveb.com/admin/?module=/editor/editor&template=index.html&url=/" role="button">Live demo <b>›</b></a>
					<div class="dropdown-menu">
					  <a class="dropdown-item" target="_blank" href="//demo.vvveb.com/admin/?module=/editor/editor&template=index.html&url=/">Page builder</a>
					  <a class="dropdown-item" target="_blank" href="//demo.vvveb.com/admin">Admin dashboard</a>
					  <a class="dropdown-item" target="_blank" href="//demo.vvveb.com">Frontend</a>
					  <div class="dropdown-divider"></div>
					  <a class="dropdown-item" target="_blank" href="https://vercel-vvveb-commerce.vercel.app/">Next.js Frontend GraphQL</a>
					</div>
				</div>
				-->
      </div>

    </div>

    <div class="frame mx-auto">
      <!--
        <video loading="lazy" src="video/intro.mp4" width="1280" muted="true" playsinline="true" loop="true" controls="true" poster="https://www.vvveb.com/img/dark-theme.webp"></video> -->
      <img src="https://www.vvveb.com/img/dark-theme.webp" class="img-fluid">
    </div>
  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <!-- <img src="demo/img//background.svg" alt="Hero background" loading="lazy"> -->
  </div>

</header>`
});Vvveb.Sections.add("hero/hero-2", {
    name: "Hero 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-2-thumb.webp",
    html: `<header class="hero-2" aria-label="hero-2">

  <div class="container">
    <div class="row align-items-center justify-content-between">
      <div class="col-lg-6 mb-5 ms-5" data-aos="fade-up" data-aos-delay="0">
        <h1 class="heading">The next generation website builder</h1>
        <p class="subheading mb-5">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
        <p>
          <a href="https://www.vvveb.com" class="btn btn-light">
            <span>&#9889;</span>
            <span>Free Download</span>
            <b>›</b>
          </a>

          <a href="https://demo.vvveb.com" class="btn btn-outline-light">Live Demo</a>
        </p>
      </div>
      <div class="col-lg-5" data-aos="fade-up" data-aos-delay="100">
        <a href="https://www.youtube.com/watch?v=3xsP3u-CVO4" class="video-wrap glightbox">
          <span class="play-button">
            <i class="la la-play"></i>
          </span>
          <img src="demo/img/team-1.jpg" loading="lazy" alt="Video image" class="img-fluid">
        </a>
      </div>
    </div>
  </div>

  <div class="separator bottom">
    <svg height="100px" id="Layer_1" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" fill="var(--bs-body-bg)" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px" width="100%" height="250">
      <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729
		c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" fill="#FFFFFF" opacity="0.6"></path>
      <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729
		c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" fill="#FFFFFF" opacity="0.6"></path>
      <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716
		H42.401L43.415,98.342z" fill="#FFFFFF" opacity="0.7"></path>
      <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428
		c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z" fill="#FFFFFF"></path>
    </svg>
  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/team-2.jpg">
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-3-full", {
    name: "Hero 3 full",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-3-full-thumb.webp",
    html: `<header class="hero-3" aria-label="hero-3">

  <div class="container vh-100">
    <div>
      <div class="row align-items-center justify-content-center text-center">
        <div class="col-lg-12">
          <h1 class="heading mb-4 display-3" data-aos="fade-up" data-aos-delay="100">Next generation website builder</h1>
          <div class="col-lg-8 mx-auto">
            <h2 class="h4 lh-base fw-normal" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</h2>
          </div>

          <div class="buttons" data-aos="fade-up" data-aos-delay="300">
            <a href="https://www.vvveb.com" class="btn btn-primary">
              <span>&#9889;</span>
              <span>Free Download</span>
            </a>
            <a href="https://demo.vvveb.com" class="btn btn-light">Live Demo</a>
          </div>


        </div>
      </div>
    </div>
  </div>
  <!--  
    <div class="separator bottom">
		
		<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" height="100" fill="var(--bs-body-bg)" preserveAspectRatio="none"><defs></defs><title>rough-edges-bottom</title><path d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)"/></svg>
		
    </div>   
-->
  <!--
   <div class="separator top">
		
		<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" height="200" preserveAspectRatio="none"><defs><style>.cls-1{fill:var(--bs-body-bg);}</style></defs><title>rough-edges-bottom</title><path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)"/></svg>
		
    </div>
-->
  <div class="overlay">
  </div>

  <div class="background-container">

    <img src="demo/img/hero-3.webp" alt="Hero background">

  </div>

</header>`
});Vvveb.Sections.add("hero/hero-3", {
    name: "Hero 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-3-thumb.webp",
    html: `<header class="hero-3" aria-label="hero-3">

  <div class="container">
    <div>
      <div class="row align-items-center justify-content-center text-center">
        <div class="col-lg-12">
          <h1 class="heading mb-4 display-2" data-aos="fade-up" data-aos-delay="100">Next generation website builder</h1>
          <div class="col-lg-8 mx-auto">
            <h2 class="h3 lh-base fw-normal" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</h2>
          </div>

          <div class="buttons" data-aos="fade-up" data-aos-delay="300">
            <a href="https://www.vvveb.com" class="btn btn-primary btn-lg">
              <span>Free Download</span>
              <span>&#9889;</span>
            </a>
            <a href="https://demo.vvveb.com" class="btn btn-light btn-lg">Live Demo</a>
          </div>


        </div>
      </div>
    </div>
  </div>

  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" height="100" fill="var(--bs-body-bg)" preserveAspectRatio="none">
      <defs></defs>
      <title>rough-edges-bottom</title>
      <path d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>
  <!--
   <div class="separator top">
		
		<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" height="200" preserveAspectRatio="none"><defs><style>.cls-1{fill:var(--bs-body-bg);}</style></defs><title>rough-edges-bottom</title><path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)"/></svg>
		
    </div>
-->
  <div class="overlay">
  </div>

  <div class="background-container">

    <img src="demo/img/hero-3.webp" alt="Hero background">

  </div>

</header>`
});Vvveb.Sections.add("hero/hero-4", {
    name: "Hero 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-4-thumb.webp",
    html: `<header class="hero-4" aria-label="hero-4">

  <div class="container">
    <div class="row align-items-center justify-content-center text-center">
      <div class="" data-aos="fade-up" data-aos-delay="100">
        <h1 class="heading mb-3 display-4">The next generation website builder</h1>
        <h4 class="subheading mb-5">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</h4>

        <img width="480" src="demo/img/team-1.jpg" class="img-fluid shadow rounded-4">

        <div class="buttons">

          <a href="https://www.vvveb.com" class="btn btn-primary btn-lg">
            <span>⚡</span>
            <span>Free Download</span>
            <b>›</b>
          </a>
          <a href="https://demo.vvveb.com" class="btn btn-white btn-lg">Live Demo</a>

        </div>
      </div>
    </div>
  </div>

  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background">
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-5", {
    name: "Hero 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-5-thumb.webp",
    html: `<header class="hero-5" aria-label="hero-5">

  <div class="container">
    <div class="row align-items-center d-flex justify-content-between">
      <div class="col-12 col-md-6 pb-5 order-2 order-sm-2 ">
        <h1 class="fw-bold mb-3 mt-5 display-3">The next generation website builder.</h1>
        <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">
            <span>&#9889;</span>
            <span>Free Download</span>
          </a>
          <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>
      <div class="col-12 col-md-6 order-sm-1 order-md-2">

        <div class="rounded-4 position-relative overflow-hidden">
          <img class="img-fluid w-100 shadow" src="demo/img/team-1.jpg" alt="Team 1">
          <a class="position-absolute top-50 start-50 translate-middle glightbox d-flex justify-content-center align-items-center z-2" href="https://www.youtube.com/watch?v=rPbrR6b6ZYs">
            <svg xmlns="http://www.w3.org/2000/svg" width="5em" height="5em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
            </svg>
          </a>
          <div class="overlay z-1"></div>
        </div>


      </div>
    </div>
  </div>


  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background">
  </div>

</header>`
});Vvveb.Sections.add("hero/hero-6", {
    name: "Hero 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-6-thumb.webp",
    html: `<header class="hero-6" aria-label="hero-6">

  <div class="container">
    <div class="row align-items-center d-flex justify-content-between">
      <div class="col-12 col-md-6 pb-5 order-2 order-sm-2 ">
        <h1 class="fw-bold mb-3 mt-5 display-3">The next generation website builder.</h1>
        <p class="lead text-white">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
        <div class="d-grid d-lg-block gap-2 mt-4">
          <a class="btn btn-primary btn-lg ms-0" href="#" role="button">
            <span>&#9889;</span>
            <span>Free Download</span>
          </a>
          <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>
      <div class="col-12 col-md-6 order-sm-1 order-md-2">
        <img src="demo/img/team-1.jpg" class="shadow img-fluid rounded-4" loading="lazy">
      </div>
    </div>
  </div>
  </div>

  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background" loading="lazy">
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-7", {
    name: "Hero 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-7-thumb.webp",
    html: `<header class="hero-7" aria-label="hero-7">

  <div class="container">
    <div>
      <div class="row align-items-center justify-content-center text-start g-5">
        <div class="col-lg-5">
          <img src="demo/img/team-1.jpg" class="img-fluid shadow">
        </div>

        <div class="col-lg-7">
          <h1 class="heading mb-3 display-3 fw-bold" data-aos="fade-up" data-aos-delay="100">Open source CMS reinvented</h1>
          <h2 class="h3 col-lg-8" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</h2>


          <div class="buttons mt-4" data-aos="fade-up" data-aos-delay="300">
            <a href="https://www.vvveb.com" class="btn btn-primary btn-lg">
              <span>⚡</span>
              <span>Free Download</span>
              <b>›</b>
            </a>
            <a href="https://demo.vvveb.com" class="btn btn-white btn-lg">Live Demo</a>
          </div>


        </div>
      </div>
    </div>
  </div>

  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background">
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-8", {
    name: "Hero 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-8-thumb.webp",
    html: `<header class="hero-8 pt-5" aria-label="hero-8">

  <div class="container py-5">
    <div class="row mb-4 mb-lg-5">
      <div class="col-lg-9 mx-auto text-center">
        <div class="mb-4">
          <div>
            <h1 class="display-2 fw-bold text-white">Next generation website builder</h1>
          </div>
        </div>

        <div class="mb-4">
          <div>
            <p class="h4 lh-base fw-normal aos-init aos-animate  text-white">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
          </div>
        </div>
        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">Free download</a>
          <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
        </div>

      </div>
    </div>

    <div class="row mb-4 ">
      <div class="col-lg-10 mx-auto text-center">

        <div class="rounded-4 position-relative overflow-hidden">
          <img class="img-fluid w-100 shadow" src="demo/img/team-1.jpg" alt="Team 1">
          <a class="position-absolute top-50 start-50 translate-middle glightbox d-flex justify-content-center align-items-center z-2" href="https://www.youtube.com/watch?v=rPbrR6b6ZYs">
            <svg xmlns="http://www.w3.org/2000/svg" width="5em" height="5em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
            </svg>
          </a>
          <div class="overlay z-1"></div>
        </div>
      </div>
    </div>
  </div>



  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>

  <div class="overlay">
  </div>

  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background">
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-9", {
    name: "Hero 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-9-thumb.webp",
    html: `<header class="hero-9 pt-5" aria-label="hero-9">

  <div class="container py-5">
    <div class="row mb-4 mb-lg-5">
      <div class="col-lg-9 mx-auto text-center">
        <div class="mb-4">
          <div>
            <h1 class="display-2 fw-bold">Next generation website builder</h1>
          </div>
        </div>

        <div class="mb-4">
          <div>
            <p class="h4 lh-base fw-normal">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
          </div>
        </div>
        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">Free download</a>
          <a class="btn btn-outline-primary btn-lg" href="#" role="button">Live demo</a>
        </div>

      </div>
    </div>

    <div class="row mb-4 ">
      <div class="col-lg-10 mx-auto text-center">

        <div class="rounded-4 position-relative overflow-hidden">
          <img class="img-fluid w-100 shadow" src="demo/img/team-1.jpg" alt="Team 1">
          <a class="position-absolute top-50 start-50 translate-middle glightbox d-flex justify-content-center align-items-center z-2" href="https://www.youtube.com/watch?v=rPbrR6b6ZYs">
            <svg xmlns="http://www.w3.org/2000/svg" width="5em" height="5em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
            </svg>
          </a>
          <div class="overlay z-1"></div>
        </div>
      </div>
    </div>
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-10", {
    name: "Hero 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-10-thumb.webp",
    html: `<header class="hero-10 pt-5" aria-label="hero-10">

  <div class="container py-5">
    <div class="row mb-4 align-items-center flex-lg-row-reverse">
      <div class="col-md-6 col-xl-7 mb-4 mb-lg-0 " style="">

        <div class="rounded-4 position-relative overflow-hidden">
          <img class="img-fluid w-100 shadow" src="demo/img/team-1.jpg" alt="Team 1">
          <a class="position-absolute top-50 start-50 translate-middle glightbox d-flex justify-content-center align-items-center z-2" href="https://www.youtube.com/watch?v=rPbrR6b6ZYs">
            <svg xmlns="http://www.w3.org/2000/svg" width="5em" height="5em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
            </svg>
          </a>
          <div class="overlay z-1"></div>
        </div>

      </div>
      <div class="col-md-6 col-xl-5">
        <div class="mb-3">
          <div>
            <h1 class="fw-bolder display-2">Next generation website builder</h1>
          </div>
        </div>



        <div class="mb-4">
          <div>
            <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
          </div>
        </div>
        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">
            <span>&#9889;</span>
            <span>Free Download</span>
          </a>
          <a class="btn btn-outline-primary btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>
    </div>
  </div>

</header>`
});Vvveb.Sections.add("hero/hero-11", {
    name: "Hero 11",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-11-thumb.webp",
    html: `<header class="hero-11 py-5" aria-label="hero-11">
  <div class="container-fluid pt-5">
    <div class="row mb-4 mb-lg-5 justify-content-lg-between">
      <div class="col-3 col-md-1 col-lg-2 d-none d-md-flex align-items-center">
        <div class="bg-dark ratio ratio-1x1 opacity-25"> </div>
      </div>
      <div class="col-4 col-md-3 col-lg-2 d-flex flex-column justify-content-between">
        <div class="bg-primary ratio ratio-1x1 opacity-25"> </div>
        <div>
          <img class="img-fluid" src="demo/img/product-2.webp" alt="Team 1">
        </div>
      </div>
      <div class="col-4 col-md-4 col-lg-3">
        <img class="img-fluid" src="demo/img/product.webp" alt="Team 1">
      </div>
      <div class="col-4 col-md-3 col-lg-2 d-flex flex-column justify-content-between">
        <div>
          <img class="img-fluid" src="demo/img/product-2.webp" alt="Team 1">
        </div>
        <div class="bg-primary ratio ratio-1x1 opacity-25"> </div>
      </div>
      <div class="col-3 col-md-1 col-lg-2 d-none d-md-flex  align-items-center">
        <div class="bg-dark ratio ratio-1x1 opacity-25"> </div>
      </div>
    </div>
  </div>
  <div class="container">
    <div class="row justify-content-center">
      <div class="text-center col-md-8">
        <div>
          <h1 class="display-2 fw-bold">Next generation website builder</h1>
        </div>
      </div>
    </div>
    <div class="row justify-content-center">
      <div class="text-center col-xxl-6 col-md-8">
        <div>
          <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
        </div>

        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">Free download</a>
          <a class="btn btn-outline-primary btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>
    </div>
  </div>
</header>`
});Vvveb.Sections.add("hero/hero-12", {
    name: "Hero 12",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-12-thumb.webp",
    html: `<header class="hero-12 py-5" aria-label="hero-12">

  <div class="container-fluid col-xxl-8">
    <div class="row flex-lg-nowrap align-items-center g-5">
      <div class="order-lg-1 w-100">
        <img style="clip-path: polygon(25% 0%, 100% 0%, 100% 99%, 0% 100%);" class="w-100" src="demo/img/team-1.jpg" alt="Team 1">
      </div>
      <div class="col-lg-6 col-xl-5 text-center text-lg-start pt-lg-5 mt-xl-4">
        <div class="mb-4">
          <div>
            <h1 class="display-2 fw-bold">Next generation website builder</h1>
          </div>
        </div>

        <div class="mb-5">
          <div>
            <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
          </div>
        </div>

        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">Free download</a>
          <a class="btn btn-outline-primary btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>

    </div>
  </div>

</header>`
});Vvveb.Sections.add("hero/hero-13", {
    name: "Hero 13",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-13-thumb.webp",
    html: `<header class="hero-13 py-5" aria-label="hero-13">

  <div class="container-fluid col-xxl-8">
    <div class="row flex-lg-nowrap align-items-center g-5">
      <div class="order-lg-1 w-100">
        <video class="min-vh-100" autoplay="true" preload="true" muted="true" loop="true" playsinline="true" style="object-fit: cover; object-position: 50% 50%;" src="../../media/demo/sample.webm" poster="demo/img/video-1.webp" type="video/mp4">
        </video>
      </div>
      <div class="col-lg-6 col-xl-5 text-center text-lg-start pt-lg-5 mt-xl-4">
        <div class="mb-4">
          <div>
            <h1 class="display-2 fw-bold">Next generation website builder</h1>
          </div>
        </div>

        <div class="mb-5">
          <div>
            <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
          </div>
        </div>

        <div class="d-grid d-lg-block gap-2">
          <a class="btn btn-primary btn-lg" href="#" role="button">Free download</a>
          <a class="btn btn-outline-primary btn-lg" href="#" role="button">Live demo</a>
        </div>
      </div>

    </div>
  </div>

</header>`
});Vvveb.Sections.add("hero/hero-14", {
    name: "Hero 14",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-14-thumb.webp",
    html: `<header class="hero-14 py-5" aria-label="hero-14">
  <div class="container">
    <div class="row justify-content-center align-items-center">
      <div class="col-lg-6 mb-5 mb-lg-0">
        <div class="pe-lg-3">
          <h1 class="display-3 fw-bold mb-2 mb-md-3">The next generation <span class="text-primary">website builder</span>
          </h1>
          <p class="lead mb-4">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
        </div>
        <div class="row">
          <div class="col-sm-6 mb-3 mb-sm-0">
            <div class="d-flex">
              <div class="flex-shrink-0">
                <div class="text-primary">
                  <svg class="bi bi-chat-right-fill" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
                    <path d="M14 0a2 2 0 0 1 2 2v12.793a.5.5 0 0 1-.854.353l-2.853-2.853a1 1 0 0 0-.707-.293H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12z"></path>
                  </svg>
                </div>
              </div>
              <div class="ms-3">
                <h6 class="mb-0">24/7</h6>
                <p>Customer Support</p>
              </div>
            </div>
          </div>
          <div class="col-sm-6">
            <div class="d-flex">
              <div class="text-primary">
                <svg class="bi bi-shield-fill-check" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
                  <path d="M8 0c-.69 0-1.843.265-2.928.56-1.11.3-2.229.655-2.887.87a1.54 1.54 0 0 0-1.044 1.262c-.596 4.477.787 7.795 2.465 9.99a11.777 11.777 0 0 0 2.517 2.453c.386.273.744.482 1.048.625.28.132.581.24.829.24s.548-.108.829-.24a7.159 7.159 0 0 0 1.048-.625 11.775 11.775 0 0 0 2.517-2.453c1.678-2.195 3.061-5.513 2.465-9.99a1.541 1.541 0 0 0-1.044-1.263 62.467 62.467 0 0 0-2.887-.87C9.843.266 8.69 0 8 0zm2.146 5.146a.5.5 0 0 1 .708.708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 7.793l2.646-2.647z" fill-rule="evenodd"></path>
                </svg>
              </div>
              <div class="ms-3">
                <h6 class="mb-0">99.99%</h6>
                <p>Uptime Guarantee</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-6">
        <div class="ps-lg-5">
          <div class="card shadow-lg border border-primary text-white text-left h-100">
            <div class="card-body bg-primary p-4 p-xl-5">
              <h2 class="pb-3 text-center">Start Today!</h2>
              <form action="/user/signup" method="post" enctype="multipart/form-data" id="signup-form">
                <input type="hidden" name="csrf" data-v-csrf>


                <label class="form-label" for="username">Username</label>
                <div class="mb-3 input-group">
                  <span class="input-group-text bg-body pe-1">
                    <i class="la la-user"></i>
                  </span>
                  <input name="username" id="username" class="form-control form-control-lg border-start-0 border-start-0" placeholder="Username" type="text" required>
                </div>
                <!--
									<label class="form-label" for="first-name">First name</label>
									<div class="mb-3 input-group">
										<span class="input-group-text bg-body pe-1"> <i class="la la-user"></i> </span>
										<input name="first_name" id="first-name" class="form-control form-control-lg border-start-0 border-start-0" placeholder="First Name" type="text" required>
									</div>

									<label class="form-label" for="last-name">Last name</label>
									<div class="mb-3 input-group">
										<span class="input-group-text bg-body pe-1"> <i class="la la-user"></i> </span>
										<input name="last_name" id="last-name" class="form-control form-control-lg border-start-0 border-start-0" placeholder="Last Name" type="text" required>
									</div>
-->
                <label class="form-label" for="email">Email address</label>
                <div class="mb-3 input-group">
                  <span class="input-group-text bg-body pe-1">
                    <i class="la la-envelope"></i>
                  </span>
                  <input name="email" id="email" class="form-control form-control-lg border-start-0 border-start-0" placeholder="Email address" type="email" required>
                </div>

                <label class="form-label" for="password">Password</label>
                <div class="mb-3 input-group">
                  <span class="input-group-text bg-body pe-1">
                    <i class="la la-lock"></i>
                  </span>
                  <input type="password" minlength="6" autocorrect="off" class="form-control form-control-lg border-start-0 border-start-0" placeholder="Password" id="password" name="password" autocomplete="new-password" value="" aria-label="Password" required>
                  <button class="btn px-3 border border-start-0 bg-body" type="button" onclick="togglePasswordInput(this, 'password')">
                    <i class="la la-eye-slash"></i>
                  </button>
                </div>

                <label class="form-label" for="new-password">Repeat password</label>
                <div class="mb-3 input-group">
                  <span class="input-group-text bg-body pe-1">
                    <i class="la la-lock"></i>
                  </span>
                  <input type="password" minlength="6" autocorrect="off" autocomplete="new-password" class="form-control form-control-lg border-start-0 border-start-0" placeholder="Repeat password" id="confirm_password" name="confirm_password" value="" aria-label="Repeat Password" required>
                  <button class="btn px-3 border border-start-0 bg-body" type="button" onclick="togglePasswordInput(this, 'confirm_password')">
                    <i class="la la-eye-slash"></i>
                  </button>
                </div>

                <!-- if these hidden inputs are filled then ignore, robots -->

                <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

                <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

                <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


                <div class="mb-3">
                  <div class="form-check mb-1">
                    <input type="checkbox" class="form-check-input" id="terms" name="terms" required>
                    <label class="form-check-label" for="terms">
                      </span>I agree to</span>
                      <a href="page/terms-conditions" target="_blank" data-v-url="content/page/index" data-v-url-params='{"slug":"terms-conditions"}'>Terms and conditions</a>
                    </label>
                  </div>
                </div>

                <div class="mb-3">
                  <button type="submit" class="btn btn-dark btn-signup btn-lg my-3">Get started</button>
                </div>

              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
  </section>`
});Vvveb.Sections.add("hero/hero-slider", {
    name: "Hero slider",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/hero/hero-slider-thumb.webp",
    html: `<header class="hero-slider" aria-label="hero-slider">


  <div class="swiper" data-slides-per-view="1" data-draggable="true">
    <div class="swiper-wrapper">


      <div class="swiper-slide">
        <img src="demo/img/hero-3.webp" loading="lazy">
        <div class="content">
          <div class="container">
            <div>
              <div class="row align-items-center justify-content-center text-start">
                <div class="col-lg-6">
                  <h1 class="heading mb-3 display-3 fw-bold" data-aos="fade-up" data-aos-delay="100">The next generation website builder</h1>
                  <p class="col-lg-8 mb-5 text-white" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>


                  <div class="d-grid d-lg-block gap-2" data-aos="fade-up" data-aos-delay="300">
                    <a class="ms-0 btn btn-primary btn-lg" href="#" role="button">
                      <span>&#9889;</span>
                      <span>Free Download</span>
                    </a>
                    <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
                  </div>


                </div>
                <div class="col-lg-6">
                  <img src="demo/img/team-1.jpg" class="shadow" loading="lazy">
                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="overlay"></div>
      </div>


      <div class="swiper-slide">
        <img src="demo/img/hero-3.webp" loading="lazy">
        <div class="content">
          <div class="container">
            <div>
              <div class="row align-items-center justify-content-center text-center">
                <div class="col-lg-12">
                  <h1 class="heading text-white mb-3 display-4 fw-bold" data-aos="fade-up" data-aos-delay="100">The fastest and leanest CMS</h1>
                  <p class="col-lg-8 mb-5 text-white" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>

                  <div class="d-grid d-lg-block gap-2" data-aos="fade-up" data-aos-delay="300">
                    <a class="ms-0 btn btn-primary btn-lg" href="#" role="button">
                      <span>&#9889;</span>
                      <span>Free Download</span>
                    </a>
                    <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
                  </div>


                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="overlay"></div>
      </div>

      <div class="swiper-slide">
        <img src="demo/img/hero-3.webp" loading="lazy">
        <div class="content">
          <div class="container">
            <div>
              <div class="row align-items-center justify-content-center text-start g-5">
                <div class="col-lg-6">
                  <img src="demo/img/team-2.jpg" class="shadow" loading="lazy">
                </div>

                <div class="col-lg-6">
                  <h1 class="heading text-white mb-3 display-3 fw-bold" data-aos="fade-up" data-aos-delay="100">Open source CMS reinvented</h1>
                  <p class="col-lg-8 mb-5 text-white" data-aos="fade-up" data-aos-delay="100">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>


                  <div class="d-grid d-lg-block gap-2" data-aos="fade-up" data-aos-delay="300">
                    <a class="ms-0 btn btn-primary btn-lg" href="#" role="button">
                      <span>&#9889;</span>
                      <span>Free Download</span>
                    </a>
                    <a class="btn btn-light btn-lg" href="#" role="button">Live demo</a>
                  </div>



                </div>
              </div>
            </div>
          </div>
        </div>
        <div class="overlay"></div>
      </div>

    </div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>

    <div class="swiper-pagination"></div>
  </div>



  <div class="separator bottom">

    <svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 500 41" width="100%" preserveAspectRatio="none">
      <defs>
        <style>
          .cls-1 {
            fill: var(--bs-body-bg);
          }
        </style>
      </defs>
      <title>rough-edges-bottom</title>
      <path class="cls-1" d="M0,185l125-26,33,17,58-12s54,19,55,19,50-11,50-11l56,6,60-8,63,15v15H0Z" transform="translate(0 -159)" />
    </svg>

  </div>


  <div class="background-container">
    <img src="demo/img/hero-3.webp" alt="Hero background" loading="lazy">
  </div>


  <script id="swiper-js" src="/js/libs/swiper/swiper-bundle.min.js"></script>
  <link id="swiper-css" href="/js/libs/swiper/swiper-bundle.min.css" rel="stylesheet">
  <script>
var swiper = [];
function initSwiper(onlyNew = false) {
	var list = document.querySelectorAll('.swiper' + (onlyNew ? ":not(.swiper-initialized)" : "") );
	list.forEach(el => {
		//el.dataset
		let params = {      
			navigation: {
				nextEl: ".swiper-button-next",
				prevEl: ".swiper-button-prev",
			},      
			pagination: {
				el: ".swiper-pagination",
		  },
		};
		for (i in el.dataset) {
			let param = el.dataset[i];
			if (param[0] = '{') {
				param = JSON.parse(param);
			}
			params[i] = param;
		}
		swiper.push(new Swiper(el, params))
		//swiper.push(new Swiper(el, { ...{autoplay:{delay: 500}}, ...el.dataset}))		
	});
}	

initSwiper();
</script>

</header>`
});
	Vvveb.SectionsGroup["Hero"] = ["hero/hero-1","hero/hero-2","hero/hero-3-full","hero/hero-3","hero/hero-4","hero/hero-5","hero/hero-6","hero/hero-7","hero/hero-8","hero/hero-9","hero/hero-10","hero/hero-11","hero/hero-12","hero/hero-13","hero/hero-14","hero/hero-slider"];
Vvveb.Sections.add("features/features-1", {
    name: "Features 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-1-thumb.webp",
    html: `<section class="features-1 bg-alternate my-5" aria-label="features-1">
  <div class="container">
    <div class="row wrap">
      <div class="col-md-6 align-self-center">
        <div class="max-box" data-aos="fade-right">
          <!--
                    <span class="badge  bg-success rounded-pill px-3">new</span>
                    -->
          <h2 class="display-5 fw-bold">Real time code editor</h2>
          <div class="mt-4">
            <p class="lead">Code editor with syntax highglighting that updates in real time.</p>
            <p class="lead">Use any of the hundreds fonts from google fonts for your design.</p>
            <p class="lead">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>
          </div>
          <a tile="Code editor features" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
      <div class="col-md-6">
        <img src="demo/img/team-1.jpg" alt="Macbook" loading="lazy" class="img-fluid shadow" data-aos="fade-left" />
      </div>
    </div>
    <div class="row g-5 wrap mt-2">
      <div class="col-md-6">
        <img src="demo/img/team-2.jpg" alt="App development" loading="lazy" class="img-fluid shadow" data-aos="fade-right" />
      </div>
      <div class="col-md-6 align-self-center">
        <div class="max-box ms-auto" data-aos="fade-left">
          <!-- <span class="badge  bg-success rounded-pill px-3">on sale</span> -->
          <h2 class="display-5 fw-bold">Drag and drop page builder</h2>
          <div class="mt-4">
            <p class="lead">Intuitive building with simple drag and drop for sections, components and blocks.</p>
            <p class="lead">The html for sections blocks and components and this template are built using Bootstrap.</p>
          </div>
          <a title="Drag and drop" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-2", {
    name: "Features 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-2-thumb.webp",
    html: `<section class="features-2 py-5 bg-alternate" aria-label="features-2">

  <div class="row no-gutters">
    <div class="col-lg-6">
      <img alt="image" src="demo/img/team-1.jpg" alt="happy cat" loading="lazy" class="img-fluid">
    </div>

    <div class="col-lg-6 bg-primary bg-gradient text-white d-flex">

      <div class="text-box align-self-center">
        <h3 class="text-white mb-3">Code editor with syntax highlighting that updates in real time</h3>
        <p>The html for sections blocks and components and this template are built using Bootstrap 5</p>
        <ul class="list-block">
          <li class="my-2">
            <span>Intuitive building with simple drag and drop for sections, components and blocks/snippets.</span>
            </span>
          </li>
          <li class="my-2">
            <span>Code editor with syntax highglighting that updates in real time.</span>
          </li>
          <li class="my-2">
            <span>Search and insert CCO images directly into the page. </span>
          </li>
          <li class="my-2">
            <span>The html for sections blocks and components and this template are built using bootstrap 5.</span>
          </li>
        </ul>
        <a class="btn btn-outline-light  mt-3">
          <span>Learn More</span>
        </a>
      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-3", {
    name: "Features 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-3-thumb.webp",
    html: `<section class="features-3 py-5 bg-alternate" aria-label="features-3">
  <div class="container">

    <div class="row">

      <div class="col-lg-6 d-flex align-items-center">
        <div class="row">
          <div class="col-md-12 mb-4">
            <div class="d-flex align-items-center">
              <div>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="72" height="72" color="#1064ea" fill="#fff">
                  <polyline points="336 176 225.2 304 176 255.8" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></polyline>
                  <path d="M463.1,112.37C373.68,64.33,336.71,84.45,256,48,175.29,84.45,138.32,64.33,48.9,112.37,32.7,369.13,240.58,457.79,256,464,271.42,457.79,479.3,369.13,463.1,112.37Z" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></path>
                </svg>

              </div>
              <div class="p-4">
                <h6 class="text-muted">
                  <a class="linking">Live code edit</a>
                </h6>
                <p class="mt-3">Code editor with syntax highglighting for html css and javascript that updates in real time.</p>
              </div>
            </div>
          </div>
          <div class="col-md-12 mb-4">
            <div class="d-flex align-items-center">
              <div>
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="72" height="72" color="#1064ea" fill="#fff">
                  <path d="M419.1,337.45a3.94,3.94,0,0,0-6.1,0c-10.5,12.4-45,46.55-45,77.66,0,27,21.5,48.89,48,48.89h0c26.5,0,48-22,48-48.89C464,384,429.7,349.85,419.1,337.45Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
                  <path d="M387,287.9,155.61,58.36a36,36,0,0,0-51,0l-5.15,5.15a36,36,0,0,0,0,51l52.89,52.89,57-57L56.33,263.2a28,28,0,0,0,.3,40l131.2,126a28.05,28.05,0,0,0,38.9-.1c37.8-36.6,118.3-114.5,126.7-122.9,5.8-5.8,18.2-7.1,28.7-7.1h.3A6.53,6.53,0,0,0,387,287.9Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
                </svg>

              </div>
              <div class="p-4">
                <h6 class="text-muted">
                  <a class="linking">Drag and drop</a>
                </h6>
                <p class="mt-3">The html for sections blocks and components and this template are built using Bootstrap 5.</p>
              </div>
            </div>
          </div>
          <div class="col-md-12 mb-4">
            <div class="d-flex align-items-center">
              <div>

                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" width="72" height="72" color="#1064ea" fill="#fff" stroke-width="28">
                  <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M80,176a16,16,0,0,0-16,16V408c0,30.24,25.76,56,56,56H392c30.24,0,56-24.51,56-54.75V192a16,16,0,0,0-16-16Z"></path>
                  <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M160,176V144a64,64,0,0,1,64-64h0a64,64,0,0,1,64,64v32"></path>
                </svg>

              </div>
              <div class="p-4">
                <h6 class="text-muted">
                  <a class="linking">Bootstrap 5</a>
                </h6>
                <p class="mt-3">The html for sections blocks and components and this template are built using Bootstrap 5.</p>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="col-lg-6">
        <img src="demo/img/team-1.jpg" alt="dog" loading="lazy" class="img-fluid" />
      </div>

      <div class="col-md-12 mt-3 text-center">
        <a class="btn btn-primary ">View Details</a>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-4", {
    name: "Features 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-4-thumb.webp",
    html: `<section class="features-4 py-5 bg-primary bg-gradient text-white" aria-label="features-4">

  <div class="container">
    <div class="row">
      <div class="col text-center">
        <h2>Our product features</h2>
      </div>
    </div>


    <div class="row text-center justify-content-sm-center no-gutters">
      <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-3 m-auto">
        <div>

          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="96" height="96" color="#fff" fill="#fff">
            <polyline points="336 176 225.2 304 176 255.8" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></polyline>
            <path d="M463.1,112.37C373.68,96.33,336.71,84.45,256,48,175.29,84.45,138.32,96.33,48.9,112.37,32.7,369.13,240.58,457.79,256,464,271.42,457.79,479.3,369.13,463.1,112.37Z" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></path>
          </svg>

          <h3 class="mt-3">Drag and drop</h3>

          <p class="mt-2">Intuitive building with simple drag and drop for sections, components and blocks/snippets.</p>
          <p class="mt-4">
            <a>Learn More <i class="la la-angle-right"></i>
            </a>
          </p>
        </div>
      </div>
      <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-3 m-auto pt-5 pt-xl-0">
        <div>

          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="96" height="96" color="#fff" fill="#fff">
            <path d="M419.1,337.45a3.94,3.94,0,0,0-6.1,0c-10.5,12.4-45,46.55-45,77.66,0,27,21.5,48.89,48,48.89h0c26.5,0,48-22,48-48.89C464,384,429.7,349.85,419.1,337.45Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
            <path d="M387,287.9,155.61,58.36a36,36,0,0,0-51,0l-5.15,5.15a36,36,0,0,0,0,51l52.89,52.89,57-57L56.33,263.2a28,28,0,0,0,.3,40l131.2,126a28.05,28.05,0,0,0,38.9-.1c37.8-36.6,118.3-114.5,126.7-122.9,5.8-5.8,18.2-7.1,28.7-7.1h.3A6.53,6.53,0,0,0,387,287.9Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
          </svg>

          <h3 class="mt-3">Live code edit</h3>

          <p class="mt-2">Code editor with syntax highglighting that updates in real time.</p>
          <p class="mt-4">
            <a>Learn More <i class="la la-angle-right"></i>
            </a>
          </p>
        </div>
      </div>
      <div class="col-12 col-sm-10 col-md-8 col-lg-7 col-xl-3 m-auto pt-5 pt-xl-0">
        <div>

          <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" width="96" height="96" color="#fff" fill="#fff" stroke-width="28">
            <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M80,176a16,16,0,0,0-16,16V408c0,30.24,25.76,56,56,56H392c30.24,0,56-24.51,56-54.75V192a16,16,0,0,0-16-16Z"></path>
            <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M160,176V144a96,96,0,0,1,96-96h0a96,96,0,0,1,96,96v32"></path>
          </svg>

          <h3 class="mt-3">Bootstrap 5</h3>

          <p class="mt-2">The html for sections blocks and components and this template are built using Bootstrap 5.</p>
          <p class="mt-4">
            <a>Learn More <i class="la la-angle-right"></i>
            </a>
          </p>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("features/features-5", {
    name: "Features 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-5-thumb.webp",
    html: `<section class="features-5 py-5 bg-alternate" aria-label="features-5">

  <div class="container">
    <div class="row align-items-center">
      <div class="col-12 col-md-8 col-lg-6 m-md-auto ms-lg-0 me-lg-auto">
        <img src="demo/img/team-1.jpg" alt="dog" loading="lazy" class="img-fluid" />
      </div>
      <div class="col-12 col-lg-6 col-xl-5 ms-sm-auto pt-5 pt-lg-0">
        <h2>Open Source CMS Reinvented</h2>

        <div class="row pt-4 pt-xl-5">
          <div class="col-12 col-sm-6 col-xl-5">
            <h4>
              <strong>Drag and drop</strong>
            </h4>
            <p>Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
          </div>
          <div class="col-12 col-sm-6 col-xl-5 m-auto pt-3 pt-sm-0">
            <h4>
              <strong>Live code edit</strong>
            </h4>
            <p>Code editor with syntax highglighting that updates in real time.</p>
          </div>
        </div>

        <div class="row pt-3">
          <div class="col-12 col-sm-6 col-xl-5">
            <h4>
              <strong>Bootstrap 5</strong>
            </h4>
            <p>The html for sections blocks and components and this template are built using bootstrap 5</p>
          </div>
          <div class="col-12 col-sm-6 col-xl-5 m-auto pt-3 pt-sm-0">
            <h4>
              <strong>Google fonts</strong>
            </h4>
            <p>Use any of the hundreds fonts from google fonts for your design</p>
          </div>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("features/features-6", {
    name: "Features 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-6-thumb.webp",
    html: `<section class="features-6 py-5 bg-alternate" aria-label="features-6">
  <div class="container">
    <div class="row text-center">
      <div class="col-12">
        <h2>Our product features</h2>
      </div>
    </div>
    <div class="row text-center justify-content-center">
      <div class="col-12 col-sm-4 col-xl-3 m-md-auto">
        <div>
          <img loading="lazy" src="demo/img/illustrations.co/109-map-location.svg" alt="map location">
          <h3>Drag and drop</h3>
          <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-sm-4 col-xl-3 m-md-auto">
        <div>
          <img loading="lazy" src="demo/img/illustrations.co/107-healthy.svg" alt="dumbbell">
          <h3>Live code editor</h3>
          <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-sm-4 col-xl-3 m-md-auto">
        <div>
          <img loading="lazy" src="demo/img/illustrations.co/104-dumbbell.svg" alt="dumbbell">
          <h3>Bootstrap 5</h3>
          <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootrap 5</p>

          <a>Learn More</a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-7", {
    name: "Features 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-7-thumb.webp",
    html: `<section class="features-7 py-5 bg-alternate" aria-label="features-7">
  <div class="container">
    <div class="row text-center">
      <div class="col-12">
        <h2>Our product features</h2>
      </div>
    </div>
    <div class="row text-center justify-content-center">
      <div class="col-12 col-md-6 col-lg-3">
        <div>
          <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">
          <h3>Drag and drop</h3>
          <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div>
          <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          <h3>Live code editor</h3>
          <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div>
          <img alt="dumbbell" loading="lazy" src="demo/img/illustrations.co/104-dumbbell.svg">
          <h3>Bootstrap 5</h3>
          <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using Bootstrap 5</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-md-6 col-lg-3">
        <div>
          <img alt="namaste" loading="lazy" src="demo/img/illustrations.co/126-namaste-no-hand-shake.svg">
          <h3>Google fonts</h3>
          <p class="lead text-muted mt-4">Use any of the hundreds fonts from google fonts for your design</p>

          <a>Learn More</a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-8", {
    name: "Features 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-8-thumb.webp",
    html: `<section class="features-8 py-5 bg-alternate" aria-label="features-8">
  <div class="container">
    <div class="row text-center">
      <div class="col-12">
        <h2>Our product features</h2>
      </div>
    </div>
    <div class="row text-start mt-5">
      <div class="col-12 col-md-4">
        <div class="row">
          <div class="col-3">
            <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">
          </div>
          <div class="col-9">
            <h4>Drag and drop</h4>
            <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-4 pt-3 pt-sm-4">
        <div class="row">
          <div class="col-3">
            <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          </div>
          <div class="col-9">
            <h4>Live code editor</h4>
            <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-4 pt-3 pt-sm-4">
        <div class="row">
          <div class="col-3">
            <img alt="dumbbell" loading="lazy" src="demo/img/illustrations.co/104-dumbbell.svg">
          </div>
          <div class="col-9">
            <h4>Bootstrap 5</h4>
            <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootrap 5</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
    </div>

    <div class="row text-start pt-3 pt-sm-4 pt-md-5">
      <div class="col-12 col-md-4">
        <div class="row">
          <div class="col-3">
            <img alt="namaste" loading="lazy" src="demo/img/illustrations.co/126-namaste-no-hand-shake.svg">
          </div>
          <div class="col-9">
            <h4>Google fonts</h4>
            <p class="lead text-muted mt-4">Use any of the hundreds fonts from google fonts for your design</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-4 pt-3 pt-sm-4">
        <div class="row">
          <div class="col-3">
            <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">
          </div>
          <div class="col-9">
            <h4>Drag and drop</h4>
            <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>

      <div class="col-12 col-md-4 pt-3 pt-sm-4">
        <div class="row">
          <div class="col-3">
            <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          </div>
          <div class="col-9">
            <h4>Bootstrap 5</h4>
            <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootrap 5</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-9", {
    name: "Features 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-9-thumb.webp",
    html: `<section class="features-9 py-5 bg-alternate" aria-label="features-9">
  <div class="container">
    <div class="row text-center">
      <div class="col-12">
        <h2>Our product features</h2>
      </div>
    </div>
    <div class="row text-start mt-5">
      <div class="col-12 col-sm-6 col-lg-3">
        <div class="row">
          <div class="col-3">
            <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">
          </div>
          <div class="col-9">
            <h4>Drag and drop</h4>
            <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-sm-0">
        <div class="row">
          <div class="col-3">
            <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          </div>
          <div class="col-9">
            <h4>Live code editor</h4>
            <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-lg-0">
        <div class="row">
          <div class="col-3">
            <img alt="dumbbell" loading="lazy" src="demo/img/illustrations.co/104-dumbbell.svg">
          </div>
          <div class="col-9">
            <h4>Bootstrap 5</h4>
            <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootrap 5</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-lg-0">
        <div class="row">
          <div class="col-3">
            <img alt="namaste" loading="lazy" src="demo/img/illustrations.co/126-namaste-no-hand-shake.svg">
          </div>
          <div class="col-9">
            <h4>Google fonts</h4>
            <p class="lead text-muted mt-4">Use any of the hundreds fonts from google fonts for your design</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
    </div>

    <div class="row text-start pt-3 pt-lg-5">
      <div class="col-12 col-sm-6 col-lg-3">
        <div class="row">
          <div class="col-3">
            <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">
          </div>
          <div class="col-9">
            <h4>Drag and drop</h4>
            <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-sm-0">
        <div class="row">
          <div class="col-3">
            <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          </div>
          <div class="col-9">
            <h4>Bootstrap 5</h4>
            <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootrap 5</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-lg-0">
        <div class="row">
          <div class="col-3">
            <img alt="map location" loading="lazy" src="demo/img/illustrations.co/109-map-location.svg">

          </div>
          <div class="col-9">
            <h4>Drag and drop</h4>
            <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-lg-3 pt-3 pt-lg-0">
        <div class="row">
          <div class="col-3">
            <img alt="healthy" loading="lazy" src="demo/img/illustrations.co/107-healthy.svg">
          </div>
          <div class="col-9">
            <h4>Live code editor</h4>
            <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time</p>
            <a>Learn More</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-10", {
    name: "Features 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-10-thumb.webp",
    html: `<section class="features-10 py-5 bg-alternate" aria-label="features-10">
  <div class="container">
    <div class="row text-end align-items-center">
      <div class="col-12 col-md-6 m-auto">
        <img src="demo/img/team-1.jpg" alt="dog" loading="lazy" class="img-fluid">
      </div>

      <div class="col-12 col-md-7 col-lg-5 m-auto text-start pt-5">
        <div class="row pb-lg-5">
          <div class="col-3">
            <img src="demo/img/illustrations.co/107-healthy.svg" alt="healthy" loading="lazy" class="img-fluid">
          </div>
          <div class="col-9">
            <h3>
              <strong>Drag and drop</strong>
            </h3>
            <p>Even the all-powerful Pointing has no control about the blind texts.</p>
          </div>
        </div>

        <div class="row pt-4 pt-md-5 pb-lg-5">
          <div class="col-3">
            <img alt="image" src="demo/img/illustrations.co/104-dumbbell.svg" alt="dumbbell" loading="lazy" class="img-fluid">
          </div>
          <div class="col-9">
            <h3>
              <strong>Live code editor</strong>
            </h3>
            <p>Duden flows by their place far far away, behind the word mountains.</p>
          </div>
        </div>


        <div class="row pt-4 pt-md-5">
          <div class="col-3">
            <img alt="image" src="demo/img/illustrations.co/109-map-location.svg" alt="map location" loading="lazy" class="img-fluid">
          </div>
          <div class="col-9">
            <h3>
              <strong>Bootstrap 5 Components</strong>
            </h3>
            <p>A small river named Duden flows by their place and supplies it.</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-11", {
    name: "Features 11",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-11-thumb.webp",
    html: `<section class="features-11 py-5 bg-alternate" aria-label="features-11">
  <div class="container">
    <div class="row text-center">
      <div class="col-12 col-md-8 col-lg-4">
        <div>
          <img alt="image" src="demo/img/illustrations.co/109-map-location.svg" alt="map location" loading="lazy" class="img-fluid">
          <h3>Drag and drop</h3>
          <p class="lead text-muted mt-4">Intuitive building with simple drag and drop for sections, components and blocks/snippets.</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-md-8 col-lg-4">
        <div>
          <img alt="image" src="demo/img/illustrations.co/107-healthy.svg" alt="healthy" loading="lazy" class="img-fluid">
          <h3>Live code editor</h3>
          <p class="lead text-muted mt-4">Code editor with syntax highglighting that updates in real time.</p>

          <a>Learn More</a>
        </div>
      </div>

      <div class="col-12 col-md-8 col-lg-4">
        <div>
          <img alt="image" src="demo/img/illustrations.co/104-dumbbell.svg" alt="dumbbell" loading="lazy" class="img-fluid">
          <h3>Bootstrap 5 Components</h3>
          <p class="lead text-muted mt-4">The html for sections blocks and components and this template are built using bootstrap 5.</p>

          <a>Learn More</a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-12", {
    name: "Features 12",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-12-thumb.webp",
    html: `<section class="features-1 bg-alternate" aria-label="features-12">
  <div class="container-fluid g-0">
    <div class="row g-0 wrap">
      <div class="col-md-6 align-self-center">
        <div class="max-box" data-aos="fade-right">
          <!--
                    <span class="badge  bg-success rounded-pill px-3">new</span>
                    -->
          <h2 class="display-6 fw-semibold">Real time code editor</h2>
          <div class="mt-4">
            <p class="lead">Code editor with syntax highglighting that updates in real time.</p>
            <p class="lead">Use any of the hundreds fonts from google fonts for your design.</p>
            <p class="lead">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>
          </div>
          <a tile="Code editor features" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
      <div class="col-md-6">
        <img src="demo/img/team-1.jpg" alt="Macbook" loading="lazy" class="img-fluid w-100" data-aos="fade-right" />
      </div>
    </div>
    <div class="row g-0 wrap">
      <div class="col-md-6">
        <img src="demo/img/team-2.jpg" alt="App development" loading="lazy" class="img-fluid w-100" data-aos="fade-right" />
      </div>
      <div class="col-md-6 align-self-center">
        <div class="max-box ms-auto" data-aos="fade-left">
          <!-- <span class="badge  bg-success rounded-pill px-3">on sale</span> -->
          <h2 class="display-6 fw-semibold">Drag and drop page builder</h2>
          <div class="mt-4">
            <p class="lead">Intuitive building with simple drag and drop for sections, components and blocks.</p>
            <p class="lead">The html for sections blocks and components and this template are built using Bootstrap.</p>
          </div>
          <a title="Drag and drop" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-13", {
    name: "Features 13",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-13-thumb.webp",
    html: `<section class="features-1 bg-alternate" aria-label="features-13">
  <div class="container">
    <div class="row wrap">
      <div class="col-md-6 align-self-center">
        <div class="max-box" data-aos="fade-right">
          <!--
                    <span class="badge  bg-success rounded-pill px-3">new</span>
                    -->
          <h2 class="display-6 fw-semibold">Real time code editor</h2>
          <div class="mt-4">
            <p class="lead">Code editor with syntax highglighting that updates in real time.</p>
            <p class="lead">Use any of the hundreds fonts from google fonts for your design.</p>
            <p class="lead">Powerful and easy to use drag and drop builder for blogs, websites or ecommerce stores.</p>
          </div>
          <a tile="Code editor features" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
      <div class="col-md-6">
        <img src="demo/img/team-1.jpg" alt="Macbook" loading="lazy" class="img-fluid w-100" data-aos="fade-right" />
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-14", {
    name: "Features 14",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-14-thumb.webp",
    html: `<section class="features-1 bg-alternate" aria-label="features-14">
  <div class="container">
    <div class="row g-0 wrap">
      <div class="col-md-6">
        <img src="demo/img/team-2.jpg" alt="App development" loading="lazy" class="img-fluid w-100" data-aos="fade-right" />
      </div>
      <div class="col-md-6 align-self-center">
        <div class="max-box ms-auto" data-aos="fade-left">
          <!-- <span class="badge  bg-success rounded-pill px-3">on sale</span> -->
          <h2 class="display-6 fw-semibold">Drag and drop page builder</h2>
          <div class="mt-4">
            <p class="lead">Intuitive building with simple drag and drop for sections, components and blocks.</p>
            <p class="lead">The html for sections blocks and components and this template are built using Bootstrap.</p>
          </div>
          <a title="Drag and drop" href="/page/about" role="button">
            <span>Learn More</span>
            <i class="la la-long-arrow-alt-right ms-1"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-15", {
    name: "Features 15",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-15-thumb.webp",
    html: ` <section aria-label="features-15">
   <div class="container py-6">
     <div class="row">
       <div class="col-md-12 text-center">
         <div class="text-center text-md-start mb-5">
           <div>
             <h1 class="display-5 fw-bold">Services</h1>
           </div>
         </div>
       </div>
     </div>

     <div class="row pt-4">
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="3em" height="3em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-white">
                 <path d="M4,2A2,2 0 0,0 2,4V14H4V4H14V2H4M8,6A2,2 0 0,0 6,8V18H8V8H18V6H8M20,12V20H12V12H20M20,10H12A2,2 0 0,0 10,12V20A2,2 0 0,0 12,22H20A2,2 0 0,0 22,20V12A2,2 0 0,0 20,10Z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" width="3em" height="3em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
                 <path d="M1 13.5a.5.5 0 0 0 .5.5h3.797a.5.5 0 0 0 .439-.26L11 3h3.5a.5.5 0 0 0 0-1h-3.797a.5.5 0 0 0-.439.26L5 13H1.5a.5.5 0 0 0-.5.5zm10 0a.5.5 0 0 0 .5.5h3a.5.5 0 0 0 0-1h-3a.5.5 0 0 0-.5.5z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
     <div class="row pt-4">
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" width="3em" height="3em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
                 <path d="M8.186 1.113a.5.5 0 0 0-.372 0L1.846 3.5l2.404.961L10.404 2l-2.218-.887zm3.564 1.426L5.596 5 8 5.961 14.154 3.5l-2.404-.961zm3.25 1.7-6.5 2.6v7.922l6.5-2.6V4.24zM7.5 14.762V6.838L1 4.239v7.923l6.5 2.6zM7.443.184a1.5 1.5 0 0 1 1.114 0l7.129 2.852A.5.5 0 0 1 16 3.5v8.662a1 1 0 0 1-.629.928l-7.185 2.874a.5.5 0 0 1-.372 0L.63 13.09a1 1 0 0 1-.63-.928V3.5a.5.5 0 0 1 .314-.464L7.443.184z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" width="3em" height="3em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
                 <path d="m7.788 2.34-.799 1.278A.25.25 0 0 0 7.201 4h1.598a.25.25 0 0 0 .212-.382l-.799-1.279a.25.25 0 0 0-.424 0Zm0 11.32-.799-1.277A.25.25 0 0 1 7.201 12h1.598a.25.25 0 0 1 .212.383l-.799 1.278a.25.25 0 0 1-.424 0ZM3.617 9.01 2.34 8.213a.25.25 0 0 1 0-.424l1.278-.799A.25.25 0 0 1 4 7.201V8.8a.25.25 0 0 1-.383.212Zm10.043-.798-1.277.799A.25.25 0 0 1 12 8.799V7.2a.25.25 0 0 1 .383-.212l1.278.799a.25.25 0 0 1 0 .424Z"></path>
                 <path d="M6.5 0A1.5 1.5 0 0 0 5 1.5v3a.5.5 0 0 1-.5.5h-3A1.5 1.5 0 0 0 0 6.5v3A1.5 1.5 0 0 0 1.5 11h3a.5.5 0 0 1 .5.5v3A1.5 1.5 0 0 0 6.5 16h3a1.5 1.5 0 0 0 1.5-1.5v-3a.5.5 0 0 1 .5-.5h3A1.5 1.5 0 0 0 16 9.5v-3A1.5 1.5 0 0 0 14.5 5h-3a.5.5 0 0 1-.5-.5v-3A1.5 1.5 0 0 0 9.5 0h-3ZM6 1.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 .5.5v3A1.5 1.5 0 0 0 11.5 6h3a.5.5 0 0 1 .5.5v3a.5.5 0 0 1-.5.5h-3a1.5 1.5 0 0 0-1.5 1.5v3a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-3A1.5 1.5 0 0 0 4.5 10h-3a.5.5 0 0 1-.5-.5v-3a.5.5 0 0 1 .5-.5h3A1.5 1.5 0 0 0 6 4.5v-3Z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
     <div class="row pt-4">
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" width="3em" height="3em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
                 <path d="M2.114 8.063V7.9c1.005-.102 1.497-.615 1.497-1.6V4.503c0-1.094.39-1.538 1.354-1.538h.273V2h-.376C3.25 2 2.49 2.759 2.49 4.352v1.524c0 1.094-.376 1.456-1.49 1.456v1.299c1.114 0 1.49.362 1.49 1.456v1.524c0 1.593.759 2.352 2.372 2.352h.376v-.964h-.273c-.964 0-1.354-.444-1.354-1.538V9.663c0-.984-.492-1.497-1.497-1.6zM13.886 7.9v.163c-1.005.103-1.497.616-1.497 1.6v1.798c0 1.094-.39 1.538-1.354 1.538h-.273v.964h.376c1.613 0 2.372-.759 2.372-2.352v-1.524c0-1.094.376-1.456 1.49-1.456V7.332c-1.114 0-1.49-.362-1.49-1.456V4.352C13.51 2.759 12.75 2 11.138 2h-.376v.964h.273c.964 0 1.354.444 1.354 1.538V6.3c0 .984.492 1.497 1.497 1.6z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-6 mb-6 mb-md-5">
         <div class="p-4 card shadow position-relative">
           <div class="card-body">
             <div class="position-absolute top-0 mt-n4 bg-primary p-3 rounded-3 shadow">
               <svg xmlns="http://www.w3.org/2000/svg" width="3em" height="3em" fill="currentColor" class="text-white" viewBox="0 0 16 16" lc-helper="svg-icon">
                 <path d="M6 0a.5.5 0 0 1 .5.5V3h3V.5a.5.5 0 0 1 1 0V3h1a.5.5 0 0 1 .5.5v3A3.5 3.5 0 0 1 8.5 10c-.002.434-.01.845-.04 1.22-.041.514-.126 1.003-.317 1.424a2.083 2.083 0 0 1-.97 1.028C6.725 13.9 6.169 14 5.5 14c-.998 0-1.61.33-1.974.718A1.922 1.922 0 0 0 3 16H2c0-.616.232-1.367.797-1.968C3.374 13.42 4.261 13 5.5 13c.581 0 .962-.088 1.218-.219.241-.123.4-.3.514-.55.121-.266.193-.621.23-1.09.027-.34.035-.718.037-1.141A3.5 3.5 0 0 1 4 6.5v-3a.5.5 0 0 1 .5-.5h1V.5A.5.5 0 0 1 6 0zM5 4v2.5A2.5 2.5 0 0 0 7.5 9h1A2.5 2.5 0 0 0 11 6.5V4H5z"></path>
               </svg>
             </div>

             <div class="pt-5 ">
               <div>

                 <h2 class="fw-bold h3">Custom Feature</h2>
                 <p class="rfs-7">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet. Aenean vel nisi in ipsum congue fermentum et ut arcu.</p>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
   </div>
 </section>
 <section class="bg-light">
   <div class="container py-5">
     <div class="row mb-4">
       <div class="col-md-12 text-center">
         <div class="text-center text-md-end mb-5">
           <div>
             <h1 class="display-5 fw-bold">Our Loved Testimonials</h1>
           </div>
         </div>
       </div>
     </div>
     <div class="row justify-content-center">
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1527980965255-d3b416303d12?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Nicolas Horn" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1527980965255-d3b416303d12?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1527980965255-d3b416303d12??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1527980965255-d3b416303d12??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1527980965255-d3b416303d12??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1527980965255-d3b416303d12??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8M3x8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">Mathew Glock</h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                 </p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1628157588553-5eeea00af15c?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Leio McLaren" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1628157588553-5eeea00af15c?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1628157588553-5eeea00af15c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1628157588553-5eeea00af15c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1628157588553-5eeea00af15c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1628157588553-5eeea00af15c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NHx8YXZhdGFyfGVufDB8Mnx8fDE2Mzg4OTExNTE&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">Tahmid William&nbsp;<p></p>
                   <p></p>
                 </h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id ligula malesuada placerat sit amet quis enim. Aliquam erat volutpat.
                 </p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Amir Seilsepour" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1595152452543-e5fc28ebc2b8??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MTh8fGZhY2V8ZW58MHwyfHx8MTYzODg5MTA3MA&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">Jarvis Ridley&nbsp;<p></p>
                   <p></p>
                 </h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
     <div class="row justify-content-center">
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1542909168-82c3e7fdca5c?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Imansyah Muhamad Putera" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1542909168-82c3e7fdca5c?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1542909168-82c3e7fdca5c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1542909168-82c3e7fdca5c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1542909168-82c3e7fdca5c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1542909168-82c3e7fdca5c??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8MXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">Bronwen Baxter&nbsp;<p></p>
                   <p></p>
                 </h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.
                 </p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Conor OBrien" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1579503841516-e0bd7fca5faa??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8NXx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">
                   Nadir Chandler

                 </h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id ligula malesuada placerat sit amet quis enim. Aliquam erat volutpat.
                 </p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
       <div class="col-md-8 col-lg-4 mb-4">
         <div class="card border-0 shadow">
           <div class="card-body py-4">
             <div class="d-flex">
               <img style="width:48px;height:48px" src="https://images.unsplash.com/photo-1584308972272-9e4e7685e80f?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080" alt="Photo by Daniil Lobachev" class="rounded-2 shadow" srcset="https://images.unsplash.com/photo-1584308972272-9e4e7685e80f?crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1080&amp;h=1080 1080w, https://images.unsplash.com/photo-1584308972272-9e4e7685e80f??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=150 150w, https://images.unsplash.com/photo-1584308972272-9e4e7685e80f??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=300 300w, https://images.unsplash.com/photo-1584308972272-9e4e7685e80f??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=768 768w, https://images.unsplash.com/photo-1584308972272-9e4e7685e80f??crop=entropy&amp;cs=tinysrgb&amp;fit=crop&amp;fm=jpg&amp;ixid=MnwzNzg0fDB8MXxzZWFyY2h8Nnx8ZmFjZXxlbnwwfDJ8fHwxNjM4ODkxMDU2&amp;ixlib=rb-1.2.1&amp;q=80&amp;w=1024 1024w" sizes="(max-width: 1080px) 100vw, 1080px" width="1080" height="1080">
               <div class="ps-2">
                 <h4 editable="inline" class="rfs-7 ms-2">
                   Samira Goldsmith

                 </h4>
               </div>
             </div>
             <div class="mt-4 text-muted">
               <div>
                 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
               </div>
             </div>
             <div class="rating mt-3 text-success">
               <div class="">
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
                 <svg width="1em" height="1em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon">
                   <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.283.95l-3.523 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z"></path>
                 </svg>
               </div>
             </div>
           </div>
         </div>
       </div>
     </div>
   </div>
 </section>
 <section>
   <div class="container py-5">
     <div class="row min-vh-50 align-items-center justify-content-center">
       <div class="col-lg-9 col-xl-8 text-center text-white p-5 bg-primary">
         <div class="mb-4">
           <div>
             <h2 class="display-3 fw-bolder">Reach us</h2>
             <p>Lorem ipsum dolor sit amet consectetur adipiscing elit sed do
               <br>&nbsp;eiusmod tempor incididunt ut labore et dolore magna aliqua.&nbsp;
             </p>

           </div>
         </div>
         <div class="mb-5">
           <a class="btn btn-lg btn-light" href="https://goo.gl/maps/zy3NkDKV3x4iyUkL9" role="button">VIEW MAP</a>
         </div>
         <div class="border-top col-md-6 offset-md-3">
           <div>
             <h2 class="fw-bolder">
               <br>
             </h2>
           </div>
         </div>
         <div class="mb-4">
           <div>
             <h2 class="fw-bolder">Working Hours</h2>
           </div>
         </div>
         <div class="">
           <div>
             <p>Monday to Friday: 07:00 – 19:45</p>
             <p>Saturday to Sunday: 11:00 – 17:00</p>
           </div>
         </div>
       </div>
     </div>
   </div>
 </section>`
});Vvveb.Sections.add("features/features-16", {
    name: "Features 16",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-16-thumb.webp",
    html: `<section aria-label="features-16">
  <div class="container py-4 py-lg-6">
    <div class="row align-items-center flex-lg-row-reverse">
      <div class="col-lg-6 mb-5 mb-lg-0 ">
        <div class="px-4">
          <div class="position-relative">
            <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark mt-4 ms-4"> </div>

            <img class="position-relative img-fluid" src="demo/img/team-1.jpg" alt="Team 1">
          </div>
        </div>
      </div>
      <div class="col-lg-6 ">
        <div class="mb-4">
          <div editable="rich">

            <h2 class="fw-bold display-5">Lorem ipsum dolor sit amet, consectetur.</h2>
          </div>
        </div>
        <div class="mb-5">
          <div editable="rich">


            <p class="lead text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est. Etiam diam metus, lobortis non augue at, placerat viverra risus. Cras ornare faucibus laoreet.</p>
          </div>
        </div>

        <div class="d-sm-flex align-items-center mb-4 overflow-hidden position-relative">
          <div class="d-inline-flex">
            <div>
              <svg width="1.5em" height="1.5em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" class="text-success">
                <path fill-rule="evenodd" d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
              </svg>
            </div>

            <div class="ms-3 align-self-center" editable="rich">
              <p>Lorem ipsum dolor sit amet consectetur adipiscing elit.</p>
            </div>
          </div>
        </div>
        <div class="d-sm-flex align-items-center mb-4">
          <div class="d-inline-flex">
            <div>
              <svg width="1.5em" height="1.5em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" class="text-success">
                <path fill-rule="evenodd" d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
              </svg>
            </div>

            <div class="ms-3 align-self-center" editable="rich">
              <p>Suspendisse a lacus est</p>
            </div>
          </div>
        </div>
        <div class="d-sm-flex align-items-center mb-4">
          <div class="d-inline-flex">
            <div>
              <svg width="1.5em" height="1.5em" viewBox="0 0 16 16" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" class="text-success">
                <path fill-rule="evenodd" d="M8 15A7 7 0 1 0 8 1a7 7 0 0 0 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
                <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
              </svg>
            </div>

            <div class="ms-3 align-self-center" editable="rich">
              <p>Etiam diam metus, lobortis non augue at</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-17", {
    name: "Features 17",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-17-thumb.webp",
    html: `<section aria-label="features-17">
  <div class="container py-4 py-md-6">
    <div class="row mb-4">
      <div class="col-md-12">
        <div class="text-center mb-4">
          <div editable="rich">
            <h2 class="display-2 fw-bolder">Features</h2>
          </div>
        </div>
        <div class="text-center">
          <div editable="rich">
            <p class="lead">Lorem ipsum dolor sit amet, consectetur adipiscing elit.
              <br>Suspendisse a lacus est.&nbsp;
            </p>
          </div>
        </div>
        <!-- /-->
      </div>
      <!-- /col -->
    </div>
    <div class="row">
      <div class="col-12 col-md-6 col-xl-3 mb-4">
        <div class="text-center ">
          <div class="rounded-circle d-flex justify-content-center align-items-center mx-auto mb-4 bg-light bg-light" style="width:72px;
	height:72px;
	 ">
            <svg xmlns="http://www.w3.org/2000/svg" width="2em" height="2em" fill="currentColor" viewBox="0 0 16 16" style="" lc-helper="svg-icon" class="text-primary">
              <path fill-rule="evenodd" d="M14 4.5V14a2 2 0 0 1-2 2v-1a1 1 0 0 0 1-1V4.5h-2A1.5 1.5 0 0 1 9.5 3V1H4a1 1 0 0 0-1 1v9H2V2a2 2 0 0 1 2-2h5.5L14 4.5Zm-7.839 9.166v.522c0 .256-.039.47-.117.641a.861.861 0 0 1-.322.387.877.877 0 0 1-.469.126.883.883 0 0 1-.471-.126.868.868 0 0 1-.32-.386 1.55 1.55 0 0 1-.117-.642v-.522c0-.257.04-.471.117-.641a.868.868 0 0 1 .32-.387.868.868 0 0 1 .471-.129c.176 0 .332.043.469.13a.861.861 0 0 1 .322.386c.078.17.117.384.117.641Zm.803.519v-.513c0-.377-.068-.7-.205-.972a1.46 1.46 0 0 0-.589-.63c-.254-.147-.56-.22-.917-.22-.355 0-.662.073-.92.22a1.441 1.441 0 0 0-.589.627c-.136.271-.205.596-.205.975v.513c0 .375.069.7.205.973.137.271.333.48.59.627.257.144.564.216.92.216.357 0 .662-.072.916-.216.256-.147.452-.356.59-.627.136-.274.204-.598.204-.973ZM0 11.926v4h1.459c.402 0 .735-.08.999-.238a1.45 1.45 0 0 0 .595-.689c.13-.3.196-.662.196-1.084 0-.42-.065-.778-.196-1.075a1.426 1.426 0 0 0-.59-.68c-.263-.156-.598-.234-1.004-.234H0Zm.791.645h.563c.248 0 .45.05.609.152a.89.89 0 0 1 .354.454c.079.201.118.452.118.753a2.3 2.3 0 0 1-.068.592 1.141 1.141 0 0 1-.196.422.8.8 0 0 1-.334.252 1.298 1.298 0 0 1-.483.082H.79V12.57Zm7.422.483a1.732 1.732 0 0 0-.103.633v.495c0 .246.034.455.103.627a.834.834 0 0 0 .298.393.845.845 0 0 0 .478.131.868.868 0 0 0 .401-.088.699.699 0 0 0 .273-.248.8.8 0 0 0 .117-.364h.765v.076a1.268 1.268 0 0 1-.226.674c-.137.194-.32.345-.55.454a1.81 1.81 0 0 1-.786.164c-.36 0-.664-.072-.914-.216a1.424 1.424 0 0 1-.571-.627c-.13-.272-.194-.597-.194-.976v-.498c0-.379.066-.705.197-.978.13-.274.321-.485.571-.633.252-.149.556-.223.911-.223.219 0 .421.032.607.097.187.062.35.153.489.272a1.326 1.326 0 0 1 .466.964v.073H9.78a.85.85 0 0 0-.12-.38.7.7 0 0 0-.273-.261.802.802 0 0 0-.398-.097.814.814 0 0 0-.475.138.868.868 0 0 0-.301.398Z"></path>
            </svg>
          </div>
          <div class="">
            <div editable="rich">
              <h5 class="">Lorem ipsum</h5>
              <p class="text-muted">Take care to develop resources continually and integrity them with previous projects.</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-md-6 col-xl-3 mb-4">
        <div class="text-center ">
          <div class="rounded-circle d-flex justify-content-center align-items-center mx-auto mb-4 bg-light" style="width:72px;
	height:72px;
	">
            <svg xmlns="http://www.w3.org/2000/svg" width="2em" height="2em" fill="currentColor" class="text-success" viewBox="0 0 16 16" style="" lc-helper="svg-icon">
              <path d="M11 2a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12h.5a.5.5 0 0 1 0 1H.5a.5.5 0 0 1 0-1H1v-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v3h1V7a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v7h1V2zm1 12h2V2h-2v12zm-3 0V7H7v7h2zm-5 0v-3H2v3h2z"></path>
            </svg>
          </div>
          <div class="">
            <div editable="rich">
              <h5 class="">Lorem ipsum</h5>
              <p class="text-muted">Take care to develop resources continually and integrity them with previous projects.</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-md-6 col-xl-3 mb-4">
        <div class="text-center ">
          <div class="rounded-circle d-flex justify-content-center align-items-center mx-auto mb-4 bg-light" style="width:72px;
	height:72px;
	">
            <svg xmlns="http://www.w3.org/2000/svg" width="2em" height="2em" fill="currentColor" class="text-danger" viewBox="0 0 16 16" style="" lc-helper="svg-icon">
              <path d="M3.05 3.05a7 7 0 0 0 0 9.9.5.5 0 0 1-.707.707 8 8 0 0 1 0-11.314.5.5 0 0 1 .707.707zm2.122 2.122a4 4 0 0 0 0 5.656.5.5 0 1 1-.708.708 5 5 0 0 1 0-7.072.5.5 0 0 1 .708.708zm5.656-.708a.5.5 0 0 1 .708 0 5 5 0 0 1 0 7.072.5.5 0 1 1-.708-.708 4 4 0 0 0 0-5.656.5.5 0 0 1 0-.708zm2.122-2.12a.5.5 0 0 1 .707 0 8 8 0 0 1 0 11.313.5.5 0 0 1-.707-.707 7 7 0 0 0 0-9.9.5.5 0 0 1 0-.707zM6 8a2 2 0 1 1 2.5 1.937V15.5a.5.5 0 0 1-1 0V9.937A2 2 0 0 1 6 8z"></path>
            </svg>
          </div>
          <div class="">
            <div editable="rich">
              <h5 class="">Lorem ipsum</h5>
              <p class="text-muted">Take care to develop resources continually and integrity them with previous projects.</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-12 col-md-6 col-xl-3 mb-4">
        <div class="text-center ">
          <div class="rounded-circle d-flex justify-content-center align-items-center mx-auto mb-4 bg-light" style="width:72px;
	height:72px;
	">
            <svg xmlns="http://www.w3.org/2000/svg" width="2em" height="2em" fill="currentColor" class="text-info" viewBox="0 0 16 16" style="" lc-helper="svg-icon">
              <path d="M14.082 2.182a.5.5 0 0 1 .103.557L8.528 15.467a.5.5 0 0 1-.917-.007L5.57 10.694.803 8.652a.5.5 0 0 1-.006-.916l12.728-5.657a.5.5 0 0 1 .556.103zM2.25 8.184l3.897 1.67a.5.5 0 0 1 .262.263l1.67 3.897L12.743 3.52 2.25 8.184z"></path>
            </svg>
          </div>
          <div class="">
            <div editable="rich">
              <h5 class="">Lorem ipsum</h5>
              <p class="text-muted">Take care to develop resources continually and integrity them with previous projects.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("features/features-18", {
    name: "Features 18",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-18-thumb.webp",
    html: `<section aria-label="features-18">
  <div class="container">
    <div class="row row-cols-1 row-cols-lg-3 align-items-stretch g-4 py-5">
      <div class="col">
        <div class="card card-cover h-100 overflow-hidden text-white bg-dark rounded-5 shadow-lg  position-relative">
          <div class="d-flex flex-column h-100 p-5 pb-3 text-white text-shadow-1 z-2">
            <div class="pt-5 mt-5 mb-4">
              <div>
                <h2 class="display-6 lh-1 fw-bold">Much longer title that wraps to multiple lines</h2>
                <p>Quickly design and customize responsive mobile-first sites with Bootstrap.</p>
              </div>
            </div>
            <ul class="d-flex list-unstyled mt-auto ms-auto">
              <a class="btn btn-link btn-sm text-white " href="#" role="button">Read more</a>
            </ul>
          </div>
          <div class="overlay z-1"></div>
          <div class="background-container z-0">
            <img src="demo/img/team-1.jpg">
          </div>

        </div>
      </div>

      <div class="col">
        <div class="card card-cover h-100 overflow-hidden text-white bg-dark rounded-5 shadow-lg  position-relative">
          <div class="d-flex flex-column h-100 p-5 pb-3 text-white text-shadow-1 z-2">
            <div class="pt-5 mt-5 mb-4">
              <div>
                <h2 class="display-6 lh-1 fw-bold">Much longer title that wraps to multiple lines</h2>
                <p>Quickly design and customize responsive mobile-first sites with Bootstrap.</p>
              </div>
            </div>
            <ul class="d-flex list-unstyled mt-auto ms-auto">
              <a class="btn btn-link btn-sm text-white " href="#" role="button">Read more</a>
            </ul>
          </div>
          <div class="overlay z-1"></div>
          <div class="background-container z-0">
            <img src="demo/img/team-2.jpg">
          </div>
        </div>
      </div>

      <div class="col">
        <div class="card card-cover h-100 overflow-hidden text-white bg-dark rounded-5 shadow-lg  position-relative">
          <div class="d-flex flex-column h-100 p-5 pb-3 text-white text-shadow-1 z-2">
            <div class="pt-5 mt-5 mb-4">
              <div>
                <h2 class="display-6 lh-1 fw-bold">Much longer title that wraps to multiple lines</h2>
                <p>Quickly design and customize responsive mobile-first sites with Bootstrap.</p>
              </div>
            </div>
            <ul class="d-flex list-unstyled mt-auto ms-auto">
              <a class="btn btn-link btn-sm text-white " href="#" role="button">Read more</a>
            </ul>
          </div>
          <div class="overlay z-1"></div>
          <div class="background-container z-0">
            <img src="demo/img/team-1.jpg">
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("features/features-19", {
    name: "Features 19",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/features/features-19-thumb.webp",
    html: `<section aria-label="features-19">
  <div class="container py-5">
    <div class="row mb-3">
      <div class="col-lg-8 mx-auto text-center">
        <div class="mb-4">
          <div>
            <p>MARKETING</p>
            <h1 class="display-2 fw-semibold">Get more clients</h1>
          </div>
        </div>

        <div>
          <div>
            <p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Nam velit temporibus impedit maxime repellendus esse tempore odio voluptatum iusto consectetur voluptates.</p>
          </div>
        </div>

      </div>
    </div>

    <div class="row mb-4 ">
      <div class="col-lg-10 mx-auto text-center">

        <div class="rounded-4 position-relative overflow-hidden">
          <img class="img-fluid w-100 shadow" src="demo/img/team-1.jpg" alt="Team 1">
          <a class="position-absolute top-50 start-50 translate-middle glightbox d-flex justify-content-center align-items-center z-2" href="https://www.youtube.com/watch?v=rPbrR6b6ZYs">
            <svg xmlns="http://www.w3.org/2000/svg" width="5em" height="5em" fill="currentColor" class="" viewBox="0 0 16 16" lc-helper="svg-icon">
              <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
            </svg>
          </a>
          <div class="overlay z-1"></div>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Features"] = ["features/features-1","features/features-2","features/features-3","features/features-4","features/features-5","features/features-6","features/features-7","features/features-8","features/features-9","features/features-10","features/features-11","features/features-12","features/features-13","features/features-14","features/features-15","features/features-16","features/features-17","features/features-18","features/features-19"];
Vvveb.Sections.add("services/services-1", {
    name: "Services 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/services/services-1-thumb.webp",
    html: `<section class="py-5 services-1" aria-label="services-1">
  <div class="container">
    <div class="row justify-content-md-center">
      <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
        <h2 class="mb-4 display-2 text-center fw-bold">Services</h2>
        <p class="text-secondary text-center lead mb-5">Our specialists are ready to work on your next awesome project</p>
      </div>
    </div>
  </div>

  <div class="container overflow-hidden">
    <div class="row gy-5 gx-md-4 gy-lg-0 gx-xxl-5 justify-content-center">
      <div class="col-11 col-sm-6 col-lg-3">
        <div class="badge bg-primary p-3 mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="la la-pie-chart" viewBox="0 0 16 16">
            <path d="M7.5 1.018a7 7 0 0 0-4.79 11.566L7.5 7.793V1.018zm1 0V7.5h6.482A7.001 7.001 0 0 0 8.5 1.018zM14.982 8.5H8.207l-4.79 4.79A7 7 0 0 0 14.982 8.5zM0 8a8 8 0 1 1 16 0A8 8 0 0 1 0 8z" />
          </svg>
        </div>
        <h4 class="mb-3">Market Research</h4>
        <p class="mb-3 text-secondary">We can help you to understand your target market and identify new opportunities for growth. We offer a variety of market research services, interviews, and focus groups.</p>
        <a href="#!" class="fw-bold text-decoration-none link-primary">
          Learn More
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
          </svg>
        </a>
      </div>
      <div class="col-11 col-sm-6 col-lg-3">
        <div class="badge bg-primary p-3 mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="la la-aspect-ratio" viewBox="0 0 16 16">
            <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h13A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5v-9zM1.5 3a.5.5 0 0 0-.5.5v9a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-13z" />
            <path d="M2 4.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1H3v2.5a.5.5 0 0 1-1 0v-3zm12 7a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1H13V8.5a.5.5 0 0 1 1 0v3z" />
          </svg>
        </div>
        <h4 class="mb-3">Web Design</h4>
        <p class="mb-3 text-secondary">We can help you to create a visually appealing and user-friendly website. We take into account your brand identity and target audience when designing your website.</p>
        <a href="#!" class="fw-bold text-decoration-none link-primary">
          Learn More
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
          </svg>
        </a>
      </div>
      <div class="col-11 col-sm-6 col-lg-3">
        <div class="badge bg-primary p-3 mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="la la-airplane-engines" viewBox="0 0 16 16">
            <path d="M8 0c-.787 0-1.292.592-1.572 1.151A4.347 4.347 0 0 0 6 3v3.691l-2 1V7.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v1.191l-1.17.585A1.5 1.5 0 0 0 0 10.618V12a.5.5 0 0 0 .582.493l1.631-.272.313.937a.5.5 0 0 0 .948 0l.405-1.214 2.21-.369.375 2.253-1.318 1.318A.5.5 0 0 0 5.5 16h5a.5.5 0 0 0 .354-.854l-1.318-1.318.375-2.253 2.21.369.405 1.214a.5.5 0 0 0 .948 0l.313-.937 1.63.272A.5.5 0 0 0 16 12v-1.382a1.5 1.5 0 0 0-.83-1.342L14 8.691V7.5a.5.5 0 0 0-.5-.5h-1a.5.5 0 0 0-.5.5v.191l-2-1V3c0-.568-.14-1.271-.428-1.849C9.292.591 8.787 0 8 0ZM7 3c0-.432.11-.979.322-1.401C7.542 1.159 7.787 1 8 1c.213 0 .458.158.678.599C8.889 2.02 9 2.569 9 3v4a.5.5 0 0 0 .276.447l5.448 2.724a.5.5 0 0 1 .276.447v.792l-5.418-.903a.5.5 0 0 0-.575.41l-.5 3a.5.5 0 0 0 .14.437l.646.646H6.707l.647-.646a.5.5 0 0 0 .14-.436l-.5-3a.5.5 0 0 0-.576-.411L1 11.41v-.792a.5.5 0 0 1 .276-.447l5.448-2.724A.5.5 0 0 0 7 7V3Z" />
          </svg>
        </div>
        <h4 class="mb-3">SEO Services</h4>
        <p class="mb-3 text-secondary">We can help you to improve your website's visibility in search engine results pages (SERPs). This can lead to more traffic to your website and more conversions.</p>
        <a href="#!" class="fw-bold text-decoration-none link-primary">
          Learn More
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
          </svg>
        </a>
      </div>
      <div class="col-11 col-sm-6 col-lg-3">
        <div class="badge bg-primary p-3 mb-4">
          <svg xmlns="http://www.w3.org/2000/svg" width="26" height="26" fill="currentColor" class="la la-alarm" viewBox="0 0 16 16">
            <path d="M8.5 5.5a.5.5 0 0 0-1 0v3.362l-1.429 2.38a.5.5 0 1 0 .858.515l1.5-2.5A.5.5 0 0 0 8.5 9V5.5z" />
            <path d="M6.5 0a.5.5 0 0 0 0 1H7v1.07a7.001 7.001 0 0 0-3.273 12.474l-.602.602a.5.5 0 0 0 .707.708l.746-.746A6.97 6.97 0 0 0 8 16a6.97 6.97 0 0 0 3.422-.892l.746.746a.5.5 0 0 0 .707-.708l-.601-.602A7.001 7.001 0 0 0 9 2.07V1h.5a.5.5 0 0 0 0-1h-3zm1.038 3.018a6.093 6.093 0 0 1 .924 0 6 6 0 1 1-.924 0zM0 3.5c0 .753.333 1.429.86 1.887A8.035 8.035 0 0 1 4.387 1.86 2.5 2.5 0 0 0 0 3.5zM13.5 1c-.753 0-1.429.333-1.887.86a8.035 8.035 0 0 1 3.527 3.527A2.5 2.5 0 0 0 13.5 1z" />
          </svg>
        </div>
        <h4 class="mb-3">Content Marketing</h4>
        <p class="mb-3 text-secondary">We can help you to promote your business online through a variety of digital marketing channels, including SEO, PPC, social media marketing, and email marketing..</p>
        <a href="#!" class="fw-bold text-decoration-none link-primary">
          Learn More
          <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
            <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
          </svg>
        </a>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("services/services-2", {
    name: "Services 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/services/services-2-thumb.webp",
    html: `<section class="py-5 services-2" aria-label="services-2">
  <div class="container">
    <div class="row justify-content-md-center">
      <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
        <h2 class="mb-4 display-2 text-center fw-bold">Services</h2>
        <p class="text-secondary text-center lead mb-5">Our specialists are ready to work on your next awesome project</p>
      </div>
    </div>
  </div>

  <div class="container overflow-hidden">
    <div class="row gy-5 gx-md-5 justify-content-center">
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-command text-primary" viewBox="0 0 16 16">
              <path d="M3.5 2A1.5 1.5 0 0 1 5 3.5V5H3.5a1.5 1.5 0 1 1 0-3zM6 5V3.5A2.5 2.5 0 1 0 3.5 6H5v4H3.5A2.5 2.5 0 1 0 6 12.5V11h4v1.5a2.5 2.5 0 1 0 2.5-2.5H11V6h1.5A2.5 2.5 0 1 0 10 3.5V5H6zm4 1v4H6V6h4zm1-1V3.5A1.5 1.5 0 1 1 12.5 5H11zm0 6h1.5a1.5 1.5 0 1 1-1.5 1.5V11zm-6 0v1.5A1.5 1.5 0 1 1 3.5 11H5z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">Market Research</h4>
            <p class="mb-3 text-secondary">We can help you to understand your target market and identify new opportunities for growth. We offer a variety of market research services including surveys.</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-laptop text-primary" viewBox="0 0 16 16">
              <path d="M13.5 3a.5.5 0 0 1 .5.5V11H2V3.5a.5.5 0 0 1 .5-.5h11zm-11-1A1.5 1.5 0 0 0 1 3.5V12h14V3.5A1.5 1.5 0 0 0 13.5 2h-11zM0 12.5h16a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">Web Design</h4>
            <p class="mb-3 text-secondary">We can help you to create a visually appealing website. We take into account your brand identity and target audience when designing your website.</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-credit-card-2-front text-primary" viewBox="0 0 16 16">
              <path d="M14 3a1 1 0 0 1 1 1v8a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V4a1 1 0 0 1 1-1h12zM2 2a2 2 0 0 0-2 2v8a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V4a2 2 0 0 0-2-2H2z" />
              <path d="M2 5.5a.5.5 0 0 1 .5-.5h2a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-2a.5.5 0 0 1-.5-.5v-1zm0 3a.5.5 0 0 1 .5-.5h5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1-.5-.5zm0 2a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5zm3 0a.5.5 0 0 1 .5-.5h1a.5.5 0 0 1 0 1h-1a.5.5 0 0 1-.5-.5z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">Secure Payments</h4>
            <p class="mb-3 text-secondary">We offer a variety of secure payment solutions to help you accept payments. We also offer fraud protection to help protect your business from fraud.</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-cup-hot text-primary" viewBox="0 0 16 16">
              <path fill-rule="evenodd" d="M.5 6a.5.5 0 0 0-.488.608l1.652 7.434A2.5 2.5 0 0 0 4.104 16h5.792a2.5 2.5 0 0 0 2.44-1.958l.131-.59a3 3 0 0 0 1.3-5.854l.221-.99A.5.5 0 0 0 13.5 6H.5ZM13 12.5a2.01 2.01 0 0 1-.316-.025l.867-3.898A2.001 2.001 0 0 1 13 12.5ZM2.64 13.825 1.123 7h11.754l-1.517 6.825A1.5 1.5 0 0 1 9.896 15H4.104a1.5 1.5 0 0 1-1.464-1.175Z" />
              <path d="m4.4.8-.003.004-.014.019a4.167 4.167 0 0 0-.204.31 2.327 2.327 0 0 0-.141.267c-.026.06-.034.092-.037.103v.004a.593.593 0 0 0 .091.248c.075.133.178.272.308.445l.01.012c.118.158.26.347.37.543.112.2.22.455.22.745 0 .188-.065.368-.119.494a3.31 3.31 0 0 1-.202.388 5.444 5.444 0 0 1-.253.382l-.018.025-.005.008-.002.002A.5.5 0 0 1 3.6 4.2l.003-.004.014-.019a4.149 4.149 0 0 0 .204-.31 2.06 2.06 0 0 0 .141-.267c.026-.06.034-.092.037-.103a.593.593 0 0 0-.09-.252A4.334 4.334 0 0 0 3.6 2.8l-.01-.012a5.099 5.099 0 0 1-.37-.543A1.53 1.53 0 0 1 3 1.5c0-.188.065-.368.119-.494.059-.138.134-.274.202-.388a5.446 5.446 0 0 1 .253-.382l.025-.035A.5.5 0 0 1 4.4.8Zm3 0-.003.004-.014.019a4.167 4.167 0 0 0-.204.31 2.327 2.327 0 0 0-.141.267c-.026.06-.034.092-.037.103v.004a.593.593 0 0 0 .091.248c.075.133.178.272.308.445l.01.012c.118.158.26.347.37.543.112.2.22.455.22.745 0 .188-.065.368-.119.494a3.31 3.31 0 0 1-.202.388 5.444 5.444 0 0 1-.253.382l-.018.025-.005.008-.002.002A.5.5 0 0 1 6.6 4.2l.003-.004.014-.019a4.149 4.149 0 0 0 .204-.31 2.06 2.06 0 0 0 .141-.267c.026-.06.034-.092.037-.103a.593.593 0 0 0-.09-.252A4.334 4.334 0 0 0 6.6 2.8l-.01-.012a5.099 5.099 0 0 1-.37-.543A1.53 1.53 0 0 1 6 1.5c0-.188.065-.368.119-.494.059-.138.134-.274.202-.388a5.446 5.446 0 0 1 .253-.382l.025-.035A.5.5 0 0 1 7.4.8Zm3 0-.003.004-.014.019a4.077 4.077 0 0 0-.204.31 2.337 2.337 0 0 0-.141.267c-.026.06-.034.092-.037.103v.004a.593.593 0 0 0 .091.248c.075.133.178.272.308.445l.01.012c.118.158.26.347.37.543.112.2.22.455.22.745 0 .188-.065.368-.119.494a3.198 3.198 0 0 1-.202.388 5.385 5.385 0 0 1-.252.382l-.019.025-.005.008-.002.002A.5.5 0 0 1 9.6 4.2l.003-.004.014-.019a4.149 4.149 0 0 0 .204-.31 2.06 2.06 0 0 0 .141-.267c.026-.06.034-.092.037-.103a.593.593 0 0 0-.09-.252A4.334 4.334 0 0 0 9.6 2.8l-.01-.012a5.099 5.099 0 0 1-.37-.543A1.53 1.53 0 0 1 9 1.5c0-.188.065-.368.119-.494.059-.138.134-.274.202-.388a5.446 5.446 0 0 1 .253-.382l.025-.035A.5.5 0 0 1 10.4.8Z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">Daily Updates</h4>
            <p class="mb-3 text-secondary">We provide our clients with daily updates on their business performance. This includes data on website traffic, sales, blog posts, and other key metrics.</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-gear text-primary" viewBox="0 0 16 16">
              <path d="M8 4.754a3.246 3.246 0 1 0 0 6.492 3.246 3.246 0 0 0 0-6.492zM5.754 8a2.246 2.246 0 1 1 4.492 0 2.246 2.246 0 0 1-4.492 0z" />
              <path d="M9.796 1.343c-.527-1.79-3.065-1.79-3.592 0l-.094.319a.873.873 0 0 1-1.255.52l-.292-.16c-1.64-.892-3.433.902-2.54 2.541l.159.292a.873.873 0 0 1-.52 1.255l-.319.094c-1.79.527-1.79 3.065 0 3.592l.319.094a.873.873 0 0 1 .52 1.255l-.16.292c-.892 1.64.901 3.434 2.541 2.54l.292-.159a.873.873 0 0 1 1.255.52l.094.319c.527 1.79 3.065 1.79 3.592 0l.094-.319a.873.873 0 0 1 1.255-.52l.292.16c1.64.893 3.434-.902 2.54-2.541l-.159-.292a.873.873 0 0 1 .52-1.255l.319-.094c1.79-.527 1.79-3.065 0-3.592l-.319-.094a.873.873 0 0 1-.52-1.255l.16-.292c.893-1.64-.902-3.433-2.541-2.54l-.292.159a.873.873 0 0 1-1.255-.52l-.094-.319zm-2.633.283c.246-.835 1.428-.835 1.674 0l.094.319a1.873 1.873 0 0 0 2.693 1.115l.291-.16c.764-.415 1.6.42 1.184 1.185l-.159.292a1.873 1.873 0 0 0 1.116 2.692l.318.094c.835.246.835 1.428 0 1.674l-.319.094a1.873 1.873 0 0 0-1.115 2.693l.16.291c.415.764-.42 1.6-1.185 1.184l-.291-.159a1.873 1.873 0 0 0-2.693 1.116l-.094.318c-.246.835-1.428.835-1.674 0l-.094-.319a1.873 1.873 0 0 0-2.692-1.115l-.292.16c-.764.415-1.6-.42-1.184-1.185l.159-.291A1.873 1.873 0 0 0 1.945 8.93l-.319-.094c-.835-.246-.835-1.428 0-1.674l.319-.094A1.873 1.873 0 0 0 3.06 4.377l-.16-.292c-.415-.764.42-1.6 1.185-1.184l.292.159a1.873 1.873 0 0 0 2.692-1.115l.094-.319z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">Digital Marketing</h4>
            <p class="mb-3 text-secondary">We can help you to promote your business online through a variety of digital marketing channels, including search engine optimization (SEO).</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-10 col-md-5 col-xl-4 overflow-hidden">
        <div class="row gy-4">
          <div class="col-12 col-lg-2">
            <svg xmlns="http://www.w3.org/2000/svg" width="42" height="42" fill="currentColor" class="la la-telephone-inbound text-primary" viewBox="0 0 16 16">
              <path d="M15.854.146a.5.5 0 0 1 0 .708L11.707 5H14.5a.5.5 0 0 1 0 1h-4a.5.5 0 0 1-.5-.5v-4a.5.5 0 0 1 1 0v2.793L15.146.146a.5.5 0 0 1 .708 0zm-12.2 1.182a.678.678 0 0 0-1.015-.063L1.605 2.3c-.483.484-.661 1.169-.45 1.77a17.568 17.568 0 0 0 4.168 6.608 17.569 17.569 0 0 0 6.608 4.168c.601.211 1.286.033 1.77-.45l1.034-1.034a.678.678 0 0 0-.063-1.015l-2.307-1.794a.678.678 0 0 0-.58-.122l-2.19.547a1.745 1.745 0 0 1-1.657-.459L5.482 8.062a1.745 1.745 0 0 1-.46-1.657l.548-2.19a.678.678 0 0 0-.122-.58L3.654 1.328zM1.884.511a1.745 1.745 0 0 1 2.612.163L6.29 2.98c.329.423.445.974.315 1.494l-.547 2.19a.678.678 0 0 0 .178.643l2.457 2.457a.678.678 0 0 0 .644.178l2.189-.547a1.745 1.745 0 0 1 1.494.315l2.306 1.794c.829.645.905 1.87.163 2.611l-1.034 1.034c-.74.74-1.846 1.065-2.877.702a18.634 18.634 0 0 1-7.01-4.42 18.634 18.634 0 0 1-4.42-7.009c-.362-1.03-.037-2.137.703-2.877L1.885.511z" />
            </svg>
          </div>
          <div class="col-12 col-lg-10">
            <h4 class="mb-3">24/7 Support</h4>
            <p class="mb-3 text-secondary">We offer 24/7 support to our clients. This means that you can always get help when you need it, no matter what time of day or night it is.</p>
            <div>
              <a href="#!" class="fw-bold text-decoration-none link-primary">
                Learn More
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="la la-arrow-right-short" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M4 8a.5.5 0 0 1 .5-.5h5.793L8.146 5.354a.5.5 0 1 1 .708-.708l3 3a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708-.708L10.293 8.5H4.5A.5.5 0 0 1 4 8z" />
                </svg>
              </a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("services/services-3", {
    name: "Services 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/services/services-3-thumb.webp",
    html: `<section class="py-5 services-3" aria-label="services-3">
  <div class="container">
    <div class="row justify-content-center text-center mb-3">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">Features</span>
        <h2 class="display-5 fw-bold">Our Features</h2>
        <p class="lead">Our specialists are ready to work on your next awesome project</p>
      </div>
    </div>
    <div class="row g-4 g-md-5">
      <div class="col-md-6">
        <div class="d-flex">
          <div class="text-primary me-4">
            <svg class="bi bi-aspect-ratio" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h13A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5v-9zM1.5 3a.5.5 0 0 0-.5.5v9a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-13z"></path>
              <path d="M2 4.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1H3v2.5a.5.5 0 0 1-1 0v-3zm12 7a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1H13V8.5a.5.5 0 0 1 1 0v3z"></path>
            </svg>
          </div>
          <div>
            <h5 class="mb-2 mb-lg-3 fw-bold">Responsive Design</h5>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris .</p>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="d-flex">
          <div class="text-primary me-4">
            <svg class="bi bi-emoji-wink" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
              <path d="M4.285 9.567a.5.5 0 0 1 .683.183A3.498 3.498 0 0 0 8 11.5a3.498 3.498 0 0 0 3.032-1.75.5.5 0 1 1 .866.5A4.498 4.498 0 0 1 8 12.5a4.498 4.498 0 0 1-3.898-2.25.5.5 0 0 1 .183-.683zM7 6.5C7 7.328 6.552 8 6 8s-1-.672-1-1.5S5.448 5 6 5s1 .672 1 1.5zm1.757-.437a.5.5 0 0 1 .68.194.934.934 0 0 0 .813.493c.339 0 .645-.19.813-.493a.5.5 0 1 1 .874.486A1.934 1.934 0 0 1 10.25 7.75c-.73 0-1.356-.412-1.687-1.007a.5.5 0 0 1 .194-.68z"></path>
            </svg>
          </div>
          <div>
            <h5 class="mb-2 mb-lg-3 fw-bold">Easy-To-Use</h5>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris .</p>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="d-flex">
          <div class="text-primary me-4">
            <svg class="bi bi-layout-text-window-reverse" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M13 6.5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5zm0 3a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5zm-.5 2.5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1h5z"></path>
              <path d="M14 0a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12zM2 1a1 1 0 0 0-1 1v1h14V2a1 1 0 0 0-1-1H2zM1 4v10a1 1 0 0 0 1 1h2V4H1zm4 0v11h9a1 1 0 0 0 1-1V4H5z"></path>
            </svg>
          </div>
          <div>
            <h5 class="mb-2 mb-lg-3 fw-bold">100+ Components</h5>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris .</p>
          </div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="d-flex">
          <div class="text-primary me-4">
            <svg class="bi bi-clipboard-check" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" fill-rule="evenodd"></path>
              <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"></path>
              <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"></path>
            </svg>
          </div>
          <div>
            <h5 class="mb-2 mb-lg-3 fw-bold">Copy & Paste</h5>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris .</p>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("services/services-4", {
    name: "Services 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/services/services-4-thumb.webp",
    html: `<section class="py-5 services-4" aria-label="services-4">
  <div class="container">
    <div class="row justify-content-center text-center mb-3">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">Features</span>
        <h2 class="display-5 fw-bold">Our Features</h2>
        <p class="lead">Our specialists are ready to work on your next awesome project</p>
      </div>
    </div>
    <div class="row g-4 g-md-5">
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-aspect-ratio" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M0 3.5A1.5 1.5 0 0 1 1.5 2h13A1.5 1.5 0 0 1 16 3.5v9a1.5 1.5 0 0 1-1.5 1.5h-13A1.5 1.5 0 0 1 0 12.5v-9zM1.5 3a.5.5 0 0 0-.5.5v9a.5.5 0 0 0 .5.5h13a.5.5 0 0 0 .5-.5v-9a.5.5 0 0 0-.5-.5h-13z"></path>
              <path d="M2 4.5a.5.5 0 0 1 .5-.5h3a.5.5 0 0 1 0 1H3v2.5a.5.5 0 0 1-1 0v-3zm12 7a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1 0-1H13V8.5a.5.5 0 0 1 1 0v3z"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">Responsive Design</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-emoji-wink" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14zm0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16z"></path>
              <path d="M4.285 9.567a.5.5 0 0 1 .683.183A3.498 3.498 0 0 0 8 11.5a3.498 3.498 0 0 0 3.032-1.75.5.5 0 1 1 .866.5A4.498 4.498 0 0 1 8 12.5a4.498 4.498 0 0 1-3.898-2.25.5.5 0 0 1 .183-.683zM7 6.5C7 7.328 6.552 8 6 8s-1-.672-1-1.5S5.448 5 6 5s1 .672 1 1.5zm1.757-.437a.5.5 0 0 1 .68.194.934.934 0 0 0 .813.493c.339 0 .645-.19.813-.493a.5.5 0 1 1 .874.486A1.934 1.934 0 0 1 10.25 7.75c-.73 0-1.356-.412-1.687-1.007a.5.5 0 0 1 .194-.68z"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">Easy-To-Use</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-layout-text-window-reverse" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M13 6.5a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5zm0 3a.5.5 0 0 0-.5-.5h-5a.5.5 0 0 0 0 1h5a.5.5 0 0 0 .5-.5zm-.5 2.5a.5.5 0 0 1 0 1h-5a.5.5 0 0 1 0-1h5z"></path>
              <path d="M14 0a2 2 0 0 1 2 2v12a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V2a2 2 0 0 1 2-2h12zM2 1a1 1 0 0 0-1 1v1h14V2a1 1 0 0 0-1-1H2zM1 4v10a1 1 0 0 0 1 1h2V4H1zm4 0v11h9a1 1 0 0 0 1-1V4H5z"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">100+ Components</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-clipboard-check" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M10.854 7.146a.5.5 0 0 1 0 .708l-3 3a.5.5 0 0 1-.708 0l-1.5-1.5a.5.5 0 1 1 .708-.708L7.5 9.793l2.646-2.647a.5.5 0 0 1 .708 0z" fill-rule="evenodd"></path>
              <path d="M4 1.5H3a2 2 0 0 0-2 2V14a2 2 0 0 0 2 2h10a2 2 0 0 0 2-2V3.5a2 2 0 0 0-2-2h-1v1h1a1 1 0 0 1 1 1V14a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1V3.5a1 1 0 0 1 1-1h1v-1z"></path>
              <path d="M9.5 1a.5.5 0 0 1 .5.5v1a.5.5 0 0 1-.5.5h-3a.5.5 0 0 1-.5-.5v-1a.5.5 0 0 1 .5-.5h3zm-3-1A1.5 1.5 0 0 0 5 1.5v1A1.5 1.5 0 0 0 6.5 4h3A1.5 1.5 0 0 0 11 2.5v-1A1.5 1.5 0 0 0 9.5 0h-3z"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">Copy & Paste</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-speedometer2" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M8 4a.5.5 0 0 1 .5.5V6a.5.5 0 0 1-1 0V4.5A.5.5 0 0 1 8 4zM3.732 5.732a.5.5 0 0 1 .707 0l.915.914a.5.5 0 1 1-.708.708l-.914-.915a.5.5 0 0 1 0-.707zM2 10a.5.5 0 0 1 .5-.5h1.586a.5.5 0 0 1 0 1H2.5A.5.5 0 0 1 2 10zm9.5 0a.5.5 0 0 1 .5-.5h1.5a.5.5 0 0 1 0 1H12a.5.5 0 0 1-.5-.5zm.754-4.246a.389.389 0 0 0-.527-.02L7.547 9.31a.91.91 0 1 0 1.302 1.258l3.434-4.297a.389.389 0 0 0-.029-.518z"></path>
              <path d="M0 10a8 8 0 1 1 15.547 2.661c-.442 1.253-1.845 1.602-2.932 1.25C11.309 13.488 9.475 13 8 13c-1.474 0-3.31.488-4.615.911-1.087.352-2.49.003-2.932-1.25A7.988 7.988 0 0 1 0 10zm8-7a7 7 0 0 0-6.603 9.329c.203.575.923.876 1.68.63C4.397 12.533 6.358 12 8 12s3.604.532 4.923.96c.757.245 1.477-.056 1.68-.631A7 7 0 0 0 8 3z" fill-rule="evenodd"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">Unlimited Usage</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
      <div class="col-md-6 col-xl-4">
        <div class="d-flex align-items-center mb-3 mb-md-4">
          <div class="text-primary">
            <svg class="bi bi-pencil-square" fill="currentColor" height="32" viewbox="0 0 16 16" width="32" xmlns="http://www.w3.org/2000/svg">
              <path d="M15.502 1.94a.5.5 0 0 1 0 .706L14.459 3.69l-2-2L13.502.646a.5.5 0 0 1 .707 0l1.293 1.293zm-1.75 2.456-2-2L4.939 9.21a.5.5 0 0 0-.121.196l-.805 2.414a.25.25 0 0 0 .316.316l2.414-.805a.5.5 0 0 0 .196-.12l6.813-6.814z"></path>
              <path d="M1 13.5A1.5 1.5 0 0 0 2.5 15h11a1.5 1.5 0 0 0 1.5-1.5v-6a.5.5 0 0 0-1 0v6a.5.5 0 0 1-.5.5h-11a.5.5 0 0 1-.5-.5v-11a.5.5 0 0 1 .5-.5H9a.5.5 0 0 0 0-1H2.5A1.5 1.5 0 0 0 1 2.5v11z" fill-rule="evenodd"></path>
            </svg>
          </div>
          <h5 class="fw-bold ms-4 mb-0">100% Customizable</h5>
        </div>
        <p>Lorem ipsum dolor sit amet consectetur elit dolor sit amet.</p>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Services"] = ["services/services-1","services/services-2","services/services-3","services/services-4"];
Vvveb.Sections.add("base/1-column", {
    name: "1 column",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/1-column-thumb.webp",
    html: `<section title="one column" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/2-columns", {
    name: "2 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/2-columns-thumb.webp",
    html: `<section title="two columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/3-columns", {
    name: "3 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/3-columns-thumb.webp",
    html: `<section title="three columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/4-columns", {
    name: "4 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/4-columns-thumb.webp",
    html: `<section title="four columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/6-columns", {
    name: "6 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/6-columns-thumb.webp",
    html: `<section title="six columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/8-columns", {
    name: "8 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/8-columns-thumb.webp",
    html: `<section title="eight columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/12-columns", {
    name: "12 columns",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/12-columns-thumb.webp",
    html: `<section title="twelve columns" class="py-4">
  <div class="container">
    <div class="row">
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
      <div class="col"></div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("base/blank", {
    name: "Blank",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/base/blank-thumb.webp",
    html: `<section title="blank" class="py-4">
  <div class="container">
    <h1>Blank container</h1>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Base"] = ["base/1-column","base/2-columns","base/3-columns","base/4-columns","base/6-columns","base/8-columns","base/12-columns","base/blank"];
Vvveb.Sections.add("clients/clients-1", {
    name: "Clients 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/clients/clients-1-thumb.webp",
    html: `<section class="py-3 py-md-5 py-xl-8" aria-label="clients-1">
  <div class="container">
    <div class="row justify-content-md-center">
      <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
        <h2 class="mb-4 display-2 text-center fw-bold">Clients</h2>
        <p class="text-secondary mb-5 text-center">Our trusted partners.</p>
        <hr class="w-50 mx-auto mb-5 mb-xl-9 border-dark-subtle">
      </div>
    </div>
  </div>

  <div class="container overflow-hidden">
    <div class="row gy-5">
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="125" height="65" viewBox="0 0 125 65" fill="currentColor" class="text-dark">
          <path d="M0,20.32v10.16H25.5c2.96,0,6.75-3.19,6.75-8.48,0-2.13,.7-3.51-1.45-6.32l-3.26-4.51c-1.87-2.03,.22-2.03,1.79-2.03h10.76V30.48h8.54V9.14h11.51V0H22.88C18.35,0,16.13,5.07,16.26,7.72c.13,2.64,.54,5.97,4.31,9.96,3.44,3.64-1.7,2.64-2.22,2.64H0ZM79.02,0h-13.77l-7.72,30.48h8.59l1.39-4.27h9.06l1.35,4.27h8.42L79.02,0h0Zm-9.59,18.9l2.96-11.18,2.79,11.18h-5.75Zm44.1,1.42c-3.31,0-3.31-1.42-3.31-1.42,2.84,0,5.35-4.82,5.35-9.76S111.44,0,108.13,0h-18.53V30.48h9.41v-10.16s4.01,5.49,6.1,7.72c2.09,2.24,2.27,2.44,5.11,2.44h14.78v-10.16s-8.15,0-11.47,0h0Zm-8.54-7.11h-5.98V7.72h5.98c2.74,0,3.21,5.49,0,5.49ZM0,34.34H9.63l2.44,10.16,2.27-10.16h10.11l2.61,10.16,2.62-10.16h8.37l-7.67,30.49h-7.67l-3.36-14.43-3.79,14.43H7.71L0,34.34Zm57.81,.18h-13.77l-7.72,30.48h8.59l1.39-4.27h9.07l1.35,4.27h8.42l-7.32-30.48Zm-9.59,18.9l2.96-11.18,2.79,11.18h-5.75Zm65.48-9.92c-1.57,0-3.28,.21-1.41,2.25l3.26,4.51c2.14,2.81,2.11,3.98,2.11,6.11,0,5.28-4.48,8.48-7.45,8.48l-20.6,.16c-2.84,0-3.01-.2-5.1-2.44-2.09-2.24-6.1-7.72-6.1-7.72v10.16h-9.41v-30.48h18.53c3.31,0,7.45,4.2,7.45,9.14s-2.52,9.76-5.36,9.76c0,0,1.25,1.46,3.34,1.46s10.15,0,10.15,0c.52,0,5.65,1,2.22-2.64-3.77-3.99-4.18-7.32-4.31-9.96s1.83-7.94,6.37-7.94h17.62v9.15h-11.3Zm-29.31,4.23h-5.98v-5.49h5.98c2.74,0,3.21,5.49,0,5.49Z" fill-rule="evenodd" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="105" height="65" viewBox="0 0 105 65" fill="currentColor" class="text-dark">
          <path d="M88.47,64.54v-13.95h-5.75v13.95h5.75Zm-30.46-5.79v-7.95h-5.58v6.07c0,1.77-.07,2.26-.18,2.72-.39,1.27-1.73,1.84-3.11,1.84-1.91,0-2.79-.74-3.14-1.91-.11-.39-.14-.81-.18-1.24-.04-.46,0-.95,0-1.48v-6h-5.65v7.98c0,1.8,.6,3.14,1.59,4.06,1.69,1.66,4.55,2.15,7.2,2.15,3.21,0,5.68-.46,7.45-2.19,.92-.88,1.59-2.05,1.59-4.06h0Zm-27.38-.99c-.28-.05-.56-.07-.85-.07h-6.35c-.32,0-.67,.04-.85,.07,.11-.11,.32-.32,.53-.6l2.86-4.73c.39-.63,.56-1.06,.64-1.24,.07,.18,.25,.6,.64,1.27l2.93,4.77c.14,.21,.35,.42,.46,.53h0Zm10.66,6.78l-12.7-19.07h-7.13l1.87,2.22s.11,.07,.18,.11c-.07,.04-.14,.07-.18,.11l-11.08,16.63h6.42l1.73-2.86c.07-.14,.11-.28,.11-.35,.07,0,.25,.07,.42,.07h11.47c.18,0,.32-.04,.39-.07,0,.1,.02,.2,.07,.28l1.8,2.93h6.63Zm39.88-7.17c0-1.55-.64-3.36-2.61-5.86l-4.76-6.04h-6.63l3.78,4.24c.64,.71,1.45,1.34,1.45,1.34-.92-.53-2.08-.74-3-.74-2.19,0-4.41,.46-6.39,1.55-2.12,1.16-3.53,3.11-3.53,5.69,0,1.98,.88,3.5,2.01,4.66,2.54,2.54,7.16,2.79,8.86,2.79,2.51,0,6.42-.57,8.65-2.58,1.31-1.2,2.19-2.86,2.19-5.05h0Zm-5.51,.18c0,1.45-.95,2.54-2.15,3.14-.99,.53-2.15,.67-3.18,.67s-2.22-.21-3.21-.71c-1.2-.6-2.12-1.77-2.12-3.04,0-1.52,1.16-2.72,2.54-3.32,.85-.39,1.87-.53,2.68-.53s1.91,.11,2.79,.46c1.59,.67,2.65,1.94,2.65,3.32h0ZM86.64,0c-4.13,0-8.14,1.39-11.38,3.96C72.03,1.39,68.01,0,63.88,0c-4.13,0-8.14,1.39-11.38,3.96C49.26,1.39,45.25,0,41.12,0c-4.13,0-8.14,1.39-11.38,3.96C26.5,1.39,22.49,0,18.36,0,8.22,0,0,8.22,0,18.37s8.22,18.37,18.36,18.37c4.13,0,8.14-1.39,11.38-3.96,3.24,2.57,7.25,3.96,11.38,3.96,4.13,0,8.14-1.39,11.38-3.96,3.24,2.57,7.25,3.96,11.38,3.96,4.13,0,8.14-1.39,11.38-3.96,3.24,2.57,7.25,3.96,11.38,3.96,10.14,0,18.36-8.22,18.36-18.37S96.78,0,86.64,0ZM26.73,29.78c-2.34,1.71-5.26,2.75-8.38,2.75-7.82,0-14.15-6.33-14.15-14.16S10.53,4.21,18.36,4.21c3.12,0,6.04,1.04,8.38,2.75-2.58,3.24-3.98,7.27-3.97,11.41,0,4.14,1.4,8.16,3.97,11.41Zm3-3c-1.8-2.43-2.78-5.38-2.77-8.41,0-3.03,.96-5.98,2.77-8.41,1.81,2.43,2.78,5.38,2.77,8.41,0,3.03-.97,5.98-2.77,8.41Zm19.76,3c-2.43,1.79-5.37,2.75-8.39,2.75-3.01,0-5.95-.96-8.37-2.75,2.57-3.25,3.97-7.27,3.97-11.41,0-4.14-1.39-8.17-3.97-11.41,2.42-1.79,5.36-2.75,8.37-2.75,3.14,0,6.04,1.02,8.39,2.75-2.58,3.24-3.98,7.27-3.97,11.41,0,4.14,1.4,8.16,3.97,11.41Zm3-3c-1.8-2.43-2.78-5.38-2.77-8.41,0-3.03,.96-5.98,2.77-8.41,1.81,2.43,2.78,5.38,2.77,8.41,0,3.03-.97,5.98-2.77,8.41Zm19.76,3c-2.35,1.73-5.25,2.75-8.39,2.75s-6.02-1.02-8.37-2.75c2.57-3.25,3.97-7.27,3.97-11.41,0-4.14-1.39-8.17-3.97-11.41,2.35-1.73,5.23-2.75,8.37-2.75s6.04,1.02,8.39,2.75c-2.58,3.24-3.98,7.27-3.97,11.41,0,4.14,1.4,8.16,3.97,11.41Zm3-3c-1.8-2.43-2.78-5.38-2.77-8.41,0-3.03,.96-5.98,2.77-8.41,1.81,2.43,2.78,5.38,2.77,8.41,0,3.03-.97,5.98-2.77,8.41Zm11.38,5.75c-3.12,0-6.04-1.04-8.38-2.75,2.57-3.25,3.97-7.27,3.97-11.41,0-4.14-1.39-8.17-3.97-11.41,2.34-1.71,5.26-2.75,8.38-2.75,7.82,0,14.15,6.33,14.15,14.16s-6.33,14.16-14.15,14.16Z" fill-rule="evenodd" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="150" height="65" viewBox="0 0 150 65" fill="currentColor" class="text-dark">
          <path d="M75.46,7.09c1.02,.05,1.99,.46,2.77,1.16,1.05,1.04,1.33,2.78,.83,4.18-1.94,4.17-6.54,6.96-9.68,7.89-1.88,.46-4.26,.46-5.98-.23-.83,.52-1.53,2.21-2.55,1.51-1.47-1.2-.2-3.08-1.04-4.42-.17-.27-.61-.29-.84-.74-1.16-2.67,.28-5.22,1.88-7.25,2.67-3.13,10.35-6.61,14.61-2.09h0Zm-8.91,2.09c-1.49,.29-3.18,.97-4.09,2.09-.91,1.12-1.49,2.2-.94,3.36,1.94-1.51,2.88-3.59,5.04-4.87,0-.23,.33-.41,0-.58Zm9.02,.58c-3.82-.35-6.7,2.67-9.41,5.57-.17,.46-1.16,.99-.39,1.51,3.65,.35,7.14-.75,9.79-3.3,.78-.75,1.33-1.74,.94-2.78-.17-.4-.56-.81-.94-.98Zm33.09,17.28c1.77,4.52,3.26,11.65,0,16-.89,1.04-2.43,2.01-3.43,1.22-3.65-3.07-5.2-7.48-7.47-11.42-.33-.17-.33,.29-.5,.46-.83,4,.72,9.22-1.88,12.35-1,.17-1.93-.36-2.27-1.39-1.27-4.12,.05-8.41,.39-12.52,.78-2.09,1.11-4.52,2.82-6.09,2.77,1.16,4.09,4.41,5.7,6.78,1.16,1.8,2.1,3.83,3.43,5.45,1.16-.52,.59-2.11,.55-3.07-.44-3.77-1.44-7.25-2.38-10.84-.05-.93-.55-2.49,.39-3.07,2.49,1.16,3.54,3.88,4.65,6.15Zm-16.71-1.39c0,.87-.66,1.96-1.22,2.09-5.31,.87-11.23,.35-16.21,2.09-.17,.64,.55,.75,.94,.93,4.26,.7,8.74,.87,12.89,1.97,2.19,.58,2.99,3.31,3.15,5.57,.1,1.78-.55,3.94-2.21,5.16-4.09,2.73-10.35,2.61-14.5,.12-1.59-.93-3.1-2.43-3.21-4.29,0-1.47,.61-2.63,1.61-3.19,3.98-1.68,8.91-.75,12.34,1.39,.22,1.16-.98,1.1-1.55,1.51-3.82,2.32-6.7-2.61-10.24-.81-.5,.35-.86,1.32-.28,1.62,4.37,2.03,9.24,.58,13.56-.7,.5-.17,1.11-.7,1.16-1.22-.17-1.86-2.16-2.26-3.43-2.78-3.76-.99-7.91-.99-11.95-1.39-.77-.17-1.76-.74-1.99-1.39-.44-1.39-.44-3.3,.55-4.46,5.15-4.75,12.95-4.35,19.48-3.07,.44,.17,.94,.34,1.11,.87h0Zm-24.18,2.2c.5,5.57,.77,10.73,.66,16.58-.11,.75-.94,.93-1.49,1.22-.89,.17-2.03-.02-2.38-.52-1.27-2.15-.83-5.04-.94-7.65,.17-4.12,.11-8.58,1.22-12.41,.21-.56,.83-1.04,1.33-.7,1.33,.7,1.55,2.09,1.6,3.48h0Zm61.48-.81c.27,.47,.54,1.19,0,1.51-2.49,1.16-5.86,.64-8.74,.99-.77,.7-1.38,1.85-1.11,2.9,.28,.17,.53,.44,.83,.4,1.77,.12,4.43-.87,5.59,.87,.28,.52-.04,2.45-.83,2.49-2.16,.29-5.71-.28-6.75,.29-1.33,.93-1.22,2.72-1.72,4.18,.94,.64,1.93-.02,3.04-.17,2.05-.35,4.32-.99,6.36-.52,.39,.75,.94,1.57,.55,2.49-3.49,2.9-7.99,5.87-12.78,3.77-1.8-.85-2.6-3.71-1.99-6.14,.39-1.74,2.1-3.42,1.05-5.28-.17-.81,.28-1.51,.94-1.68,1.83,0,1.44-2.38,2.38-3.48-1.05-1.22-3.71-1.16-3.43-3.59,1.27-.7,2.82-.46,4.26-.7,3.26-.7,6.92-1.1,10.24-.7,.66,.14,1.55,1.51,2.1,2.38ZM50.23,13.82c5.11,4.37,11.73,11.83,10.9,20.41-1,6.78-7.86,11.89-13.67,13.51-5.64,1.74-12.73,1.57-18.48,.17-.39,1.1-.77,2.43-1.99,2.9-.77,.29-1.77,.12-2.38-.41-1.71-1.68-.33-4.93-2.82-5.97-4.87-2.15-10.13-6.38-12.62-11.6-.33-1.04,.06-2.09,.66-2.9,3.82-3.19,8.63-4.46,13.45-5.45,.28,.12,.17-.29,.39-.41,.28-3.48,.39-7.02,1.44-10.15,.24-.44,.83-.58,1.22-.29,3.04,2.43,1.6,7.02,2.93,10.32,5.81,.29,11.62,.58,16.21,4,1.55,1.33,1.93,3.88,1.44,5.33-.49,1.45-2.1,2.49-3.6,2.61-1,0-2.88,.1-2.77-.69,.11-.8,3.38-2.1,2.38-3.19-1.45-1.56-8.68-2.49-13.16-3.07-.55-.12-1.06,.06-1.06,.7-.11,4.41-.44,9.28,.28,13.51,.06,.29,.39,.64,.66,.69,7.91,1.33,16.27,.58,22.47-4.17,2.88-2.43,3.82-5.86,3.32-9.62-2.49-10.49-12.95-16.82-21.52-20.87C25.55,5.35,16.31,3.38,6.4,3.9c-1.58,.12-4.08,.69-4.09,1.28-.02,.58,2.83,.4,2.49,1.51-.34,1.11-3.24,.45-4.09,.17C-.16,6.59-.07,5.3,.15,4.48,2.31,.48,8.33,.16,11.05,.02c15.05-.41,29.6,5.6,39.18,13.8h0Zm-27.11,15.54c-3.82,.06-7.86,.46-11.4,1.85-.72,.29-1.61,1.1-1.05,2.09,1.44,2.03,3.5,3.69,5.42,4.87,1.93,1.17,4.48,2.67,6.81,3.02,.55-3.77,.55-7.48,.5-11.36-.22-.12,0-.35-.28-.46h0Zm114.37-5.28c-.17,5.04-4.65,8.18-4.65,13.22,.17,.17,.28,.41,.5,.29,3.6-4.12,7.14-9.97,12.4-11.71,1.39-.12,2.64,1.15,3.15,2.09,1.83,3.83,1.39,9.22-1.16,12.7-2.63,3.41-7.19,6.84-12.39,6.26-2.16,5.57-3.65,11.42-4.48,17.51-.44,1.22-1.49,.12-2.16-.12-4.48-3.71-.8-13.53-.5-14.79,.3-1.25,1.5-4.2,2.38-6.67-2.1-3.94-.78-8.7,.94-12.35,1.33-2.44,3.16-4.87,5.31-6.73,.27,0,.5,.06,.66,.29h0Zm8.91,6.26c-.66-.12-.94,.81-1.49,.99-2.54,3.02-5.09,6.03-6.36,9.62,1.72,.23,3.15-.93,4.65-1.57,2.54-1.68,4.15-4.46,3.98-7.65-.11-.52-.55-.93-.78-1.39h0Z" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="125" height="65" viewBox="0 0 125 65" fill="currentColor" class="text-dark mt-xl-5">
          <path d="M67.37,.18c-.41,.05-.8,1.32-1.59,1.98-.58,.47-1.3,.45-1.68,1.03-.15,.22-.1,.59-.26,.95-.32,.72-1.46,.78-1.46,1.57,0,.85,.95,1.01,1.77,1.61,.64,.48,.7,.82,1.48,1.05,.66,.19,1.65-.43,2.54-.21,.73,.18,1.43,.31,1.6,.94,.14,.58-.01,1.48-.9,1.38-.3-.03-1.6-.39-3.19-.25-1.92,.18-4.11,.71-4.33,2.51-.12,1,1.36,2.19,2.79,1.95,.99-.16,.52-1.14,1.06-1.62,.7-.61,4.7,2.13,8.42,2.13,1.56,0,2.73-.33,3.89-1.35,.11-.08,.24-.24,.41-.25,.16,.01,.43,.14,.52,.2,2.99,2.02,5.26,6.08,16.26,6.12,1.55,0,3.31,.63,4.75,1.73,1.28,1,2.04,2.55,2.77,4.12,1.1,2.36,3.07,4.66,6.07,7.22,.16,.14,2.63,1.75,2.82,1.87,.03,.02,.21,.38,.15,.58-.07,1.53-.34,5.99,3.62,6.19,.96,.04,.71-.53,.71-.92,0-.78-.17-1.55,.32-2.34,.67-1.09-1.41-1.6-1.35-3.96,.05-1.76-1.72-1.46-2.61-2.8-.52-.78-.97-1.19-.94-2.14,.2-5.35-1.36-8.87-2.13-9.74-.61-.65-1.11-.91-.55-1.21,3.3-1.83,4.05-3.54,4.05-3.54,1.76-3.47,3.33-6.63,5.51-8.03,.44-.29,1.56-.99,2.25-1.27,2.03-.8,3.1-1.29,3.69-1.77,.93-.76,1.67-2.36,.78-3.32-1.11-1.19-3.04-.25-3.89,.18-6.07,3.03-6.96,8.36-9.07,11.43-1.68,2.45-4.4,4.25-6.84,4.4-1.83,.11-3.8-.2-5.76-.92-4.77-1.76-7.38-4.03-8-4.43-1.28-.83-11.23-9.04-19.29-9.37,0,0-1-1.68-1.25-1.71-.59-.06-1.19,1-1.62,1.13-.41,.11-1.09-1.16-1.5-1.1h0ZM31.88,49.16c-.76-.02-1.4-.54-1.4-1.19V26.85h-8.29v23.29c0,1.14,1.1,2.07,2.45,2.07h14.49c1.36,0,2.45-.93,2.45-2.07V26.85h-8.28v21.13c0,.65-.65,1.17-1.41,1.19Zm27.75-22.31h-12.54c-1.49,0-2.7,1.02-2.69,2.27h0v23.09h8.3V31.03c0-.65,.63-1.17,1.4-1.16h0c.77,0,1.4,.5,1.41,1.15v21.2h8.26V31.01c.01-.64,.63-1.15,1.41-1.15s1.4,.51,1.41,1.16v21.18h8.3V29.12c0-1.25-1.2-2.27-2.69-2.27h-12.55ZM16.66,45.84H8.28v6.37H0V26.85H16.71c1.5,0,2.66,1.02,2.66,2.28v14.42c0,1.26-1.21,2.28-2.71,2.29h-.01Zm-5.56-14.76c.01-.66-.62-1.2-1.4-1.21h-1.41v12.83h1.41c.73,0,1.41-.49,1.4-1.19v-10.43h0Zm95.93,18.13c0,1.72-1.64,3.12-3.68,3.12-2.04,0-3.7-1.39-3.71-3.11,0,0,0-.01,0-.02,0-1.7,1.65-3.12,3.65-3.12,2.09,0,3.74,1.38,3.74,3.12Zm-3.73-2.67c-1.67,0-3.06,1.21-3.06,2.67s1.4,2.67,3.11,2.67,3.09-1.2,3.09-2.67-1.38-2.67-3.09-2.67h-.05Zm1.79,4.47h-.99l-1.27-1.42v1.42h-.81v-3.6h.85c1.16,0,1.77,.37,1.77,1.07,0,.47-.36,.88-.87,1.01l-.06,.02,1.38,1.5h0Zm-2.12-2.01c.57,0,.88-.17,.88-.51,0-.31-.3-.46-.86-.46h-.17v.98h.14Zm-14.19,3.2v-6.37h-2.82v6.37h-8.28V29.12c0-1.26,1.21-2.27,2.69-2.27h13.99c1.49,0,2.7,1.02,2.7,2.27h0v23.09h-8.28Zm0-9.51v-11.68c-.02-.65-.64-1.14-1.41-1.14-.77,0-1.39,.52-1.41,1.16v11.66h2.82ZM.23,65v-6.97h.92v.65c.22-.26,.46-.45,.74-.58,.27-.13,.61-.19,1-.19,.51,0,.96,.11,1.35,.33,.39,.22,.69,.54,.89,.94,.2,.4,.3,.85,.3,1.33,0,.51-.11,.98-.33,1.39-.22,.41-.54,.73-.96,.95-.4,.21-.85,.33-1.32,.33-.34,0-.64-.06-.91-.18-.26-.11-.48-.27-.66-.46v2.45H.23Zm.92-4.42c0,.65,.16,1.13,.47,1.44,.31,.31,.69,.46,1.13,.46s.84-.16,1.16-.48c.32-.32,.48-.82,.48-1.49s-.16-1.12-.47-1.44c-.31-.32-.69-.48-1.13-.48s-.82,.17-1.15,.51c-.33,.34-.5,.84-.5,1.48h0Zm15.22,2.49v-.74c-.47,.57-1.1,.85-1.9,.85-.35,0-.68-.06-.99-.17-.31-.11-.53-.26-.68-.43-.16-.19-.27-.41-.31-.63-.04-.17-.06-.43-.06-.8v-3.12h1.02v2.79c0,.45,.02,.75,.06,.9,.07,.22,.2,.4,.41,.53,.21,.13,.46,.19,.77,.19s.59-.07,.86-.2c.27-.13,.46-.31,.57-.54,.11-.23,.17-.56,.17-.98v-2.7h1.02v5.04h-.91Zm8.28,0v-5.04h.91v.71c.19-.25,.45-.45,.75-.59,.31-.15,.67-.23,1.07-.23,.44,0,.81,.08,1.09,.23,.29,.16,.49,.37,.6,.65,.48-.59,1.09-.88,1.85-.88,.6,0,1.05,.14,1.37,.42,.32,.28,.48,.7,.48,1.28v3.46h-1.01v-3.17c0-.34-.03-.59-.1-.74-.07-.15-.19-.28-.36-.36-.18-.09-.4-.14-.61-.14-.42,0-.77,.12-1.05,.35-.28,.24-.42,.61-.42,1.13v2.93h-1.02v-3.27c0-.38-.08-.67-.25-.85-.17-.19-.44-.28-.81-.28-.29,0-.55,.06-.79,.19-.24,.13-.42,.31-.53,.55-.11,.24-.16,.59-.16,1.05v2.61h-1.02Zm19.32-.62c-.38,.27-.74,.46-1.09,.57-.36,.11-.74,.17-1.12,.17-.66,0-1.16-.13-1.52-.4-.35-.27-.53-.62-.53-1.04,0-.25,.07-.47,.2-.68,.13-.2,.31-.36,.52-.49,.22-.12,.46-.22,.73-.28,.3-.06,.6-.1,.9-.13,.82-.08,1.43-.18,1.81-.3,0-.12,0-.19,0-.22,0-.35-.1-.59-.29-.73-.26-.19-.65-.29-1.16-.29-.48,0-.83,.07-1.06,.21-.23,.14-.39,.39-.5,.75l-.99-.12c.09-.35,.24-.64,.45-.86,.21-.22,.51-.39,.9-.51,.39-.12,.84-.18,1.36-.18s.93,.05,1.25,.15c.32,.1,.56,.23,.71,.38,.15,.15,.25,.35,.32,.58,.03,.14,.05,.41,.05,.79v1.14c0,.79,.02,1.3,.07,1.51,.04,.21,.13,.41,.26,.61h-1.06c-.11-.19-.18-.41-.2-.62h0Zm-.09-1.91c-.37,.13-.92,.23-1.66,.32-.42,.05-.71,.11-.89,.17-.16,.06-.3,.15-.4,.28-.09,.12-.14,.25-.14,.4,0,.23,.1,.42,.31,.57,.2,.15,.5,.23,.9,.23s.74-.07,1.04-.21c.29-.13,.53-.34,.67-.59,.11-.19,.16-.48,.16-.85v-.31h0Zm8.67,2.53v-.97h1.16v.97h-1.16Zm12.62-1.85l1,.11c-.11,.58-.39,1.03-.84,1.36-.45,.33-1,.49-1.66,.49-.82,0-1.48-.22-1.98-.67-.5-.45-.75-1.1-.75-1.94,0-.54,.11-1.02,.32-1.43,.22-.41,.54-.71,.98-.92,.44-.2,.93-.31,1.43-.31,.65,0,1.19,.14,1.6,.42,.41,.28,.68,.67,.8,1.18l-.99,.13c-.1-.34-.26-.59-.5-.76-.24-.17-.53-.26-.87-.26-.51,0-.93,.15-1.25,.46-.32,.31-.48,.8-.48,1.46s.16,1.17,.46,1.48c.31,.31,.71,.46,1.21,.46,.4,0,.73-.1,1-.31,.27-.2,.44-.52,.51-.95h0Zm7.27-.67c0-.93,.31-1.62,.93-2.07,.52-.37,1.14-.56,1.88-.56,.83,0,1.5,.23,2.02,.68,.52,.45,.78,1.08,.78,1.88,0,.65-.12,1.16-.35,1.53-.23,.37-.58,.67-1.01,.87-.44,.21-.94,.31-1.45,.31-.84,0-1.52-.22-2.04-.68-.52-.45-.78-1.1-.78-1.95h0Zm1.05,0c0,.64,.17,1.13,.5,1.45,.33,.32,.76,.48,1.26,.48s.92-.16,1.26-.48c.33-.32,.5-.81,.5-1.48,0-.62-.17-1.1-.5-1.42-.34-.32-.76-.48-1.26-.48s-.93,.16-1.26,.48c-.34,.32-.5,.8-.5,1.45Zm11.54,2.52v-5.04h.91v.71c.19-.25,.45-.45,.75-.59,.31-.15,.67-.23,1.07-.23,.44,0,.81,.08,1.09,.23,.29,.16,.49,.37,.6,.65,.48-.59,1.09-.88,1.85-.88,.59,0,1.05,.14,1.37,.42,.32,.28,.48,.7,.48,1.28v3.46h-1.01v-3.17c0-.34-.03-.59-.1-.74-.07-.15-.19-.27-.36-.36-.18-.09-.39-.14-.61-.14-.42,0-.77,.12-1.05,.35-.28,.24-.42,.61-.42,1.13v2.93h-1.02v-3.27c0-.38-.08-.67-.25-.85-.17-.19-.44-.28-.81-.28-.29,0-.55,.06-.79,.19-.24,.13-.42,.31-.53,.55-.11,.24-.16,.59-.16,1.05v2.61h-1.02Z" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="65" height="65" viewBox="0 0 65 65" fill="currentColor" class="text-dark mt-xl-5">
          <path d="M32.5,0c17.9,0,32.5,14.6,32.5,32.5s-14.6,32.5-32.5,32.5S0,50.4,0,32.5,14.6,0,32.5,0h0Zm0,5.86c14.67,0,26.64,11.97,26.64,26.64s-11.97,26.64-26.64,26.64S5.86,47.17,5.86,32.5,17.83,5.86,32.5,5.86h0Zm15.61,44.09h-12.99V24.44h6.21v20.32h6.78v5.2Zm-15.48-16.37c0,4.65-3.1,7.18-7.53,7.18h-.91c-4.4,0-7.59-2.26-7.59-6.98V14.85h6.21v19.26c0,1.35,.54,2.02,1.62,2.02h.34c1.38,0,1.65-1.32,1.65-2.43V14.85h6.21v18.73h0Zm-11.67,12.39c0,2,1.63,3.62,3.62,3.62s3.62-1.63,3.62-3.62-1.61-3.62-3.62-3.62c-2,0-3.62,1.63-3.62,3.62h0Zm.68,0c0-1.71,1.33-3.07,2.94-3.07s2.94,1.37,2.94,3.07-1.3,3.07-2.94,3.07c-1.62,0-2.94-1.38-2.94-3.07Zm1.62,1.78h.67v-1.5h.55c.77,0,.79,.34,.8,.67,.02,.6,.01,.68,.13,.83h.69c-.14-.2-.11-.3-.14-.86-.02-.36-.05-.78-.52-.87v-.02c.54-.22,.61-.58,.61-.83,0-.94-.81-1.05-1.19-1.05h-1.61v3.62h0Zm.67-3.13h.7c.43,0,.74,.11,.74,.55,0,.26-.1,.58-.66,.58h-.78v-1.13h0Z" fill-rule="evenodd" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="125" height="65" viewBox="0 0 125 65" fill="currentColor" class="text-dark">
          <path d="M31.75,14.84c15.02,2.84,29.72,.88,35.7,.55-10.07,9.01-10.28,27.63-22.14,27.72-1.82,.01-3.91-.41-6.35-1.36,8.43-19.24-4.19-24.25-7.21-26.9h0Zm-4.65,1.64c5.54-.19,12.32,6.08,12.62,12.62,.43,9.34-4.89,13.45-4.84,16.65,.05,3.01,2.54,5.76,3.5,7.72h-7.71c-.43-1.49-1.53-2.14-1.56-2.25-.46-1.57,.56-2.81,.53-5.22-.1-6.93-10.64-7.36-10.93-20.45-.1-4.72,2.78-8.88,8.39-9.08h0Zm44.76,14.38c-3.05,.07-4.92,3.29-8.04,6.73-1.68,2.72-3.07,11.4-3.52,15.88h8.19c.43-3.59-1.94-2.8-1.79-4.25,.51-5,3.48-4.41,4.02-9.03,3.63-.33,5.44-2.48,5.54-4.75,.14-3.32-2.78-4.61-4.38-4.57h0Zm3.45,9.86c-.46,.22-1.32,1.18-3.14,1.19-1.13,3.17-3.01,3.26-3.93,6.41-.31,.51,1.47,1.39,.98,2.36,.24,.33,1.27,1,1.34,2.79h6.06c-.9-4.36-4.19-4.23-4.21-5.69-.05-3.14,2.36-5.35,2.89-7.06h0Zm-37.43,1.07c.22,1.43-1.69,1.83-1.59,5.04,.04,1.16,2.41,4.65,3.89,6.64h5.31c-2.53-4.38-6.12-5.5-6.14-6.78-.03-1.34,1.25-3.26-1.46-4.89h0Zm-19.79-12.41c.88,1,1.63,3.54,1.49,6.05-.13,2.51-1.46,3.35-2.02,4.34-1.08-1.42-1.59-2.98-1.59-5.15s1.46-4.35,2.12-5.24h0Zm57.96-14.97c3.82-.37,5.48,2.34,5.62,4.89,.26,4.8-3.21,4.87-3.29,8.63-.04,2.22,.69,1.34,.87,6.41,.13,3.64-2.31,5.17-3.38,5.86-.03-.46,1.4-3.12,1.13-6.47-.24-2.93-3.06-4.19-5.01-4.2-5.21-.02-8.73,9.68-15.36,12.5-.78,.33-3.01,.25-3.32-.17,8.84-7.17,7.76-26,22.74-27.45h0Zm11.6-.91c.04,1.01,.16,2.7-1.09,4.12s-2.98,1.5-3.8,1.66c.02-1.36,.51-2.47,1.53-3.75s2.57-1.82,3.37-2.03h0Zm-.22,10.65c.99,4.6,9.12,9.62,8.84,11.54-.3,2.12,.84,5.85-1.94,6.36-.26-1.32-.78-1.89-1.53-1.87-1.03,.03-1.34,2.5-1.18,4.01-1.9,.42-3.84-1.59-5.69-2.91-2.04-1.47-4.11-2.88-5.73-4.72,.98-3.81-.89-10.1,.19-11.33,.91-1.03,4.46,.44,7.03-1.09h0Zm12.25-.37c2.03,4.23-1.66,8.76-4.59,8.48-.83-.08-1.89-1.51-1.58-2.49,2.86-1.81,5.18-4.67,6.16-5.99h0Zm-9.28-8.46c.78,3.89-1.88,8.98-8.23,8.54,.71-1.02,.16-2.73,.68-3.71,2.79-.31,6.26-3.21,7.55-4.83Zm18.78,6.77c2.22,5.42-7.65,15.37-10.59,15.84-1.75,.28-1.52-3.14-1.38-4.31,2.86-1.81,10.26-7.29,11.98-11.52h0Zm-20.12,9.95c.07,1.6-.84,2.38-1.75,2.22-.95-.17-1.4-1.66-1.23-2.75,.92,.72,2.28,.74,2.98,.53h0ZM8.63,59.58H106.17c1.31,0,2.61-.56,3.64-1.46h0c1.06-.93,1.83-2.16,2.06-3.5l7.73-45.17c.04-.25,.06-.51,.06-.77,0-.84-.26-1.58-.71-2.14-.45-.55-1.1-.94-1.88-1.07-.24-.04-.48-.06-.71-.06H18.82c-1.31,0-2.61,.56-3.64,1.46-1.06,.91-1.83,2.15-2.06,3.49L5.39,55.54c-.04,.25-.06,.51-.06,.77,0,.84,.26,1.58,.72,2.14,.45,.55,1.1,.94,1.88,1.07,.21,.04,.45,.06,.71,.06h0Zm0,5.42c-.54,0-1.08-.05-1.61-.14-2.09-.37-3.85-1.42-5.08-2.93-1.23-1.51-1.94-3.45-1.94-5.61,0-.54,.05-1.1,.15-1.68L7.87,9.46c.45-2.62,1.89-4.99,3.85-6.68,1.98-1.71,4.51-2.77,7.1-2.77H116.37c.54,0,1.08,.05,1.61,.14,2.09,.37,3.84,1.42,5.08,2.93,1.23,1.51,1.94,3.45,1.94,5.61,0,.54-.05,1.1-.15,1.68l-7.73,45.17c-.45,2.63-1.89,5-3.85,6.7h0c-1.98,1.69-4.5,2.76-7.1,2.76H8.63Z" fill-rule="evenodd" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="125" height="65" viewBox="0 0 125 65" fill="currentColor" class="text-dark mt-xl-5">
          <path d="M122.61,13.9c-1.32,0-2.4,1.13-2.4,2.52s1.07,2.52,2.4,2.52c1.32,0,2.39-1.13,2.39-2.52h0c0-1.4-1.07-2.52-2.39-2.52Zm0,4.74c-1.16,0-2.11-.99-2.11-2.22h0c0-1.23,.94-2.22,2.11-2.22h0c1.16,0,2.1,.99,2.1,2.21,0,1.22-.93,2.22-2.09,2.22h0Zm1.23-2.88c0-.24-.1-.49-.3-.61-.2-.13-.43-.14-.65-.14h-1.17v2.82h.33v-1.3h.6l.77,1.3h.39l-.81-1.3c.48-.01,.85-.22,.85-.77h0Zm-1.29,.5h-.5v-1h.77c.33,0,.7,.05,.7,.49,0,.57-.58,.51-.96,.51ZM42.33,58.01l-15.62-8.02c-.34-.19-.52-.66-.51-.98l.04-4.43c0-.31,.06-.63,.45-.93,1.67-1.12,6.84-4.13,12.19-12.33,7.12-10.93,0-20.1-11.12-17.61-9.88,2.22-19.94,7.85-24.3,10.9C-.43,27.34,.11,30.64,0,33.59c.22,1.25,.65,1.14,1.62-.11,7.24-7.04,18.25-12.38,20.3-13.29s6.91-3.98,12.64-2.61c5.5,1.31,4.16,9.17,2.48,12.49-1.84,3.63-7.07,8.92-9.45,10.22-.9,.5-1.24,0-1.24-.8l.38-17.1c0-1.14-.49-1.65-1.57-1.25l-1.73,.91c-1.19,.74-1.13,1.02-1.24,1.93l-.26,19.71c0,.43-.2,.77-.42,.87l-5.64,3.33c-1.3,.68-.97,1.7,0,2.05l4.54,2.27c1.08,.45,1.4,.79,1.4,1.93l-.16,9.54c4.05-.85,4.32-2.9,4.43-4.26v-2.9c.11-.68,.49-.91,1.03-.79l13.18,6.7c1.19,.57,1.84,.34,2.7-1.25,.86-1.59,.97-2.38-.65-3.18h0Zm23.02-24.07c-1.83,1.11-2.68,3.19-1.96,4.51,.72,1.31,2.9,1.53,4.73,.42,1.83-1.11,2.62-3.14,1.9-4.45-.72-1.31-2.84-1.59-4.68-.48Zm-6.76,1.41c-.5,.64-1.46,2.58-2,3.78-.54,1.19-1.67,3.89-2.81,3.89-1.2,0-1.35-3.12-1.35-4.26s-.65-1.31-.97-1.25-1.24,.4-1.51,1.59c-.27,1.19-1.73,6.36-3.35,6.36-1.03,0-1.78-3.12-1.84-4.09-.05-.96-.49-1.76-1.4-1.76-.65,0-1.46,.34-1.78,.74s-.38,1.02-2.11,.62c-1.57-.06-3.08,.8-4.91,4.03-1.11,1.95-2,5.58-.32,7.04,1.57,1.36,4.32-1.08,5.13-2.1,.81-1.02,1.51-1.76,1.84-2.33,.32-.57,.65-.51,.81,.06,.16,.57,1.08,2.78,2.27,2.73,1.19-.06,2.7-1.02,4.48-4.32,.32-.68,.81-.62,.92-.06,.11,.57,.81,2.44,2,2.44s2.4-1.89,3.02-3.01c.43-.77,1.08-.4,1.08,.34s-.32,18.17-.32,18.17c0,.79,.3,1.02,.84,1.02h2.35c.43,0,.81-.4,.81-1.02l.49-28.26c0-.68-.73-1.16-1.35-.37h0Zm-18.36,11.13c-.49,.85-1.78,3.12-2.92,2.73-.59-.34,.2-2.61,.59-3.41,.59-1.19,2.34-3.09,3.13-2.61,.76,.45-.32,2.44-.81,3.29h0ZM122.52,29.06c-.22,.2-.57,.54-1.35,.17-1.35-.57-1.46-3.24-2.16-5.68-.63-2.19-2.15-2.06-2.7-1.05l-1.65,2.78c-.3,.57-.94,1.87-1.59,1.87-.76,0-.42-1.14-.38-2.27,.03-.77-.43-1.73-1.19-1.73-.86,0-1.78,1.39-2.48,2.98-.49,1.11-1.76,5.37-3.35,5.37-1.03,0-1.13-3.12-1.19-4.09s-.38-2.16-1.3-2.16c-.62,0-1.03,.34-1.35,.74-.32,.4-.38,.74-1.51,.57-1.57-.06-4.16,1.48-5.99,4.71-1.11,1.95-2.44,6.04-.76,7.5,1.57,1.36,4.37-1.82,5.18-2.84,.81-1.02,1.51-1.76,1.84-2.33,.32-.57,.65-.51,.81,.06,.16,.57,1.08,2.78,2.27,2.73,1.19-.06,2.16-.34,3.94-3.64,.32-.68,.92-.77,1.03-.2s.22,2.07,1.35,2.07c1.94,0,4.15-4.97,4.7-6.13,.49-1.02,1.27-.74,1.54,.03,.39,1.1,.73,4.63,2.83,4.63s3.54-2.36,3.97-3.1c.49-.74,.23-1.68-.51-.99h0Zm-22.89,3.41c-.49,.85-1.57,2.73-2.7,2.33-.59-.34,.14-1.99,.54-2.78,.59-1.19,2.33-3.12,3.13-2.64,.75,.45-.49,2.24-.97,3.1h0Zm-10.43-2.98s-4.59-3.52-5.89-5.11c-.87-1.07-.27-1.87,.27-2.33,3.24-2.27,8.31-5.79,10.31-11.25,1.92-5.26-1.08-9.83-3.24-10.56-2.96-1.01-9.23,1.02-12.37,7.16-2.03,3.97-2.97,5.28-3.24,16.07-.05,2.04-.11,4.37-.11,6.93s-.27,9.48-.54,10.79c-1.03,3.07,2.05,1.25,3.46,.06,1.4-1.19,1.3-2.98,1.3-3.75,0-.97,.05-18,.54-21.81,.3-2.37,.65-6.76,3.02-10.56,2.38-3.81,4.81-2.27,5.45-1.65,.65,.62,1.57,2.22,1.08,5.45-.75,5.02-6.26,10.51-7.67,12.21-1.4,1.7-1.08,3.18-.27,4.37,.58,.85,2,2.5,3.46,4.03,1.46,1.53,1.3,2.9,1.08,3.92-.76,3.07-8.64,11.36-8.64,11.36-1.67,1.87,.05,4.94,.65,5.96,.6,1.02,1.35,.68,1.84-.17,1.94-3.8,10.31-13.01,10.31-13.01,2.43-3.24,1.41-6.36-.81-8.12h0Z" fill-rule="evenodd" />
        </svg>
      </div>
      <div class="col-6 col-md-3 align-self-center text-center">
        <svg xmlns="http://www.w3.org/2000/svg" width="150" height="65" viewBox="0 0 150 65" fill="currentColor" class="text-dark mt-xl-5">
          <path d="M76.42,3.33c-3.06,3.64-11.77,15.4-12.77,16.92-1.91,2.92-2.08,4.33-2.14,5.27-.06,.92-.06,2.59,1.5,3.95,2.61,2.25,6.26,1.88,9.51,1.88h26.72c1.14,0,1.48-.33,2.1-1.12,2.14-3.15,3.09-6.58,3.09-9.64,0-6.56-4.41-14.82-15.56-18.55l-1.26,1.74c8.85,4.06,12.51,9.37,12.51,16.79,.06,1.99-.49,4.15-1.84,6.14h-25.99c-1.56,0-1.78-1.7-1.22-2.66,2.23-3.83,4.71-7.52,7.44-11.03,2.63-3.39,5.21-6.56,7.93-9.87,.73-.92,.24-1.81-1.22-2.1-3.04-.62-6.21-1.05-10.05-1.05-21.32,0-29.12,11.83-29.12,20.6,0,9.51,7.86,20.54,29.18,20.54,11.83,0,19.58-3.68,24.06-8.41h-4.52c-3.92,3.5-10.65,5.98-19.54,5.98-18.06,0-24.71-9.8-24.71-18.24,.13-7.54,7.27-17.93,25.16-18.28,.68-.02,1.2,.58,.73,1.14h0Zm64.13,54.29c1.07,.15,1.89,.96,1.89,1.92,0,1.09-1.01,1.96-2.25,1.96h-22.91v-14.47h-6.75v14.51h-12.41c-3.36,0-4.05-1.97-4.05-3.79v-10.81h-11.19c-1.11,.72-2.18,1.52-3.32,2.19l-6.64,3.95-8.62-6.09h-13.43v3.64h4.86v-1.99l11.42,7.92-7.8,4.73h-8.48v3.64h9.81c1.05-.69,2.04-1.41,3.13-2.05l6.82-4,8.66,5.98h9.86l-13.03-9.47,6.69-4.22c1.43-.91,2.93-1.67,4.39-2.5v9.53c0,4.02,1.07,6.81,9.45,6.81l47.34-.11c3.66,.05,6-2.39,6-5.34s-2.7-5.35-6-5.35h-17.1c.23-2.01,2.02-3.69,3.84-3.69h17.31l-.05-3.5h-18.36c-5.81,0-10.46,4.66-10.59,10.07-.02,.38,.24,.62,.68,.62l20.83-.08h0Zm-89.68-.05v-3.71h3.34v3.71h-3.34Zm0-10.58h-12.68c-3.43,0-6.08,.87-8.02,2.35-3.51,2.68-4.63,5.51-4.59,6.78h4.57c-2.01,1.45-3.36,3.19-4.07,5.2H11.08c-2.7,0-4.44-1.85-4.44-3.64v-10.81H0v11.23c0,4.04,3.98,6.83,10.35,6.83H50.87v-3.64h-16.09c.08-1.85,2.12-3.71,3.97-3.71h12.11v-3.71h-16.28c-.22-1.09,1.88-3.22,3.49-3.22h12.79v-3.64h0Z" fill-rule="evenodd" />
        </svg>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Clients"] = ["clients/clients-1"];
Vvveb.Sections.add("contact-form/contact-form-1", {
    name: "Contact form 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-1-thumb.webp",
    html: `<section class="contact-form-9" aria-label="contact-form-9">
  <div class="container py-5 my-5">
    <div class="row py-5">
      <div class="col py-5">
        <div>
          <div class="row text-center justify-content-center">
            <div class="col-12 col-md-9 col-lg-7">
              <h1>Contact Us</h1>
              <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
            </div>
          </div>

          <div class="row justify-content-center pt-4" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

            <div class="notifications" data-v-notifications>

              <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                </div>

                <div class="flex-grow-1 align-self-center text-small">
                  <div>
                    <div data-v-notification-text>
                      This is a placeholder for a notification message.
                    </div>
                  </div>
                </div>


                <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

              <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                </div>

                <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                  This is a placeholder for a success message.
                </div>

                <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

              <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                </div>

                <div class="flex-grow-1 align-self-center" data-v-notification-text>
                  This is a placeholder for a info message.
                </div>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

            </div>

            <div class="col-12 col-md-8">
              <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
                <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
                <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
                <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


                <div class="row">
                  <div class="col-12 col-md">
                    <input type="text" class="form-control" placeholder="Name">
                  </div>
                  <div class="col-12 col-md mt-4 mt-md-0">
                    <input type="text" class="form-control" placeholder="Email">
                  </div>
                </div>

                <div class="row mt-4">
                  <div class="col">
                    <input type="email" class="form-control" placeholder="Subject">
                  </div>
                </div>

                <div class="row mt-4">
                  <div class="col">
                    <textarea class="form-control" name="message" rows="3" placeholder="How can we help?"></textarea>
                  </div>
                </div>

                <!-- if these hidden inputs are filled then ignore, robots -->

                <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

                <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

                <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


                <div class="row mt-4">
                  <div class="col text-center">
                    <button type="submit" class="btn btn-primary">Send</button>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-2", {
    name: "Contact form 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-2-thumb.webp",
    html: `<section class="contact-form-11 pt-0" aria-label="contact-form-11">
  <div class="container-fluid p-0 pb-5">
    <iframe loading="lazy" class="map" title="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2848.8444388087937!2d26.101253041406952!3d44.43635311654287!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40b1ff4770adb5b7%3A0x58147f39579fe6fa!2zR3J1cHVsIFN0YXR1YXIgIkPEg3J1yJthIEN1IFBhaWHIm2Ui!5e0!3m2!1sen!2sro!4v1507381157656" style="border:0" allowfullscreen="" width="100%" height="300" frameborder="0"></iframe>
  </div>
  <div class="container">
    <div class="row pt-5">
      <div class="col-12" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
          <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
          <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
          <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


          <div class="row">
            <div class="col-12 col-md">
              <label>First Name</label>
              <input type="text" class="form-control">
            </div>
            <div class="col-12 col-md mt-4 mt-md-0">
              <label>Last Name</label>
              <input type="text" class="form-control">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <label>Your Email</label>
              <input type="email" class="form-control">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <label>Subject (optional but helpful)</label>
              <input type="email" class="form-control">
            </div>
          </div>
          <div class="row mt-4">
            <div class="col">
              <label>How can we help?</label>
              <textarea class="form-control" name="message" rows="3"></textarea>
            </div>
          </div>

          <!-- if these hidden inputs are filled then ignore, robots -->

          <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

          <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

          <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          <div class="row mt-4 text-center">
            <div class="col">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-3", {
    name: "Contact form 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-3-thumb.webp",
    html: `<section class="contact-form-12 py-0" aria-label="contact-form-12">
  <div class="container py-5">
    <div class="row text-center justify-content-center">
      <div class="col-12 col-md-8 col-lg-7">
        <h1>Contact Us</h1>
        <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
      </div>
    </div>
    <div class="row-50">
    </div>
    <div class="row justify-content-center">
      <div class="col-12 col-md-8 col-lg-7" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
          <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
          <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
          <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


          <div class="row">
            <div class="col">
              <label>Your Email Address</label>
              <input type="text" class="form-control">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <label>Subject</label>
              <input type="email" class="form-control">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <label>How can we help?</label>
              <textarea class="form-control" name="message" rows="3"></textarea>
            </div>
          </div>

          <!-- if these hidden inputs are filled then ignore, robots -->

          <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

          <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

          <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          <div class="row mt-4">
            <div class="col text-end">
              <button type="submit" class="btn btn-dark">Send</button>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div class="row-100"></div>
  </div>

  <div class="container-fluid p-0">
    <iframe loading="lazy" class="map" title="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2848.8444388087937!2d26.101253041406952!3d44.43635311654287!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40b1ff4770adb5b7%3A0x58147f39579fe6fa!2zR3J1cHVsIFN0YXR1YXIgIkPEg3J1yJthIEN1IFBhaWHIm2Ui!5e0!3m2!1sen!2sro!4v1507381157656" style="border:0" allowfullscreen="" width="100%" height="300" frameborder="0"></iframe>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-4", {
    name: "Contact form 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-4-thumb.webp",
    html: `<section class="contact-form-13" aria-label="contact-form-13">
  <div class="container">
    <div class="row text-center justify-content-center">
      <div class="col-12 col-md-8 col-lg-7">
        <h1>Contact Us</h1>
        <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
      </div>
    </div>
    <div class="row-70"></div>
    <div class="row">
      <div class="col-12 col-md-8 col-lg m-auto" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
          <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
          <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
          <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


          <div class="row">
            <div class="col">
              <input type="email" class="form-control" placeholder="Email">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <input type="email" class="form-control" placeholder="Subject">
            </div>
          </div>
          <div class="row mt-4">
            <div class="col">
              <textarea class="form-control" name="message" rows="3" placeholder="How can we help?"></textarea>
            </div>
          </div>

          <!-- if these hidden inputs are filled then ignore, robots -->

          <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

          <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

          <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          <div class="row mt-4">
            <div class="col">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>
          </div>
        </form>
      </div>

      <div class="col-12 col-md-8 col-lg pt-5 m-auto pt-lg-0">
        <iframe loading="lazy" class="mb-4" title="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2848.8444388087937!2d26.101253041406952!3d44.43635311654287!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40b1ff4770adb5b7%3A0x58147f39579fe6fa!2zR3J1cHVsIFN0YXR1YXIgIkPEg3J1yJthIEN1IFBhaWHIm2Ui!5e0!3m2!1sen!2sro!4v1507381157656" style="border:0" allowfullscreen="" width="100%" height="200" frameborder="0"></iframe>

        <p>
          <strong>Showroom</strong>
        </p>
        <p>
          71 Pilgrim Avenue
          <br>Chevy Chase, MD 20815
        </p>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-5", {
    name: "Contact form 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-5-thumb.webp",
    html: `<section class="contact-form-2 container-fluid px-5 my-5" aria-label="contact-form-2">
  <div class="row justify-content-center">
    <div class="col-xl-10">
      <div class="card border-0 rounded-3 shadow-lg ">
        <div class="card-body p-0">
          <div class="row g-0">
            <div class="col-sm-6 d-none d-sm-block bg-image">

              <img alt="image" src="demo/img/team-1.jpg" alt="happy cat" loading="lazy" class="img-fluid">

            </div>
            <div class="col-sm-6 p-4" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

              <div class="notifications" data-v-notifications>

                <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

                  <div class="icon align-middle me-2">
                    <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                  </div>

                  <div class="flex-grow-1 align-self-center text-small">
                    <div>
                      <div data-v-notification-text>
                        This is a placeholder for a notification message.
                      </div>
                    </div>
                  </div>


                  <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">
                      <!-- <i class="la la-times"></i> -->
                    </span>
                  </button>
                </div>

                <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

                  <div class="icon align-middle me-2">
                    <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                  </div>

                  <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                    This is a placeholder for a success message.
                  </div>

                  <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">
                      <!-- <i class="la la-times"></i> -->
                    </span>
                  </button>
                </div>

                <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

                  <div class="icon align-middle me-2">
                    <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                  </div>

                  <div class="flex-grow-1 align-self-center" data-v-notification-text>
                    This is a placeholder for a info message.
                  </div>

                  <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">
                      <!-- <i class="la la-times"></i> -->
                    </span>
                  </button>
                </div>

              </div>

              <div class="text-center">
                <div class="h3 fw-light">Contact Form</div>
                <p class="mb-4 text-muted">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
              </div>


              <form id="contactForm" action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
                <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
                <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
                <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


                <div class=" mb-3">
                  <input class="form-control" id="name" type="text" placeholder="Name" required />
                  <label for="name">Name</label>
                </div>


                <div class=" mb-3">
                  <input class="form-control" id="emailAddress" type="email" placeholder="Email Address" required />
                  <label for="emailAddress">Email Address</label>
                </div>


                <div class=" mb-3">
                  <textarea class="form-control" id="message" type="text" placeholder="Message" style="height: 10rem;" required></textarea>
                  <label for="message">Message</label>
                </div>

                <!-- if these hidden inputs are filled then ignore, robots -->

                <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

                <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

                <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


                <div class="d-grid">
                  <button class="btn btn-primary btn-lg disabled" id="submitButton" type="submit">Submit</button>
                </div>
              </form>


            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-6", {
    name: "Contact form 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-6-thumb.webp",
    html: `<section title="contact-form-6" class="contact-form-6">
  <div class="container-fluid g-0">

    <div style="height:300px" data-component-maps>
      <iframe loading="lazy" frameborder="0" title="map" src="https://maps.google.com/maps?q=Bucharest&z=15&t=q&key=&output=embed" width="100%" height="100%" style="width:100%;height:100%;left:0px">
      </iframe>
    </div>

  </div>
  <div class="container">
    <div class="row my-5">
      <div class="col-12 col-md-6 col-lg-5">
        <h2 class="display-6 mb-1 fw-bold mb-4">Contact Us</h2>
        <p class="lead">
          Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.
        </p>

        <p class="lead">
          The html for sections blocks and components and this template are built using Bootstrap 5.
        </p>

        <div data-v-component-site>
          <p class="mt-5">
            <b>
              <i class="la la-lg la-envelope opacity-50"></i> Email:
            </b>
            <span data-v-if="site.contact-email">
              <a href="mailto:contact@mysite.com" data-v-site-contact-email>
                <span data-v-site-contact-email>contact@mysite.com</span>
              </a>
            </span>
          </p>
          <p class="">
            <b>
              <i class="la la-lg la-phone opacity-50"></i> Phone:
            </b>
            <a href="tel:5511112377" data-v-site-description-phone-number>
              <span data-v-site-description-phone-number>+55 (111) 123 777</span>
            </a>
          </p>
        </div>
      </div>

      <div class="col-12 col-md-6 ms-auto" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error>

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info>

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>
        <div class="border rounded-3 p-4 border-opacity-25 border-light-subtle">
          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>

            <div class="row">
              <div class="col">
                <input type="text" class="form-control" placeholder="First name" name="first_name" required>
              </div>
              <div class="col">
                <input type="text" class="form-control" placeholder="Last name" name="last_name" required>
              </div>
            </div>

            <div class="row mt-4">
              <div class="col">
                <input type="email" class="form-control" placeholder="Email" name="email" required>
              </div>
            </div>

            <div class="row mt-4">
              <div class="col">
                <input type="text" class="form-control" placeholder="Subject" name="subject" required>
              </div>
            </div>
            <div class="row mt-4">
              <div class="col">
                <textarea class="form-control" name="message" rows="3" placeholder="How can we help?" required></textarea>
              </div>
            </div>


            <!-- if these hidden inputs are filled then ignore, robots -->

            <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


            <div class="row mt-4">
              <div class="col">
                <button type="submit" class="btn btn-primary">
                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                    </span>
                    <span>Submitting</span> ...
                  </span>

                  <span class="button-text">
                    <span>Submit</span>
                    <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                  </span>
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-7", {
    name: "Contact form 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-7-thumb.webp",
    html: `<section class="contact-form-8" aria-label="contact-form-8">
  <div class="container">
    <div class="row text-center justify-content-center">
      <div class="col-12 col-md-8 col-lg-7">
        <h1>Contact Us</h1>
        <p class="lead">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
      </div>
    </div>

    <div class="row pt-4">
      <div class="col-12 col-md-6">
        <iframe loading="lazy" class="map" title="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2848.8444388087937!2d26.101253041406952!3d44.43635311654287!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40b1ff4770adb5b7%3A0x58147f39579fe6fa!2zR3J1cHVsIFN0YXR1YXIgIkPEg3J1yJthIEN1IFBhaWHIm2Ui!5e0!3m2!1sen!2sro!4v1507381157656" style="border:0" allowfullscreen="" width="100%" height="300" frameborder="0"></iframe>
      </div>

      <div class="col-12 col-md-6 pt-5" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
          <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
          <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
          <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


          <div class="row">
            <div class="col">
              <input type="email" class="form-control" placeholder="Email">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <input type="email" class="form-control" placeholder="Subject">
            </div>
          </div>
          <div class="row mt-4">
            <div class="col">
              <textarea class="form-control" name="message" rows="3" placeholder="How can we help?"></textarea>
            </div>
          </div>

          <!-- if these hidden inputs are filled then ignore, robots -->

          <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

          <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

          <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


          <div class="row mt-4">
            <div class="col">
              <button type="submit" class="btn btn-primary">Submit</button>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-8", {
    name: "Contact form 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-8-thumb.webp",
    html: `<section class="contact-form-8 pt-0" aria-label="contact-form-8">
  <div class="container-fluid p-0 pb-3">
    <iframe loading="lazy" class="map" title="map" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2848.8444388087937!2d26.101253041406952!3d44.43635311654287!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x40b1ff4770adb5b7%3A0x58147f39579fe6fa!2zR3J1cHVsIFN0YXR1YXIgIkPEg3J1yJthIEN1IFBhaWHIm2Ui!5e0!3m2!1sen!2sro!4v1507381157656" style="border:0" allowfullscreen="" width="100%" height="300" frameborder="0"></iframe>
  </div>
  <div class="container">
    <div class="row text-center justify-content-center pt-5">
      <div class="col-12 col-md-7">
        <h1>Contact Us</h1>
      </div>
    </div>

    <div class="row justify-content-center pt-4">
      <div class="col-12 col-md-7" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
          <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
          <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
          <input type="hidden" class="form-control" name="form-name" value="contact-us-home">


          <div class="row">
            <div class="col">
              <input type="text" class="form-control" placeholder="Email">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <input type="email" class="form-control" placeholder="Subject">
            </div>
          </div>

          <div class="row mt-4">
            <div class="col">
              <textarea class="form-control" name="message" rows="3" placeholder="How can we help?"></textarea>
            </div>
          </div>

          <!-- if these hidden inputs are filled then ignore, robots -->

          <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

          <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

          <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


          <div class="row mt-4">
            <div class="col text-center">
              <button type="submit" class="btn btn-primary">Send</button>
            </div>
          </div>
        </form>
      </div>
    </div>
    <div class="row-100"></div>
  </div>
  <div class="">
    <div class="container">
      <div class="row-50"></div>
      <div class="row justify-content-center text-center">
        <div class="col-12 col-md me-auto ms-auto">
          <p class="lead">+55 (111) 123 777</p>
        </div>

        <div class="col-12 col-md pt-4 me-auto ms-auto">
          <p class="lead">7th St.
            <br>New York, NY 12345
          </p>
        </div>

        <div class="col-12 col-md pt-4 me-auto ms-auto">
          <p class="lead">support@vvveb.com</p>
        </div>
      </div>
      <div class="row-50"></div>
    </div>
  </div>

  <div class="container">
    <div class="row-70"></div>
    <div class="row text-center">
      <div class="col">
        <p class="h2">
          <a class="mx-2">
            <i class="la la-facebook"></i>
          </a>
          <a class="mx-2">
            <i class="la la-twitter"></i>
          </a>
          <a class="mx-2">
            <i class="la la-instagram"></i>
          </a>
          <a class="mx-2">
            <i class="la la-google"></i>
          </a>
          <a class="mx-2">
            <i class="la la-pinterest"></i>
          </a>
        </p>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-9", {
    name: "Contact form 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-9-thumb.webp",
    html: `<section class="contact-form-3 py-5" aria-label="contact-form-3">
  <div class="row no-gutters">
    <div class="container">
      <div class="row">
        <div class="col-lg-6">
          <div class="card-shadow">
            <img alt="image" src="demo/img/team-1.jpg" alt="happy cat" loading="lazy" class="img-fluid">
          </div>
        </div>
        <div class="col-lg-6">
          <div class="contact-box ms-3" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

            <div class="notifications" data-v-notifications>

              <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                </div>

                <div class="flex-grow-1 align-self-center text-small">
                  <div>
                    <div data-v-notification-text>
                      This is a placeholder for a notification message.
                    </div>
                  </div>
                </div>


                <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

              <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                </div>

                <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                  This is a placeholder for a success message.
                </div>

                <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

              <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

                <div class="icon align-middle me-2">
                  <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                </div>

                <div class="flex-grow-1 align-self-center" data-v-notification-text>
                  This is a placeholder for a info message.
                </div>

                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                  <span aria-hidden="true">
                    <!-- <i class="la la-times"></i> -->
                  </span>
                </button>
              </div>

            </div>

            <h1 class=" mt-2">Quick Contact</h1>
            <form class="mt-4" action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
              <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
              <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
              <input type="hidden" class="form-control" name="form-name" value="contact-us-home">

              <div class="row">
                <div class="col-lg-12">
                  <div class="form-group mt-2">
                    <input class="form-control" type="text" placeholder="name">
                  </div>
                </div>
                <div class="col-lg-12">
                  <div class="form-group mt-2">
                    <input class="form-control" type="email" placeholder="email address">
                  </div>
                </div>
                <div class="col-lg-12">
                  <div class="form-group mt-2">
                    <input class="form-control" type="text" placeholder="phone">
                  </div>
                </div>
                <div class="col-lg-12">
                  <div class="form-group mt-2">
                    <textarea class="form-control" rows="3" placeholder="message"></textarea>
                  </div>
                </div>


                <!-- if these hidden inputs are filled then ignore, robots -->

                <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

                <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

                <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

                <div class="col-lg-12">
                  <button type="submit" class="btn btn-success mt-3 text-white border-0 px-3 py-2">
                    <span> Submit</span>
                  </button>
                </div>
              </div>
            </form>
          </div>
        </div>
        <div class="col-lg-12">
          <div class="card mt-4 border-0 mb-4">
            <div class="row">
              <div class="col-lg-4 col-md-4">
                <div class="card-body d-flex align-items-center c-detail pl-0">
                  <div class="me-3 align-self-center">
                    <i class="la la-map la-lg"></i>
                  </div>
                  <div>
                    <h6>Address</h6>
                    <p>708 Picadilly Ave.
                      <br> New York
                    </p>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4">
                <div class="card-body d-flex align-items-center c-detail">
                  <div class="me-3 align-self-center">
                    <i class="la la-phone la-lg"></i>
                  </div>
                  <div>
                    <h6>Phone</h6>
                    <p>555 111 333</p>
                  </div>
                </div>
              </div>
              <div class="col-lg-4 col-md-4">
                <div class="card-body d-flex align-items-center c-detail">
                  <div class="me-3 align-self-center">
                    <i class="la la-email la-lg"></i>
                  </div>
                  <div>
                    <h6>Email</h6>
                    <p>
                      hello@vvveb.com
                    </p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("contact-form/contact-form-10", {
    name: "Contact form 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/contact-form/contact-form-10-thumb.webp",
    html: `<section title="contact-form-10" class="contact-form-10 border-top">
  <div class="container">
    <div class="row my-5">
      <div class="col-12 col-md-6 col-lg-5">
        <h2 class="display-6 mb-1 fw-bold mb-4">Contact Us</h2>
        <p class="lead">
          Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.
        </p>

        <p class="lead">
          The html for sections blocks and components and this template are built using Bootstrap 5.
        </p>

        <div data-v-component-site>
          <p class="mt-5">
            <b>
              <i class="la la-lg la-envelope opacity-50"></i> Email:
            </b>
            <span data-v-if="site.contact-email">
              <a href="mailto:contact@mysite.com" data-v-site-contact-email>
                <span data-v-site-contact-email>contact@mysite.com</span>
              </a>
            </span>
          </p>
          <p class="">
            <b>
              <i class="la la-lg la-phone opacity-50"></i> Phone:
            </b>
            <a href="tel:5511112377" data-v-site-description-phone-number>
              <span data-v-site-description-phone-number>+55 (111) 123 777</span>
            </a>
          </p>
        </div>
      </div>

      <div class="col-12 col-md-6 ms-auto" data-v-component-plugin-contact-form-form data-v-storage="database" data-v-name="contact-us-home">

        <div class="notifications" data-v-notifications>

          <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
            </div>

            <div class="flex-grow-1 align-self-center text-small">
              <div>
                <div data-v-notification-text>
                  This is a placeholder for a notification message.
                </div>
              </div>
            </div>


            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1 la-check-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
              This is a placeholder for a success message.
            </div>

            <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

          <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="contact-us-home">

            <div class="icon align-middle me-2">
              <i class="align-middle la la-2x lh-1  la-info-circle"></i>
            </div>

            <div class="flex-grow-1 align-self-center" data-v-notification-text>
              This is a placeholder for a info message.
            </div>

            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">
                <!-- <i class="la la-times"></i> -->
              </span>
            </button>
          </div>

        </div>

        <div class="border rounded-3 p-4 border-opacity-25 border-light-subtle">
          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-contact-form-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
            <input type="hidden" class="form-control" name="form-name" value="contact-us-home">

            <div class="row">
              <div class="col">
                <input type="text" class="form-control" placeholder="First name" name="first_name" required>
              </div>
              <div class="col">
                <input type="text" class="form-control" placeholder="Last name" name="last_name" required>
              </div>
            </div>

            <div class="row mt-4">
              <div class="col">
                <input type="email" class="form-control" placeholder="Email" name="email" required>
              </div>
            </div>

            <div class="row mt-4">
              <div class="col">
                <input type="text" class="form-control" placeholder="Subject" name="subject" required>
              </div>
            </div>
            <div class="row mt-4">
              <div class="col">
                <textarea class="form-control" name="message" rows="3" placeholder="How can we help?" required></textarea>
              </div>
            </div>


            <!-- if these hidden inputs are filled then ignore, robots -->

            <input type="text" class="form-control d-none" placeholder="Contact form" name="contact-form">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">


            <div class="row mt-4">
              <div class="col">
                <button type="submit" class="btn btn-primary">
                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                    </span>
                    <span>Submitting</span> ...
                  </span>

                  <span class="button-text">
                    <span>Submit</span>
                    <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                  </span>
                </button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Contact form"] = ["contact-form/contact-form-1","contact-form/contact-form-2","contact-form/contact-form-3","contact-form/contact-form-4","contact-form/contact-form-5","contact-form/contact-form-6","contact-form/contact-form-7","contact-form/contact-form-8","contact-form/contact-form-9","contact-form/contact-form-10"];
Vvveb.Sections.add("counter/counter-1", {
    name: "Counter 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/counter/counter-1-thumb.webp",
    html: `<section class="py-5" aria-label="counter-1">
  <div class="container">
    <div class="row justify-content-md-center">
      <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-xxl-6">
        <h2 class="mb-4 display-5 text-center fw-bold">Some of our achievments</h2>
        <p class="text-secondary mb-5 text-center lead fs-4">Lorem ipsum dolor sit amet, consectetur.</p>
      </div>
    </div>
  </div>

  <div class="container overflow-hidden">
    <div class="row gy-5 gy-md-6 gy-lg-0">
      <div class="col-6 col-lg-3">
        <div class="text-center">
          <div class="d-inline-block bg-primary mb-3 mx-auto rounded-circle p-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-people text-white" viewBox="0 0 16 16">
              <path d="M15 14s1 0 1-1-1-4-5-4-5 3-5 4 1 1 1 1h8zm-7.978-1A.261.261 0 0 1 7 12.996c.001-.264.167-1.03.76-1.72C8.312 10.629 9.282 10 11 10c1.717 0 2.687.63 3.24 1.276.593.69.758 1.457.76 1.72l-.008.002a.274.274 0 0 1-.014.002H7.022zM11 7a2 2 0 1 0 0-4 2 2 0 0 0 0 4zm3-2a3 3 0 1 1-6 0 3 3 0 0 1 6 0zM6.936 9.28a5.88 5.88 0 0 0-1.23-.247A7.35 7.35 0 0 0 5 9c-4 0-5 3-5 4 0 .667.333 1 1 1h4.216A2.238 2.238 0 0 1 5 13c0-1.01.377-2.042 1.09-2.904.243-.294.526-.569.846-.816zM4.92 10A5.493 5.493 0 0 0 4 13H1c0-.26.164-1.03.76-1.724.545-.636 1.492-1.256 3.16-1.275zM1.5 5.5a3 3 0 1 1 6 0 3 3 0 0 1-6 0zm3-2a2 2 0 1 0 0 4 2 2 0 0 0 0-4z" />
            </svg>
          </div>
          <h5 class="display-6 fw-bold m-1">150K</h5>
          <p class="text-secondary m-0">Happy Customers</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="text-center">
          <div class="d-inline-block bg-primary mb-3 mx-auto rounded-circle p-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-activity text-white" viewBox="0 0 16 16">
              <path fill-rule="evenodd" d="M6 2a.5.5 0 0 1 .47.33L10 12.036l1.53-4.208A.5.5 0 0 1 12 7.5h3.5a.5.5 0 0 1 0 1h-3.15l-1.88 5.17a.5.5 0 0 1-.94 0L6 3.964 4.47 8.171A.5.5 0 0 1 4 8.5H.5a.5.5 0 0 1 0-1h3.15l1.88-5.17A.5.5 0 0 1 6 2Z" />
            </svg>
          </div>
          <h5 class="display-6 fw-bold m-1">1200+</h5>
          <p class="text-secondary m-0">Issues Solved</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="text-center">
          <div class="d-inline-block bg-primary mb-3 mx-auto rounded-circle p-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-briefcase text-white" viewBox="0 0 16 16">
              <path d="M6.5 1A1.5 1.5 0 0 0 5 2.5V3H1.5A1.5 1.5 0 0 0 0 4.5v8A1.5 1.5 0 0 0 1.5 14h13a1.5 1.5 0 0 0 1.5-1.5v-8A1.5 1.5 0 0 0 14.5 3H11v-.5A1.5 1.5 0 0 0 9.5 1h-3zm0 1h3a.5.5 0 0 1 .5.5V3H6v-.5a.5.5 0 0 1 .5-.5zm1.886 6.914L15 7.151V12.5a.5.5 0 0 1-.5.5h-13a.5.5 0 0 1-.5-.5V7.15l6.614 1.764a1.5 1.5 0 0 0 .772 0zM1.5 4h13a.5.5 0 0 1 .5.5v1.616L8.129 7.948a.5.5 0 0 1-.258 0L1 6.116V4.5a.5.5 0 0 1 .5-.5z" />
            </svg>
          </div>
          <h5 class="display-6 fw-bold m-1">30K</h5>
          <p class="text-secondary m-0">Finished Projects</p>
        </div>
      </div>
      <div class="col-6 col-lg-3">
        <div class="text-center">
          <div class="d-inline-block bg-primary mb-3 mx-auto rounded-circle p-4">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" fill="currentColor" class="bi bi-award text-white" viewBox="0 0 16 16">
              <path d="M9.669.864 8 0 6.331.864l-1.858.282-.842 1.68-1.337 1.32L2.6 6l-.306 1.854 1.337 1.32.842 1.68 1.858.282L8 12l1.669-.864 1.858-.282.842-1.68 1.337-1.32L13.4 6l.306-1.854-1.337-1.32-.842-1.68L9.669.864zm1.196 1.193.684 1.365 1.086 1.072L12.387 6l.248 1.506-1.086 1.072-.684 1.365-1.51.229L8 10.874l-1.355-.702-1.51-.229-.684-1.365-1.086-1.072L3.614 6l-.25-1.506 1.087-1.072.684-1.365 1.51-.229L8 1.126l1.356.702 1.509.229z" />
              <path d="M4 11.794V16l4-1 4 1v-4.206l-2.018.306L8 13.126 6.018 12.1 4 11.794z" />
            </svg>
          </div>
          <h5 class="display-6 fw-bold m-1">12+</h5>
          <p class="text-secondary m-0">Awards Winned</p>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("counter/counter-2", {
    name: "Counter 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/counter/counter-2-thumb.webp",
    html: `<section class="py-5" aria-label="counter-2">
  <div class="container">
    <div class="row justify-content-md-center">
      <div class="col-12 col-md-10 col-lg-8 col-xl-7 col-6">
        <h2 class="mb-2 display-5 text-center fw-bold">Some of our achievments</h2>
        <p class="text-secondary mb-5 text-center lead fs-4">Lorem ipsum dolor sit amet, consectetur.</p>
      </div>
    </div>
  </div>

  <div class="container">
    <div class="row gy-4 gy-lg-0 align-items-lg-center">
      <div class="col-12 col-lg-6">
        <img class="img-fluid rounded-4" loading="lazy" src="demo/img/team-1.jpg" alt="Team 1">
      </div>
      <div class="col-12 col-lg-6">
        <div class="row justify-content-xl-end">
          <div class="col-12 col-xl-11">
            <div class="row gy-4 gy-sm-0 overflow-hidden">
              <div class="col-12 col-sm-6">
                <div class="card border-0 border-bottom border-primary shadow mb-4">
                  <div class="card-body text-center p-4 p-5">
                    <h3 class="display-2 fw-bold mb-2">60</h3>
                    <p class="fs-5 mb-0 text-secondary">Finished Projects</p>
                  </div>
                </div>
                <div class="card border-0 border-bottom border-primary shadow">
                  <div class="card-body text-center p-4 p-5">
                    <h3 class="display-2 fw-bold mb-2">10k+</h3>
                    <p class="fs-5 mb-0 text-secondary">Issues Solved</p>
                  </div>
                </div>
              </div>
              <div class="col-12 col-sm-6">
                <div class="card border-0 border-bottom border-primary shadow mt-5 mb-4">
                  <div class="card-body text-center p-4 p-5">
                    <h3 class="display-2 fw-bold mb-2">3k+</h3>
                    <p class="fs-5 mb-0 text-secondary">Happy Customers</p>
                  </div>
                </div>
                <div class="card border-0 border-bottom border-primary shadow">
                  <div class="card-body text-center p-4 p-5">
                    <h3 class="display-2 fw-bold mb-2">7</h3>
                    <p class="fs-5 mb-0 text-secondary">Awards</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Counter"] = ["counter/counter-1","counter/counter-2"];
Vvveb.Sections.add("cta/cta-1", {
    name: "Cta 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/cta/cta-1-thumb.webp",
    html: `<section class="cta-1" aria-label="cta-1" data-bs-theme="dark">

  <div class="container">

    <div class="row justify-content-center">
      <div class="col text-center">
        <h2 class="display-3 fw-bold text-body mb-3">Ready to take the next step?</h2>
        <p class="text-body h4 fw-normal">Our specialists are ready to work on your next awesome project</p>
        <p class="text-body h4 fw-normal">Contact us today to get started!</p>
        <a href="https://www.vvveb.com" class="btn btn-lg btn-primary mt-5">
          <span>Contact us</span>
        </a>
      </div>
    </div>
  </div>


  <div class="overlay">
  </div>

  <div class="background-container parallax">

    <img src="demo/img/hero-3.webp" alt="Hero background">

  </div>

</section>`
});Vvveb.Sections.add("cta/cta-2", {
    name: "Cta 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/cta/cta-2-thumb.webp",
    html: `<section class="cta-2 m-5" aria-label="cta-1" data-bs-theme="dark">

  <div class="container rounded-4">
    <img src="demo/img/hero-3.webp" alt="Team 1" class="w-100 rounded-4">

    <div class="position-absolute top-0 h-100 container">
      <div class="row align-items-center h-100 mx-auto">
        <div class="col text-center">
          <h2 class="display-3 fw-bold text-body mb-3">Ready to take the next step?</h2>
          <p class="text-body h4 fw-normal">Our specialists are ready to work on your next awesome project</p>
          <p class="text-body h4 fw-normal">Contact us today to get started!</p>
          <a href="https://www.vvveb.com" class="btn btn-lg btn-primary mt-5">
            <span>Contact us</span>
          </a>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("cta/cta-3", {
    name: "Cta 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/cta/cta-3-thumb.webp",
    html: `<section class="cta-3 p-5" aria-label="cta-1" data-bs-theme="dark">

  <div class="container">

    <div class="row">
      <div class="col-8">
        <h2 class="display-4 fw-bold text-body mb-3">Ready to take the next step?</h2>
        <p class="text-body h4 fw-normal">Our specialists are ready to work on your next awesome project</p>
        <p class="text-body h4 fw-normal">Contact us today to get started!</p>
        <a href="https://www.vvveb.com" class="btn btn-lg btn-light mt-5">
          <span>Contact us</span>
        </a>
      </div>
    </div>
    <div class="col-4"></div>
  </div>


  <div class="overlay">
  </div>

  <div class="background-container parallax">

    <img src="demo/img/team-1.jpg" alt="Team 1">

  </div>

</section>`
});
	Vvveb.SectionsGroup["Cta"] = ["cta/cta-1","cta/cta-2","cta/cta-3"];
Vvveb.Sections.add("faq/faq-1", {
    name: "Faq 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/faq/faq-1-thumb.webp",
    html: `<section class="py-5" aria-label="faq-1">
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">F.A.Q</span>
        <h2 class="display-5 fw-bold">Frequently Asked Questions</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row mt-4 justify-content-center">
      <div class="col-md-8">
        <div class="accordion faq accordion-flush" id="faqAccordion1">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button aria-controls="collapseOne" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseOne" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseOne">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button aria-controls="collapseTwo" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseTwo" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseTwo">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button aria-controls="collapseThree" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseThree" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseThree">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("faq/faq-2", {
    name: "Faq 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/faq/faq-2-thumb.webp",
    html: `<section class="py-5" aria-label="faq-2">
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">F.A.Q</span>
        <h2 class="display-5 fw-bold">Frequently Asked Questions</h2>
        <p class="lead">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Soluta harum ipsum venenatis metus sem veniam eveniet aperiam suscipit.</p>
      </div>
    </div>
    <div class="row mt-4 justify-content-center">
      <div class="col-md-6">
        <div class="accordion faq accordion-flush" id="faqAccordion1">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button aria-controls="collapseOne" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseOne" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseOne">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button aria-controls="collapseTwo" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseTwo" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseTwo">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button aria-controls="collapseThree" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseThree" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion1" id="collapseThree">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="col-md-6">
        <div class="accordion faq accordion-flush" id="faqAccordion2">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button aria-controls="collapseOne2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseOne2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseOne2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button aria-controls="collapseTwo2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseTwo2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseTwo2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button aria-controls="collapseThree2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseThree2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseThree2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>

        </div>
      </div>



    </div>
  </div>
</section>`
});Vvveb.Sections.add("faq/faq-3", {
    name: "Faq 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/faq/faq-3-thumb.webp",
    html: `<section class="py-5" aria-label="faq-3">
  <div class="container">
    <div class="row justify-content-center text-center">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">F.A.Q</span>
        <h2 class="display-5 fw-bold">Frequently Asked Questions</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row mt-4 justify-content-center">
      <div class="col-md-5">
        <span class="text-muted">Lorem ipsum dolor</span>
        <h2 class="fw-bold">Have Any Questions?</h2>
        <p>Lorem ipsum dolor sit, amet consectetur adipisicing elit. Consequatur quidem eius cum voluptatum quasi delectus assumenda culpa.</p>
        <a class="btn btn-primary mt-1" href="/page/contact">Contact us</a>
      </div>
      <div class="col-md-7">
        <div class="accordion faq accordion-flush" id="faqAccordion2">
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingOne">
              <button aria-controls="collapseOne2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseOne2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingOne" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseOne2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingTwo">
              <button aria-controls="collapseTwo2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseTwo2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingTwo" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseTwo2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="headingThree">
              <button aria-controls="collapseThree2" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#collapseThree2" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="headingThree" class="accordion-collapse collapse" data-bs-parent="#faqAccordion2" id="collapseThree2">
              <div class="accordion-body">
                Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
              </div>
            </div>
          </div>

        </div>
      </div>



    </div>
  </div>
</section>`
});Vvveb.Sections.add("faq/faq-4", {
    name: "Faq 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/faq/faq-4-thumb.webp",
    html: `<section class="py-5" aria-label="faq-4">
  <div class="container">
    <div class="row justify-content-center text-center mb-5">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">F.A.Q</span>
        <h2 class="display-5 fw-bold">Frequently Asked Questions</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row justify-content-center">
      <div class="col-md-10">
        <div class="row g-3 g-md-4">
          <div class="col-lg-6">
            <h6 class="mb-3 mt-3 mt-md-0">Technical</h6>
            <div class="accordion faq accordion-flush" id="faq1-accordion accordion-flush">
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq1-headingOne">
                  <button aria-controls="faq1-collapseOne" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq1-collapseOne" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq1-headingOne" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq1-accordion accordion-flush" id="faq1-collapseOne">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq1-headingTwo">
                  <button aria-controls="faq1-collapseTwo" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq1-collapseTwo" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq1-headingTwo" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq1-accordion accordion-flush" id="faq1-collapseTwo">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq1-headingThree">
                  <button aria-controls="faq1-collapseThree" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq1-collapseThree" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq1-headingThree" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq1-accordion accordion-flush" id="faq1-collapseThree">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq1-headingFour">
                  <button aria-controls="faq1-collapseFour" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq1-collapseFour" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq1-headingFour" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq1-accordion accordion-flush" id="faq1-collapseFour">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <h6 class="mb-3 mt-3 mt-md-0">Licensing</h6>
            <div class="accordion faq accordion-flush" id="faq2-accordion accordion-flush">
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq1-headingOne">
                  <button aria-controls="faq2-collapseOne" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq2-collapseOne" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq2-headingOne" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq2-accordion accordion-flush" id="faq2-collapseOne">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq2-headingTwo">
                  <button aria-controls="faq2-collapseTwo" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq2-collapseTwo" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq2-headingTwo" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq2-accordion accordion-flush" id="faq2-collapseTwo">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq2-headingThree">
                  <button aria-controls="faq2-collapseThree" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq2-collapseThree" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq2-headingThree" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq2-accordion accordion-flush" id="faq2-collapseThree">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq2-headingFour">
                  <button aria-controls="faq2-collapseFour" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq2-collapseFour" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq2-headingFour" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq2-accordion accordion-flush" id="faq2-collapseFour">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <h6 class="mb-3 mt-3 mt-md-0">Support</h6>
            <div class="accordion faq accordion-flush" id="faq3-accordion accordion-flush">
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq3-headingOne">
                  <button aria-controls="faq3-collapseOne" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq3-collapseOne" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq3-headingOne" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq3-accordion accordion-flush" id="faq3-collapseOne">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq3-headingTwo">
                  <button aria-controls="faq3-collapseTwo" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq3-collapseTwo" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq3-headingTwo" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq3-accordion accordion-flush" id="faq3-collapseTwo">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq3-headingThree">
                  <button aria-controls="faq3-collapseThree" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq3-collapseThree" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq3-headingThree" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq3-accordion accordion-flush" id="faq3-collapseThree">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq3-headingFour">
                  <button aria-controls="faq3-collapseFour" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq3-collapseFour" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq3-headingFour" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq3-accordion accordion-flush" id="faq3-collapseFour">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
            </div>
          </div>
          <div class="col-lg-6">
            <h6 class="mb-3 mt-3 mt-md-0">Payments</h6>
            <div class="accordion faq accordion-flush" id="faq4-accordion accordion-flush">
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq4-headingOne">
                  <button aria-controls="faq4-collapseOne" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq4-collapseOne" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq4-headingOne" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq4-accordion accordion-flush" id="faq4-collapseOne">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq4-headingTwo">
                  <button aria-controls="faq4-collapseTwo" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq4-collapseTwo" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq4-headingTwo" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq4-accordion accordion-flush" id="faq4-collapseTwo">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq4-headingThree">
                  <button aria-controls="faq4-collapseThree" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq4-collapseThree" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq4-headingThree" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq4-accordion accordion-flush" id="faq4-collapseThree">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
              <div class="accordion faq accordion-item">
                <h2 class="accordion faq accordion-header" id="faq4-headingFour">
                  <button aria-controls="faq4-collapseFour" aria-expanded="false" class="accordion faq accordion-button collapsed" data-bs-target="#faq4-collapseFour" data-bs-toggle="collapse" type="button">
                    <div class="text-muted me-3">
                    </div>Lorem ipsum dolor sit amet adipisicing ?
                  </button>
                </h2>
                <div aria-labelledby="faq4-headingFour" class="accordion faq accordion-collapse collapse" data-bs-parent="#faq4-accordion accordion-flush" id="faq4-collapseFour">
                  <div class="accordion faq accordion-body">
                    Lorem ipsum dolor sit amet, consectetur adipisicing elit. Maiores porro quidem qui recusandae animi eaque id atque, dolorum expedita magnam modi dolores corrupti. Laudantium cumque suscipit voluptas asperiores, et recusandae.
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("faq/faq-5", {
    name: "Faq 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/faq/faq-5-thumb.webp",
    html: `<section class="py-5" aria-label="subscribe-5">
  <div class="container">
    <div class="row justify-content-center text-center mb-5">
      <div class="col-lg-8 col-xl-7">
        <span class="text-muted">F.A.Q</span>
        <h2 class="display-5 fw-bold">Frequently Asked Questions</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row justify-content-center pt-lg-3">
      <div class="col-md-3">
        <h2 class="mt-3 fw-bold">Payment</h2>
      </div>
      <div class="col-md-9">
        <div class="accordion faq accordion-flush" id="payment-accordion">
          <div class="accordion-item">
            <h2 class="accordion-header" id="payment-headingOne">
              <button aria-controls="payment-collapseOne" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#payment-collapseOne" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="payment-headingOne" class="accordion-collapse collapse" data-bs-parent="#payment-accordion" id="payment-collapseOne">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="payment-headingTwo">
              <button aria-controls="payment-collapseTwo" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#payment-collapseTwo" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="payment-headingTwo" class="accordion-collapse collapse" data-bs-parent="#payment-accordion" id="payment-collapseTwo">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="payment-headingThree">
              <button aria-controls="payment-collapseThree" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#payment-collapseThree" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="payment-headingThree" class="accordion-collapse collapse" data-bs-parent="#payment-accordion" id="payment-collapseThree">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="payment-headingFour">
              <button aria-controls="payment-collapseFour" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#payment-collapseFour" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="payment-headingFour" class="accordion-collapse collapse" data-bs-parent="#payment-accordion" id="payment-collapseFour">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <div class="row justify-content-center mt-5">
      <div class="col-md-3">
        <h2 class="mt-3 fw-bold">Shipping</h2>
      </div>
      <div class="col-md-9">
        <div class="accordion faq accordion-flush" id="Shipping-accordion">
          <div class="accordion-item">
            <h2 class="accordion-header" id="Shipping-headingOne">
              <button aria-controls="Shipping-collapseOne" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#Shipping-collapseOne" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="Shipping-headingOne" class="accordion-collapse collapse" data-bs-parent="#Shipping-accordion" id="Shipping-collapseOne">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="Shipping-headingTwo">
              <button aria-controls="Shipping-collapseTwo" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#Shipping-collapseTwo" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="Shipping-headingTwo" class="accordion-collapse collapse" data-bs-parent="#Shipping-accordion" id="Shipping-collapseTwo">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="Shipping-headingThree">
              <button aria-controls="Shipping-collapseThree" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#Shipping-collapseThree" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="Shipping-headingThree" class="accordion-collapse collapse" data-bs-parent="#Shipping-accordion" id="Shipping-collapseThree">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
          <div class="accordion-item">
            <h2 class="accordion-header" id="Shipping-headingFour">
              <button aria-controls="Shipping-collapseFour" aria-expanded="false" class="accordion-button collapsed" data-bs-target="#Shipping-collapseFour" data-bs-toggle="collapse" type="button">
                <div class="text-muted me-3">

                </div>Lorem ipsum dolor sit amet adipisicing ?
              </button>
            </h2>
            <div aria-labelledby="Shipping-headingFour" class="accordion-collapse collapse" data-bs-parent="#Shipping-accordion" id="Shipping-collapseFour">
              <div class="accordion-body">
                Lorem ipsum dolor sit, amet consectetur adipisicing elit. Maxime quos voluptatum at, quibusdam blanditiis saepe soluta laborum, repellendus nemo id porro dolor eveniet perspiciatis veritatis doloremque aliquam nam! Libero, nostrum!
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Faq"] = ["faq/faq-1","faq/faq-2","faq/faq-3","faq/faq-4","faq/faq-5"];
Vvveb.Sections.add("footer/footer-1", {
    name: "Footer 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-1-thumb.webp",
    html: `<footer class="footer-1" title="footer-1" data-v-save-global="index.html,.footer-1">
  <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

    <div class="row" data-v-menu-items>

      <div class="col-md">

        <div data-v-component-site>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
        </div>

      </div>


      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Vvveb</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://themes.vvveb.com/" data-v-menu-item-url>
              <span data-v-menu-item-name>Themes</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://plugins.vvveb.com/" data-v-menu-item-url>
              <span data-v-menu-item-name>Plugins</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="content/index.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="product/index.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Shop</span>
            </a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Resources</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
              <span data-v-menu-item-name>User documentation</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
              <span data-v-menu-item-name>Developer documentation</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="pricing.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Pricing</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="services.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Services</span>
            </a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Contact</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="" href="contact.html">Contact us</a>
            <a href="" href="portfolio.html">Portfolio</a>
            <a href="" href="about.html">About us</a>
            <a href="" href="user/return-form.html">Return form</a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>My account</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="" href="user/order-tracking.html">Order tracking</a>
            <a href="" href="user/wishlist.html">Wishlist</a>
            <a href="" href="user/orders.html">Orders</a>
            <a href="" href="cart/compare.html">Compare</a>
          </div>
        </nav>
      </div>



    </div>
    <!--
		<div class="row justify-content-end">
			<div class="col-md-3 text-muted text-small mt-5">
				&copy; <span data-v-year>2025</span> <span data-v-sitename>Vvveb</span>. Powered by <a href="https://vvveb.com" target="_blank">Vvveb</a>	
			</div>
		</div>
		-->

  </div>

  <div class="footer-copyright">
    <div class="container">
      <div class="d-flex flex-column flex-md-row">
        <div class="text-muted flex-grow-1">
          <a class="btn-link text-muted" href="/page/terms-conditions">Terms and conditions</a> |
          <a class="btn-link text-muted" href="/page/privacy-policy">Privacy Policy</a>
        </div>
        <div class="text-muted">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>. <span>Powered by</span>
          <a href="https://vvveb.com" class="btn-link text-muted" target="_blank">Vvveb</a>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-2", {
    name: "Footer 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-2-thumb.webp",
    html: `<footer class="bg-white" title="footer-2" data-v-save-global="index.html,.footer-2">

  <div class="container py-5">
    <div class="row py-4">
      <div class="col-md">
        <img src="demo/img/logo.png" alt="Site logo" loading="lazy" alt="" width="180" class="mb-3">
        <p class="font-italic text-muted">Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt.</p>
        <ul class="list-inline mt-4">
          <li class="list-inline-item">
            <a target="_blank" title="twitter">
              <i class="la la-twitter"></i>
            </a>
          </li>
          <li class="list-inline-item">
            <a target="_blank" title="facebook">
              <i class="la la-facebook"></i>
            </a>
          </li>
          <li class="list-inline-item">
            <a target="_blank" title="instagram">
              <i class="la la-instagram"></i>
            </a>
          </li>
          <li class="list-inline-item">
            <a target="_blank" title="pinterest">
              <i class="la la-pinterest"></i>
            </a>
          </li>
          <li class="list-inline-item">
            <a target="_blank" title="vimeo">
              <i class="la la-vimeo"></i>
            </a>
          </li>
        </ul>
      </div>
      <div class="col-md">
        <h6 class="text-uppercase font-weight-bold mb-4">Shop</h6>
        <ul class="list-unstyled mb-0">
          <li class="mb-2">
            <a class="text-muted">For Women</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">For Men</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">Stores</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">Our Blog</a>
          </li>
        </ul>
      </div>
      <div class="col-md">
        <h6 class="text-uppercase font-weight-bold mb-4">Company</h6>
        <ul class="list-unstyled mb-0">
          <li class="mb-2">
            <a class="text-muted">Login</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">Register</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">Wishlist</a>
          </li>
          <li class="mb-2">
            <a class="text-muted">Our Products</a>
          </li>
        </ul>
      </div>
      <div class="col-lg-4 col-md-6 mb-lg-0">
        <h6 class="text-uppercase font-weight-bold mb-4">Newsletter</h6>
        <p class="text-muted mb-4">Lorem ipsum dolor sit amet, consectetur adipisicing elit. At itaque temporibus.</p>
        <div class="p-1 rounded border">
          <div class="input-group">
            <input type="email" placeholder="Enter your email address" aria-describedby="button-addon1" class="form-control border-0 shadow-0">
            <div class="input-group-append">
              <button id="button-addon1" type="submit" class="btn btn-link">
                <i class="la la-paper-plane"></i>
              </button>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>
</footer>`
});Vvveb.Sections.add("footer/footer-3", {
    name: "Footer 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-3-thumb.webp",
    html: `<footer class="footer-3 bg-dark text-white" title="footer-3" data-v-save-global="index.html,.footer-3" data-bs-theme="dark">
  <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

    <div class="row" data-v-menu-items>


      <div class="col-md">

        <div data-v-component-site>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
        </div>

      </div>


      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Vvveb</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://themes.vvveb.com/" data-v-menu-item-url>
              <span data-v-menu-item-name>Themes</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://plugins.vvveb.com/" data-v-menu-item-url>
              <span data-v-menu-item-name>Plugins</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="content/index.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="product/index.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Shop</span>
            </a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Resources</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
              <span data-v-menu-item-name>User documentation</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
              <span data-v-menu-item-name>Developer documentation</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="pricing.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Pricing</span>
            </a>
          </div>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="services.html" data-v-menu-item-url>
              <span data-v-menu-item-name>Services</span>
            </a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>Contact</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="" href="contact.html">Contact us</a>
            <a href="" href="portfolio.html">Portfolio</a>
            <a href="" href="about.html">About us</a>
            <a href="" href="user/return-form.html">Return form</a>
          </div>
        </nav>
      </div>

      <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
        <div class="h6" data-v-menu-item-name>My account</div>
        <nav data-v-menu-item-recursive>
          <div data-v-menu-item data-v-if="category.children == 0">
            <a href="" href="user/order-tracking.html">Order tracking</a>
            <a href="" href="user/wishlist.html">Wishlist</a>
            <a href="" href="user/orders.html">Orders</a>
            <a href="" href="cart/compare.html">Compare</a>
          </div>
        </nav>
      </div>



    </div>
    <!--
		<div class="row justify-content-end">
			<div class="col-md-3 text-muted text-small mt-5">
				&copy; <span data-v-year>2025</span> <span data-v-sitename>Vvveb</span>. Powered by <a href="https://vvveb.com" target="_blank">Vvveb</a>	
			</div>
		</div>
		-->

  </div>

  <div class="footer-copyright">
    <div class="container">
      <div class="d-flex flex-column flex-md-row">
        <div class="text-muted flex-grow-1">
          <a class="btn-link text-muted" href="/page/terms-conditions">Terms and conditions</a> |
          <a class="btn-link text-muted" href="/page/privacy-policy">Privacy Policy</a>
        </div>
        <div class="text-muted">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>. <span>Powered by</span>
          <a href="https://vvveb.com" class="btn-link text-muted" target="_blank">Vvveb</a>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-4", {
    name: "Footer 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-4-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-4" data-bs-theme="dark">

  <div class="container border-bottom border-dark pb-4">
    <div class="row gy-3 align-items-sm-center">
      <div class="col-12 col-sm-6">
        <div class="footer-logo-wrapper text-start">
          <div data-v-component-site>
            <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
            <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6">
        <div class="social-media-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-2">
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="30" fill="currentColor" class="bi bi-facebook text-lightx" viewBox="0 0 16 16">
                  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                  <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                  <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-reddit" viewBox="0 0 16 16">
                  <path d="M6.167 8a.83.83 0 0 0-.83.83c0 .459.372.84.83.831a.831.831 0 0 0 0-1.661m1.843 3.647c.315 0 1.403-.038 1.976-.611a.23.23 0 0 0 0-.306.213.213 0 0 0-.306 0c-.353.363-1.126.487-1.67.487-.545 0-1.308-.124-1.671-.487a.213.213 0 0 0-.306 0 .213.213 0 0 0 0 .306c.564.563 1.652.61 1.977.61zm.992-2.807c0 .458.373.83.831.83s.83-.381.83-.83a.831.831 0 0 0-1.66 0z" />
                  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-3.828-1.165c-.315 0-.602.124-.812.325-.801-.573-1.9-.945-3.121-.993l.534-2.501 1.738.372a.83.83 0 1 0 .83-.869.83.83 0 0 0-.744.468l-1.938-.41a.2.2 0 0 0-.153.028.2.2 0 0 0-.086.134l-.592 2.788c-1.24.038-2.358.41-3.17.992-.21-.2-.496-.324-.81-.324a1.163 1.163 0 0 0-.478 2.224q-.03.17-.029.353c0 1.795 2.091 3.256 4.669 3.256s4.668-1.451 4.668-3.256c0-.114-.01-.238-.029-.353.401-.181.688-.592.688-1.069 0-.65-.525-1.165-1.165-1.165" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-dribbble" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M8 0C3.584 0 0 3.584 0 8s3.584 8 8 8c4.408 0 8-3.584 8-8s-3.592-8-8-8m5.284 3.688a6.8 6.8 0 0 1 1.545 4.251c-.226-.043-2.482-.503-4.755-.217-.052-.112-.096-.234-.148-.355-.139-.33-.295-.668-.451-.99 2.516-1.023 3.662-2.498 3.81-2.69zM8 1.18c1.735 0 3.323.65 4.53 1.718-.122.174-1.155 1.553-3.584 2.464-1.12-2.056-2.36-3.74-2.551-4A7 7 0 0 1 8 1.18m-2.907.642A43 43 0 0 1 7.627 5.77c-3.193.85-6.013.833-6.317.833a6.87 6.87 0 0 1 3.783-4.78zM1.163 8.01V7.8c.295.01 3.61.053 7.02-.971.199.381.381.772.555 1.162l-.27.078c-3.522 1.137-5.396 4.243-5.553 4.504a6.82 6.82 0 0 1-1.752-4.564zM8 14.837a6.8 6.8 0 0 1-4.19-1.44c.12-.252 1.509-2.924 5.361-4.269.018-.009.026-.009.044-.017a28.3 28.3 0 0 1 1.457 5.18A6.7 6.7 0 0 1 8 14.837m3.81-1.171c-.07-.417-.435-2.412-1.328-4.868 2.143-.338 4.017.217 4.251.295a6.77 6.77 0 0 1-2.924 4.573z" />
                </svg>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="py-4 py-md-5">
    <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

      <div class="row" data-v-menu-items>


        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Vvveb</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://themes.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Themes</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://plugins.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Plugins</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="content/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Blog</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="product/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Shop</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Resources</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>User documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Developer documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="pricing.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Pricing</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="services.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Services</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Contact</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="contact.html">Contact us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="portfolio.html">Portfolio</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="about.html">About us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/return-form.html">Return form</a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>My account</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/order-tracking.html">Order tracking</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/wishlist.html">Wishlist</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/orders.html">Orders</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="cart/compare.html">Compare</a>
            </div>
          </nav>
        </div>

      </div>

    </div>
  </div>

  <div class="container border-top border-dark pt-4">
    <div class="row gy-3 align-items-lg-center">
      <div class="col-12 col-lg-6 order-1 order-lg-0">
        <div class="small d-block mb-1 text-body">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>
        </div>
        <div class="small d-block text-body">
          <span>Powered by</span>
          <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
        </div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="link-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-centerX justify-content-lg-end gap-2 gap-md-3">
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Shipping
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Refund
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Warranty
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Privacy
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center">
                Security
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-5", {
    name: "Footer 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-5-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-5" data-bs-theme="dark">

  <div class="py-3 py-md-5 py-xl-8 py-xxl-10">
    <div class="container">
      <div class="row gy-4 gy-md-0">
        <div class="col-12 col-md-6">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled">
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Shop
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Products
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Offers
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Clearance
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Releases
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Deals
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover text-decoration-none link-light fs-1 lh-sm">
                  Contact
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-12 col-md-6">
          <section class="mb-4 mb-lg-5 mb-xl-7">
            <div class="row">
              <div class="col-6">
                <div class="address-wrapper">
                  <h4 class="mb-3 h5 text-white">Head Office</h4>
                  <address class="mb-3 fs-7 text-light opacity-75">
                    69323 Swaniawski Forest
                    <br>
                    North Aronfort, Alabama, 26323
                  </address>
                  <p class="m-0">
                    <a class="fs-7 link-light link-opacity-75 link-opacity-100-hover text-decoration-none" href="tel:+1-479-589-0693">
                      1-479-589-0693
                    </a>
                  </p>
                </div>
              </div>
              <div class="col-6">
                <div class="address-wrapper">
                  <h4 class="mb-3 h5 text-white">Branch Office</h4>
                  <address class="mb-3 fs-7 text-light opacity-75">
                    166 McGlynn Overpass Suite
                    <br>
                    Elisabethside, Minnesota, 55755
                  </address>
                  <p class="m-0">
                    <a class="fs-7 link-light link-opacity-75 link-opacity-100-hover text-decoration-none" href="tel:+540-284-4036">
                      540-284-4036
                    </a>
                  </p>
                </div>
              </div>
            </div>
          </section>
          <section>
            <div class="row">
              <div class="col-6">
                <div class="address-wrapper">
                  <h4 class="mb-3 h5 text-white">Warehouse</h4>
                  <address class="m-0 fs-7 text-light opacity-75">
                    88329 Dach Grove Apt.
                    <br>
                    West Bretton, Carolina, 81706
                  </address>
                </div>
              </div>
              <div class="col-6">
                <div class="social-media-wrapper">
                  <h4 class="mb-3 h5 text-white">Connect</h4>
                  <ul class="m-0 list-unstyled d-flex justify-content-start gap-3">
                    <li>
                      <a href="#!" class="link-opacity-75 link-opacity-100-hover link-light">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                          <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                        </svg>
                      </a>
                    </li>
                    <li>
                      <a href="#!" class="link-opacity-75 link-opacity-100-hover link-light">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                          <path d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334q.002-.211-.006-.422A6.7 6.7 0 0 0 16 3.542a6.7 6.7 0 0 1-1.889.518 3.3 3.3 0 0 0 1.447-1.817 6.5 6.5 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.32 9.32 0 0 1-6.767-3.429 3.29 3.29 0 0 0 1.018 4.382A3.3 3.3 0 0 1 .64 6.575v.045a3.29 3.29 0 0 0 2.632 3.218 3.2 3.2 0 0 1-.865.115 3 3 0 0 1-.614-.057 3.28 3.28 0 0 0 3.067 2.277A6.6 6.6 0 0 1 .78 13.58a6 6 0 0 1-.78-.045A9.34 9.34 0 0 0 5.026 15" />
                        </svg>
                      </a>
                    </li>
                    <li>
                      <a href="#!" class="link-opacity-75 link-opacity-100-hover link-light">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                          <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                        </svg>
                      </a>
                    </li>
                    <li>
                      <a href="#!" class="link-opacity-75 link-opacity-100-hover link-light">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                          <path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334" />
                        </svg>
                      </a>
                    </li>
                  </ul>
                </div>
              </div>
            </div>
          </section>
        </div>
      </div>
    </div>
  </div>

  <div>
    <div class="container border-top border-dark py-3 py-md-5 py-xl-8 py-xxl-10">
      <div class="row gy-3 align-items-lg-center">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
        <div class="col-12 col-lg-6">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center justify-content-lg-end gap-2 gap-md-3">
              <li>
                <a href="#!" class="link-opacity-75 link-underline-opacity-0 link-opacity-100-hover link-underline-opacity-100-hover link-offset-1 link-light fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Shipping
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75 link-underline-opacity-0 link-opacity-100-hover link-underline-opacity-100-hover link-offset-1 link-light fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Refund
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75 link-underline-opacity-0 link-opacity-100-hover link-underline-opacity-100-hover link-offset-1 link-light fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Warranty
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75 link-underline-opacity-0 link-opacity-100-hover link-underline-opacity-100-hover link-offset-1 link-light fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Privacy
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75 link-underline-opacity-0 link-opacity-100-hover link-underline-opacity-100-hover link-offset-1 link-light fs-8 d-flex align-items-center">
                  Security
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-6", {
    name: "Footer 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-6-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-6" data-bs-theme="dark">

  <section class="pb-5 pb-md-6 pb-xl-8">
    <div class="container">
      <div class="row gy-3">
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Mission</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Our Values
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Sustainability Efforts
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  CSR Initiatives
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Environmental Impact
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Community Outreach
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Diversity & Inclusion
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Products</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Product Catalog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  New Arrivals
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Best Sellers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Product Reviews
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Product Comparison
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Request a Demo
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Services</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Offerings
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Packages
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Service Areas
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Pricing
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Testimonials
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Request a Quote
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Information</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Blog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Resources
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Case Studies
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Whitepapers
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Guides & Tutorials
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Infographics
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Support</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Help Center
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  FAQ
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Troubleshooting
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Report a Problem
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-sm-4 col-lg-2">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Connect</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Social Media
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Live Chat
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Feedback
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark">
                  Newsletter
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="pb-3">
    <div class="container">
      <div class="row gy-3 align-items-center">
        <div class="col-12 col-sm-6">
          <div class="footer-logo-wrapper text-center text-sm-start">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="141" height="46">
            </a>
          </div>
        </div>
        <div class="col-12 col-sm-6">
          <div class="social-media-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center justify-content-sm-end gap-2">
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                    <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-reddit" viewBox="0 0 16 16">
                    <path d="M6.167 8a.83.83 0 0 0-.83.83c0 .459.372.84.83.831a.831.831 0 0 0 0-1.661m1.843 3.647c.315 0 1.403-.038 1.976-.611a.23.23 0 0 0 0-.306.213.213 0 0 0-.306 0c-.353.363-1.126.487-1.67.487-.545 0-1.308-.124-1.671-.487a.213.213 0 0 0-.306 0 .213.213 0 0 0 0 .306c.564.563 1.652.61 1.977.61zm.992-2.807c0 .458.373.83.831.83s.83-.381.83-.83a.831.831 0 0 0-1.66 0z" />
                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-3.828-1.165c-.315 0-.602.124-.812.325-.801-.573-1.9-.945-3.121-.993l.534-2.501 1.738.372a.83.83 0 1 0 .83-.869.83.83 0 0 0-.744.468l-1.938-.41a.2.2 0 0 0-.153.028.2.2 0 0 0-.086.134l-.592 2.788c-1.24.038-2.358.41-3.17.992-.21-.2-.496-.324-.81-.324a1.163 1.163 0 0 0-.478 2.224q-.03.17-.029.353c0 1.795 2.091 3.256 4.669 3.256s4.668-1.451 4.668-3.256c0-.114-.01-.238-.029-.353.401-.181.688-.592.688-1.069 0-.65-.525-1.165-1.165-1.165" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-dribbble" viewBox="0 0 16 16">
                    <path fill-rule="evenodd" d="M8 0C3.584 0 0 3.584 0 8s3.584 8 8 8c4.408 0 8-3.584 8-8s-3.592-8-8-8m5.284 3.688a6.8 6.8 0 0 1 1.545 4.251c-.226-.043-2.482-.503-4.755-.217-.052-.112-.096-.234-.148-.355-.139-.33-.295-.668-.451-.99 2.516-1.023 3.662-2.498 3.81-2.69zM8 1.18c1.735 0 3.323.65 4.53 1.718-.122.174-1.155 1.553-3.584 2.464-1.12-2.056-2.36-3.74-2.551-4A7 7 0 0 1 8 1.18m-2.907.642A43 43 0 0 1 7.627 5.77c-3.193.85-6.013.833-6.317.833a6.87 6.87 0 0 1 3.783-4.78zM1.163 8.01V7.8c.295.01 3.61.053 7.02-.971.199.381.381.772.555 1.162l-.27.078c-3.522 1.137-5.396 4.243-5.553 4.504a6.82 6.82 0 0 1-1.752-4.564zM8 14.837a6.8 6.8 0 0 1-4.19-1.44c.12-.252 1.509-2.924 5.361-4.269.018-.009.026-.009.044-.017a28.3 28.3 0 0 1 1.457 5.18A6.7 6.7 0 0 1 8 14.837m3.81-1.171c-.07-.417-.435-2.412-1.328-4.868 2.143-.338 4.017.217 4.251.295a6.77 6.77 0 0 1-2.924 4.573z" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>


  <div>
    <div class="container pt-3 border-top border-light-subtle">
      <div class="row gy-3 align-items-lg-center">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
        <div class="col-12 col-lg-6 order-0 order-lg-1">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center justify-content-lg-end gap-2 gap-md-3">
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Shipping
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Refund
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Warranty
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Privacy
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center">
                  Security
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-7", {
    name: "Footer 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-7-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-7">
  <div>
    <div class="container">
      <div class="row gy-3">
        <div class="col-12">
          <div class="footer-logo-wrapper">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="141" height="46">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="py-4 pb-md-6 pb-xl-7 pb-xxl-10">
    <div class="container">
      <div class="row gy-3">
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Company</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  About Us
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Our Team
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Mission & Values
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Company Culture
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Contact Us
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Careers
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Products</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Product Catalog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  New Arrivals
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Best Sellers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Product Reviews
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Request a Demo
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Information</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Blog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Resources
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Whitepapers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Infographics
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Support</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Feedback
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Help Desk
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Live Chat
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>


  <div class="pb-3">
    <div class="container">
      <div class="row gy-2">
        <div class="col-12 col-sm-9">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-start gap-2 gap-md-3">
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Privacy
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Terms
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Disclaimer
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center">
                  Compliance
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-12 col-sm-3">
          <div class="social-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-start justify-content-sm-end gap-2">
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                    <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>


  <div>
    <div class="container border-top border-light-subtle pt-3">
      <div class="row">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-8", {
    name: "Footer 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-8-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-8">


  <div>
    <div class="container">
      <div class="row gy-3">
        <div class="col-12">
          <div class="footer-logo-wrapper">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="141" height="46">
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>


  <section class="py-4 pb-md-6 pb-xl-7 pb-xxl-10">
    <div class="container">
      <div class="row gy-3">
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Company</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  About Us
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Our Team
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Mission & Values
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Company Culture
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Contact Us
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Careers
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Products</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Product Catalog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  New Arrivals
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Best Sellers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Product Reviews
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Request a Demo
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Information</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Blog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Resources
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Whitepapers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Infographics
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-2 fs-10 fw-light text-secondary text-uppercase">Support</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Feedback
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Help Desk
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark fw-medium">
                  Live Chat
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>


  <div class="pb-3">
    <div class="container">
      <div class="row gy-2">
        <div class="col-12 col-sm-9">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-start gap-2 gap-md-3">
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Privacy
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Terms
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Disclaimer
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center">
                  Compliance
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-12 col-sm-3">
          <div class="social-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-start justify-content-sm-end gap-2">
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                    <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="btn btn-dark rounded-circle rounded-circle-xs link-opacity-75-hover link-light">
                  <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>


  <div>
    <div class="container border-top border-light-subtle pt-3">
      <div class="row">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-9", {
    name: "Footer 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-9-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-9">


  <div class="py-6 py-md-8 py-xl-10">
    <div class="container">
      <div class="row gy-3">
        <div class="col-12">
          <div class="footer-logo-wrapper text-center">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="153" height="50">
            </a>
          </div>
        </div>
        <div class="col-12">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center gap-3">
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75 fs-7">
                  Platform
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75 fs-7">
                  Solutions
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75 fs-7">
                  Resources
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75 fs-7">
                  Pricing
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>


  <div>
    <div class="container">
      <div class="row gy-3 gy-sm-0 align-items-sm-center">
        <div class="col-sm-6">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
        <div class="col-sm-6">
          <div class="social-media-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center justify-content-sm-end gap-3">
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                    <path d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334q.002-.211-.006-.422A6.7 6.7 0 0 0 16 3.542a6.7 6.7 0 0 1-1.889.518 3.3 3.3 0 0 0 1.447-1.817 6.5 6.5 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.32 9.32 0 0 1-6.767-3.429 3.29 3.29 0 0 0 1.018 4.382A3.3 3.3 0 0 1 .64 6.575v.045a3.29 3.29 0 0 0 2.632 3.218 3.2 3.2 0 0 1-.865.115 3 3 0 0 1-.614-.057 3.28 3.28 0 0 0 3.067 2.277A6.6 6.6 0 0 1 .78 13.58a6 6 0 0 1-.78-.045A9.34 9.34 0 0 0 5.026 15" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-10", {
    name: "Footer 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-10-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-10">

  <div>
    <div class="container border-bottom pb-3 pb-md-4">
      <div class="row gy-3 align-items-center">
        <div class="col-12 col-sm-6x col-md-4 col-xl-3">
          <div class="footer-logo-wrapper">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="141" height="46">
            </a>
          </div>
        </div>
        <div class="col-12 col-sm-6x col-md-8 col-xl-9">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex gap-2 gap-sm-3 gap-md-4">
              <li>
                <a href="#!" class="fw-bold link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75">
                  Platform
                </a>
              </li>
              <li>
                <a href="#!" class="fw-bold link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75">
                  Solutions
                </a>
              </li>
              <li>
                <a href="#!" class="fw-bold link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75">
                  Resources
                </a>
              </li>
              <li>
                <a href="#!" class="fw-bold link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-dark link-opacity-75">
                  Pricing
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="py-4 py-md-5 py-xl-6 py-xxl-8">
    <div class="container">
      <div class="row gy-3">
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Platform</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Overview
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Framer
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Extensions
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Connected
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Building
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Data
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Solutions</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Operations
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Marketing
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Documents
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Product
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Finance
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Sales
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Learn</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Events
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Integrations
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Learning
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Webinars
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Customer
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Webinars
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper">
            <h4 class="mb-3 fw-bold fs-6">Company</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  About
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Blog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Careers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Services
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Newsroom
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Developers
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="pb-4">
    <div class="container">
      <div class="row align-items-sm-center gy-3">
        <div class="col-12 col-sm-6">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex gap-3 gap-xl-4">
              <li>
                <a href="#!" class="fs-8 link-dark text-decoration-none link-opacity-75-hover">
                  Legal
                </a>
              </li>
              <li>
                <a href="#!" class="fs-8 link-dark text-decoration-none link-opacity-75-hover">
                  Status
                </a>
              </li>
              <li>
                <a href="#!" class="fs-8 link-dark text-decoration-none link-opacity-75-hover">
                  Security
                </a>
              </li>
              <li>
                <a href="#!" class="fs-8 link-dark text-decoration-none link-opacity-75-hover">
                  Cookies
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-12 col-sm-6">
          <div class="social-media-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-3 gap-xl-4">
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                    <path d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334q.002-.211-.006-.422A6.7 6.7 0 0 0 16 3.542a6.7 6.7 0 0 1-1.889.518 3.3 3.3 0 0 0 1.447-1.817 6.5 6.5 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.32 9.32 0 0 1-6.767-3.429 3.29 3.29 0 0 0 1.018 4.382A3.3 3.3 0 0 1 .64 6.575v.045a3.29 3.29 0 0 0 2.632 3.218 3.2 3.2 0 0 1-.865.115 3 3 0 0 1-.614-.057 3.28 3.28 0 0 0 3.067 2.277A6.6 6.6 0 0 1 .78 13.58a6 6 0 0 1-.78-.045A9.34 9.34 0 0 0 5.026 15" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-dark">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                    <path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div>
    <div class="container border-top pt-3 pt-md-4">
      <div class="row">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-11", {
    name: "Footer 11",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-11-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-11">

  <div class="py-3 py-md-4 py-xl-5 border-bottom">
    <div class="container">
      <div class="row gy-3 gy-sm-0 align-items-sm-center">
        <div class="col-12 col-sm-6">
          <div class="footer-logo-wrapper">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="175" height="57">
            </a>
          </div>
        </div>
        <div class="col-12 col-sm-6">
          <div class="social-media-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-3">
              <li>
                <a href="#!" class="link-opacity-50-hover link-secondary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-50-hover link-secondary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-50-hover link-secondary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-twitter" viewBox="0 0 16 16">
                    <path d="M5.026 15c6.038 0 9.341-5.003 9.341-9.334q.002-.211-.006-.422A6.7 6.7 0 0 0 16 3.542a6.7 6.7 0 0 1-1.889.518 3.3 3.3 0 0 0 1.447-1.817 6.5 6.5 0 0 1-2.087.793A3.286 3.286 0 0 0 7.875 6.03a9.32 9.32 0 0 1-6.767-3.429 3.29 3.29 0 0 0 1.018 4.382A3.3 3.3 0 0 1 .64 6.575v.045a3.29 3.29 0 0 0 2.632 3.218 3.2 3.2 0 0 1-.865.115 3 3 0 0 1-.614-.057 3.28 3.28 0 0 0 3.067 2.277A6.6 6.6 0 0 1 .78 13.58a6 6 0 0 1-.78-.045A9.34 9.34 0 0 0 5.026 15" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-50-hover link-secondary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-50-hover link-secondary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                    <path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="py-4 py-md-5 py-xl-6">
    <div class="container">
      <div class="row gy-3">
        <div class="col-6 col-md-3">
          <div class="link-wrapper mb-3 mb-md-4 mb-xl-5">
            <h4 class="mb-2 fw-bold fs-6">Product</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  AI
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Docs
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Wikis
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Projects
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  What's New
                </a>
              </li>
            </ul>
          </div>

          <div class="link-wrapper">
            <h4 class="mb-2 fw-bold fs-6">Solutions</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Enterprise
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Startups
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Education
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Nonprofits
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Managers
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper mb-3 mb-md-4 mb-xl-5">
            <h4 class="mb-2 fw-bold fs-6">Download</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  iOS & Android
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Mac & Windows
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Calendar
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Web Clipper
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  What's New
                </a>
              </li>
            </ul>
          </div>

          <div class="link-wrapper">
            <h4 class="mb-2 fw-bold fs-6">Build</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Integrations
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Templates
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  API Docs
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Guides & Tutorials
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Hire a Consultant
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper mb-3 mb-md-4 mb-xl-5">
            <h4 class="mb-2 fw-bold fs-6">Get started</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Miro
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Sketch
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Framer
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Adobe XD
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Invision Studio
                </a>
              </li>
            </ul>
          </div>

          <div class="link-wrapper">
            <h4 class="mb-2 fw-bold fs-6">Resources</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Pricing
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  About Us
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Careers
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Media kit
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Email Us
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-md-3">
          <div class="link-wrapper mb-3 mb-md-4 mb-xl-5">
            <h4 class="mb-2 fw-bold fs-6">Learn</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Customer Stories
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Help Center
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Webinars
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Blog
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Community
                </a>
              </li>
            </ul>
          </div>

          <div class="link-wrapper">
            <h4 class="mb-2 fw-bold fs-6">Explore</h4>
            <ul class="m-0 list-unstyled">
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1 link-secondary">
                  Blog
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Best practice
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Color wheel
                </a>
              </li>
              <li class="mb-1">
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Support
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-50-hover link-underline-opacity-100-hover link-offset-1
                link-secondary">
                  Developers
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="py-3 py-md-4 py-xl-5 border-top">
    <div class="container">
      <div class="row">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-12", {
    name: "Footer 12",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-12-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-12">

  <div>
    <div class="container">
      <div class="row gy-3 align-items-center">
        <div class="col-12 col-sm-5 col-md-4 col-lg-3">
          <div class="footer-logo-wrapper text-start">
            <a href="#!">
              <img src="./assets/img/bsb-logo.svg" alt="Logo" width="175" height="57">
            </a>
          </div>
        </div>
        <div class="col-12 col-sm-7 col-md-8 col-lg-9">
          <div class="social-media-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-start gap-4">
              <li>
                <a href="#!" class="link-opacity-75-hover link-primary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                    <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-primary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
                    <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-primary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                    <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-primary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                    <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                  </svg>
                </a>
              </li>
              <li>
                <a href="#!" class="link-opacity-75-hover link-primary">
                  <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" fill="currentColor" class="bi bi-instagram" viewBox="0 0 16 16">
                    <path d="M8 0C5.829 0 5.556.01 4.703.048 3.85.088 3.269.222 2.76.42a3.9 3.9 0 0 0-1.417.923A3.9 3.9 0 0 0 .42 2.76C.222 3.268.087 3.85.048 4.7.01 5.555 0 5.827 0 8.001c0 2.172.01 2.444.048 3.297.04.852.174 1.433.372 1.942.205.526.478.972.923 1.417.444.445.89.719 1.416.923.51.198 1.09.333 1.942.372C5.555 15.99 5.827 16 8 16s2.444-.01 3.298-.048c.851-.04 1.434-.174 1.943-.372a3.9 3.9 0 0 0 1.416-.923c.445-.445.718-.891.923-1.417.197-.509.332-1.09.372-1.942C15.99 10.445 16 10.173 16 8s-.01-2.445-.048-3.299c-.04-.851-.175-1.433-.372-1.941a3.9 3.9 0 0 0-.923-1.417A3.9 3.9 0 0 0 13.24.42c-.51-.198-1.092-.333-1.943-.372C10.443.01 10.172 0 7.998 0zm-.717 1.442h.718c2.136 0 2.389.007 3.232.046.78.035 1.204.166 1.486.275.373.145.64.319.92.599s.453.546.598.92c.11.281.24.705.275 1.485.039.843.047 1.096.047 3.231s-.008 2.389-.047 3.232c-.035.78-.166 1.203-.275 1.485a2.5 2.5 0 0 1-.599.919c-.28.28-.546.453-.92.598-.28.11-.704.24-1.485.276-.843.038-1.096.047-3.232.047s-2.39-.009-3.233-.047c-.78-.036-1.203-.166-1.485-.276a2.5 2.5 0 0 1-.92-.598 2.5 2.5 0 0 1-.6-.92c-.109-.281-.24-.705-.275-1.485-.038-.843-.046-1.096-.046-3.233s.008-2.388.046-3.231c.036-.78.166-1.204.276-1.486.145-.373.319-.64.599-.92s.546-.453.92-.598c.282-.11.705-.24 1.485-.276.738-.034 1.024-.044 2.515-.045zm4.988 1.328a.96.96 0 1 0 0 1.92.96.96 0 0 0 0-1.92m-4.27 1.122a4.109 4.109 0 1 0 0 8.217 4.109 4.109 0 0 0 0-8.217m0 1.441a2.667 2.667 0 1 1 0 5.334 2.667 2.667 0 0 1 0-5.334" />
                  </svg>
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

  <section class="py-4 py-md-5 py-xl-6">
    <div class="container">
      <div class="row gy-3">
        <div class="col-12 col-lg-7 col-xl-6">
          <div class="widget">
            <h4 class="widget-title mb-3">Subscribe to Our Newsletter</h4>
            <p class="mb-4">
              Don't miss out on the opportunity to be part of something great.
              <br>
              Subscribe now and let the journey begin!
            </p>
            <form action="#!">
              <div class="row gy-4">
                <div class="col-12 col-md-8">
                  <div class="input-group">
                    <span class="input-group-text" id="email-newsletter-addon">
                      <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-envelope" viewBox="0 0 16 16">
                        <path d="M0 4a2 2 0 0 1 2-2h12a2 2 0 0 1 2 2v8a2 2 0 0 1-2 2H2a2 2 0 0 1-2-2V4Zm2-1a1 1 0 0 0-1 1v.217l7 4.2 7-4.2V4a1 1 0 0 0-1-1H2Zm13 2.383-4.708 2.825L15 11.105V5.383Zm-.034 6.876-5.64-3.471L8 9.583l-1.326-.795-5.64 3.47A1 1 0 0 0 2 13h12a1 1 0 0 0 .966-.741ZM1 11.105l4.708-2.897L1 5.383v5.722Z" />
                      </svg>
                    </span>
                    <input type="email" class="form-control" id="email-newsletter" value="" placeholder="Email Address" aria-label="email-newsletter" aria-describedby="email-newsletter-addon" required>
                  </div>
                </div>
                <div class="col-12 col-lg-8">
                  <div class="d-grid mb-3 mb-lg-0">
                    <button class="btn btn-primary" type="submit">Subscribe</button>
                  </div>
                </div>
              </div>
            </form>
          </div>
        </div>
        <div class="col-6 col-lg-2 col-xl-2">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled">
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Our Values
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Sustainability Efforts
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  CSR Initiatives
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Environmental Impact
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Community Outreach
                </a>
              </li>
              <li>
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Diversity & Inclusion
                </a>
              </li>
            </ul>
          </div>
        </div>
        <div class="col-6 col-lg-3 col-xl-4">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled">
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Shipping & Returns
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Refund Policy
                </a>
              </li>
              <li class="mb-3">
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Warranty Information
                </a>
              </li>
              <li>
                <a href="#!" class="link-dark text-decoration-none link-opacity-75-hover">
                  Privacy Practices
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </section>

  <div class="py-3 py-md-4 py-xl-5 bg-light">
    <div class="container">
      <div class="row g-3 align-items-center">
        <div class="col-12 col-lg-6 order-1 order-lg-0">
          <div class="small d-block mb-1 text-body">
            &copy; <span data-v-year>2025</span>
            <span data-v-global-site.description.title>Vvveb</span>
          </div>
          <div class="small d-block text-body">
            <span>Powered by</span>
            <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
          </div>
        </div>
        <div class="col-12 col-lg-6 order-0 order-lg-1">
          <div class="link-wrapper">
            <ul class="m-0 list-unstyled d-flex justify-content-center justify-content-lg-end gap-2 gap-md-3">
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Shipping
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Refund
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Warranty
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center pe-2 pe-md-3">
                  Privacy
                </a>
              </li>
              <li>
                <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-underline-opacity-100-hover link-offset-1 link-secondary fs-8 d-flex align-items-center">
                  Security
                </a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-13", {
    name: "Footer 13",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-13-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-4" data-bs-theme="dark">

  <div class="container border-bottom border-dark pb-4">
    <div class="row gy-3 align-items-sm-center">
      <div class="col-12 col-sm-6">
        <div class="footer-logo-wrapper text-start">
          <div data-v-component-site>
            <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
            <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6">
        <div class="social-media-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-2">
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="30" fill="currentColor" class="bi bi-facebook text-lightx" viewBox="0 0 16 16">
                  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                  <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                  <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-reddit" viewBox="0 0 16 16">
                  <path d="M6.167 8a.83.83 0 0 0-.83.83c0 .459.372.84.83.831a.831.831 0 0 0 0-1.661m1.843 3.647c.315 0 1.403-.038 1.976-.611a.23.23 0 0 0 0-.306.213.213 0 0 0-.306 0c-.353.363-1.126.487-1.67.487-.545 0-1.308-.124-1.671-.487a.213.213 0 0 0-.306 0 .213.213 0 0 0 0 .306c.564.563 1.652.61 1.977.61zm.992-2.807c0 .458.373.83.831.83s.83-.381.83-.83a.831.831 0 0 0-1.66 0z" />
                  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-3.828-1.165c-.315 0-.602.124-.812.325-.801-.573-1.9-.945-3.121-.993l.534-2.501 1.738.372a.83.83 0 1 0 .83-.869.83.83 0 0 0-.744.468l-1.938-.41a.2.2 0 0 0-.153.028.2.2 0 0 0-.086.134l-.592 2.788c-1.24.038-2.358.41-3.17.992-.21-.2-.496-.324-.81-.324a1.163 1.163 0 0 0-.478 2.224q-.03.17-.029.353c0 1.795 2.091 3.256 4.669 3.256s4.668-1.451 4.668-3.256c0-.114-.01-.238-.029-.353.401-.181.688-.592.688-1.069 0-.65-.525-1.165-1.165-1.165" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-dribbble" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M8 0C3.584 0 0 3.584 0 8s3.584 8 8 8c4.408 0 8-3.584 8-8s-3.592-8-8-8m5.284 3.688a6.8 6.8 0 0 1 1.545 4.251c-.226-.043-2.482-.503-4.755-.217-.052-.112-.096-.234-.148-.355-.139-.33-.295-.668-.451-.99 2.516-1.023 3.662-2.498 3.81-2.69zM8 1.18c1.735 0 3.323.65 4.53 1.718-.122.174-1.155 1.553-3.584 2.464-1.12-2.056-2.36-3.74-2.551-4A7 7 0 0 1 8 1.18m-2.907.642A43 43 0 0 1 7.627 5.77c-3.193.85-6.013.833-6.317.833a6.87 6.87 0 0 1 3.783-4.78zM1.163 8.01V7.8c.295.01 3.61.053 7.02-.971.199.381.381.772.555 1.162l-.27.078c-3.522 1.137-5.396 4.243-5.553 4.504a6.82 6.82 0 0 1-1.752-4.564zM8 14.837a6.8 6.8 0 0 1-4.19-1.44c.12-.252 1.509-2.924 5.361-4.269.018-.009.026-.009.044-.017a28.3 28.3 0 0 1 1.457 5.18A6.7 6.7 0 0 1 8 14.837m3.81-1.171c-.07-.417-.435-2.412-1.328-4.868 2.143-.338 4.017.217 4.251.295a6.77 6.77 0 0 1-2.924 4.573z" />
                </svg>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="py-4 py-md-5">
    <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

      <div class="row" data-v-menu-items>


        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Vvveb</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://themes.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Themes</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://plugins.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Plugins</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="content/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Blog</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="product/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Shop</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Resources</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>User documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Developer documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="pricing.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Pricing</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="services.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Services</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Contact</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="contact.html">Contact us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="portfolio.html">Portfolio</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="about.html">About us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/return-form.html">Return form</a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>My account</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/order-tracking.html">Order tracking</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/wishlist.html">Wishlist</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/orders.html">Orders</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="cart/compare.html">Compare</a>
            </div>
          </nav>
        </div>

      </div>

    </div>
  </div>

  <div class="container border-top border-dark pt-4">
    <div class="row gy-3 align-items-lg-center">
      <div class="col-12 col-lg-6 order-1 order-lg-0">
        <div class="small d-block mb-1 text-body">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>
        </div>
        <div class="small d-block text-body">
          <span>Powered by</span>
          <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
        </div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="link-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-centerX justify-content-lg-end gap-2 gap-md-3">
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Shipping
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Refund
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Warranty
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Privacy
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center">
                Security
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-14", {
    name: "Footer 14",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-14-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-4" data-bs-theme="dark">

  <div class="container border-bottom border-dark pb-4">
    <div class="row gy-3 align-items-sm-center">
      <div class="col-12 col-sm-6">
        <div class="footer-logo-wrapper text-start">
          <div data-v-component-site>
            <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
            <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6">
        <div class="social-media-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-2">
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="30" fill="currentColor" class="bi bi-facebook text-lightx" viewBox="0 0 16 16">
                  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                  <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                  <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-reddit" viewBox="0 0 16 16">
                  <path d="M6.167 8a.83.83 0 0 0-.83.83c0 .459.372.84.83.831a.831.831 0 0 0 0-1.661m1.843 3.647c.315 0 1.403-.038 1.976-.611a.23.23 0 0 0 0-.306.213.213 0 0 0-.306 0c-.353.363-1.126.487-1.67.487-.545 0-1.308-.124-1.671-.487a.213.213 0 0 0-.306 0 .213.213 0 0 0 0 .306c.564.563 1.652.61 1.977.61zm.992-2.807c0 .458.373.83.831.83s.83-.381.83-.83a.831.831 0 0 0-1.66 0z" />
                  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-3.828-1.165c-.315 0-.602.124-.812.325-.801-.573-1.9-.945-3.121-.993l.534-2.501 1.738.372a.83.83 0 1 0 .83-.869.83.83 0 0 0-.744.468l-1.938-.41a.2.2 0 0 0-.153.028.2.2 0 0 0-.086.134l-.592 2.788c-1.24.038-2.358.41-3.17.992-.21-.2-.496-.324-.81-.324a1.163 1.163 0 0 0-.478 2.224q-.03.17-.029.353c0 1.795 2.091 3.256 4.669 3.256s4.668-1.451 4.668-3.256c0-.114-.01-.238-.029-.353.401-.181.688-.592.688-1.069 0-.65-.525-1.165-1.165-1.165" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-dribbble" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M8 0C3.584 0 0 3.584 0 8s3.584 8 8 8c4.408 0 8-3.584 8-8s-3.592-8-8-8m5.284 3.688a6.8 6.8 0 0 1 1.545 4.251c-.226-.043-2.482-.503-4.755-.217-.052-.112-.096-.234-.148-.355-.139-.33-.295-.668-.451-.99 2.516-1.023 3.662-2.498 3.81-2.69zM8 1.18c1.735 0 3.323.65 4.53 1.718-.122.174-1.155 1.553-3.584 2.464-1.12-2.056-2.36-3.74-2.551-4A7 7 0 0 1 8 1.18m-2.907.642A43 43 0 0 1 7.627 5.77c-3.193.85-6.013.833-6.317.833a6.87 6.87 0 0 1 3.783-4.78zM1.163 8.01V7.8c.295.01 3.61.053 7.02-.971.199.381.381.772.555 1.162l-.27.078c-3.522 1.137-5.396 4.243-5.553 4.504a6.82 6.82 0 0 1-1.752-4.564zM8 14.837a6.8 6.8 0 0 1-4.19-1.44c.12-.252 1.509-2.924 5.361-4.269.018-.009.026-.009.044-.017a28.3 28.3 0 0 1 1.457 5.18A6.7 6.7 0 0 1 8 14.837m3.81-1.171c-.07-.417-.435-2.412-1.328-4.868 2.143-.338 4.017.217 4.251.295a6.77 6.77 0 0 1-2.924 4.573z" />
                </svg>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="py-4 py-md-5">
    <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

      <div class="row" data-v-menu-items>


        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Vvveb</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://themes.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Themes</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://plugins.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Plugins</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="content/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Blog</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="product/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Shop</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Resources</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>User documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Developer documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="pricing.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Pricing</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="services.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Services</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Contact</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="contact.html">Contact us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="portfolio.html">Portfolio</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="about.html">About us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/return-form.html">Return form</a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>My account</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/order-tracking.html">Order tracking</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/wishlist.html">Wishlist</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/orders.html">Orders</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="cart/compare.html">Compare</a>
            </div>
          </nav>
        </div>

      </div>

    </div>
  </div>

  <div class="container border-top border-dark pt-4">
    <div class="row gy-3 align-items-lg-center">
      <div class="col-12 col-lg-6 order-1 order-lg-0">
        <div class="small d-block mb-1 text-body">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>
        </div>
        <div class="small d-block text-body">
          <span>Powered by</span>
          <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
        </div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="link-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-centerX justify-content-lg-end gap-2 gap-md-3">
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Shipping
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Refund
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Warranty
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Privacy
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center">
                Security
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

</footer>`
});Vvveb.Sections.add("footer/footer-15", {
    name: "Footer 15",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/footer/footer-15-thumb.webp",
    html: `<footer class="py-4 py-md-5 bg-black" aria-label="footer-4" data-bs-theme="dark">

  <div class="container border-bottom border-dark pb-4">
    <div class="row gy-3 align-items-sm-center">
      <div class="col-12 col-sm-6">
        <div class="footer-logo-wrapper text-start">
          <div data-v-component-site>
            <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
            <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6">
        <div class="social-media-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-sm-end gap-2">
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="30" fill="currentColor" class="bi bi-facebook text-lightx" viewBox="0 0 16 16">
                  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16">
                  <path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-linkedin" viewBox="0 0 16 16">
                  <path d="M0 1.146C0 .513.526 0 1.175 0h13.65C15.474 0 16 .513 16 1.146v13.708c0 .633-.526 1.146-1.175 1.146H1.175C.526 16 0 15.487 0 14.854zm4.943 12.248V6.169H2.542v7.225zm-1.2-8.212c.837 0 1.358-.554 1.358-1.248-.015-.709-.52-1.248-1.342-1.248S2.4 3.226 2.4 3.934c0 .694.521 1.248 1.327 1.248zm4.908 8.212V9.359c0-.216.016-.432.08-.586.173-.431.568-.878 1.232-.878.869 0 1.216.662 1.216 1.634v3.865h2.401V9.25c0-2.22-1.184-3.252-2.764-3.252-1.274 0-1.845.7-2.165 1.193v.025h-.016l.016-.025V6.169h-2.4c.03.678 0 7.225 0 7.225z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-youtube" viewBox="0 0 16 16">
                  <path d="M8.051 1.999h.089c.822.003 4.987.033 6.11.335a2.01 2.01 0 0 1 1.415 1.42c.101.38.172.883.22 1.402l.01.104.022.26.008.104c.065.914.073 1.77.074 1.957v.075c-.001.194-.01 1.108-.082 2.06l-.008.105-.009.104c-.05.572-.124 1.14-.235 1.558a2.01 2.01 0 0 1-1.415 1.42c-1.16.312-5.569.334-6.18.335h-.142c-.309 0-1.587-.006-2.927-.052l-.17-.006-.087-.004-.171-.007-.171-.007c-1.11-.049-2.167-.128-2.654-.26a2.01 2.01 0 0 1-1.415-1.419c-.111-.417-.185-.986-.235-1.558L.09 9.82l-.008-.104A31 31 0 0 1 0 7.68v-.123c.002-.215.01-.958.064-1.778l.007-.103.003-.052.008-.104.022-.26.01-.104c.048-.519.119-1.023.22-1.402a2.01 2.01 0 0 1 1.415-1.42c.487-.13 1.544-.21 2.654-.26l.17-.007.172-.006.086-.003.171-.007A100 100 0 0 1 7.858 2zM6.4 5.209v4.818l4.157-2.408z" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-reddit" viewBox="0 0 16 16">
                  <path d="M6.167 8a.83.83 0 0 0-.83.83c0 .459.372.84.83.831a.831.831 0 0 0 0-1.661m1.843 3.647c.315 0 1.403-.038 1.976-.611a.23.23 0 0 0 0-.306.213.213 0 0 0-.306 0c-.353.363-1.126.487-1.67.487-.545 0-1.308-.124-1.671-.487a.213.213 0 0 0-.306 0 .213.213 0 0 0 0 .306c.564.563 1.652.61 1.977.61zm.992-2.807c0 .458.373.83.831.83s.83-.381.83-.83a.831.831 0 0 0-1.66 0z" />
                  <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0m-3.828-1.165c-.315 0-.602.124-.812.325-.801-.573-1.9-.945-3.121-.993l.534-2.501 1.738.372a.83.83 0 1 0 .83-.869.83.83 0 0 0-.744.468l-1.938-.41a.2.2 0 0 0-.153.028.2.2 0 0 0-.086.134l-.592 2.788c-1.24.038-2.358.41-3.17.992-.21-.2-.496-.324-.81-.324a1.163 1.163 0 0 0-.478 2.224q-.03.17-.029.353c0 1.795 2.091 3.256 4.669 3.256s4.668-1.451 4.668-3.256c0-.114-.01-.238-.029-.353.401-.181.688-.592.688-1.069 0-.65-.525-1.165-1.165-1.165" />
                </svg>
              </a>
            </li>
            <li>
              <a href="#!" class="btn btn-outline-lightbtn btn-outline-secondary rounded-circle">
                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="30" fill="currentColor" class="bi bi-dribbble" viewBox="0 0 16 16">
                  <path fill-rule="evenodd" d="M8 0C3.584 0 0 3.584 0 8s3.584 8 8 8c4.408 0 8-3.584 8-8s-3.592-8-8-8m5.284 3.688a6.8 6.8 0 0 1 1.545 4.251c-.226-.043-2.482-.503-4.755-.217-.052-.112-.096-.234-.148-.355-.139-.33-.295-.668-.451-.99 2.516-1.023 3.662-2.498 3.81-2.69zM8 1.18c1.735 0 3.323.65 4.53 1.718-.122.174-1.155 1.553-3.584 2.464-1.12-2.056-2.36-3.74-2.551-4A7 7 0 0 1 8 1.18m-2.907.642A43 43 0 0 1 7.627 5.77c-3.193.85-6.013.833-6.317.833a6.87 6.87 0 0 1 3.783-4.78zM1.163 8.01V7.8c.295.01 3.61.053 7.02-.971.199.381.381.772.555 1.162l-.27.078c-3.522 1.137-5.396 4.243-5.553 4.504a6.82 6.82 0 0 1-1.752-4.564zM8 14.837a6.8 6.8 0 0 1-4.19-1.44c.12-.252 1.509-2.924 5.361-4.269.018-.009.026-.009.044-.017a28.3 28.3 0 0 1 1.457 5.18A6.7 6.7 0 0 1 8 14.837m3.81-1.171c-.07-.417-.435-2.412-1.328-4.868 2.143-.338 4.017.217 4.251.295a6.77 6.77 0 0 1-2.924 4.573z" />
                </svg>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="py-4 py-md-5">
    <div class="container" data-v-component-menu="footer" data-v-slug="main-footer">

      <div class="row" data-v-menu-items>


        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Vvveb</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://themes.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Themes</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://plugins.vvveb.com/" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Plugins</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="content/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Blog</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="product/index.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Shop</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Resources</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>User documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="https://github.com/givanz/VvvebJs/wiki" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Developer documentation</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="pricing.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Pricing</span>
              </a>
            </div>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="services.html" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" data-v-menu-item-url>
                <span data-v-menu-item-name>Services</span>
              </a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>Contact</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="contact.html">Contact us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="portfolio.html">Portfolio</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="about.html">About us</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/return-form.html">Return form</a>
            </div>
          </nav>
        </div>

        <div class="col-md" data-v-menu-item data-v-if="category.children > 0">
          <h6 class="mb-3 fw-bold text-light" data-v-menu-item-name>My account</h6>
          <nav data-v-menu-item-recursive>
            <div data-v-menu-item data-v-if="category.children == 0">
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/order-tracking.html">Order tracking</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/wishlist.html">Wishlist</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="user/orders.html">Orders</a>
              <a href="" class="link-opacity-75 link-opacity-100-hover text-decoration-none link-light" href="cart/compare.html">Compare</a>
            </div>
          </nav>
        </div>

      </div>

    </div>
  </div>

  <div class="container border-top border-dark pt-4">
    <div class="row gy-3 align-items-lg-center">
      <div class="col-12 col-lg-6 order-1 order-lg-0">
        <div class="small d-block mb-1 text-body">
          &copy; <span data-v-year>2025</span>
          <span data-v-global-site.description.title>Vvveb</span>
        </div>
        <div class="small d-block text-body">
          <span>Powered by</span>
          <a href="https://vvveb.com" class="link-opacity-0 link-opacity-75-hover link-light text-decoration-none" target="_blank">Vvveb</a>
        </div>
      </div>
      <div class="col-12 col-lg-6">
        <div class="link-wrapper">
          <ul class="m-0 list-unstyled d-flex justify-content-centerX justify-content-lg-end gap-2 gap-md-3">
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Shipping
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Refund
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Warranty
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center pe-2 pe-md-3">
                Privacy
              </a>
            </li>
            <li>
              <a href="#!" class="link-underline-opacity-0 link-opacity-75-hover link-offset-1 link-light d-flex align-items-center">
                Security
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

</footer>`
});
	Vvveb.SectionsGroup["Footer"] = ["footer/footer-1","footer/footer-2","footer/footer-3","footer/footer-4","footer/footer-5","footer/footer-6","footer/footer-7","footer/footer-8","footer/footer-9","footer/footer-10","footer/footer-11","footer/footer-12","footer/footer-13","footer/footer-14","footer/footer-15"];
Vvveb.Sections.add("how-it-works/how-it-works-1", {
    name: "How it works 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/how-it-works/how-it-works-1-thumb.webp",
    html: `<section class="py-5" aria-label="how-it-works-1">
  <div class="container">
    <div class="row justify-content-center text-center mb-4">
      <div class="col-lg-8 col-xxl-7">
        <span class="text-muted">Steps</span>
        <h2 class="display-5 fw-bold">How it Works</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto bg-primary border rounded-circle d-flex align-items-center justify-content-center" style="width:120px;height:120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#fff" fill="#999" viewBox="0 0 512 512">
              <circle cx="176" cy="416" r="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <circle cx="400" cy="416" r="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M48 80h64l48 272h256" />
              <path d="M160 288h249.44a8 8 0 007.85-6.43l28.8-144a8 8 0 00-7.85-9.57H128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 1</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="position-absolute d-none d-lg-block" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto bg-primary border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#fff" fill="#999" viewBox="0 0 512 512">
              <path d="M320 96H88a40 40 0 00-40 40v240a40 40 0 0040 40h334.73a40 40 0 0040-40V239" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M112 160l144 112 87-65.67" />
              <circle cx="431.95" cy="128.05" r="47.95" />
              <path d="M432 192a63.95 63.95 0 1163.95-63.95A64 64 0 01432 192zm0-95.9a32 32 0 1031.95 32 32 32 0 00-31.95-32z" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 2</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="d-none d-lg-block position-absolute" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto bg-primary border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#fff" fill="#999" viewBox="0 0 512 512">
              <rect x="336" y="336" width="80" height="80" rx="8" ry="8" />
              <rect x="272" y="272" width="48" height="64" rx="8" ry="8" />
              <rect x="416" y="416" width="48" height="64" rx="8" ry="8" />
              <rect x="432" y="272" width="48" height="48" rx="8" ry="8" />
              <rect x="272" y="432" width="48" height="48" rx="8" ry="8" />
              <rect x="336" y="96" width="80" height="80" rx="8" ry="8" />
              <rect x="288" y="48" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <rect x="96" y="96" width="80" height="80" rx="8" ry="8" />
              <rect x="48" y="48" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <rect x="96" y="336" width="80" height="80" rx="8" ry="8" />
              <rect x="48" y="288" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 3</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="d-none d-lg-block position-absolute" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto bg-primary border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#fff" fill="#999" viewBox="0 0 512 512">
              <rect x="48" y="96" width="416" height="320" rx="56" ry="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="60" d="M48 192h416M128 300h48v20h-48z" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 4</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("how-it-works/how-it-works-2", {
    name: "How it works 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/how-it-works/how-it-works-2-thumb.webp",
    html: `<section class="py-5" aria-label="how-it-works-2">
  <div class="container">
    <div class="row justify-content-center text-center mb-4">
      <div class="col-lg-8 col-xxl-7">
        <span class="text-muted">Steps</span>
        <h2 class="display-5 fw-bold">How it Works</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto border border-2 border rounded-circle d-flex align-items-center justify-content-center" style="width:120px;height:120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#333" fill="#999" viewBox="0 0 512 512">
              <circle cx="176" cy="416" r="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <circle cx="400" cy="416" r="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M48 80h64l48 272h256" />
              <path d="M160 288h249.44a8 8 0 007.85-6.43l28.8-144a8 8 0 00-7.85-9.57H128" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 1</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="position-absolute d-none d-lg-block" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto border border-2 border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#333" fill="#999" viewBox="0 0 512 512">
              <path d="M320 96H88a40 40 0 00-40 40v240a40 40 0 0040 40h334.73a40 40 0 0040-40V239" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" d="M112 160l144 112 87-65.67" />
              <circle cx="431.95" cy="128.05" r="47.95" />
              <path d="M432 192a63.95 63.95 0 1163.95-63.95A64 64 0 01432 192zm0-95.9a32 32 0 1031.95 32 32 32 0 00-31.95-32z" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 2</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="d-none d-lg-block position-absolute" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto border border-2 border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#333" fill="#999" viewBox="0 0 512 512">
              <rect x="336" y="336" width="80" height="80" rx="8" ry="8" />
              <rect x="272" y="272" width="48" height="64" rx="8" ry="8" />
              <rect x="416" y="416" width="48" height="64" rx="8" ry="8" />
              <rect x="432" y="272" width="48" height="48" rx="8" ry="8" />
              <rect x="272" y="432" width="48" height="48" rx="8" ry="8" />
              <rect x="336" y="96" width="80" height="80" rx="8" ry="8" />
              <rect x="288" y="48" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <rect x="96" y="96" width="80" height="80" rx="8" ry="8" />
              <rect x="48" y="48" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <rect x="96" y="336" width="80" height="80" rx="8" ry="8" />
              <rect x="48" y="288" width="176" height="176" rx="16" ry="16" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 3</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
          <div class="d-none d-lg-block position-absolute" style="top:50px; right:-25px">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="32" stroke="#000" viewBox="0 0 512 512">
              <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="48" d="M268 112l144 144-144 144M392 256H100" />
            </svg>
          </div>
        </div>
      </div>
      <div class="col-md-3">
        <div class="text-center position-relative">
          <div class="mx-auto border border-2 border rounded-circle d-flex align-items-center justify-content-center" style="width: 120px;height: 120px;">
            <svg xmlns="http://www.w3.org/2000/svg" class="ionicon" width="48" color="#333" fill="#999" viewBox="0 0 512 512">
              <rect x="48" y="96" width="416" height="320" rx="56" ry="56" fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="32" />
              <path fill="none" stroke="currentColor" stroke-linejoin="round" stroke-width="60" d="M48 192h416M128 300h48v20h-48z" />
            </svg>
          </div>
          <h4 class="mt-3 fs-5">Step 4</h4>
          <p class="lead text-muted mt-4 fs-5 px-lg-3 mb-5 mb-lg-0">Lorem ipsum dolor sit ame consectetur.</p>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("how-it-works/how-it-works-3", {
    name: "How it works 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/how-it-works/how-it-works-3-thumb.webp",
    html: `<section class="py-5" aria-label="how-it-works-3">
  <div class="container">
    <div class="row text-center mb-4">
      <div class="col-12 col-lg-10 col-xl-8 mx-auto text-center">
        <p class="text-muted mb-0 fw-light">Steps</p>
        <h2>How It Works</h2>
        <p class="lead mb-0">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Soluta harum ipsum venenatis metus sem veniam eveniet aperiam suscipit.</p>
      </div>
    </div>
    <div class="row justify-content-center pt-5">
      <div class="col-lg-9">
        <div class="row">
          <div class="col-lg-4">
            <div class="card rounded-0 text-center p-3 px-5 mb-5 mb-lg-0">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top:-3.5rem;">
                1
              </div>
              <h5 class="mt-3 mb-4">Step 1</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="card rounded-0 text-center p-3 px-5 mb-5 mb-lg-0">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top: -3.5rem;">
                2
              </div>
              <h5 class="mt-3 mb-4">Step 2</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>
          <div class="col-lg-4">
            <div class="card rounded-0 text-center p-3 px-5 mb-5 mb-lg-0">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top: -3.5rem;">
                3
              </div>
              <h5 class="mt-3 mb-4">Step 3</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("how-it-works/how-it-works-4", {
    name: "How it works 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/how-it-works/how-it-works-4-thumb.webp",
    html: `<section class="py-5" aria-label="how-it-works-4">
  <div class="container">
    <div class="row text-center mb-4">
      <div class="col-12 col-lg-10 col-xl-8 mx-auto text-center">
        <p class="text-muted mb-0 fw-light">Steps</p>
        <h2>How It Works</h2>
        <p class="lead mb-0">Lorem ipsum dolor sit amet, consectetur adipisicing elit. Soluta harum ipsum venenatis metus sem veniam eveniet aperiam suscipit.</p>
      </div>
    </div>
    <div class="row justify-content-center pt-5">
      <div class="col-lg-9">
        <div class="row justify-content-center">
          <div class="col-md-6">
            <div class="card rounded-0 text-center p-3 px-5 mb-5">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top:-3.5rem;">
                1
              </div>
              <h5 class="mt-3 mb-4">Step 1</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>

            <div class="card rounded-0 text-center p-3 px-5 mb-5">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top: -3.5rem;">
                2
              </div>
              <h5 class="mt-3 mb-4">Step 2</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>

            <div class="card rounded-0 text-center p-3 px-5 mb-5">
              <div class="d-flex rounded-circle mx-auto align-items-center justify-content-center text-white fs-3 fw-bold bg-primary border border-white border-4" style="width: 4rem; height:4rem; margin-top: -3.5rem;">
                3
              </div>
              <h5 class="mt-3 mb-4">Step 3</h5>
              <p class="text-muted">Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("how-it-works/how-it-works-5", {
    name: "How it works 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/how-it-works/how-it-works-5-thumb.webp",
    html: `<section class="py-5" aria-label="how-it-works-5">
  <div class="container">
    <div class="row justify-content-center text-center mb-4">
      <div class="col-lg-8 col-xxl-7">
        <span class="text-muted">Steps</span>
        <h2 class="display-5 fw-bold">How it Works</h2>
        <p class="lead">Lorem ipsum dolor sit, amet consectetur adipisicing elit Consequatur quidem eius cum voluptatum quasi delectus.</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6 mx-auto">
        <div class="row">
          <div class="col-auto text-center">
            <div class="d-flex rounded-circle align-items-center justify-content-center bg-primary text-white fs-3 fw-bold border border-white border-4 me-1" style="width: 4rem; height:4rem;">
              1
            </div>
            <div class="text-muted fw-light mt-1">
              Step
            </div>
          </div>
          <div class="col">
            <div class="card rounded-0 py-4 px-5 mb-5">
              <h5>Headline</h5>
              <p class="text-muted mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing .</p>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-auto text-center">
            <div class="d-flex rounded-circle align-items-center justify-content-center bg-primary text-white fs-3 fw-bold border border-white border-4 me-1" style="width: 4rem; height:4rem;">
              2
            </div>
            <div class="text-muted fw-light mt-1">
              Step
            </div>
          </div>
          <div class="col">
            <div class="card rounded-0 py-4 px-5 mb-5">
              <h5>Headline</h5>
              <p class="text-muted mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing .</p>
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-auto text-center">
            <div class="d-flex rounded-circle align-items-center justify-content-center bg-primary text-white fs-3 fw-bold border border-white border-4 me-1" style="width: 4rem; height:4rem;">
              3
            </div>
            <div class="text-muted fw-light mt-1">
              Step
            </div>
          </div>
          <div class="col">
            <div class="card rounded-0 py-4 px-5 mb-5">
              <h5>Headline</h5>
              <p class="text-muted mb-0">Lorem ipsum dolor sit amet, consectetur adipiscing .</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["How it works"] = ["how-it-works/how-it-works-1","how-it-works/how-it-works-2","how-it-works/how-it-works-3","how-it-works/how-it-works-4","how-it-works/how-it-works-5"];
Vvveb.Sections.add("navigation/navigation-1", {
    name: "Navigation 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/navigation/navigation-1-thumb.webp",
    html: `<nav class="navigation-1 clearfix" data-v-save-global="blank.html,.navigation-1">

  <div id="top" class="top-nav clearfix">
    <div class="container">
      <div class="d-flex justify-content-between  flex-md-row d-flex flex-column flex-md-row">
        <div class="nav">
          <ul class="list-inline" data-v-component-site>
            <li class="list-inline-item" data-v-if="site.description.phone-number">
              <a href="tel:5511112377" class="p-2 p-md-0" title="Phone" data-v-site-description-phone-number>
                <i class="la la-phone"></i>
                <span class=" text-muted" data-v-site-description-phone-number>+55 (111) 123 777</span>
              </a>
            </li>
            <!--
					<li class="list-inline-item"  data-v-if="site.contact-email">
						<a href="mailto:contact@mysite.com" class="p-2 p-md-0" title="Email" data-v-site-contact-email>
						<i class="la la-envelope"></i> 
						<span class=" text-muted" data-v-site-contact-email>contact@mysite.com</span></a>
					</li>
					-->
          </ul>
        </div>
        <div class="nav">
          <ul class="list-inline">
            <!--
					<li class="list-inline-item"><a id="wishlist-total" title="Wish List (0)"><i class="la la-heart"></i> <span class="">Favorites</span></a></li>
					<li class="list-inline-item"><a title="Checkout"><i class="la la-share"></i> <span class="">Checkout</span></a></li>
					<li class="list-inline-item">
						<div class="dropdown">
							<a href="" class="dropdown-toggle" data-bs-toggle="dropdown" role="button"><i class="la la-user"></i> <span class="">My Account</span></i></a>
							<ul class="dropdown-menu dropdown-menu-right">
								<li><a class="dropdown-item">Register</a></li>
								<li><a class="dropdown-item">Login</a></li>
							</ul>
						</div>
					</li>
					-->
            <li class="list-inline-item">
              <div data-v-component-currency>
                <form method="post" enctype="multipart/form-data" id="form-currency">

                  <a class="dropdown-toggle p-2 p-md-0" data-bs-toggle="dropdown" role="button" title="Currency" aria-expanded="false">
                    <!-- <i class="la la-dollar-sign me-1"></i> -->
                    <span class="" data-v-currency-info-name>USD</span>
                  </a>


                  <div class="dropdown-menu dropdown-menu-end">

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="EUR" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>€</span>
                        <span data-v-currency-sign_end>€</span>
                        <span class="ms-1" data-v-currency-name>Euro</span>
                      </button>
                    </div>

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="GBP" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>£</span>
                        <span data-v-currency-sign_end>£</span>
                        <span class="ms-1" data-v-currency-name>Pound Sterling</span>
                      </button>
                    </div>

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="USD" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>$</span>
                        <span data-v-currency-sign_end>$</span>
                        <span class="ms-1" data-v-currency-name>US Dollar</span>
                      </button>
                    </div>

                  </div>
                </form>
              </div>
            </li>
            <li class="list-inline-item">
              <div data-v-component-language>
                <form method="post" enctype="multipart/form-data" id="form-language">

                  <a class="dropdown-toggle p-2 p-md-0" data-bs-toggle="dropdown" role="button" title="Language" aria-expanded="false">
                    <!-- <i class="la la-flag me-1"></i> -->
                    <!-- 
									<img src="" data-v-language-info-img>
									-->
                    <span class="" data-v-language-info-name>English</span>
                  </a>


                  <div class="dropdown-menu dropdown-menu-end">

                    <div data-v-language>
                      <button class="dropdown-item" type="submit" value="eng" name="language" data-v-language-code>
                        <!-- <i class="la la-flag la-lg me-2"></i> -->
                        <img src="" loading="lazy" class="me-1" data-v-language-img>

                        <!-- <a href="" data-v-language-url> -->
                        <span data-v-language-name>English</span>
                        <!-- </a> -->
                      </button>
                    </div>

                    <div data-v-language>
                      <button class="dropdown-item" type="submit" value="ro" name="language" data-v-language-code>
                        <!-- <i class="la la-flag la-lg me-2"></i> -->
                        <img src="" loading="lazy" class="me-1" data-v-language-img>
                        <!-- <a href="" data-v-language-url>  -->
                        <span data-v-language-name>Romanian</span>
                        <!-- </a>  -->
                      </button>
                    </div>

                  </div>
                </form>
              </div>
            </li>
            <li class="list-inline-item">

              <a id="color-theme-switch" class="p-2 p-md-0" role="button" title="Switch sidebar color theme">
                <i class="la la-sun la-lg"></i>
              </a>

            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="navbar navbar-expand-md">

    <div class="container">
      <div data-v-component-site>
        <!-- <a class="navbar-brand" href="/" data-url data-v-url-params='{"host":"*.*.*"}'><span class="visually-hidden">Logo</span> -->
        <a class="navbar-brand" href="/" data-v-site-url>
          <span class="visually-hidden">Logo</span>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          <img src="demo/img/logo.png" alt="Site logo sticky" loading="lazy" class="logo-sticky" data-v-site-logo-sticky>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo-white.png" alt="Site logo dark sticky" loading="lazy" class="logo-default-dark-sticky" data-v-site-logo-dark-sticky>
        </a>
      </div>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbar" data-v-component-menu="header" data-v-slug="main-menu">
        <ul class="navbar-nav ms-auto" data-v-menu-items>
          <li class="nav-item dropdown position-static" data-v-menu-item data-v-class-if-has-dropdown="category.children > 0" data-v-class-if-position-static="category.has-text">

            <a class="nav-link dropdown-toggle" data-v-class-if-dropdown-toggle="category.children > 0" data-v-class-if-active="category.active" aria-expanded="false" data-v-menu-item-url>
              <span data-v-menu-item-name data-v-if-not="category.type = 'text' && category.name"></span>
              <span data-v-menu-item-content data-v-if="category.content">
                <img src="/media/vvveb.svg" height="24" alt="" class="me-2">Mega menu
              </span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" data-v-class-if-active="category.active && category.type != 'text'" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'"></span>
                  <span data-v-menu-item-content data-v-if="category.content">
                    <div class="row">
                      <div class="col-6 align-self-center">
                        <img src="demo/img/video-1.webp" alt="Post" width="250" loading="lazy" class="rounded img-fluid">
                      </div>
                      <div class="col-6">
                        <h4>Features</h4>
                        <p class="text-muted">Just a few mentions, but there is more</p>
                        <ul class="list-unstyled">
                          <li class="text-primary">Page builder</li>
                          <li class="text-primary">Mega menu</li>
                          <li class="text-primary">Multi language</li>
                          <li class="text-primary">Advanced SEO</li>
                          <li class="text-primary">Ecommerce</li>
                        </ul>
                      </div>
                    </div>
                  </span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-class-if-active="category.active" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item dropdown" data-v-menu-item>
            <a class="nav-link dropdown-toggle" href="https://blog.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">User Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com/page/contact" data-v-menu-item-url>
              <span data-v-menu-item-name>Contact</span>
            </a>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>About us</span>
            </a>
          </li>

          <li class="nav-toggle">
            <!-- User Login Info -->
            <div class="dropdown nav-item">
              <a class="dropdown-toggle nav-link " href role="button" id="user-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="user/index">
                <!-- <img src="demo/img/user.svg" loading="lazy" width="20" alt> -->
                <i class="la la-lg la-user"></i>
                <span class="visually-hidden">User</span>
              </a>

              <div class="dropdown-menu dropdown-menu-end login-box user-box" aria-labelledby="user-dropdown">

                <div data-v-component-user>

                  <div class="notifications" data-v-notifications>

                    <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center text-small">
                        <div>
                          <div data-v-notification-text>
                            This is a placeholder for a notification message.
                          </div>
                        </div>
                      </div>


                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                        This is a placeholder for a success message.
                      </div>

                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center" data-v-notification-text>
                        This is a placeholder for a info message.
                      </div>

                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                  </div>

                  <form action method="post" enctype="multipart/form-data" data-v-url="user/login/index" data-v-vvveb-action="login" data-v-vvveb-on="submit" class="login-form">

                    <input type="hidden" name="csrf" data-v-csrf>

                    <div class="login-form" data-v-if-not="component.user_id">

                      <div class="mb-3">
                        <label class="form-label" for="input-email">E-Mail Address</label>
                        <input type="email" name="email" value placeholder="E-Mail Address" id="user-email" class="form-control" data-v-user-email required>
                      </div>

                      <div class="mb-3">
                        <label class="form-label" for="input-password">Password</label>

                        <div class="input-group">
                          <input type="password" minlength="4" autocorrect="off" autocomplete="current-password" class="form-control" placeholder="Password" id="user-password" name="password" value="" aria-label="Password" required>
                          <button class="btn btn-sm px-3 border border-start-0" type="button" onclick="togglePasswordInput(this, 'user-password')">
                            <i class="la la-eye-slash"></i>
                          </button>
                        </div>
                      </div>

                      <button type="submit" value="Login" class="btn btn-primary py-2 btn-login w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Authenticating</span>...
                        </span>

                        <span class="button-text">
                          Login <i class="la la-arrow-right ms-2"></i>
                        </span>

                      </button>
                      <div class="my-2"></div>
                      <a href="/user/reset" data-v-url="user/reset/index" class="my-2">Forgot your password?</a>

                      <div class="my-2"></div>
                      <!--
		<a>
			<span class="btn btn-secondary btn-sm">
				  <i class="lab la-google la-lg"></i>
			</span>
		</a>
		<a>
			<span class="btn btn-secondary btn-sm">
			  <i class="lab la-facebook la-lg"></i>
			</span>
		</a> -->
                      <hr class="text-secondary">
                      <span>Don’t have an account?</span>
                      <br>
                      <a href="/user/signup" data-v-url="user/signup/index">Register Account</a>
                      <span class="text-body-tertiary">|</span>
                      <a href="/user/login" data-v-url="user/login/index">Login</a>

                    </div>


                    <div class="user-form" data-v-if="component.user_id">
                      <div class="text-center" data-v-if="user.first_name">Welcome <b data-v-user-first_name data-filter-capitalize>John</b>
                        <b data-v-user-last_name data-filter-capitalize>Doe</b>
                      </div>
                      <div class="text-center" data-v-if-not="user.first_name">Welcome <b data-v-user-username>johndoe</b>
                      </div>

                      <div class="dropdown-divider opacity-50 my-3"></div>

                      <ul class="m-3 list-unstyled">
                        <li>
                          <a href="user" data-v-url="user/index">
                            <i class="la la-user la-lg text-muted m-1"></i>
                            <span>My account</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/comments" data-v-url="user/comments/index">
                            <i class="la la-comment la-lg text-muted m-1"></i>
                            <span>Comments</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/orders" data-v-url="user/orders/index">
                            <i class="la la-shopping-bag la-lg text-muted m-1"></i>
                            <span>Orders</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/downloads" data-v-url="user/downloads/index">
                            <i class="la la-hand-holding-heart la-lg text-muted m-1"></i>
                            <span>Downloads</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/wishlist" data-v-url="user/wishlist/index">
                            <i class="la la-download la-lg text-muted m-1"></i>
                            <span>Wishlist</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/profile" data-v-url="user/profile/index">
                            <i class="la la-cogs la-lg text-muted m-1"></i>
                            <span>Profile</span>
                          </a>
                        </li>
                      </ul>


                      <input type="hidden" name="logout">

                      <button type="submit" value="logout" class="btn btn-sm btn-primary w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Loading ...</span>...
                        </span>

                        <span class="button-text">
                          <i class="la la-sign-out-alt la-lg m-1"></i>
                          <span>Log out</span>
                          </a>
                        </span>

                      </button>
                    </div>
                  </form>


                </div>
              </div>
            </div>

          </li>


          <li class="nav-toggle">
            <!-- Cart Area -->
            <div class="dropdown nav-item mini-cart" data-v-component-cart>

              <a class="dropdown-toggle cart-info nav-link " href role="button" id="cart-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="cart/cart/index">
                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                <i class="la la-lg la-shopping-bag"></i>
                <span class="visually-hidden">Cart</span>
                <strong class="badge bg-primary-subtle text-black" data-v-total_items data-v-if="cart.total_items > 0"></strong>
              </a>


              <div class="dropdown-menu dropdown-menu-end cart-box" aria-labelledby="cart-dropdown">

                <div>
                  <div class="table-responsive">
                    <table class="table cart-table align-middle mb-0">
                      <tbody>


                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url>
                              <span data-v-cart-product-name>Product name</span>
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>

                            <div class="option" data-v-if="product.option">
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Color</span>: <span data-v-product-option-name>Red</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Size</span>: <span data-v-product-option-name>XL</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Material</span>: <span data-v-product-option-name>Wool</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                            </div>

                            <div class="subscription" data-v-if="product.subscription">
                              <span>Subscription plan</span>:
                              <span data-v-cart-product-subscription_name>Subscription plan</span>
                            </div>
                          </td>
                          <td class="text-end">
                            <a class="btn btn-remove btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times-circle la-lg"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url data-v-cart-product-name>
                              Product name
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>


                          </td>
                          <td class="text-end">
                            <a class="btn btn-outline-secondary btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-if-not="cart.total_items">
                          <td colspan="100">
                            <div class="d-flex  p-2">
                              <div class="text-center p-2 opacity-75">
                                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                                <i class="la la-2x la-shopping-bag"></i>
                              </div>
                              <div class="p-2">
                                <strong>Empty cart</strong>
                                <br>
                                <span class="text-muted">No products added yet!</span>
                              </div>
                            </div>
                          </td>
                        </tr>
                      </tbody>

                    </table>
                  </div>

                  <div class="p-3 pt-0 border-top" data-v-if="cart.total_items">
                    <div class="table-responsive mb-2" data-v-cart-totals>
                      <table class="table mb-0 cart-table cart-total" cellspacing="0">
                        <tfoot>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small data-v-cart-total-title>Sub-Total</small>:
                            </td>
                            <td class="text-end">
                              <span data-v-cart-total-text data-v-if="total.text"> - </span>
                              <span data-v-cart-total-value_formatted data-v-if="total.value > 0">$101.00</span>
                            </td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Eco Tax (2.00):</small>
                            </td>
                            <td class="text-end">$2.00</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>VAT (19%):</small>
                            </td>
                            <td class="text-end">$20.20</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Total:</small>
                            </td>
                            <td class="text-end">$123.20</td>
                          </tr>
                          <tr>
                            <td colspan="5" class="text-end">Total:</td>
                            <td class="text-end" data-v-grand-total_formatted>$0</td>
                          </tr>
                        </tfoot>

                      </table>
                    </div>

                  </div>

                  <div class="row mt-2 g-2 px-3 pb-2" data-v-if="cart.total_items">
                    <div class="col-6">
                      <a href="" class="btn btn-light btn-sm border w-100" data-v-url="cart/cart/index" data-url>
                        <i class="la la-shopping-cart la-lg"></i>
                        <span>View cart</span>
                      </a>
                    </div>
                    <div class="col-6">
                      <a href="" class="btn btn-primary btn-sm w-100" data-v-url="checkout/checkout/index">
                        <span>Checkout</span>
                        <i class="la la-arrow-right la-lg"></i>
                      </a>
                    </div>
                  </div>


                </div>



              </div>

            </div>

          </li>

        </ul>



        <button class="btn btn-outline-secondary btn-sm border-0 shadow-none" type="submit" title="Search" data-bs-toggle="modal" data-bs-target="#searchModal">
          <div class="la-flip-horizontal">
            <i class="la la-search la-lg" aria-hidden="true"></i>
          </div>
        </button>


        <!--
	<div class="search-area toggle-hover">
		<form action="/search" method="get" data-v-action="/search">
			<input type="hidden" name="route" value="search">
			<div class="input-group">
				<input type="search" name="search" class="form-control" id="headerSearch" placeholder="Type for search" data-v-vvveb-action="search" data-v-vvveb-on="keyup">
				<button class="btn border-0" type="submit" title="Search">
					<div class="la-flip-horizontal">
						<i class="la la-search la-lg" aria-hidden="true"></i>
					</div>
				</button>
			</div>			  
		</form>
	</div>
-->
      </div>


    </div>
  </div>
</nav>`
});Vvveb.Sections.add("navigation/navigation-2", {
    name: "Navigation 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/navigation/navigation-2-thumb.webp",
    html: `<nav class="navigation-2 clearfix fixed-top transparent" title="navigation-2" data-v-save-global="index.html,.navigation-2">

  <div class="container">

    <div class="navbar navbar-expand-md navbar-dark">
      <div data-v-component-site>
        <!-- <a class="navbar-brand" href="/" data-url data-v-url-params='{"host":"*.*.*"}'><span class="visually-hidden">Logo</span> -->
        <a class="navbar-brand" href="/" data-v-site-url>
          <span class="visually-hidden">Logo</span>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          <img src="demo/img/logo.png" alt="Site logo sticky" loading="lazy" class="logo-sticky" data-v-site-logo-sticky>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo-white.png" alt="Site logo dark sticky" loading="lazy" class="logo-default-dark-sticky" data-v-site-logo-dark-sticky>
        </a>
      </div>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbar" data-v-component-menu="header" data-v-slug="main-menu">
        <ul class="navbar-nav ms-auto" data-v-menu-items>
          <li class="nav-item dropdown position-static" data-v-menu-item data-v-class-if-has-dropdown="category.children > 0" data-v-class-if-position-static="category.has-text">

            <a class="nav-link dropdown-toggle" data-v-class-if-dropdown-toggle="category.children > 0" data-v-class-if-active="category.active" aria-expanded="false" data-v-menu-item-url>
              <span data-v-menu-item-name data-v-if-not="category.type = 'text' && category.name"></span>
              <span data-v-menu-item-content data-v-if="category.content">
                <img src="/media/vvveb.svg" height="24" alt="" class="me-2">Mega menu
              </span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" data-v-class-if-active="category.active && category.type != 'text'" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'"></span>
                  <span data-v-menu-item-content data-v-if="category.content">
                    <div class="row">
                      <div class="col-6 align-self-center">
                        <img src="demo/img/video-1.webp" alt="Post" width="250" loading="lazy" class="rounded img-fluid">
                      </div>
                      <div class="col-6">
                        <h4>Features</h4>
                        <p class="text-muted">Just a few mentions, but there is more</p>
                        <ul class="list-unstyled">
                          <li class="text-primary">Page builder</li>
                          <li class="text-primary">Mega menu</li>
                          <li class="text-primary">Multi language</li>
                          <li class="text-primary">Advanced SEO</li>
                          <li class="text-primary">Ecommerce</li>
                        </ul>
                      </div>
                    </div>
                  </span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-class-if-active="category.active" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item dropdown" data-v-menu-item>
            <a class="nav-link dropdown-toggle" href="https://blog.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">User Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com/page/contact" data-v-menu-item-url>
              <span data-v-menu-item-name>Contact</span>
            </a>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>About us</span>
            </a>
          </li>

          <li class="nav-toggle">
            <!-- User Login Info -->
            <div class="dropdown nav-item">
              <a class="dropdown-toggle nav-link " href role="button" id="user-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="user/index">
                <!-- <img src="demo/img/user.svg" loading="lazy" width="20" alt> -->
                <i class="la la-lg la-user"></i>
                <span class="visually-hidden">User</span>
              </a>

              <div class="dropdown-menu dropdown-menu-end login-box user-box" aria-labelledby="user-dropdown">

                <div data-v-component-user>

                  <div class="notifications" data-v-notifications>

                    <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center text-small">
                        <div>
                          <div data-v-notification-text>
                            This is a placeholder for a notification message.
                          </div>
                        </div>
                      </div>


                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                        This is a placeholder for a success message.
                      </div>

                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center" data-v-notification-text>
                        This is a placeholder for a info message.
                      </div>

                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                  </div>

                  <form action method="post" enctype="multipart/form-data" data-v-url="user/login/index" data-v-vvveb-action="login" data-v-vvveb-on="submit" class="login-form">

                    <input type="hidden" name="csrf" data-v-csrf>

                    <div class="login-form" data-v-if-not="component.user_id">

                      <div class="mb-3">
                        <label class="form-label" for="input-email">E-Mail Address</label>
                        <input type="email" name="email" value placeholder="E-Mail Address" id="user-email" class="form-control" data-v-user-email required>
                      </div>

                      <div class="mb-3">
                        <label class="form-label" for="input-password">Password</label>

                        <div class="input-group">
                          <input type="password" minlength="4" autocorrect="off" autocomplete="current-password" class="form-control" placeholder="Password" id="user-password" name="password" value="" aria-label="Password" required>
                          <button class="btn btn-sm px-3 border border-start-0" type="button" onclick="togglePasswordInput(this, 'user-password')">
                            <i class="la la-eye-slash"></i>
                          </button>
                        </div>
                      </div>

                      <button type="submit" value="Login" class="btn btn-primary py-2 btn-login w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Authenticating</span>...
                        </span>

                        <span class="button-text">
                          Login <i class="la la-arrow-right ms-2"></i>
                        </span>

                      </button>
                      <div class="my-2"></div>
                      <a href="/user/reset" data-v-url="user/reset/index" class="my-2">Forgot your password?</a>

                      <div class="my-2"></div>
                      <!--
		<a>
			<span class="btn btn-secondary btn-sm">
				  <i class="lab la-google la-lg"></i>
			</span>
		</a>
		<a>
			<span class="btn btn-secondary btn-sm">
			  <i class="lab la-facebook la-lg"></i>
			</span>
		</a> -->
                      <hr class="text-secondary">
                      <span>Don’t have an account?</span>
                      <br>
                      <a href="/user/signup" data-v-url="user/signup/index">Register Account</a>
                      <span class="text-body-tertiary">|</span>
                      <a href="/user/login" data-v-url="user/login/index">Login</a>

                    </div>


                    <div class="user-form" data-v-if="component.user_id">
                      <div class="text-center" data-v-if="user.first_name">Welcome <b data-v-user-first_name data-filter-capitalize>John</b>
                        <b data-v-user-last_name data-filter-capitalize>Doe</b>
                      </div>
                      <div class="text-center" data-v-if-not="user.first_name">Welcome <b data-v-user-username>johndoe</b>
                      </div>

                      <div class="dropdown-divider opacity-50 my-3"></div>

                      <ul class="m-3 list-unstyled">
                        <li>
                          <a href="user" data-v-url="user/index">
                            <i class="la la-user la-lg text-muted m-1"></i>
                            <span>My account</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/comments" data-v-url="user/comments/index">
                            <i class="la la-comment la-lg text-muted m-1"></i>
                            <span>Comments</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/orders" data-v-url="user/orders/index">
                            <i class="la la-shopping-bag la-lg text-muted m-1"></i>
                            <span>Orders</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/downloads" data-v-url="user/downloads/index">
                            <i class="la la-hand-holding-heart la-lg text-muted m-1"></i>
                            <span>Downloads</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/wishlist" data-v-url="user/wishlist/index">
                            <i class="la la-download la-lg text-muted m-1"></i>
                            <span>Wishlist</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/profile" data-v-url="user/profile/index">
                            <i class="la la-cogs la-lg text-muted m-1"></i>
                            <span>Profile</span>
                          </a>
                        </li>
                      </ul>


                      <input type="hidden" name="logout">

                      <button type="submit" value="logout" class="btn btn-sm btn-primary w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Loading ...</span>...
                        </span>

                        <span class="button-text">
                          <i class="la la-sign-out-alt la-lg m-1"></i>
                          <span>Log out</span>
                          </a>
                        </span>

                      </button>
                    </div>
                  </form>


                </div>
              </div>
            </div>

          </li>


          <li class="nav-toggle">
            <!-- Cart Area -->
            <div class="dropdown nav-item mini-cart" data-v-component-cart>

              <a class="dropdown-toggle cart-info nav-link " href role="button" id="cart-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="cart/cart/index">
                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                <i class="la la-lg la-shopping-bag"></i>
                <span class="visually-hidden">Cart</span>
                <strong class="badge bg-primary-subtle text-black" data-v-total_items data-v-if="cart.total_items > 0"></strong>
              </a>


              <div class="dropdown-menu dropdown-menu-end cart-box" aria-labelledby="cart-dropdown">

                <div>
                  <div class="table-responsive">
                    <table class="table cart-table align-middle mb-0">
                      <tbody>


                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url>
                              <span data-v-cart-product-name>Product name</span>
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>

                            <div class="option" data-v-if="product.option">
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Color</span>: <span data-v-product-option-name>Red</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Size</span>: <span data-v-product-option-name>XL</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Material</span>: <span data-v-product-option-name>Wool</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                            </div>

                            <div class="subscription" data-v-if="product.subscription">
                              <span>Subscription plan</span>:
                              <span data-v-cart-product-subscription_name>Subscription plan</span>
                            </div>
                          </td>
                          <td class="text-end">
                            <a class="btn btn-remove btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times-circle la-lg"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url data-v-cart-product-name>
                              Product name
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>


                          </td>
                          <td class="text-end">
                            <a class="btn btn-outline-secondary btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-if-not="cart.total_items">
                          <td colspan="100">
                            <div class="d-flex  p-2">
                              <div class="text-center p-2 opacity-75">
                                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                                <i class="la la-2x la-shopping-bag"></i>
                              </div>
                              <div class="p-2">
                                <strong>Empty cart</strong>
                                <br>
                                <span class="text-muted">No products added yet!</span>
                              </div>
                            </div>
                          </td>
                        </tr>
                      </tbody>

                    </table>
                  </div>

                  <div class="p-3 pt-0 border-top" data-v-if="cart.total_items">
                    <div class="table-responsive mb-2" data-v-cart-totals>
                      <table class="table mb-0 cart-table cart-total" cellspacing="0">
                        <tfoot>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small data-v-cart-total-title>Sub-Total</small>:
                            </td>
                            <td class="text-end">
                              <span data-v-cart-total-text data-v-if="total.text"> - </span>
                              <span data-v-cart-total-value_formatted data-v-if="total.value > 0">$101.00</span>
                            </td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Eco Tax (2.00):</small>
                            </td>
                            <td class="text-end">$2.00</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>VAT (19%):</small>
                            </td>
                            <td class="text-end">$20.20</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Total:</small>
                            </td>
                            <td class="text-end">$123.20</td>
                          </tr>
                          <tr>
                            <td colspan="5" class="text-end">Total:</td>
                            <td class="text-end" data-v-grand-total_formatted>$0</td>
                          </tr>
                        </tfoot>

                      </table>
                    </div>

                  </div>

                  <div class="row mt-2 g-2 px-3 pb-2" data-v-if="cart.total_items">
                    <div class="col-6">
                      <a href="" class="btn btn-light btn-sm border w-100" data-v-url="cart/cart/index" data-url>
                        <i class="la la-shopping-cart la-lg"></i>
                        <span>View cart</span>
                      </a>
                    </div>
                    <div class="col-6">
                      <a href="" class="btn btn-primary btn-sm w-100" data-v-url="checkout/checkout/index">
                        <span>Checkout</span>
                        <i class="la la-arrow-right la-lg"></i>
                      </a>
                    </div>
                  </div>


                </div>



              </div>

            </div>

          </li>

        </ul>



        <button class="btn btn-outline-secondary btn-sm border-0 shadow-none" type="submit" title="Search" data-bs-toggle="modal" data-bs-target="#searchModal">
          <div class="la-flip-horizontal">
            <i class="la la-search la-lg" aria-hidden="true"></i>
          </div>
        </button>


        <!--
	<div class="search-area toggle-hover">
		<form action="/search" method="get" data-v-action="/search">
			<input type="hidden" name="route" value="search">
			<div class="input-group">
				<input type="search" name="search" class="form-control" id="headerSearch" placeholder="Type for search" data-v-vvveb-action="search" data-v-vvveb-on="keyup">
				<button class="btn border-0" type="submit" title="Search">
					<div class="la-flip-horizontal">
						<i class="la la-search la-lg" aria-hidden="true"></i>
					</div>
				</button>
			</div>			  
		</form>
	</div>
-->
      </div>

    </div>


  </div>

</nav>`
});Vvveb.Sections.add("navigation/navigation-3", {
    name: "Navigation 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/navigation/navigation-3-thumb.webp",
    html: `<nav class="navigation-3 clearfix fixed-top transparent" title="navigation-3" data-v-save-global="index.html,.navigation-3">

  <div id="top" class="top-nav clearfix" data-bs-theme="dark">
    <div class="container">
      <div class="d-flex justify-content-between  flex-md-row d-flex flex-column flex-md-row">
        <div class="nav">
          <ul class="list-inline" data-v-component-site>
            <li class="list-inline-item" data-v-if="site.description.phone-number">
              <a href="tel:5511112377" class="p-2 p-md-0" title="Phone" data-v-site-description-phone-number>
                <i class="la la-phone"></i>
                <span class=" text-muted" data-v-site-description-phone-number>+55 (111) 123 777</span>
              </a>
            </li>
            <!--
					<li class="list-inline-item" class="p-2 p-md-0" data-v-if="site.contact-email">
						<a href="mailto:contact@mysite.com" title="Email" data-v-site-contact-email>
						<i class="la la-envelope"></i> 
						<span class=" text-muted" data-v-site-contact-email>contact@mysite.com</span></a>
					</li>
					-->
          </ul>
        </div>
        <div class="nav">
          <ul class="list-inline">
            <!--
					<li class="list-inline-item"><a id="wishlist-total" title="Wish List (0)"><i class="la la-heart"></i> <span class="">Favorites</span></a></li>
					<li class="list-inline-item"><a title="Checkout"><i class="la la-share"></i> <span class="">Checkout</span></a></li>
					<li class="list-inline-item">
						<div class="dropdown">
							<a href="" class="dropdown-toggle" data-bs-toggle="dropdown" role="button"><i class="la la-user"></i> <span class="">My Account</span></i></a>
							<ul class="dropdown-menu dropdown-menu-right">
								<li><a class="dropdown-item">Register</a></li>
								<li><a class="dropdown-item">Login</a></li>
							</ul>
						</div>
					</li>
					-->
            <li class="list-inline-item">
              <div data-v-component-currency>
                <form method="post" enctype="multipart/form-data" id="form-currency">

                  <a class="dropdown-toggle p-2 p-md-0" data-bs-toggle="dropdown" role="button" title="Currency" aria-expanded="false">
                    <!-- <i class="la la-dollar-sign me-1"></i> -->
                    <span class="" data-v-currency-info-name>USD</span>
                  </a>


                  <div class="dropdown-menu dropdown-menu-end">

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="EUR" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>€</span>
                        <span data-v-currency-sign_end>€</span>
                        <span class="ms-1" data-v-currency-name>Euro</span>
                      </button>
                    </div>

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="GBP" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>£</span>
                        <span data-v-currency-sign_end>£</span>
                        <span class="ms-1" data-v-currency-name>Pound Sterling</span>
                      </button>
                    </div>

                    <div data-v-currency>
                      <button class="dropdown-item" type="submit" value="USD" name="currency" data-v-currency-code>
                        <span data-v-currency-sign_start>$</span>
                        <span data-v-currency-sign_end>$</span>
                        <span class="ms-1" data-v-currency-name>US Dollar</span>
                      </button>
                    </div>

                  </div>
                </form>
              </div>
            </li>
            <li class="list-inline-item">
              <div data-v-component-language>
                <form method="post" enctype="multipart/form-data" id="form-language">

                  <a class="dropdown-toggle p-2 p-md-0" data-bs-toggle="dropdown" role="button" title="Language" aria-expanded="false">
                    <!-- <i class="la la-flag me-1"></i> -->
                    <!-- 
									<img src="" data-v-language-info-img>
									-->
                    <span class="" data-v-language-info-name>English</span>
                  </a>


                  <div class="dropdown-menu dropdown-menu-end">

                    <div data-v-language>
                      <button class="dropdown-item" type="submit" value="eng" name="language" data-v-language-code>
                        <!-- <i class="la la-flag la-lg me-2"></i> -->
                        <img src="" loading="lazy" class="me-1" data-v-language-img>

                        <!-- <a href="" data-v-language-url> -->
                        <span data-v-language-name>English</span>
                        <!-- </a> -->
                      </button>
                    </div>

                    <div data-v-language>
                      <button class="dropdown-item" type="submit" value="ro" name="language" data-v-language-code>
                        <!-- <i class="la la-flag la-lg me-2"></i> -->
                        <img src="" loading="lazy" class="me-1" data-v-language-img>
                        <!-- <a href="" data-v-language-url>  -->
                        <span data-v-language-name>Romanian</span>
                        <!-- </a>  -->
                      </button>
                    </div>

                  </div>
                </form>
              </div>
            </li>
            <li class="list-inline-item">

              <a id="color-theme-switch" class="p-2 p-md-0" role="button" title="Switch sidebar color theme">
                <i class="la la-sun la-lg"></i>
              </a>

            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>

  <div class="navbar navbar-expand-md navbar-dark">

    <div class="container">

      <div data-v-component-site>
        <!-- <a class="navbar-brand" href="/" data-url data-v-url-params='{"host":"*.*.*"}'><span class="visually-hidden">Logo</span> -->
        <a class="navbar-brand" href="/" data-v-site-url>
          <span class="visually-hidden">Logo</span>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          <img src="demo/img/logo.png" alt="Site logo sticky" loading="lazy" class="logo-sticky" data-v-site-logo-sticky>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo-white.png" alt="Site logo dark sticky" loading="lazy" class="logo-default-dark-sticky" data-v-site-logo-dark-sticky>
        </a>
      </div>


      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <div class="collapse navbar-collapse" id="navbar" data-v-component-menu="header" data-v-slug="main-menu">
        <ul class="navbar-nav ms-auto" data-v-menu-items>
          <li class="nav-item dropdown position-static" data-v-menu-item data-v-class-if-has-dropdown="category.children > 0" data-v-class-if-position-static="category.has-text">

            <a class="nav-link dropdown-toggle" data-v-class-if-dropdown-toggle="category.children > 0" data-v-class-if-active="category.active" aria-expanded="false" data-v-menu-item-url>
              <span data-v-menu-item-name data-v-if-not="category.type = 'text' && category.name"></span>
              <span data-v-menu-item-content data-v-if="category.content">
                <img src="/media/vvveb.svg" height="24" alt="" class="me-2">Mega menu
              </span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" data-v-class-if-active="category.active && category.type != 'text'" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'"></span>
                  <span data-v-menu-item-content data-v-if="category.content">
                    <div class="row">
                      <div class="col-6 align-self-center">
                        <img src="demo/img/video-1.webp" alt="Post" width="250" loading="lazy" class="rounded img-fluid">
                      </div>
                      <div class="col-6">
                        <h4>Features</h4>
                        <p class="text-muted">Just a few mentions, but there is more</p>
                        <ul class="list-unstyled">
                          <li class="text-primary">Page builder</li>
                          <li class="text-primary">Mega menu</li>
                          <li class="text-primary">Multi language</li>
                          <li class="text-primary">Advanced SEO</li>
                          <li class="text-primary">Ecommerce</li>
                        </ul>
                      </div>
                    </div>
                  </span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-class-if-active="category.active" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item dropdown" data-v-menu-item>
            <a class="nav-link dropdown-toggle" href="https://blog.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">User Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name data-v-if-not="category.type = 'text'">Developer Documentation</span>
                  <span data-v-menu-item-content></span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com/page/contact" data-v-menu-item-url>
              <span data-v-menu-item-name>Contact</span>
            </a>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>About us</span>
            </a>
          </li>

          <li class="nav-toggle">
            <!-- User Login Info -->
            <div class="dropdown nav-item">
              <a class="dropdown-toggle nav-link " href role="button" id="user-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="user/index">
                <!-- <img src="demo/img/user.svg" loading="lazy" width="20" alt> -->
                <i class="la la-lg la-user"></i>
                <span class="visually-hidden">User</span>
              </a>

              <div class="dropdown-menu dropdown-menu-end login-box user-box" aria-labelledby="user-dropdown">

                <div data-v-component-user>

                  <div class="notifications" data-v-notifications>

                    <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center text-small">
                        <div>
                          <div data-v-notification-text>
                            This is a placeholder for a notification message.
                          </div>
                        </div>
                      </div>


                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                        This is a placeholder for a success message.
                      </div>

                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center" data-v-notification-text>
                        This is a placeholder for a info message.
                      </div>

                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                  </div>

                  <form action method="post" enctype="multipart/form-data" data-v-url="user/login/index" data-v-vvveb-action="login" data-v-vvveb-on="submit" class="login-form">

                    <input type="hidden" name="csrf" data-v-csrf>

                    <div class="login-form" data-v-if-not="component.user_id">

                      <div class="mb-3">
                        <label class="form-label" for="input-email">E-Mail Address</label>
                        <input type="email" name="email" value placeholder="E-Mail Address" id="user-email" class="form-control" data-v-user-email required>
                      </div>

                      <div class="mb-3">
                        <label class="form-label" for="input-password">Password</label>

                        <div class="input-group">
                          <input type="password" minlength="4" autocorrect="off" autocomplete="current-password" class="form-control" placeholder="Password" id="user-password" name="password" value="" aria-label="Password" required>
                          <button class="btn btn-sm px-3 border border-start-0" type="button" onclick="togglePasswordInput(this, 'user-password')">
                            <i class="la la-eye-slash"></i>
                          </button>
                        </div>
                      </div>

                      <button type="submit" value="Login" class="btn btn-primary py-2 btn-login w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Authenticating</span>...
                        </span>

                        <span class="button-text">
                          Login <i class="la la-arrow-right ms-2"></i>
                        </span>

                      </button>
                      <div class="my-2"></div>
                      <a href="/user/reset" data-v-url="user/reset/index" class="my-2">Forgot your password?</a>

                      <div class="my-2"></div>
                      <!--
		<a>
			<span class="btn btn-secondary btn-sm">
				  <i class="lab la-google la-lg"></i>
			</span>
		</a>
		<a>
			<span class="btn btn-secondary btn-sm">
			  <i class="lab la-facebook la-lg"></i>
			</span>
		</a> -->
                      <hr class="text-secondary">
                      <span>Don’t have an account?</span>
                      <br>
                      <a href="/user/signup" data-v-url="user/signup/index">Register Account</a>
                      <span class="text-body-tertiary">|</span>
                      <a href="/user/login" data-v-url="user/login/index">Login</a>

                    </div>


                    <div class="user-form" data-v-if="component.user_id">
                      <div class="text-center" data-v-if="user.first_name">Welcome <b data-v-user-first_name data-filter-capitalize>John</b>
                        <b data-v-user-last_name data-filter-capitalize>Doe</b>
                      </div>
                      <div class="text-center" data-v-if-not="user.first_name">Welcome <b data-v-user-username>johndoe</b>
                      </div>

                      <div class="dropdown-divider opacity-50 my-3"></div>

                      <ul class="m-3 list-unstyled">
                        <li>
                          <a href="user" data-v-url="user/index">
                            <i class="la la-user la-lg text-muted m-1"></i>
                            <span>My account</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/comments" data-v-url="user/comments/index">
                            <i class="la la-comment la-lg text-muted m-1"></i>
                            <span>Comments</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/orders" data-v-url="user/orders/index">
                            <i class="la la-shopping-bag la-lg text-muted m-1"></i>
                            <span>Orders</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/downloads" data-v-url="user/downloads/index">
                            <i class="la la-hand-holding-heart la-lg text-muted m-1"></i>
                            <span>Downloads</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/wishlist" data-v-url="user/wishlist/index">
                            <i class="la la-download la-lg text-muted m-1"></i>
                            <span>Wishlist</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/profile" data-v-url="user/profile/index">
                            <i class="la la-cogs la-lg text-muted m-1"></i>
                            <span>Profile</span>
                          </a>
                        </li>
                      </ul>


                      <input type="hidden" name="logout">

                      <button type="submit" value="logout" class="btn btn-sm btn-primary w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Loading ...</span>...
                        </span>

                        <span class="button-text">
                          <i class="la la-sign-out-alt la-lg m-1"></i>
                          <span>Log out</span>
                          </a>
                        </span>

                      </button>
                    </div>
                  </form>


                </div>
              </div>
            </div>

          </li>


          <li class="nav-toggle">
            <!-- Cart Area -->
            <div class="dropdown nav-item mini-cart" data-v-component-cart>

              <a class="dropdown-toggle cart-info nav-link " href role="button" id="cart-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="cart/cart/index">
                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                <i class="la la-lg la-shopping-bag"></i>
                <span class="visually-hidden">Cart</span>
                <strong class="badge bg-primary-subtle text-black" data-v-total_items data-v-if="cart.total_items > 0"></strong>
              </a>


              <div class="dropdown-menu dropdown-menu-end cart-box" aria-labelledby="cart-dropdown">

                <div>
                  <div class="table-responsive">
                    <table class="table cart-table align-middle mb-0">
                      <tbody>


                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url>
                              <span data-v-cart-product-name>Product name</span>
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>

                            <div class="option" data-v-if="product.option">
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Color</span>: <span data-v-product-option-name>Red</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Size</span>: <span data-v-product-option-name>XL</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                              <div class="" data-v-product-option>
                                <span data-v-product-option-option>Material</span>: <span data-v-product-option-name>Wool</span>
                                <span data-v-if="value.price > 0">(<span data-v-product-option-price></span>)</span>
                              </div>
                            </div>

                            <div class="subscription" data-v-if="product.subscription">
                              <span>Subscription plan</span>:
                              <span data-v-cart-product-subscription_name>Subscription plan</span>
                            </div>
                          </td>
                          <td class="text-end">
                            <a class="btn btn-remove btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times-circle la-lg"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-cart-product>
                          <td class="text-center">
                            <a href="#40" data-v-cart-product-url>
                              <img src="demo/img/product.webp" alt="Product name" class="img-rounded" loading="lazy" data-v-cart-product-image width=50>
                            </a>
                          </td>
                          <td class="text-start">
                            <a href="#40" class="d-block" data-v-cart-product-url data-v-cart-product-name>
                              Product name
                            </a>

                            <span data-v-cart-product-quantity>1</span>
                            <i class="la la-times text-muted"></i>
                            <span data-v-cart-product-price_tax_formatted>$123.20</span>


                          </td>
                          <td class="text-end">
                            <a class="btn btn-outline-secondary btn-sm border-0" data-v-vvveb-action="removeFromCart" data-v-cart-product-remove-url>
                              <i class="la la-times"></i>
                            </a>
                          </td>
                        </tr>
                        <tr data-v-if-not="cart.total_items">
                          <td colspan="100">
                            <div class="d-flex  p-2">
                              <div class="text-center p-2 opacity-75">
                                <!-- <img src="demo/img/bag.svg" width="20" alt> -->
                                <i class="la la-2x la-shopping-bag"></i>
                              </div>
                              <div class="p-2">
                                <strong>Empty cart</strong>
                                <br>
                                <span class="text-muted">No products added yet!</span>
                              </div>
                            </div>
                          </td>
                        </tr>
                      </tbody>

                    </table>
                  </div>

                  <div class="p-3 pt-0 border-top" data-v-if="cart.total_items">
                    <div class="table-responsive mb-2" data-v-cart-totals>
                      <table class="table mb-0 cart-table cart-total" cellspacing="0">
                        <tfoot>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small data-v-cart-total-title>Sub-Total</small>:
                            </td>
                            <td class="text-end">
                              <span data-v-cart-total-text data-v-if="total.text"> - </span>
                              <span data-v-cart-total-value_formatted data-v-if="total.value > 0">$101.00</span>
                            </td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Eco Tax (2.00):</small>
                            </td>
                            <td class="text-end">$2.00</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>VAT (19%):</small>
                            </td>
                            <td class="text-end">$20.20</td>
                          </tr>
                          <tr data-v-cart-total>
                            <td colspan="5" class="text-end">
                              <small>Total:</small>
                            </td>
                            <td class="text-end">$123.20</td>
                          </tr>
                          <tr>
                            <td colspan="5" class="text-end">Total:</td>
                            <td class="text-end" data-v-grand-total_formatted>$0</td>
                          </tr>
                        </tfoot>

                      </table>
                    </div>

                  </div>

                  <div class="row mt-2 g-2 px-3 pb-2" data-v-if="cart.total_items">
                    <div class="col-6">
                      <a href="" class="btn btn-light btn-sm border w-100" data-v-url="cart/cart/index" data-url>
                        <i class="la la-shopping-cart la-lg"></i>
                        <span>View cart</span>
                      </a>
                    </div>
                    <div class="col-6">
                      <a href="" class="btn btn-primary btn-sm w-100" data-v-url="checkout/checkout/index">
                        <span>Checkout</span>
                        <i class="la la-arrow-right la-lg"></i>
                      </a>
                    </div>
                  </div>


                </div>



              </div>

            </div>

          </li>

        </ul>



        <button class="btn btn-outline-secondary btn-sm border-0 shadow-none" type="submit" title="Search" data-bs-toggle="modal" data-bs-target="#searchModal">
          <div class="la-flip-horizontal">
            <i class="la la-search la-lg" aria-hidden="true"></i>
          </div>
        </button>


        <!--
	<div class="search-area toggle-hover">
		<form action="/search" method="get" data-v-action="/search">
			<input type="hidden" name="route" value="search">
			<div class="input-group">
				<input type="search" name="search" class="form-control" id="headerSearch" placeholder="Type for search" data-v-vvveb-action="search" data-v-vvveb-on="keyup">
				<button class="btn border-0" type="submit" title="Search">
					<div class="la-flip-horizontal">
						<i class="la la-search la-lg" aria-hidden="true"></i>
					</div>
				</button>
			</div>			  
		</form>
	</div>
-->
      </div>


      <!--
			  <div class="collapse navbar-collapse" id="navbar">
				<ul class="navbar-nav ms-auto">
				  <li class="nav-item">
					<a class="nav-link" href="#features">Features <span class="sr-only">(current)</span></a>
				  </li>
				  <li class="nav-item">
					<a class="nav-link" href="https://themes.vvveb.com">Themes</a>
				  </li>
				  <li class="nav-item">
					<a class="nav-link" href="https://plugins.vvveb.com">Plugins</a>
				  </li>
				  <li class="nav-item dropdown">
					<a class="nav-link dropdown-toggle" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">Resources</a>
					<div class="dropdown-menu" aria-labelledby="dropdown01">
					  <a class="dropdown-item" target="_blank"  href="https://github.com/givanz/VvvebJs/wiki">User Documentation</a>
					  <a class="dropdown-item" target="_blank"  href="https://github.com/givanz/VvvebJs/wiki">Developer Documentation</a>
					</div>
				  </li>
				  <li class="nav-item">
					<a class="nav-link" target="_blank" href="https://github.com/givanz/VvvebJs">Github</a>
				  </li>
				  <li class="nav-item">
					<a class="nav-link" href="contact.html">Contact</a>
				  </li>
				  <li class="nav-item active">
					<a class="nav-link" href="https://vvveb.com/download.php">Download for free</a>
				  </li>			  
				</ul>
			  </div>
			  -->
    </div>

  </div>

</nav>`
});Vvveb.Sections.add("navigation/navigation-4", {
    name: "Navigation 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/navigation/navigation-4-thumb.webp",
    html: `<nav class="navigation-4 clearfix" data-v-save-global="index.html,.navigation-4">

  <div class="navbar navbar-expand-md">

    <div class="container">

      <div data-v-component-site>
        <!-- <a class="navbar-brand" href="/" data-url data-v-url-params='{"host":"*.*.*"}'><span class="visually-hidden">Logo</span> -->
        <a class="navbar-brand" href="/" data-v-site-url>
          <span class="visually-hidden">Logo</span>
          <img src="demo/img/logo.png" alt="Site logo" loading="lazy" class="logo-default" data-v-site-logo>
          <img src="demo/img/logo.png" alt="Site logo sticky" loading="lazy" class="logo-sticky" data-v-site-logo-sticky>
          <img src="demo/img/logo-white.png" alt="Site logo dark" loading="lazy" class="logo-default-dark" data-v-site-logo-dark>
          <img src="demo/img/logo-white.png" alt="Site logo dark sticky" loading="lazy" class="logo-default-dark-sticky" data-v-site-logo-dark-sticky>
        </a>
      </div>

      <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbar" aria-controls="navbar" aria-expanded="false" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>


      <div class="collapse navbar-collapse" id="navbar" data-v-component-menu="header" data-v-slug="main-menu">
        <ul class="navbar-nav ms-auto" data-v-menu-items>
          <li class="nav-item dropdown" data-v-menu-item data-v-class-if-has-dropdown="category.children > 0">

            <a class="nav-link" data-v-class-if-dropdown-toggle="category.children > 0" aria-expanded="false" data-v-menu-item-url>
              <span data-v-menu-item-name>Resources</span>
            </a>

            <div class="dropdown-menu" data-v-menu-item-recursive>
              <div data-v-menu-item class="nav-item" data-v-menu-item data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name>User Documentation</span>
                </a>
              </div>
              <div data-v-menu-item class="nav-item" data-v-menu-item data-v-class-if-dropdown="category.children > 0">
                <a class="dropdown-item" href="https://github.com/givanz/VvvebJs/wiki" data-v-menu-item-url>
                  <span data-v-menu-item-name>Developer Documentation</span>
                </a>
              </div>
            </div>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://blog.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>Blog</span>
            </a>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com/page/contact" data-v-menu-item-url>
              <span data-v-menu-item-name>Contact</span>
            </a>
          </li>
          <li class="nav-item" data-v-menu-item>
            <a class="nav-link" href="https://www.vvveb.com" data-v-menu-item-url>
              <span data-v-menu-item-name>About us</span>
            </a>
          </li>
          <li class="nav-item dropdown">
            <a class="nav-link dropdown-toggle" href="//demo.vvveb.com/admin/?module=/editor/editor&template=index.html&url=/" role="button">Demo</a>
            <div class="dropdown-menu">
              <a class="dropdown-item" target="_blank" href="//demo.vvveb.com/admin/?module=/editor/editor&template=index.html&url=/">Page builder</a>
              <a class="dropdown-item" target="_blank" href="//demo.vvveb.com/admin">Admin dashboard</a>
              <a class="dropdown-item" target="_blank" href="//demo.vvveb.com">Frontend</a>
              <div class="dropdown-divider"></div>
              <a class="dropdown-item" target="_blank" href="https://vercel-vvveb-commerce.vercel.app/">Next.js Frontend GraphQL</a>
            </div>
          </li>


          <li class="nav-toggle">
            <!-- User Login Info -->
            <div class="dropdown nav-item">
              <a class="dropdown-toggle nav-link " href role="button" id="user-dropdown" data-bs-toggle="dropdown" aria-expanded="false" data-v-url="user/index">
                <!-- <img src="demo/img/user.svg" loading="lazy" width="20" alt> -->
                <i class="la la-lg la-user"></i>
                <span class="visually-hidden">User</span>
              </a>

              <div class="dropdown-menu dropdown-menu-end login-box user-box" aria-labelledby="user-dropdown">

                <div data-v-component-user>

                  <div class="notifications" data-v-notifications>

                    <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center text-small">
                        <div>
                          <div data-v-notification-text>
                            This is a placeholder for a notification message.
                          </div>
                        </div>
                      </div>


                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1 la-check-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                        This is a placeholder for a success message.
                      </div>

                      <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                    <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="login">

                      <div class="icon align-middle me-2">
                        <i class="align-middle la la-2x lh-1  la-info-circle"></i>
                      </div>

                      <div class="flex-grow-1 align-self-center" data-v-notification-text>
                        This is a placeholder for a info message.
                      </div>

                      <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">
                          <!-- <i class="la la-times"></i> -->
                        </span>
                      </button>
                    </div>

                  </div>

                  <form action method="post" enctype="multipart/form-data" data-v-url="user/login/index" data-v-vvveb-action="login" data-v-vvveb-on="submit" class="login-form">

                    <input type="hidden" name="csrf" data-v-csrf>

                    <div class="login-form" data-v-if-not="component.user_id">

                      <div class="mb-3">
                        <label class="form-label" for="input-email">E-Mail Address</label>
                        <input type="email" name="email" value placeholder="E-Mail Address" id="user-email" class="form-control" data-v-user-email required>
                      </div>

                      <div class="mb-3">
                        <label class="form-label" for="input-password">Password</label>

                        <div class="input-group">
                          <input type="password" minlength="4" autocorrect="off" autocomplete="current-password" class="form-control" placeholder="Password" id="user-password" name="password" value="" aria-label="Password" required>
                          <button class="btn btn-sm px-3 border border-start-0" type="button" onclick="togglePasswordInput(this, 'user-password')">
                            <i class="la la-eye-slash"></i>
                          </button>
                        </div>
                      </div>

                      <button type="submit" value="Login" class="btn btn-primary py-2 btn-login w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Authenticating</span>...
                        </span>

                        <span class="button-text">
                          Login <i class="la la-arrow-right ms-2"></i>
                        </span>

                      </button>
                      <div class="my-2"></div>
                      <a href="/user/reset" data-v-url="user/reset/index" class="my-2">Forgot your password?</a>

                      <div class="my-2"></div>
                      <!--
		<a>
			<span class="btn btn-secondary btn-sm">
				  <i class="lab la-google la-lg"></i>
			</span>
		</a>
		<a>
			<span class="btn btn-secondary btn-sm">
			  <i class="lab la-facebook la-lg"></i>
			</span>
		</a> -->
                      <hr class="text-secondary">
                      <span>Don’t have an account?</span>
                      <br>
                      <a href="/user/signup" data-v-url="user/signup/index">Register Account</a>
                      <span class="text-body-tertiary">|</span>
                      <a href="/user/login" data-v-url="user/login/index">Login</a>

                    </div>


                    <div class="user-form" data-v-if="component.user_id">
                      <div class="text-center" data-v-if="user.first_name">Welcome <b data-v-user-first_name data-filter-capitalize>John</b>
                        <b data-v-user-last_name data-filter-capitalize>Doe</b>
                      </div>
                      <div class="text-center" data-v-if-not="user.first_name">Welcome <b data-v-user-username>johndoe</b>
                      </div>

                      <div class="dropdown-divider opacity-50 my-3"></div>

                      <ul class="m-3 list-unstyled">
                        <li>
                          <a href="user" data-v-url="user/index">
                            <i class="la la-user la-lg text-muted m-1"></i>
                            <span>My account</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/comments" data-v-url="user/comments/index">
                            <i class="la la-comment la-lg text-muted m-1"></i>
                            <span>Comments</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/orders" data-v-url="user/orders/index">
                            <i class="la la-shopping-bag la-lg text-muted m-1"></i>
                            <span>Orders</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/downloads" data-v-url="user/downloads/index">
                            <i class="la la-hand-holding-heart la-lg text-muted m-1"></i>
                            <span>Downloads</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/wishlist" data-v-url="user/wishlist/index">
                            <i class="la la-download la-lg text-muted m-1"></i>
                            <span>Wishlist</span>
                          </a>
                        </li>
                        <li>
                          <a href="user/profile" data-v-url="user/profile/index">
                            <i class="la la-cogs la-lg text-muted m-1"></i>
                            <span>Profile</span>
                          </a>
                        </li>
                      </ul>


                      <input type="hidden" name="logout">

                      <button type="submit" value="logout" class="btn btn-sm btn-primary w-100">

                        <span class="loading d-none">
                          <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                          </span>
                          <span>Loading ...</span>...
                        </span>

                        <span class="button-text">
                          <i class="la la-sign-out-alt la-lg m-1"></i>
                          <span>Log out</span>
                          </a>
                        </span>

                      </button>
                    </div>
                  </form>


                </div>
              </div>
            </div>

          </li>

          <li class="nav-toggle">
            <button class="btn btn-outline-secondary btn-sm border-0" type="submit" title="Search" data-bs-toggle="modal" data-bs-target="#searchModal">
              <div class="la-flip-horizontal">
                <i class="la la-search la-lg" aria-hidden="true"></i>
              </div>
            </button>
          </li>

          <li class="nav-item">
            <a id="color-theme-switch" class="nav-link" role="button" title="Switch sidebar color theme">
              <i class="la la-sun"></i>
            </a>
          </li>
        </ul>
      </div>

      <!--				
				<div class="search-area toggle-hover">
					<form action="/search" method="get" data-v-action="/search">
						<input type="hidden" name="route" value="search">
						<div class="input-group">
							<input type="search" name="search" class="form-control" id="headerSearch" placeholder="Type for search" data-v-vvveb-action="search" data-v-vvveb-on="keyup">
							<button class="btn border-0" type="submit" title="Search">
								<div class="la-flip-horizontal">
									<i class="la la-search la-lg" aria-hidden="true"></i>
								</div>
							</button>
						</div>			  
					</form>
				</div>
-->
      <!--	  </div> -->
      <!--
		  <div class="collapse navbar-collapse" id="navbar">
			<ul class="navbar-nav ms-auto">
			  <li class="nav-item">
				<a class="nav-link" href="#features">Features <span class="sr-only">(current)</span></a>
			  </li>
			  <li class="nav-item">
				<a class="nav-link" href="https://themes.vvveb.com">Themes</a>
			  </li>
			  <li class="nav-item">
				<a class="nav-link" href="https://plugins.vvveb.com">Plugins</a>
			  </li>
			  <li class="nav-item dropdown">
				<a class="nav-link dropdown-toggle" id="dropdown01" data-bs-toggle="dropdown" aria-expanded="false">Resources</a>
				<div class="dropdown-menu" aria-labelledby="dropdown01">
				  <a class="dropdown-item" target="_blank"  href="https://github.com/givanz/VvvebJs/wiki">User Documentation</a>
				  <a class="dropdown-item" target="_blank"  href="https://github.com/givanz/VvvebJs/wiki">Developer Documentation</a>
				</div>
			  </li>
			  <li class="nav-item">
				<a class="nav-link" target="_blank" href="https://github.com/givanz/VvvebJs">Github</a>
			  </li>
			  <li class="nav-item">
				<a class="nav-link" href="contact.html">Contact</a>
			  </li>
			  <li class="nav-item active">
				<a class="nav-link" href="https://vvveb.com/download.php">Download for free</a>
			  </li>			  
			</ul>
		  </div>
		  -->
    </div>

  </div>

</nav>`
});
	Vvveb.SectionsGroup["Navigation"] = ["navigation/navigation-1","navigation/navigation-2","navigation/navigation-3","navigation/navigation-4"];
Vvveb.Sections.add("portfolio/portfolio-1", {
    name: "Portfolio 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/portfolio/portfolio-1-thumb.webp",
    html: `<section class="portfolio-1 my-5" aria-label="portfolio-1">
  <div class="row justify-content-center pb-2">
    <div class="col-md-7 heading-section text-center">
      <h2 class="text-center display-6 mb-1 fw-bold">Portfolio</h2>
      <p class="lead text-center text-muted mb-4">Some of our work</p>
    </div>
  </div>
  <div class="gallery masonry hover-effect" data-component-gallery="portfolio-1" id="gallery-RANDOM_ID">
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="100">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="200">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="300">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="400">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="500">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="600">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
    <div class="item">
      <figure>
        <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="700">
        <figcaption></figcaption>
        <h3 class="title d-none"></h3>
        <div class="description d-none"></div>
      </figure>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("portfolio/portfolio-2", {
    name: "Portfolio 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/portfolio/portfolio-2-thumb.webp",
    html: `<section class="portfolio-2 my-5" aria-label="portfolio-2">
  <div class="container">
    <div class="row justify-content-center pb-2">
      <div class="col-md-7 text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">Portfolio</h2>
        <p class="lead text-center text-muted mb-4">Some of our work</p>
      </div>
    </div>
    <div class="gallery masonry has-shadow hover-effect" data-component-gallery="portfolio-1" id="gallery-RANDOM_ID">
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="100">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="200">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="300">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="400">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="500">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("portfolio/portfolio-3", {
    name: "Portfolio 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/portfolio/portfolio-3-thumb.webp",
    html: `<section class="portfolio-2 my-5" aria-label="portfolio-3">
  <div class="container">
    <div class="row justify-content-center pb-2">
      <div class="col-md-7 text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">Portfolio</h2>
        <p class="lead text-center text-muted mb-4">Some of our work</p>
      </div>
    </div>
    <div class="gallery masonry has-shadow hover-effect" data-component-gallery="portfolio-3" style="column-count: 2;" id="gallery-RANDOM_ID">
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="100">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-1.jpg" data-aos="fade-up" data-aos-delay="200">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
      <div class="item">
        <figure>
          <img class="img-fluid" src="demo/img/team-2.jpg" data-aos="fade-up" data-aos-delay="300">
          <figcaption></figcaption>
          <h3 class="title d-none"></h3>
          <div class="description d-none"></div>
        </figure>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Portfolio"] = ["portfolio/portfolio-1","portfolio/portfolio-2","portfolio/portfolio-3"];
Vvveb.Sections.add("posts/posts-1", {
    name: "Posts 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/posts/posts-1-thumb.webp",
    html: `<section class="posts-1" aria-label="latest-post-1">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="section-heading text-center">
          <h2 class="text-center display-6 mb-1 fw-bold">Latest Posts</h2>
          <p class="lead text-center text-muted mb-4">Fresh updates from the industry.</p>
        </div>
      </div>
    </div>
  </div>



  <div class="container">
    <div data-v-component-posts="posts-1" data-v-limit="3" data-v-image_size="medium">
      <div class="row">



        <div class="col-12 col-lg-4 mb-2" data-aos="fade-up" data-aos-delay="000" data-v-post>

          <article class="card post h-100 shadow-sm border">
            <div class="card-img-top" data-v-if="post.image">
              <img src="demo/img/video-1.webp" alt="" class="w-100" loading="lazy" data-v-size="thumb" data-v-post-image>
            </div>
            <!-- Post Title -->
            <a data-v-post-url>
              <div class="card-body p-4">
                <div class="post-title card-title">
                  <h3 class="h4" data-v-post-name>
                    Vivamus sed nunc in arcu cursus mollis quis et orci. Interdum et malesuada
                  </h3>
                </div>


                <ul class="post-meta text-start mb-3 small">

                  <li class="post-author meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post author</span>
                      <i class="la la-user"></i>
                    </span>
                    <span class="meta-text">
                      By <a href="content/post.html" data-v-post-author-url>
                        <span data-v-post-display_name>admin</span>
                      </a>
                    </span>
                  </li>

                  <li class="post-date meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post date</span>

                      <i class="la la-calendar"></i>
                    </span>
                    <span class="meta-text">
                      <a href="content/post.html" data-v-post-url>
                        <!-- <span data-v-post-created_at data-filter-friendly_date>December 31, 2020</span> -->
                        <span data-v-post-created_at_formatted>December 31, 2020</span>
                      </a>
                    </span>
                  </li>
                  <!--
						<li class="post-comment-link meta-wrapper">
							<span class="meta-icon">
								<i class="la la-comment"></i>
							</span>
							<span class="meta-text">
								<a href="#comments" data-v-post-comments-url><span data-v-post-comment_text>0 Comments</span></a>
							</span>
						</li>
						-->
                </ul>

                <p class="card-text text-muted" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
                <button title="{$post.name}" role="button" class="btn btn-link px-0">
                  <span>Read more</span>
                  <i class="la la-angle-right"></i>
                </button>
              </div>
            </a>
          </article>


        </div>



        <div class="col-12 col-lg-4 mb-2" data-aos="fade-up" data-aos-delay="100" data-v-post>

          <article class="card post h-100 shadow-sm border">
            <div class="card-img-top" data-v-if="post.image">
              <img src="demo/img/video-1.webp" alt="" class="w-100" loading="lazy" data-v-size="thumb" data-v-post-image>
            </div>
            <!-- Post Title -->
            <a data-v-post-url>
              <div class="card-body p-4">
                <div class="post-title card-title">
                  <h3 class="h4" data-v-post-name>
                    Vivamus sed nunc in arcu cursus mollis quis et orci. Interdum et malesuada
                  </h3>
                </div>


                <ul class="post-meta text-start mb-3 small">

                  <li class="post-author meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post author</span>
                      <i class="la la-user"></i>
                    </span>
                    <span class="meta-text">
                      By <a href="content/post.html" data-v-post-author-url>
                        <span data-v-post-display_name>admin</span>
                      </a>
                    </span>
                  </li>

                  <li class="post-date meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post date</span>

                      <i class="la la-calendar"></i>
                    </span>
                    <span class="meta-text">
                      <a href="content/post.html" data-v-post-url>
                        <!-- <span data-v-post-created_at data-filter-friendly_date>December 31, 2020</span> -->
                        <span data-v-post-created_at_formatted>December 31, 2020</span>
                      </a>
                    </span>
                  </li>
                  <!--
						<li class="post-comment-link meta-wrapper">
							<span class="meta-icon">
								<i class="la la-comment"></i>
							</span>
							<span class="meta-text">
								<a href="#comments" data-v-post-comments-url><span data-v-post-comment_text>0 Comments</span></a>
							</span>
						</li>
						-->
                </ul>

                <p class="card-text text-muted" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
                <button title="{$post.name}" role="button" class="btn btn-link px-0">
                  <span>Read more</span>
                  <i class="la la-angle-right"></i>
                </button>
              </div>
            </a>
          </article>


        </div>



        <div class="col-12 col-lg-4 mb-2" data-aos="fade-up" data-aos-delay="200" data-v-post>

          <article class="card post h-100 shadow-sm border">
            <div class="card-img-top" data-v-if="post.image">
              <img src="demo/img/video-1.webp" alt="" class="w-100" loading="lazy" data-v-size="thumb" data-v-post-image>
            </div>
            <!-- Post Title -->
            <a data-v-post-url>
              <div class="card-body p-4">
                <div class="post-title card-title">
                  <h3 class="h4" data-v-post-name>
                    Vivamus sed nunc in arcu cursus mollis quis et orci. Interdum et malesuada
                  </h3>
                </div>


                <ul class="post-meta text-start mb-3 small">

                  <li class="post-author meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post author</span>
                      <i class="la la-user"></i>
                    </span>
                    <span class="meta-text">
                      By <a href="content/post.html" data-v-post-author-url>
                        <span data-v-post-display_name>admin</span>
                      </a>
                    </span>
                  </li>

                  <li class="post-date meta-wrapper">
                    <span class="meta-icon">
                      <span class="screen-reader-text">Post date</span>

                      <i class="la la-calendar"></i>
                    </span>
                    <span class="meta-text">
                      <a href="content/post.html" data-v-post-url>
                        <!-- <span data-v-post-created_at data-filter-friendly_date>December 31, 2020</span> -->
                        <span data-v-post-created_at_formatted>December 31, 2020</span>
                      </a>
                    </span>
                  </li>
                  <!--
						<li class="post-comment-link meta-wrapper">
							<span class="meta-icon">
								<i class="la la-comment"></i>
							</span>
							<span class="meta-text">
								<a href="#comments" data-v-post-comments-url><span data-v-post-comment_text>0 Comments</span></a>
							</span>
						</li>
						-->
                </ul>

                <p class="card-text text-muted" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
                <button title="{$post.name}" role="button" class="btn btn-link px-0">
                  <span>Read more</span>
                  <i class="la la-angle-right"></i>
                </button>
              </div>
            </a>
          </article>


        </div>



      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("posts/posts-2", {
    name: "Posts 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/posts/posts-2-thumb.webp",
    html: `<section class="pt-5 pb-5" aria-label="posts-2">
  <div class="container">
    <div class="row">
      <div class="col-6">
        <h3 class="mb-3">News sections</h3>
      </div>
      <div class="col-6 text-end">
        <a class="btn btn-outline-primary mb-3 me-1" href="#carouselPosts2" role="button" data-bs-slide="prev">
          <i class="la la-arrow-left"></i>
        </a>
        <a class="btn btn-outline-primary mb-3 " href="#carouselPosts2" role="button" data-bs-slide="next">
          <i class="la la-arrow-right"></i>
        </a>
      </div>
      <div class="col-12">
        <div id="carouselPosts2" class="carousel slide" data-bs-ride="carousel">

          <div class="carousel-inner">
            <div class="carousel-item active" data-v-component-posts="slide1" data-v-limit="3" data-v-page="1" data-v-image_size="medium">
              <div class="row">

                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="day67-dog" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>

                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="day22-owl" src="demo/img/team-2.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>
                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="day68-happy-cat" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="carousel-item" data-v-component-posts="slide2" data-v-limit="3" data-v-page="2">
              <div class="row">

                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="day79-coffee" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>

                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="109-map-location" src="demo/img/team-2.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>
                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="107-healthy" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>
                  </div>
                </div>

              </div>
            </div>
            <div class="carousel-item" data-v-component-posts="slide3" data-v-limit="3" data-v-page="3">
              <div class="row">

                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="126-namaste-no-hand-shake" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>

                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="104-dumbbell" src="demo/img/team-2.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>

                    </div>
                  </div>
                </div>
                <div class="col-md-4 mb-3" data-v-post>
                  <div class="card">
                    <img class="img-fluid" loading="lazy" alt="day50-pirahna" src="demo/img/team-1.jpg" data-v-post-image>
                    <div class="card-body">
                      <a href="content/post.html" data-v-post-url>
                        <h4 class="card-title" data-v-post-name>Interdum et malesuada</h4>
                      </a>
                      <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("posts/posts-3", {
    name: "Posts 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/posts/posts-3-thumb.webp",
    html: `<section class="posts-3 py-5" aria-label="posts-3">
  <div class="container">

    <div class="row justify-content-center">

      <div class="col-md-8 text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">From Our Blog</h2>
        <p class="lead text-center text-muted mb-4">Vivamus sed nunc in arcu cursus mollis quis et orci. Interdum et malesuada.</p>
      </div>

    </div>

    <div data-v-component-posts="posts-3" data-v-limit="3" data-v-page="1" data-v-image_size="medium">
      <div class="row mt-4">

        <div class="col-md-4" data-v-post>
          <div class="card position-relative shadow border-0 mb-4" data-bs-theme="dark">
            <img class="card-img" src="demo/img/product.webp" loading="lazy" alt="product" data-v-post-image>
            <div class="card-img-overlay overflow-hidden">
              <div class="d-flex align-items-center">
                <span class="badge bg-primary text-white px-3 py-1 font-weight-normal">New</span>
                <div class="ms-2">
                  <span class="ms-2 small" data-v-post-created_at_formatted>Jan 21, 2024</span>
                </div>
              </div>
              <a href="content/post.html" class="text-body" data-v-post-url>
                <h5 class="card-title my-3 font-weight-normal" data-v-post-name>Interdum et malesuada</h5>
              </a>
              <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
            </div>
          </div>
        </div>


        <div class="col-md-4" data-v-post>
          <div class="card position-relative shadow border-0 mb-4" data-bs-theme="dark">
            <img class="card-img" src="demo/img/product.webp" loading="lazy" alt="product" data-v-post-image>
            <div class="card-img-overlay overflow-hidden">
              <div class="d-flex align-items-center">
                <span class="badge bg-primary text-white px-3 py-1 font-weight-normal">New</span>
                <div class="ms-2">
                  <span class="ms-2 small" data-v-post-created_at_formatted>Jan 21, 2024</span>
                </div>
              </div>
              <a href="content/post.html" class="text-body" data-v-post-url>
                <h5 class="card-title my-3 font-weight-normal" data-v-post-name>Interdum et malesuada</h5>
              </a>
              <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
            </div>
          </div>
        </div>


        <div class="col-md-4" data-v-post>
          <div class="card position-relative shadow border-0 mb-4" data-bs-theme="dark">
            <img class="card-img" src="demo/img/product.webp" loading="lazy" alt="product" data-v-post-image>
            <div class="card-img-overlay overflow-hidden">
              <div class="d-flex align-items-center">
                <span class="badge bg-primary text-white px-3 py-1 font-weight-normal">New</span>
                <div class="ms-2">
                  <span class="ms-2 small" data-v-post-created_at_formatted>Jan 21, 2024</span>
                </div>
              </div>
              <a href="content/post.html" class="text-body" data-v-post-url>
                <h5 class="card-title my-3 font-weight-normal" data-v-post-name>Interdum et malesuada</h5>
              </a>
              <p class="card-text" data-v-post-excerpt>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce enim nulla, mollis eu metus in, sagittis fringilla tortor. Phasellus purus dignissim convallis.</p>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Posts"] = ["posts/posts-1","posts/posts-2","posts/posts-3"];
Vvveb.Sections.add("pricing-table/pricing-table-3", {
    name: "Pricing table 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-3-thumb.webp",
    html: `<section class="pricing-table-3 my-3" aria-label="pricing-table-3">
  <div class="container">
    <div class="row justify-content-center pb-2">
      <div class="col-md-7 heading-section text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">Choose your plan</h2>
        <p class="lead text-center text-muted mb-4">14-day free trial no credit card required.</p>
      </div>
    </div>
    <div class="row">
      <div class="col-md-4">
        <div class="price my-5-col shadow-sm border rounded-3" data-aos="fade-up">
          <!--
                    <div class="img"><img src="demo/img/illustrations.co/104-dumbbell.svg" alt="104-dumbbell" loading="lazy" class="img-fluid" /></div>
                    -->
          <div class="text-center p-5">
            <span class="excerpt d-block">Personal</span>
            <span class="price my-5">
              <sup>$</sup>
              <span class="number">49</span>
              <sub>/mos</sub>
            </span>
            <ul class="pricing-text mb-5">
              <li>
                <span class="la la-check me-2"></span>5 Dog Walk
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Vet Visit
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Pet Spa
              </li>
              <li>
                <span class="la la-check me-2"></span>Free Support
              </li>
            </ul>
            <a href="/page/pricing" class="btn btn-primary">
              <span>Get Started</span>
              <i class="la la-long-arrow-alt-right ms-1"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="price my-5-col shadow-sm border rounded-3" data-aos="fade-up" data-aos-delay="200">
          <!--
                    <div class="img"><img src="demo/img/illustrations.co/107-healthy.svg" alt="107-healthy" loading="lazy" class="img-fluid" /></div>
                    -->
          <div class="text-center p-5">
            <span class="excerpt d-block">Business</span>
            <span class="price my-5">
              <sup>$</sup>
              <span class="number">79</span>
              <sub>/mos</sub>
            </span>
            <ul class="pricing-text mb-5">
              <li>
                <span class="la la-check me-2"></span>5 Dog Walk
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Vet Visit
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Pet Spa
              </li>
              <li>
                <span class="la la-check me-2"></span>Free Support
              </li>
            </ul>
            <a href="/page/pricing" class="btn btn-primary">
              <span>Get Started</span>
              <i class="la la-long-arrow-alt-right ms-1"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-md-4">
        <div class="price my-5-col shadow-sm border rounded-3" data-aos="fade-up" data-aos-delay="400">
          <!--
                    <div class="img"><img src="demo/img/illustrations.co/126-namaste-no-hand-shake.svg" alt="126-namaste-no-hand-shake" loading="lazy" class="img-fluid" /></div>
                    -->
          <div class="text-center p-5">
            <span class="excerpt d-block">Ultimate</span>
            <span class="price my-5">
              <sup>$</sup>
              <span class="number">109</span>
              <sub>/mos</sub>
            </span>
            <ul class="pricing-text mb-5">
              <li>
                <span class="la la-check me-2"></span>5 Dog Walk
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Vet Visit
              </li>
              <li>
                <span class="la la-check me-2"></span>3 Pet Spa
              </li>
              <li>
                <span class="la la-check me-2"></span>Free Support
              </li>
            </ul>
            <a href="/page/pricing" class="btn btn-primary">
              <span>Get Started</span>
              <i class="la la-long-arrow-alt-right ms-1"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-4", {
    name: "Pricing table 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-4-thumb.webp",
    html: `<section class="pricing-table-4 my-3" aria-label="pricing-table-4">
  <div class="container py-4 py-lg-6">
    <div class="row g-4  ">
      <div class="col-lg-4 col-xl-5">
        <div class="  card h-100 px-xl-3 border-0 py-lg-4 " style="" id="">
          <div class=" mb-2">
            <div editable="rich">
              <h1 class="fw-bolder">Our Plans</h1>
            </div>
          </div>
          <div class="">
            <div editable="rich">
              <p class="lead text-dark">Lorem ipsum dolor sit amet.</p>
            </div>
          </div>
          <div class="">
            <div editable="rich">
              <p>Lorem ipsum dolor sit amet, consectetur adipisicing elit. Aliquid quasi, blanditiis sed!
                <br>Facere laborum debitis veritatis vel ex enim, eligendi distinctio, quidem esse accusantium amet facilis dolore ea impedit alias..
              </p>
            </div>
          </div>
          <div class=" bg-primary">
            <img style="mix-blend-mode:overlay" class="img-fluid" src="demo/img/team-1.jpg" alt="Team 2" loading="lazy">
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-xl-3 ms-auto text-center my-lg-auto">
        <div class=" card px-xl-3 border py-lg-4" style="" id="">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class=" mb-4">
                <div editable="rich">
                  <h3>Basic</h3>
                </div>
              </div>
              <div class=" mb-4 bg-light text-dark rounded py-3 ">
                <h3 editable="inline" class="fw-bolder d-inline small">$</h3>
                <h3 editable="inline" class="fw-bolder d-inline rfs-30 ls-n2">19</h3>
                <span class="opacity-50" editable="inline">/ Year</span>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>

            </div>
            <div class=" d-grid">
              <a class="btn btn-primary" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-xl-3 text-center">
        <div class=" card h-100 px-xl-3 border py-lg-5" style="" id="">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class=" mb-4">
                <div editable="rich">
                  <h3>Professional</h3>
                </div>
              </div>
              <div class=" mb-4 bg-light text-dark rounded py-3 ">
                <h3 editable="inline" class="fw-bolder d-inline small">$</h3>
                <h3 editable="inline" class="fw-bolder d-inline rfs-30 ls-n2">149</h3>
                <span class="opacity-50" editable="inline">/ Year</span>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>
              <div class=" mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div editable="rich">
                    <p class="text-start">Consectetur similique</p>
                  </div>
                </div>
              </div>

            </div>
            <div class=" d-grid">
              <a class="btn btn-primary" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-5", {
    name: "Pricing table 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-5-thumb.webp",
    html: `<section class="pricing-table-5 my-3" aria-label="pricing-table-5">
  <div class="container py-4">
    <div class="row mb-4 align-items-center">
      <div class="col-lg-6 col-xl-5">
        <div class=" ">
          <div>
            <h2 class="fw-bolder">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</h2>
          </div>
        </div>
      </div>
      <div class="col-lg-6 offset-xl-1">
        <div class=" opacity-50">
          <div>
            <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit.&nbsp;</p>
          </div>
        </div>
      </div>
    </div>

    <div class="row g-4 g-xxl-5">
      <div class="col-lg-4">
        <div class=" card h-100 p-4 py-xl-6 shadow border-0">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class=" mb-2">
                <div>
                  <p class="opacity-50 mb-0 ls-3">Basic</p>

                </div>
              </div>
              <div class=" mb-4">
                <h3 editable="inline" class="fw-bolder d-inline rfs-30 ls-n2">$29</h3>
                <span class="opacity-50" editable="inline">/ month</span>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Nunc et metus id ligula malesuada placerat sit amet quis enim.</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Aliquam erat volutpat.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p class="text-decoration-line-through"> In pellentesque scelerisque auctor.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p class="text-decoration-line-through"> Ut porta lacus eget nisi fermentum lobortis.</p>
                </div>
              </div>

            </div>
            <div class="d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 ">
        <div class=" card h-100 p-4 py-xl-6 shadow border-0 bg-dark text-light">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class=" mb-2">
                <div>
                  <p class="opacity-50 mb-0 ls-3">Standard</p>

                </div>
              </div>
              <div class=" mb-4">
                <h3 editable="inline" class="fw-bolder d-inline rfs-30 ls-n2">$59</h3>
                <span class="opacity-50" editable="inline">/ month</span>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Nunc et metus id ligula malesuada placerat sit amet quis enim.</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Aliquam erat volutpat.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> In pellentesque scelerisque auctor.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p class="text-decoration-line-through"> Ut porta lacus eget nisi fermentum lobortis.</p>
                </div>
              </div>





            </div>
            <div class=" d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>

      <div class="col-lg-4">
        <div class=" card h-100 p-4 py-xl-6 shadow border-0">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class=" mb-2">
                <div>
                  <p class="opacity-50 mb-0 ls-3">Premium</p>

                </div>
              </div>
              <div class=" mb-4">
                <h3 editable="inline" class="fw-bolder d-inline rfs-30 ls-n2">$199</h3>
                <span class="opacity-50" editable="inline">/ month</span>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Nunc et metus id ligula malesuada placerat sit amet quis enim.</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Aliquam erat volutpat.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> In pellentesque scelerisque auctor.&nbsp;</p>
                </div>
              </div>
              <div class=" mb-2">
                <div>
                  <p> Ut porta lacus eget nisi fermentum lobortis.</p>
                </div>
              </div>





            </div>
            <div class=" d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-6", {
    name: "Pricing table 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-6-thumb.webp",
    html: `<section class="pricing-table-6 my-3" aria-label="pricing-table-6">
  <div class="container py-4">

    <div class="row g-4 g-xxl-5">
      <div class="col-lg-4 text-center">
        <div class="card h-100 p-4" style="">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class="border-bottom border-4 mb-4">
                <div>
                  <p class="opacity-50 mb-0 ls-3">SINGLE</p>
                  <h2 class="fw-bolder h4">Basic plan</h2>
                </div>
              </div>
              <div class="mb-4">
                <div>

                  <h3 class="fw-bolder rfs-40">
                    <span class="h2 align-top">$</span>29
                  </h3>



                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Consectetur similique repellat ex doloribus error</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start text-decoration-line-through">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start text-decoration-line-through">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>


            </div>
            <div class="d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 text-center">
        <div class="card h-100 p-4">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class="border-bottom border-4 mb-4">
                <div>
                  <p class="opacity-50 mb-0 ls-3">TEAM</p>
                  <h2 class="fw-bolder h4">Pro plan</h2>
                </div>
              </div>
              <div class="mb-4">
                <div>

                  <h3 class="fw-bolder rfs-40">
                    <span class="h2 align-top">$</span>99
                  </h3>



                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Consectetur similique repellat ex doloribus error</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start text-decoration-line-through">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>


            </div>
            <div class="d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>

      <div class="col-lg-4 text-center">
        <div class="card h-100 p-4">
          <div class="card-body d-flex flex-column justify-content-between">
            <div>
              <div class="border-bottom border-4 mb-4">
                <div>
                  <p class="opacity-50 mb-0 ls-3">ENTERPRISE</p>
                  <h2 class="fw-bolder h4">Pro plan</h2>
                </div>
              </div>
              <div class="mb-4">
                <div>

                  <h3 class="fw-bolder rfs-40">
                    <span class="h2 align-top">$</span>219
                  </h3>



                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Lorem ipsum dolor sit amet, consectetur adipisicing elit.</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Consectetur similique repellat ex doloribus error</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start  ">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start">Cupiditate, quidem magnam quaerat molestiae.</p>
                  </div>
                </div>
              </div>
              <div class="mb-2">
                <div class="d-inline-flex w-100 gap-2 ">
                  <div>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="1em" height="1em" viewBox="0 0 24 24" lc-helper="svg-icon" fill="currentColor" class="text-primary">
                      <path d="M9,20.42L2.79,14.21L5.62,11.38L9,14.77L18.88,4.88L21.71,7.71L9,20.42Z"></path>
                    </svg>
                  </div>

                  <div>
                    <p class="text-start  ">Assumenda fuga suscipit aliquam illum aut voluptas atque laborum</p>
                  </div>
                </div>
              </div>


            </div>
            <div class="d-grid">
              <a class="btn btn-primary btn-lg" href="#" role="button">Subscribe</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>

</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-7", {
    name: "Pricing table 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-7-thumb.webp",
    html: `<section class="pricing-table-7 my-3" aria-label="pricing-table-7">
  <div class="container py-5 overflow-hidden">
    <div class="row mb-5 pb-2">
      <div class="col-md-12 text-center">
        <div class="mb-4">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">Pricing</h2>
          <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row justify-content-center pt-2 pb-4">
      <div class="col-12 col-lg-4">
        <div class="text-center rounded border shadow-sm py-5 mb-5">
          <div class="text-center">
            <img src="demo/img/team-1.jpg" alt="Team 1" style="" loading="lazy" class="w-50 mb-2 rounded-4">
          </div>
          <div class="text-center">
            <div editable="rich">
              <h2>Personal</h2>
            </div>
          </div>
          <div class="text-center small">
            <div editable="rich">
              <p>Perfect for
                <strong>designers</strong>
              </p>
            </div>
          </div>
          <div class="text-center text-primary display-4">
            <p>
              <span>
                <b>$79</b>
              </span>
              <span class="lead">/ per year</span>
            </p>
          </div>
          <div class="">
            <ul class="list-unstyled mt-3 mb-4">
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Build Unlimited Websites</span>
              </li>
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Updates for 1 Year</span>
              </li>
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Support for 1 Year</span>
              </li>
            </ul>
          </div>
          <div class="" style="z-index:4">
            <a class="btn btn-outline-primary" href="#" role="button">Sign Up</a>
          </div>
        </div>
      </div>
      <!-- Single Price Plan Area -->
      <div class="col-12 col-lg-4" style="z-index: 5;">
        <div class="text-center mb-5 py-5 shadow bg-white shadow-lg text-dark" style="border-radius: 12px;z-index: 2;transform: scale(1.2);">
          <div class="text-center">
            <img src="demo/img/team-2.jpg" alt="Team 2" style="" loading="lazy" class="w-50 mb-2 rounded-4">
          </div>
          <div class="text-center">
            <div editable="rich">
              <h2>Business</h2>
            </div>
          </div>
          <div class="text-center small">
            <div editable="rich">
              <p>Perfect for
                <strong>agency</strong>
              </p>
            </div>
          </div>
          <div class="text-center text-primary display-4">
            <p>
              <span>
                <b>$199</b>
              </span>
              <span class="lead">/ per year</span>
            </p>
          </div>
          <div class="">
            <ul class="list-unstyled mt-3 mb-4">
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Build Unlimited Websites</span>
              </li>
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Updates for 1 Year</span>
              </li>
              <li class="py-2">
                <svg viewBox="0 0 16 16" class="text-success" fill="currentColor" xmlns="http://www.w3.org/2000/svg" lc-helper="svg-icon" width="2em" height="2em">
                  <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093 3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                </svg>
                <span>Support for 1 Year</span>
              </li>
            </ul>
          </div>
          <div class="" style="z-index:4">
            <a class="btn btn-outline-primary" href="#" role="button">Sign Up</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-8", {
    name: "Pricing table 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-8-thumb.webp",
    html: `<section class="pricing-table-8 my-3" aria-label="pricing-table-8">
  <div class="container py-4">
    <div class="row">
      <div class="col-md-12">
        <div class="text-center">
          <div>
            <h2>Pricing</h2>
            <p class="lead">We offer flexible pricing options for freelancers and design teams.</p>
          </div>
        </div>
      </div>
    </div>

    <div class="row align-items-start g-0">
      <div class="col-lg-3 text-center border mb-4 mb-lg-0">
        <div class="pt-4 px-md-4 border-bottom">

          <div class="">
            <div>
              <h2>Free</h2>
            </div>
          </div>
          <div class="mb-5">
            <div>
              <p class="lead">Forever Free</p>
            </div>
          </div>
          <div class="mb-4">
            <div class="d-flex justify-content-center">
              <div>
                <p>$</p>
              </div>
              <div>
                <p class="display-1">0</p>
              </div>
            </div>
          </div>
          <div class="">
            <a class="btn mb-4 btn-outline-primary" href="#" role="button">Start for free</a>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p> 1 GB of Space
              </p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 text-center border mb-4 mb-lg-0">
        <div class="pt-4 px-md-4 border-bottom">

          <div class="">
            <div>
              <h2>Starter</h2>
            </div>
          </div>
          <div class="mb-5">
            <div>
              <p class="lead">Basic</p>
            </div>
          </div>
          <div class="mb-4">
            <div class="d-flex justify-content-center">
              <div>
                <p>$</p>
              </div>
              <div>
                <p class="display-1">9</p>
              </div>
            </div>
          </div>
          <div class="">
            <a class="btn btn-primary mb-4" href="#" role="button">Buy now</a>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>5 GB of Space
              </p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>Unlimited Projects&nbsp;</p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>1 Users&nbsp;</p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 text-center border mb-4 mb-lg-0">
        <div class="pt-4 px-md-4 border-bottom">

          <div class="">
            <div>
              <h2>Pro</h2>
            </div>
          </div>
          <div class="mb-5">
            <div>
              <p class="lead">Best value</p>
            </div>
          </div>
          <div class="mb-4">
            <div class="d-flex justify-content-center">
              <div>
                <p>$</p>
              </div>
              <div>
                <p class="display-1">29</p>
              </div>
            </div>
          </div>
          <div class="">
            <a class="btn btn-primary mb-4" href="#" role="button">Buy now</a>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>20 GB of Space
              </p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p> Unlimited Projects
              </p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>5 Users
              </p>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 text-center border">
        <div class="pt-4 px-md-4 border-bottom">

          <div class="">
            <div>
              <h2>Agency</h2>
            </div>
          </div>
          <div class="mb-5">
            <div>
              <p class="lead">Enterprise</p>
            </div>
          </div>
          <div class="mb-4">
            <div class="d-flex justify-content-center">
              <div>
                <p>$</p>
              </div>
              <div>
                <p class="display-1">199</p>
              </div>
            </div>
          </div>
          <div class="">
            <a class="btn btn-primary mb-4" href="#" role="button">Buy now</a>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>Unlimited Space</p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p> Unlimited Projects
              </p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p> Unlimited Users</p>
            </div>
          </div>
        </div>
        <div class="pt-4 px-md-4 border-bottom">
          <div class="">
            <div>
              <p>Access to Cloud</p>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-9", {
    name: "Pricing table 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-9-thumb.webp",
    html: `<section class="pricing-table-9 my-3" aria-label="pricing-table-9">
  <div class="container py-4">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="mb-4">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Pricing</b>
          </h2>
          <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-4">
      <div class="text-center col-md-6 py-5 bg-light text-dark">
        <div class="">
          <div editable="rich">

            <h2>
              <strong>Basic</strong>
            </h2>

            <p>
              <em>1 USER</em>
            </p>
          </div>
        </div>
        <div class="">
          <div editable="rich">

            <h2 class="display-3">$59</h2>
            <p>/month</p>
          </div>
        </div>
        <div class="px-4 mb-4">
          <div editable="rich">

            <p>&nbsp;Aenean vel nisi in ipsum congue fermentum et ut arcu. Proin leo diam,
              vulputate eu tellus ac, mattis cursus nunc.</p>
          </div>
        </div>
        <div class="">
          <a class="btn btn-outline-primary" href="#" role="button">Buy Now</a>
        </div>
      </div>
      <div class="text-center col-md-6 py-5 shadow-lg">
        <div class="">
          <div editable="rich">

            <h2>
              <strong>Business</strong>
            </h2>

            <p>
              <em>100 USERs</em>
            </p>
          </div>
        </div>
        <div class="">
          <div editable="rich">

            <h2 class="display-3">$199</h2>
            <p>/month</p>
          </div>
        </div>
        <div class="px-4 mb-4">
          <div editable="rich">

            <p>&nbsp;Aenean vel nisi in ipsum congue fermentum et ut arcu. Proin leo diam,
              vulputate eu tellus ac, mattis cursus nunc.</p>
          </div>
        </div>
        <div class="">
          <a class="btn btn-outline-primary" href="#" role="button">Buy Now</a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-10", {
    name: "Pricing table 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-10-thumb.webp",
    html: `<section class="pricing-table-1 my-3" aria-label="pricing-table-10">
  <div class="container py-4">
    <div class="row mb-5">
      <div class="col-12">
        <div class="text-center">
          <div>
            <h2 class="">Our menu</h2>
            Lorem ipsum dolor sit amet, consectetur adipiscing elit. Suspendisse a lacus est.
          </div>
        </div>
      </div>
    </div>
    <!-- Menu Items -->
    <div class="row row-cols-1 row-cols-lg-2 g-4 g-xxl-5">
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex d-sm-block flex-shrink-0 col-sm-3">
            <img class="position-relative img-fluid" src="demo/img/team-1.jpg" alt="Team 1">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Caesar Salad</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$10</strong>

              </div>
            </div>
            <div class="opacity-50">

              Classic Caesar with romaine lettuce, parmesan cheese, croutons, and creamy dressing.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex d-sm-block flex-shrink-0 col-sm-3">
            <img class="position-relative img-fluid" src="demo/img/team-2.jpg" alt="Team 2">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Margherita Pizza</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$15</strong>

              </div>
            </div>
            <div class="opacity-50">

              Traditional Italian pizza with tomato, mozzarella, fresh basil, and extra virgin olive oil.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-1.jpg" alt="Team 1">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">BBQ Ribs</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$24</strong>

              </div>
            </div>
            <div class="opacity-50">

              Slow-cooked pork ribs glazed with our signature BBQ sauce, served with fries and coleslaw.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-2.jpg" alt="Team 2">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Pasta Primavera</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$14</strong>

              </div>
            </div>
            <div class="opacity-50">

              Fresh garden vegetables tossed with penne pasta in a light garlic and olive oil sauce.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-1.jpg" alt="Team 1">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Chocolate Cake</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$7</strong>

              </div>
            </div>
            <div class="opacity-50">

              Rich and moist chocolate cake with a smooth chocolate ganache frosting.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-2.jpg" alt="Team 2">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Craft Beer</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$5</strong>

              </div>
            </div>
            <div class="opacity-50">

              A selection of local and imported craft beers, served chilled.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-1.jpg" alt="Team 1">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Mushroom Risotto with truffle cream.</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$16</strong>

              </div>
            </div>
            <div class="opacity-50">

              Creamy risotto enriched with porcini mushrooms and finished with black truffle.

            </div>
          </div>
        </div>
      </div>
      <div class="col">
        <div class="d-grid d-sm-flex gap-3 gap-xl-4">
          <div class="d-flex col-sm-3 d-sm-block flex-shrink-0">
            <img class="position-relative img-fluid" src="demo/img/team-2.jpg" alt="Team 2">
          </div>
          <div class="w-100">
            <div class="d-flex gap-2 align-items-baseline">
              <div>
                <h3 class="h5 fw-bold">Panna Cotta</h3>
              </div>
              <div class="flex-grow-1 border-dashed opacity-25"></div>
              <div>

                <strong class="h5">$9</strong>

              </div>
            </div>
            <div class="opacity-50">

              Light and creamy spoon dessert with berry coulis.

            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-11", {
    name: "Pricing table 11",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-11-thumb.webp",
    html: `<section class="pricing-table-11 my-3" aria-label="pricing-table-11">
  <div class="container pb-5">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class=" mb-4">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Pricing</b>
          </h2>
          <p editable="inline"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-4 text-center">
      <div class="col-lg-3 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0 " editable="inline">Free</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$0</b>
              </span>
              <span class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li editable="inline">10 users included</li>
                  <li editable="inline">2 GB of storage</li>
                  <li editable="inline">Email support</li>
                  <li editable="inline">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg  btn-outline-primary">Sign up for free</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0" editable="inline">Pro</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$15</b>
              </span>
              <span class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li class="">20 users included</li>
                  <li class="">10 GB of storage</li>
                  <li class="">Priority email support</li>
                  <li class="">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg  btn-primary">Contact us</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0" editable="inline">Enterprise</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$29</b>
              </span>
              <span class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li class="">30 users included</li>
                  <li class="">15 GB of storage</li>
                  <li class="">Phone and email support</li>
                  <li class="">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg  btn-primary">Contact us</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-3 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0" editable="inline">Exclusive</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$49</b>
              </span>
              <span class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li class="">50 users included</li>
                  <li class="">45 GB of storage</li>
                  <li class="">Phone and email support</li>
                  <li editable="inline">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg  btn-primary">Contact us</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-12", {
    name: "Pricing table 12",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-12-thumb.webp",
    html: `<section class="pricing-table-12 my-3" aria-label="pricing-table-12">
  <div class="container py-4">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class=" mb-4">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Pricing</b>
          </h2>
          <p editable="inline"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-4">
      <div class="text-center col-md-3 py-4 shadow-sm">
        <div class="">
          <div>

            <h2>
              <strong>Basic</strong>
            </h2>

            <p>
              <em>1 USER</em>
            </p>
          </div>
        </div>
        <div class="">
          <div>

            <h2 class="display-3">$59</h2>
            <p>/month</p>
          </div>
        </div>
        <div class=" px-4 mb-4">
          <div>

            <p>&nbsp;Aenean vel nisi in ipsum congue fermentum et ut arcu. Proin leo diam,
              vulputate eu tellus ac, mattis cursus nunc.</p>
          </div>
        </div>
        <div class="">
          <a class="btn btn-outline-primary" href="#" role="button">Buy Now</a>
        </div>
      </div>
      <div class="text-center col-md-4 offset-md-1 pb-4 pt-2 shadow-lg">
        <div class=" text-end pb-2  ">
          <span class="badge bg-dark" editable="inline">Popular</span>
        </div>


        <div class="">
          <div>

            <h2 class="display-3">
              <strong>Pro</strong>
            </h2>

            <p>
              <em>100 USER</em>
            </p>
          </div>
        </div>
        <div class="">
          <div>

            <h2 class="display-3">$79</h2>
            <p>/month</p>
          </div>
        </div>
        <div class=" px-4 mb-4">
          <div>

            <p>&nbsp;Aenean vel nisi in ipsum congue fermentum et ut arcu. Proin leo diam,
              vulputate eu tellus ac, mattis cursus nunc.</p>
          </div>
        </div>
        <div class="">
          <a class="btn btn-outline-primary" href="#" role="button">Buy Now</a>
        </div>
      </div>
      <div class="text-center col-md-3 offset-md-1 py-4 shadow-sm">
        <div class="">
          <div>

            <h2>
              <strong>Business</strong>
            </h2>

            <p>
              <em>UNLIMITED</em>
            </p>
          </div>
        </div>
        <div class="">
          <div>

            <h2 class="display-3">$199</h2>
            <p>/month</p>
          </div>
        </div>
        <div class=" px-4 mb-4">
          <div>

            <p>&nbsp;Aenean vel nisi in ipsum congue fermentum et ut arcu. Proin leo diam,
              vulputate eu tellus ac, mattis cursus nunc.</p>
          </div>
        </div>
        <div class="">
          <a class="btn btn-outline-primary" href="#" role="button">Buy Now</a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-13", {
    name: "Pricing table 13",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-13-thumb.webp",
    html: `<section class="pricing-table-13 my-3" aria-label="pricing-table-13">
  <div class="container pb-5">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="mb-4">
          <span editable="inline" class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 editable="inline" class="display-2 mb-0">
            <b>Pricing</b>
          </h2>
          <p editable="inline"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-4 text-center">
      <div class="col-lg-4 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0 " editable="inline">Free</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$0</b>
              </span>
              <span editable="inline" class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li editable="inline">10 users included</li>
                  <li editable="inline">2 GB of storage</li>
                  <li editable="inline">Email support</li>
                  <li editable="inline">Help center access</li>
                </ul>

              </div>
            </div>

            <div class="d-grid ">
              <a href="#" class="btn btn-lg btn-outline-primary">Sign up for free</a>
            </div>

          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0" editable="inline">Pro</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$15</b>
              </span>
              <span editable="inline" class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li editable="inline" class="">20 users included</li>
                  <li editable="inline" class="">10 GB of storage</li>
                  <li editable="inline" class="">Priority email support</li>
                  <li editable="inline" class="">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg btn-primary">Contact us</a>
            </div>
          </div>
        </div>
      </div>
      <div class="col-lg-4 col-md-6 text-dark my-2">
        <div class="card">
          <div class="card-header">
            <h4 class="my-0" editable="inline">Enterprise</h4>
          </div>
          <div class="card-body">
            <h5 class="card-title">
              <span class="display-4" editable="inline">
                <b>$29</b>
              </span>
              <span editable="inline" class="lead">/mo</span>
            </h5>

            <div class="card-text my-4 ">
              <div editable="rich">
                <ul class="list-unstyled">

                  <li editable="inline" class="">30 users included</li>
                  <li editable="inline" class="">15 GB of storage</li>
                  <li editable="inline" class="">Phone and email support</li>
                  <li editable="inline" class="">Help center access</li>
                </ul>

              </div>
            </div>
            <div class="d-grid ">
              <a href="#" class="btn btn-lg btn-primary">Contact us</a>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("pricing-table/pricing-table-14", {
    name: "Pricing table 14",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/pricing-table/pricing-table-14-thumb.webp",
    html: `<section class="pricing-table-14 my-3" aria-label="pricing-table-14">
  <div class="container py-4">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="mb-4">
          <span editable="inline" class="mt-4 d-block lead">OUR PRICING PLANS</span>
          <h2 editable="inline" class="display-2 mb-3">
            <b>Find the Right Tier.</b>
          </h2>
          <p editable="inline" class="text-secondary">Flexible pricing options for freelancers and design teams. No Credit Card required!
            <br>
          </p>
        </div>
      </div>
    </div>
    <div class="row mt-4" id="pricing">
      <div class="col-lg-4 mb-4 mb-lg-0">
        <div class="py-3 shadow-sm bg-dark text-white rounded">

          <div class="mb-4 text-left px-4">
            <svg class="text-warning" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" width="2em" height="2em" viewBox="0 0 24 24" style="" lc-helper="svg-icon" fill="currentColor">
              <path d="M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M7.07,18.28C7.5,17.38 10.12,16.5 12,16.5C13.88,16.5 16.5,17.38 16.93,18.28C15.57,19.36 13.86,20 12,20C10.14,20 8.43,19.36 7.07,18.28M18.36,16.83C16.93,15.09 13.46,14.5 12,14.5C10.54,14.5 7.07,15.09 5.64,16.83C4.62,15.5 4,13.82 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,13.82 19.38,15.5 18.36,16.83M12,6C10.06,6 8.5,7.56 8.5,9.5C8.5,11.44 10.06,13 12,13C13.94,13 15.5,11.44 15.5,9.5C15.5,7.56 13.94,6 12,6M12,11A1.5,1.5 0 0,1 10.5,9.5A1.5,1.5 0 0,1 12,8A1.5,1.5 0 0,1 13.5,9.5A1.5,1.5 0 0,1 12,11Z"></path>
            </svg>

            <span editable="inline" class="ml-2 fw-light">Individual</span>
          </div>
          <div class="mb-5 px-4">
            <div editable="rich">
              <h2 class="text-light">Professional</h2>

              <p class="h5">$19.99 <span class="text-secondary fw-light">/month</span>
              </p>
            </div>
          </div>

          <div class="mb-5 text-left">
            <div editable="rich">

              <ul>
                <li>1 users</li>
                <li>20 TB of secure storage</li>
                <li>Premium productivity features and simple, secure file sharing</li>
              </ul>
            </div>
          </div>
          <div class="mb-4 text-center">
            <a class="btn btn-outline-primary " href="#" role="button">Try free for 30 days</a>
          </div>
        </div>
      </div>

      <div class="col-lg-4 mb-4 mb-lg-0">
        <div class="py-3 rounded shadow">
          <div class="mb-4 text-left px-4">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="text-primary" width="2em" height="2em" viewBox="0 0 24 24" style="" lc-helper="svg-icon" fill="currentColor">
              <path d="M19 17V19H7V17S7 13 13 13 19 17 19 17M16 8A3 3 0 1 0 13 11A3 3 0 0 0 16 8M19.2 13.06A5.6 5.6 0 0 1 21 17V19H24V17S24 13.55 19.2 13.06M18 5A2.91 2.91 0 0 0 17.11 5.14A5 5 0 0 1 17.11 10.86A2.91 2.91 0 0 0 18 11A3 3 0 0 0 18 5M7.34 8.92L8.5 10.33L3.75 15.08L1 12.08L2.16 10.92L3.75 12.5L7.34 8.92"></path>
            </svg>

            <span editable="inline" class="ml-2 fw-light">Small Team</span>
          </div>
          <div class="mb-5 px-4">
            <div editable="rich">
              <h2 class=" ">Standard</h2>

              <p class="h5 text-primary">$39.99 <span class="text-secondary fw-light">/month</span>
              </p>
            </div>
          </div>

          <div class="mb-5 text-left">
            <div editable="rich">

              <ul>
                <li> 2 users</li>
                <li> 20 TB of secure storage</li>
                <li> Premium productivity features and simple, secure file sharing</li>
              </ul>
            </div>
          </div>
          <div class="mb-4 text-center">
            <a class="btn btn-outline-primary " href="#" role="button">Try free for 30 days</a>
          </div>
        </div>
      </div>
      <div class="col-lg-4 ">
        <div class="py-3 rounded border">
          <div class="mb-4 text-left px-4">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" class="text-primary" width="2em" height="2em" viewBox="0 0 24 24" style="" lc-helper="svg-icon" fill="currentColor">
              <path d="M5,3V21H11V17.5H13V21H19V3H5M7,5H9V7H7V5M11,5H13V7H11V5M15,5H17V7H15V5M7,9H9V11H7V9M11,9H13V11H11V9M15,9H17V11H15V9M7,13H9V15H7V13M11,13H13V15H11V13M15,13H17V15H15V13M7,17H9V19H7V17M15,17H17V19H15V17Z"></path>
            </svg>

            <span editable="inline" class="ml-2 fw-light">Large Team</span>
          </div>
          <div class="mb-5 px-4">
            <div editable="rich">
              <h2 class=" ">Ultimate</h2>

              <p class="h5 text-primary">$99.99 <span class="text-secondary fw-lighter">/month</span>
              </p>
            </div>
          </div>

          <div class="mb-5 text-left">
            <div editable="rich">

              <ul>
                <li>+20 users</li>
                <li>100 TB of secure storage</li>
                <li> Premium productivity features and simple, secure file sharing</li>
              </ul>
            </div>
          </div>
          <div class="mb-4 text-center">
            <a class="btn btn-outline-primary" href="#" role="button">Try free for 30 days</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Pricing table"] = ["pricing-table/pricing-table-3","pricing-table/pricing-table-4","pricing-table/pricing-table-5","pricing-table/pricing-table-6","pricing-table/pricing-table-7","pricing-table/pricing-table-8","pricing-table/pricing-table-9","pricing-table/pricing-table-10","pricing-table/pricing-table-11","pricing-table/pricing-table-12","pricing-table/pricing-table-13","pricing-table/pricing-table-14"];
Vvveb.Sections.add("products/products-1", {
    name: "Products 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/products/products-1-thumb.webp",
    html: `<section class="products-1" aria-label="products-1">
  <div class="container">
    <div class="row">
      <div class="col-12">
        <div class="section-heading text-center">
          <h2 class="text-center display-6 mb-1 fw-bold">Latest Products</h2>
          <p class="lead text-center text-muted mb-4">Best quality at the lowest price.</p>
        </div>
      </div>
    </div>
  </div>


  <div class="container" data-v-component-products="latest" data-v-limit="8" data-v-variant_price="true" data-v-image_size="medium">
    <div class="row">



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="000" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="100" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="200" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="300" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="400" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="500" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="600" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



      <div class="col-md-3" data-aos="fade-up" data-aos-delay="700" data-v-product>

        <article class="single-product-wrapper">
          <!-- Product Image -->
          <a href="product/product.html" data-v-product-url> </a>
          <div class="product-image">
            <a href="product/product.html" data-v-product-url>

              <img src="demo/img/product.webp" loading="lazy" data-v-product-alt alt="" data-v-size="thumb" loading="lazy" data-v-if="prod.image" data-v-product-image />
              <img src="/media/placeholder.svg" class="bg-body-tertiary" loading="lazy" alt="" data-v-if-not="prod.image" />

              <!-- Hover Thumb -->
              <img class="hover-img" src="demo/img/product-2.webp" loading="lazy" data-v-product-alt alt="" loading="lazy" data-v-size="thumb" data-v-product-image-1 />
            </a>


            <!-- Favourite -->
            <div class="product-favourite">
              <a href="product/product.html" class="la la-heart" data-v-vvveb-action="addToWishlist" data-v-product-add_wishlist_url>
                <span></span>
              </a>
            </div>

            <!-- Compare -->
            <div class="product-compare">
              <a href="product/product.html" class="la la-random" data-v-vvveb-action="addToCompare" data-v-product-add_compare_url>
                <span></span>
              </a>
            </div>

            <div class="badges">
              <span class="badge text-bg-secondary" data-v-if="prod.old_price > 0">Sale</span>
            </div>
          </div>

          <!-- Product Description -->
          <div class="product-content">

            <a href="product/product.html" class="text-body" data-v-product-url>
              <span data-v-product-name>Product 8</span>
            </a>

            <p data-v-if="prod.min_price > 0">
              <span class="text-muted small">From</span>
              <span class="product-price" data-v-product-min_price_tax_formatted>100.0000</span>
            </p>

            <div data-v-if-not="prod.min_price">
              <p class="product-price old-price" data-v-if="prod.old_price > 0" data-v-product-old_price_tax_formatted>100.0000</p>
              <p class="product-price" data-v-if="prod.price > 0" data-v-product-price_tax_formatted>100.0000</p>
            </div>

            <!-- Hover Content -->
            <div class="hover-content" data-v-if="prod.price > 0 && !prod.has_variants">
              <!-- Add to Cart -->
              <div class="add-to-cart-btn">
                <input type="hidden" name="product_id" value="" data-v-product-product_id />

                <a href="#" class="btn btn-secondary btn-sm w-100 disabled" data-v-if="prod.stock_quantity < 1">
                  <span class="button-text">
                    Out of stock
                  </span>
                </a>

                <a href="" class="btn btn-primary btn-sm w-100" data-v-if="prod.stock_quantity > 0" data-v-product-add_cart_url data-v-vvveb-action="addToCart" data-product_id="1">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true"> </span>
                    <span>Add to cart</span>
                  </span>

                  <span class="button-text">
                    <i class="la la-lg la-shopping-bag"></i>
                    <span>Add to cart</span>
                  </span>

                </a>
              </div>
            </div>

          </div>
        </article>


      </div>



    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Products"] = ["products/products-1"];
Vvveb.Sections.add("showcase/showcase-1", {
    name: "Showcase 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-1-thumb.webp",
    html: `<section class="d-flex showcase-1" aria-label="showcase-1">
  <div class="container">
    <div class="row align-items-center w-100">
      <div class="col-md-6 col-sm-12">
        <h3>Drag and drop builder</h3>
        <p class="lead">Unlimited design powers with an easy to use interface, change anything on your website with a few clicks.</p>
        <a href="content/post.html">
          <span>Learn more</span>
          <i class="la la-long-arrow-alt-right ms-1"></i>
        </a>
      </div>
      <div class="col-md-6 col-sm-12 col-img">
        <img class="img-fluid" loading="lazy" src="demo/img/illustrations.co/126-namaste-no-hand-shake.svg" alt="namaste">
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-2", {
    name: "Showcase 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-2-thumb.webp",
    html: `<section class="d-flex showcase-2" aria-label="showcase-2">
  <div class="container">
    <div class="row align-items-center w-100">
      <div class="col-md-6 col-sm-12 col-img">
        <img class="img-fluid" src="demo/img/illustrations.co/107-healthy.svg" alt="healthy">
      </div>
      <div class="col-md-6 col-sm-12">
        <h3>Drag and drop builder</h3>
        <p class="lead">Unlimited design powers with an easy to use interface, change anything on your website with a few clicks.</p>
        <a href="content/post.html">
          <span>Learn more</span>
          <i class="la la-long-arrow-alt-right ms-1"></i>
        </a>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-3", {
    name: "Showcase 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-3-thumb.webp",
    html: `<section class="showcase-3" aria-label="showcase-3">
  <div class="container">
    <div class="row g-1 justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-3">
        <div class="feature" data-aos="fade-up" data-aos-delay="100">
          <div class="font-container text-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="64" height="64" color="#1064ea" fill="#1064ea">
              <polyline points="336 176 225.2 304 176 255.8" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></polyline>
              <path d="M463.1,112.37C373.68,96.33,336.71,84.45,256,48,175.29,84.45,138.32,96.33,48.9,112.37,32.7,369.13,240.58,457.79,256,464,271.42,457.79,479.3,369.13,463.1,112.37Z" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-linejoin:round;stroke-width:32px"></path>
            </svg>
          </div>
          <h3>
            Better Security
          </h3>
          <p class="text-center">Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3">
        <div class="feature" data-aos="fade-up" data-aos-delay="200">
          <div class="font-container text-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" version="1.1" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" style="enable-background:new 0 0 512 512;" xml:space="preserve" width="64" height="64" color="#1064ea" fill="#1064ea">
              <path d="M419.1,337.45a3.94,3.94,0,0,0-6.1,0c-10.5,12.4-45,46.55-45,77.66,0,27,21.5,48.89,48,48.89h0c26.5,0,48-22,48-48.89C464,384,429.7,349.85,419.1,337.45Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
              <path d="M387,287.9,155.61,58.36a36,36,0,0,0-51,0l-5.15,5.15a36,36,0,0,0,0,51l52.89,52.89,57-57L56.33,263.2a28,28,0,0,0,.3,40l131.2,126a28.05,28.05,0,0,0,38.9-.1c37.8-36.6,118.3-114.5,126.7-122.9,5.8-5.8,18.2-7.1,28.7-7.1h.3A6.53,6.53,0,0,0,387,287.9Z" style="fill:none;stroke:currentColor;stroke-miterlimit:10;stroke-width:32px"></path>
            </svg>
          </div>
          <h3>
            Unlimited customization
          </h3>
          <p class="text-center">Vvveb uses only html for templating for maximum flexibility.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3">
        <div class="feature" data-aos="fade-up" data-aos-delay="300">
          <div class="font-container text-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" id="icons" width="64" height="64" color="#1064ea" fill="#1064ea" stroke-width="28">
              <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M80,176a16,16,0,0,0-16,16V408c0,30.24,25.76,56,56,56H392c30.24,0,56-24.51,56-54.75V192a16,16,0,0,0-16-16Z"></path>
              <path fill="none" stroke-linecap="round" stroke-linejoin="round" stroke="currentColor" fill-rule="evenodd" d="M160,176V144a96,96,0,0,1,96-96h0a96,96,0,0,1,96,96v32"></path>
            </svg>
          </div>
          <h3>
            Advanced Ecommerce
          </h3>
          <p class="text-center">Vvveb is a full featured ecommerce platform with advanced functionality.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3">
        <div class="feature" data-aos="fade-up" data-aos-delay="400">
          <div class="font-container text-center">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="64" height="64" color="#1064ea" fill="#1064ea">
              <path d="M80,464V68.14a8,8,0,0,1,4-6.9C91.81,56.66,112.92,48,160,48c64,0,145,48,192,48a199.53,199.53,0,0,0,77.23-15.77A2,2,0,0,1,432,82.08V301.44a4,4,0,0,1-2.39,3.65C421.37,308.7,392.33,320,352,320c-48,0-128-32-192-32s-80,16-80,16" style="fill:none;stroke:currentColor;stroke-linecap:round;stroke-miterlimit:10;stroke-width:32px"></path>
            </svg>
          </div>
          <h3>
            Full Localization
          </h3>
          <p class="text-center">Publish content in multiple languages or sell in different currencies.</p>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-4", {
    name: "Showcase 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-4-thumb.webp",
    html: `<section class="showcase-4" aria-label="showcase-4">
  <div class="container">
    <div class="row g-1 justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shield-alt"></i>
          </div>
          <h3>
            <a>Security</a>
          </h3>
          <p>Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
          <a class="more  d-block">
            Read more
            <i class="font-icon la la-chevron-circle-right"></i>
          </a>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-praying-hands"></i>
          </div>
          <h3>
            <a>Unlimited theme flexibility</a>
          </h3>
          <p>Vvveb uses only html for templating for maximum flexibility.</p>
          <a class="more d-block">
            Read more
            <i class="font-icon la la-chevron-circle-right"></i>
          </a>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shopping-cart"></i>
          </div>
          <h3>
            <a>Ecommerce</a>
          </h3>
          <p>Vvveb is a full featured ecommerce platform with advanced functionality.</p>
          <a class="more d-block">
            Read more
            <i class="font-icon la la-chevron-circle-right"></i>
          </a>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-globe-europe"></i>
          </div>
          <h3>
            <a>Localization</a>
          </h3>
          <p>Publish content in multiple languages or sell in different currencies.</p>
          <a class="more d-block">
            Read more
            <i class="font-icon la la-chevron-circle-right"></i>
          </a>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-5", {
    name: "Showcase 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-5-thumb.webp",
    html: `<section class="showcase-5" aria-label="showcase-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shield-alt"></i>
          </div>
          <h3>
            <a>Security</a>
          </h3>
          <p>Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
          <!-- a class="more d-block">
			  Read more
			  <i class="font-icon la la-chevron-circle-right"></i>
          </a-->
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-praying-hands"></i>
          </div>
          <h3>
            <a>Unlimited flexibility</a>
          </h3>
          <p>Vvveb uses only html for templating for maximum flexibility.</p>
          <!-- a class="more d-block">
			  Read more
			  <i class="font-icon la la-chevron-circle-right"></i>
          </a-->
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shopping-cart"></i>
          </div>
          <h3>
            <a>Ecommerce</a>
          </h3>
          <p>Vvveb is a full featured ecommerce platform with advanced functionality.</p>
          <!-- a class="more d-block">
			  Read more
			  <i class="font-icon la la-chevron-circle-right"></i>
          </a-->
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-globe-europe"></i>
          </div>
          <h3>
            <a>Localization</a>
          </h3>
          <p>Publish content in multiple languages or sell in different currencies.</p>
          <!-- a class="more d-block">
			  Read more
			  <i class="font-icon la la-chevron-circle-right"></i>
          </a-->
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-6", {
    name: "Showcase 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-6-thumb.webp",
    html: `<section class="showcase-6" aria-label="showcase-6">
  <div class="separator top">
    <svg class="pricing-divider-img" enable-background="new 0 0 300 100" height="100px" id="Layer_1" fill="currentColor" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" width="300px" x="0px" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px">
      <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729
		c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" fill="currentColor" opacity="0.6"></path>
      <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729
		c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" fill="currentColor" opacity="0.6"></path>
      <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716
		H42.401L43.415,98.342z" fill="currentColor" opacity="0.7"></path>
      <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428
		c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z" fill="currentColor"></path>
    </svg>
  </div>


  <div class="background-container"></div>

  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-shield-alt"></i>
          </div>
          <div class="text">
            <h3>
              <a>Security</a>
            </h3>
            <p>Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="300">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-praying-hands"></i>
          </div>
          <div class="text">
            <h3>
              <a>Unlimited flexibility</a>
            </h3>
            <p>Vvveb uses only html for templating for maximum flexibility.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="600">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-shopping-cart"></i>
          </div>
          <div class="text">
            <h3>
              <a>Ecommerce</a>
            </h3>
            <p>Vvveb is a full featured ecommerce platform with advanced functionality.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="separator bottom">
    <svg class="pricing-divider-img" enable-background="new 0 0 300 100" height="100px" fill="currentColor" id="Layer_1" preserveAspectRatio="none" version="1.1" viewBox="0 0 300 100" width="300px" x="0px" xml:space="preserve" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns="http://www.w3.org/2000/svg" y="0px">
      <path class="deco-layer deco-layer--1" d="M30.913,43.944c0,0,42.911-34.464,87.51-14.191c77.31,35.14,113.304-1.952,146.638-4.729
		c48.654-4.056,69.94,16.218,69.94,16.218v54.396H30.913V43.944z" fill="currentColor" opacity="0.6"></path>
      <path class="deco-layer deco-layer--2" d="M-35.667,44.628c0,0,42.91-34.463,87.51-14.191c77.31,35.141,113.304-1.952,146.639-4.729
		c48.653-4.055,69.939,16.218,69.939,16.218v54.396H-35.667V44.628z" fill="currentColor" opacity="0.6"></path>
      <path class="deco-layer deco-layer--3" d="M43.415,98.342c0,0,48.283-68.927,109.133-68.927c65.886,0,97.983,67.914,97.983,67.914v3.716
		H42.401L43.415,98.342z" fill="currentColor" opacity="0.7"></path>
      <path class="deco-layer deco-layer--4" d="M-34.667,62.998c0,0,56-45.667,120.316-27.839C167.484,57.842,197,41.332,232.286,30.428
		c53.07-16.399,104.047,36.903,104.047,36.903l1.333,36.667l-372-2.954L-34.667,62.998z" fill="currentColor"></path>
    </svg>
  </div>

</section>`
});Vvveb.Sections.add("showcase/showcase-7", {
    name: "Showcase 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-7-thumb.webp",
    html: `<section class="showcase-7" aria-label="showcase-7">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-shield-alt"></i>
          </div>
          <div class="text">
            <h3>
              <a>Security</a>
            </h3>
            <p>Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="300">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-praying-hands"></i>
          </div>
          <div class="text">
            <h3>
              <a>Unlimited theme flexibility</a>
            </h3>
            <p>Vvveb uses only html for templating for maximum flexibility.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-4" data-aos="fade-up" data-aos-delay="600">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-shopping-cart"></i>
          </div>
          <div class="text">
            <h3>
              <a>Ecommerce</a>
            </h3>
            <p>Vvveb is a full featured ecommerce platform with advanced functionality and internationalization.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-8", {
    name: "Showcase 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-8-thumb.webp",
    html: `<section class="showcase-8" aria-label="showcase-8">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-7 mx-auto" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-robot"></i>
          </div>
          <div class="text">
            <h3>
              <a>The next generation website builder</a>
            </h3>
            <p>Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-9", {
    name: "Showcase 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-9-thumb.webp",
    html: `<section class="showcase-8" aria-label="showcase-9">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-7 mx-auto" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-robot"></i>
          </div>
          <div class="text">
            <h3>
              <a>The next generation website builder</a>
            </h3>
            <p>Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-10", {
    name: "Showcase 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-10-thumb.webp",
    html: `<section class="showcase-10" aria-label="showcase-10">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-7 mx-auto" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container">
            <i class="font-icon la la-robot la-2x"></i>
          </div>
          <div class="text">
            <h3>
              <a>The next generation website builder</a>
            </h3>
            <p>Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
            <a class="more d-block">
              Read more
              <i class="font-icon la la-chevron-circle-right"></i>
            </a>
          </div>
        </div>
      </div>
    </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-11", {
    name: "Showcase 11",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-11-thumb.webp",
    html: `<section class="pt-5 pb-5">
  <div class="container">
    <div class="row align-items-center justify-content-center">
      <div class="col-12 col-md-6   mt-4 mt-md-0 order-md-1 order-2">
        <img alt="image" loading="lazy" class="img-fluid" src="http://via.placeholder.com/650x450/5fa9f8/fff">
      </div>
      <div class="col-12 col-md-4 order-1 order-md-2">
        <h2>Nice Heading</h2>
        <p class="text-h3 mt-3">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
      </div>
    </div>
    <div class="row align-items-center justify-content-center pt-5 pb-5">
      <div class="col-12 col-md-4 offset-md-1">
        <h2>Nice Heading</h2>
        <p class="text-h3 mt-3">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>

      </div>
      <div class="col-12 col-md-6   mt-4 mt-md-0">
        <img alt="image" loading="lazy" class="img-fluid" src="http://via.placeholder.com/650x450/5fa9f8/fff">
      </div>
    </div>
    <div class="row align-items-center justify-content-center">
      <div class="col-12 col-md-6   mt-4 mt-md-0 order-md-1 order-2">
        <img alt="image" loading="lazy" class="img-fluid" src="http://via.placeholder.com/650x450/5fa9f8/fff">
      </div>
      <div class="col-12 col-md-4 order-1 order-md-2">
        <h2>Nice Heading</h2>
        <p class="text-h3 mt-3">Powerful and easy to use drag and drop website builder for blogs, presentation or ecommerce stores.</p>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("showcase/showcase-12", {
    name: "Showcase 12",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/showcase/showcase-12-thumb.webp",
    html: `<section class="showcase-12" aria-label="showcase-12">
  <div class="container">
    <div class="row g-1 justify-content-center">
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="0">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shield-alt"></i>
          </div>
          <h3>
            <a>Security</a>
          </h3>
          <p class="text-center">Vvveb is 100% safe against sql injections, a vulerability that affects most CMS.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="100">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-praying-hands"></i>
          </div>
          <h3>
            <a>Unlimited theme flexibility</a>
          </h3>
          <p class="text-center">Vvveb uses only html for templating for maximum flexibility.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="200">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-shopping-cart"></i>
          </div>
          <h3>
            <a>Ecommerce</a>
          </h3>
          <p class="text-center">Vvveb is a full featured ecommerce platform with advanced functionality.</p>
        </div>
      </div>
      <div class="col-12 col-sm-6 col-md-6 col-lg-3" data-aos="fade-up" data-aos-delay="300">
        <div class="feature">
          <div class="font-container text-center">
            <i class="font-icon la la-globe-europe"></i>
          </div>
          <h3>
            <a>Localization</a>
          </h3>
          <p class="text-center">Publish content in multiple languages or sell in different currencies.</p>
        </div>
      </div>
    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Showcase"] = ["showcase/showcase-1","showcase/showcase-2","showcase/showcase-3","showcase/showcase-4","showcase/showcase-5","showcase/showcase-6","showcase/showcase-7","showcase/showcase-8","showcase/showcase-9","showcase/showcase-10","showcase/showcase-11","showcase/showcase-12"];
Vvveb.Sections.add("subscribe/subscribe-1", {
    name: "Subscribe 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/subscribe/subscribe-1-thumb.webp",
    html: `<section class="subscribe-1 text-white" aria-label="subscribe-1" data-bs-theme="dark">

  <div class="container">

    <div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="contact-us-home">
      <div class="row h-100 d-flex justify-content-center align-items-center">

        <div class="col-md-12">

          <h4 class="text-center">Stay Informed with Early Updates!</h4>
          <p class="text-muted text-center">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>

          <div class="notifications" data-v-notifications>

            <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
              </div>

              <div class="flex-grow-1 align-self-center text-small">
                <div>
                  <div data-v-notification-text>
                    This is a placeholder for a notification message.
                  </div>
                </div>
              </div>


              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-check-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                This is a placeholder for a success message.
              </div>

              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1  la-info-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center" data-v-notification-text>
                This is a placeholder for a info message.
              </div>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

          </div>

          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>


            <div class="col-md-6 mx-auto mt-5">
              <div class="search position-relative">
                <input class="form-control rounded-5" name="email" placeholder="Your email address">
                <button type="submit" class="btn btn-primary position-absolute  rounded-5">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                    </span>
                    <span>Submitting</span> ...
                  </span>

                  <span class="button-text">
                    <span>Submit</span>
                    <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                  </span>

                </button>
              </div>

              <label class="small mt-2 text-muted form-check">
                <input type="checkbox" class="form-check-input" value="1" name="optin" required>
                <span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
              </label>
            </div>

            <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          </form>

        </div>

      </div>
    </div>

  </div>

</section>`
});Vvveb.Sections.add("subscribe/subscribe-2", {
    name: "Subscribe 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/subscribe/subscribe-2-thumb.webp",
    html: `<section class="subscribe-2" aria-label="subscribe-2">

  <div class="container">

    <div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="subscribe-footer" data-v-list="footer">
      <div class="row h-100 d-flex justify-content-center align-items-center">

        <div class="col-md-6">
          <h5 class="mb-3">Stay Informed with Early Updates!</h5>
          <p class="text-muted">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>
        </div>

        <div class="col-md-6">

          <div class="notifications" data-v-notifications>

            <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error data-v-type="subscribe-footer">

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
              </div>

              <div class="flex-grow-1 align-self-center text-small">
                <div>
                  <div data-v-notification-text>
                    This is a placeholder for a notification message.
                  </div>
                </div>
              </div>


              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success data-v-type="subscribe-footer">

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-check-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                This is a placeholder for a success message.
              </div>

              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info data-v-type="subscribe-footer">

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1  la-info-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center" data-v-notification-text>
                This is a placeholder for a info message.
              </div>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

          </div>

          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>
            <input type="hidden" class="form-control" name="form-name" value="subscribe-footer">

            <div class="search position-relative">
              <input class="form-control" name="email" placeholder="Your email address">
              <button type="submit" class="btn btn-primary position-absolute">

                <span class="loading d-none">
                  <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                  </span>
                  <span>Submitting</span> ...
                </span>

                <span class="button-text">
                  <span>Submit</span>
                  <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                </span>

              </button>
            </div>

            <label class="small mt-2 text-muted form-check">
              <input type="checkbox" class="form-check-input" value="1" name="optin" required>
              <span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
            </label>


            <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          </form>

        </div>

      </div>

    </div>
  </div>

</section>`
});Vvveb.Sections.add("subscribe/subscribe-3", {
    name: "Subscribe 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/subscribe/subscribe-3-thumb.webp",
    html: `<section class="subscribe-3 text-white" aria-label="subscribe-1" data-bs-theme="dark">

  <div class="container">

    <div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="contact-us-home">
      <div class="row h-100 d-flex justify-content-center align-items-center">

        <div class="col-md-6">
          <h5 class="mb-3">Stay Informed with Early Updates!</h5>
          <p class="text-muted">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>
        </div>

        <div class="col-md-6">

          <div class="notifications" data-v-notifications>

            <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
              </div>

              <div class="flex-grow-1 align-self-center text-small">
                <div>
                  <div data-v-notification-text>
                    This is a placeholder for a notification message.
                  </div>
                </div>
              </div>


              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-check-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                This is a placeholder for a success message.
              </div>

              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1  la-info-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center" data-v-notification-text>
                This is a placeholder for a info message.
              </div>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

          </div>

          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>


            <div class="search position-relative">
              <input class="form-control" name="email" placeholder="Your email address">
              <button type="submit" class="btn btn-primary position-absolute">

                <span class="loading d-none">
                  <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                  </span>
                  <span>Submitting</span> ...
                </span>

                <span class="button-text">
                  <span>Submit</span>
                  <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                </span>

              </button>
            </div>

            <label class="small mt-2 text-muted form-check">
              <input type="checkbox" class="form-check-input" value="1" name="optin" required>
              <span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
            </label>


            <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          </form>

        </div>

      </div>
    </div>

  </div>

</section>`
});Vvveb.Sections.add("subscribe/subscribe-4", {
    name: "Subscribe 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/subscribe/subscribe-4-thumb.webp",
    html: `<section class="subscribe-4" aria-label="subscribe-4">

  <div class="container">

    <div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="contact-us-home">
      <div class="row h-100 d-flex justify-content-center align-items-center">

        <div class="col-md-12">

          <h4 class="text-center">Stay Informed with Early Updates!</h4>
          <p class="text-muted text-center">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>

          <div class="notifications" data-v-notifications>

            <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
              </div>

              <div class="flex-grow-1 align-self-center text-small">
                <div>
                  <div data-v-notification-text>
                    This is a placeholder for a notification message.
                  </div>
                </div>
              </div>


              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-check-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                This is a placeholder for a success message.
              </div>

              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1  la-info-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center" data-v-notification-text>
                This is a placeholder for a info message.
              </div>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

          </div>

          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>


            <div class="col-md-6 mx-auto mt-5">
              <div class="search position-relative">
                <input class="form-control" name="email" placeholder="Your email address">
                <button type="submit" class="btn btn-primary position-absolute">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                    </span>
                    <span>Submitting</span> ...
                  </span>

                  <span class="button-text">
                    <span>Submit</span>
                    <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                  </span>

                </button>
              </div>

              <label class="small mt-2 text-muted form-check">
                <input type="checkbox" class="form-check-input" value="1" name="optin" required>
                <span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
              </label>
            </div>

            <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          </form>

        </div>

      </div>
    </div>

  </div>

</section>`
});Vvveb.Sections.add("subscribe/subscribe-5", {
    name: "Subscribe 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/subscribe/subscribe-5-thumb.webp",
    html: `<section class="subscribe-5 text-white" aria-label="subscribe-5" data-bs-theme="dark">

  <div class="container">

    <div data-v-component-plugin-newsletter-form data-v-storage="database" data-v-name="contact-us-home">
      <div class="row h-100 d-flex justify-content-center align-items-center">

        <div class="col-md-12">

          <h4 class="text-center">Stay Informed with Early Updates!</h4>
          <p class="lead text-muted text-center">Subscribe to our newsletter and receive the latest updates and important news directly to your inbox.</p>

          <div class="notifications" data-v-notifications>

            <div class="alert alert-danger d-flex alert-dismissable" role="alert" data-v-notification-error>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-exclamation-triangle"></i>
              </div>

              <div class="flex-grow-1 align-self-center text-small">
                <div>
                  <div data-v-notification-text>
                    This is a placeholder for a notification message.
                  </div>
                </div>
              </div>


              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-success d-flex  alert-dismissable d-flex" role="alert" data-v-notification-success>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1 la-check-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center align-middle" data-v-notification-text>
                This is a placeholder for a success message.
              </div>

              <button type="button" class="btn-close align-middle" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

            <div class="alert alert-primary d-flex alert-dismissable d-flex" role="alert" data-v-notification-info>

              <div class="icon align-middle me-2">
                <i class="align-middle la la-2x lh-1  la-info-circle"></i>
              </div>

              <div class="flex-grow-1 align-self-center" data-v-notification-text>
                This is a placeholder for a info message.
              </div>

              <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">
                  <!-- <i class="la la-times"></i> -->
                </span>
              </button>
            </div>

          </div>

          <form action="" method="post" data-v-vvveb-action="submit" data-selector="[data-v-component-plugin-newsletter-form]" data-v-vvveb-on="submit">
            <input type="hidden" class="form-control" placeholder="First name" name="firstname-empty">
            <input type="hidden" class="form-control" placeholder="Email" name="csrf" data-v-csrf>


            <div class="col-md-6 mx-auto mt-5">
              <div class="search position-relative">
                <input class="form-control" placeholder="Your email address">
                <button type="submit" class="btn btn-primary position-absolute">

                  <span class="loading d-none">
                    <span class="spinner-border spinner-border-sm align-middle" role="status" aria-hidden="true">
                    </span>
                    <span>Submitting</span> ...
                  </span>

                  <span class="button-text">
                    <span>Submit</span>
                    <i class="la la-lg la-envelope opacity-50 ms-2"></i>
                  </span>

                </button>
              </div>

              <label class="small mt-2 text-muted form-check">
                <input type="checkbox" class="form-check-input" value="1" name="optin" required>
                <span class="form-check-label">I agree to receive your newsletters and accept the data privacy statement.</span>
              </label>
            </div>

            <input type="text" class="form-control d-none" placeholder="Contact form" name="newsletter">

            <input type="text" class="form-control d-none" placeholder="Subject" name="subject-empty">

            <input type="text" class="form-control visually-hidden" placeholder="Last name" name="lastname-empty" tabindex="-1">

          </form>

        </div>

      </div>
    </div>

  </div>

</section>`
});
	Vvveb.SectionsGroup["Subscribe"] = ["subscribe/subscribe-1","subscribe/subscribe-2","subscribe/subscribe-3","subscribe/subscribe-4","subscribe/subscribe-5"];
Vvveb.Sections.add("team/team-1", {
    name: "Team 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-1-thumb.webp",
    html: `<section class="py-5" aria-label="team-1">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">Meet Our Team</h2>
        <p class="lead text-center text-muted mb-4">We are a group of professionals dedicated to their work</p>

      </div>
    </div>
    <div class="row">

      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <img alt="image" loading="lazy" src="demo/img/sections/team/1.webp" class="img-fluid p-4 rounded-circle">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h3 class="mt-4 mb-0">John Doe</h3>
              <h4 class="text-muted mb-3">CTO - Founder</h4>
              <p class="text-muted">We are a group of professionals dedicated to their work</p>

              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>

            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <img alt="image" loading="lazy" src="demo/img/sections/team/2.webp" class="img-fluid p-4 rounded-circle">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h3 class="mt-4 mb-0">John Doe</h3>
              <h4 class="text-muted mb-3">CTO - Tech</h4>
              <p class="text-muted">We are a group of professionals dedicated to their work</p>

              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>

            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <img alt="image" loading="lazy" src="demo/img/sections/team/3.webp" class="img-fluid p-4 rounded-circle">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h3 class="mt-4 mb-0">John Doe</h3>
              <h4 class="text-muted mb-3">CSO - Financial</h4>
              <p class="text-muted">We are a group of professionals dedicated to their work</p>

              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>

            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <img alt="image" loading="lazy" src="demo/img/sections/team/4.webp" class="img-fluid p-4 rounded-circle">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h3 class="mt-4 mb-0">John Doe</h3>
              <h4 class="text-muted mb-3">CMO - Operations</h4>
              <p class="text-muted">You can relay on our amazing features list and also our user services will be great experience.</p>

              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>

            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-2", {
    name: "Team 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-2-thumb.webp",
    html: `<section class="py-5 team-2" aria-label="team-2">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h3 class="mb-3">Meet Our Team</h3>
        <h5 class="lead text-muted">We are a group of professionals dedicated to their work</h5>
      </div>
    </div>
    <div class="row justify-content-center py-5">
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body p-0">
            <div class="profile">
              <img src="demo/img/sections/team/1.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>Jane Doe</h4>
              <small>CEO - Founder</small>
            </div>
            <div class="card-subtitle">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing </p>
            </div>
            <div class="card-footer">
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body p-0">
            <div class="profile">
              <img src="demo/img/sections/team/2.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>John Doe</h4>
              <small>CTO - Co-Founder</small>
            </div>
            <div class="card-subtitle">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing </p>
            </div>
            <div class="card-footer">
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body p-0">
            <div class="profile">
              <img src="demo/img/sections/team/3.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>Jane Doe</h4>
              <small>CSO - Financial</small>
            </div>
            <div class="card-subtitle">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing </p>
            </div>
            <div class="card-footer">
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook-f"></i>
                    <span class="visually-hidden">Facebook</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>`
});Vvveb.Sections.add("team/team-3", {
    name: "Team 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-3-thumb.webp",
    html: `<section class="py-5" aria-label="team-5">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h3 class="mb-3">Meet Our Team</h3>
        <h5 class="text-muted">We are a group of professionals dedicated to their work</h5>
      </div>
    </div>
    <div class="row">

      <div class="col-lg-3 mb-4">

        <div class="row no-gutters">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/1.webp" class="img-fluid p-4" loading="lazy">

            <ul class="mb-0 list-inline mt-3 px-4">
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-facebook"></i>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-twitter"></i>
                  <span class="visually-hidden">Twitter</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-instagram"></i>
                  <span class="visually-hidden">Instagram</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-linkedin"></i>
                  <span class="visually-hidden">Linkedin</span>
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row no-gutters">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/2.webp" class="img-fluid p-4" loading="lazy">

            <ul class="mb-0 list-inline mt-3 px-4">
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-facebook"></i>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-twitter"></i>
                  <span class="visually-hidden">Twitter</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-instagram"></i>
                  <span class="visually-hidden">Instagram</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-linkedin"></i>
                  <span class="visually-hidden">Linkedin</span>
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row no-gutters">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/3.webp" class="img-fluid p-4" loading="lazy">

            <ul class="mb-0 list-inline mt-3 px-4">
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-facebook"></i>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-twitter"></i>
                  <span class="visually-hidden">Twitter</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-instagram"></i>
                  <span class="visually-hidden">Instagram</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-linkedin"></i>
                  <span class="visually-hidden">Linkedin</span>
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row no-gutters">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/4.webp" class="img-fluid p-4" loading="lazy">

            <ul class="mb-0 list-inline mt-3 px-4">
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-facebook"></i>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-twitter"></i>
                  <span class="visually-hidden">Twitter</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-instagram"></i>
                  <span class="visually-hidden">Instagram</span>
                </a>
              </li>
              <li class="list-inline-item">
                <a class="social-link">
                  <i class="lab la-linkedin"></i>
                  <span class="visually-hidden">Linkedin</span>
                </a>
              </li>
            </ul>
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
            </div>
          </div>
        </div>

      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-4", {
    name: "Team 4",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-4-thumb.webp",
    html: `<section class="py-5" aria-label="team-6">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h3 class="mb-3">Meet Our Team</h3>
        <h5 class="text-muted">We are a group of professionals dedicated to their work</h5>
      </div>
    </div>
    <div class="row">

      <div class="col-lg-4 mb-4">

        <div class="row">
          <div class="col-md-12">
            <img alt="image" src="demo/img/sections/team/1.webp" class="img-fluid p-4" loading="lazy">
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook"></i>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-4 mb-4">

        <div class="row">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/2.webp" class="img-fluid p-4" loading="lazy">
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook"></i>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-4 mb-4">

        <div class="row">
          <div class="col-md-12 pro-pic">
            <img alt="image" src="demo/img/sections/team/3.webp" class="img-fluid p-4" loading="lazy">
          </div>
          <div class="col-md-12">
            <div class="px-4">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
              <p class="mt-3">We are a group of professionals dedicated to their work</p>
              <ul class="mb-0 list-inline mt-3">
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-facebook"></i>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-twitter"></i>
                    <span class="visually-hidden">Twitter</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-instagram"></i>
                    <span class="visually-hidden">Instagram</span>
                  </a>
                </li>
                <li class="list-inline-item">
                  <a class="social-link">
                    <i class="lab la-linkedin"></i>
                    <span class="visually-hidden">Linkedin</span>
                  </a>
                </li>
              </ul>
            </div>
          </div>
        </div>

      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-5", {
    name: "Team 5",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-5-thumb.webp",
    html: `<section class="py-5" aria-label="team-7">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h3 class="mb-3">Meet Our Team</h3>
        <h5 class="text-muted">We are a group of professionals dedicated to their work</h5>
      </div>
    </div>
    <div class="row">

      <div class="col-lg-6">
        <div class="card shadow-sm border-1 mb-4 p-0">

          <div class="row no-gutters">
            <div class="col-md-5">

              <img alt="image" src="demo/img/sections/team/1.webp" class="img-fluid" loading="lazy">

            </div>
            <div class="col-md-7">
              <div class="p-4">
                <h4 class="mb-3">John Doe</h4>
                <p>We are a group of professionals dedicated to their work</p>
                <ul class="mb-0 list-inline mt-3">
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-facebook-f"></i>
                      <span class="visually-hidden">Facebook</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-twitter"></i>
                      <span class="visually-hidden">Twitter</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-instagram"></i>
                      <span class="visually-hidden">Instagram</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-linkedin"></i>
                      <span class="visually-hidden">Linkedin</span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="col-lg-6">
        <div class="card shadow-sm border-1 mb-4 p-0">

          <div class="row no-gutters">
            <div class="col-md-5">

              <img alt="image" src="demo/img/sections/team/2.webp" class="img-fluid" loading="lazy">

            </div>
            <div class="col-md-7">
              <div class="p-4">
                <h4 class="mb-3">John Doe</h4>
                <p>We are a group of professionals dedicated to their work</p>
                <ul class="mb-0 list-inline mt-3">
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-facebook-f"></i>
                      <span class="visually-hidden">Facebook</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-twitter"></i>
                      <span class="visually-hidden">Twitter</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-instagram"></i>
                      <span class="visually-hidden">Instagram</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-linkedin"></i>
                      <span class="visually-hidden">Linkedin</span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>

        </div>
      </div>

    </div>
    <div class="row">

      <div class="col-lg-6">
        <div class="card shadow-sm border-1 mb-4 p-0">

          <div class="row no-gutters">
            <div class="col-md-5">

              <img alt="image" src="demo/img/sections/team/3.webp" class="img-fluid" loading="lazy">
            </div>
            <div class="col-md-7">
              <div class="p-4">
                <h4 class="mb-3">John Doe</h4>
                <p>We are a group of professionals dedicated to their work</p>
                <ul class="mb-0 list-inline mt-3">
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-facebook-f"></i>
                      <span class="visually-hidden">Facebook</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-twitter"></i>
                      <span class="visually-hidden">Twitter</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-instagram"></i>
                      <span class="visually-hidden">Instagram</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-linkedin"></i>
                      <span class="visually-hidden">Linkedin</span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>

        </div>
      </div>

      <div class="col-lg-6">

        <div class="card shadow-sm border-1 mb-4 p-0">
          <div class="row no-gutters">
            <div class="col-md-5">

              <img alt="image" src="demo/img/sections/team/4.webp" class="img-fluid" loading="lazy">

            </div>
            <div class="col-md-7">
              <div class="p-4">
                <h4 class="mb-3">John Doe</h4>
                <p>We are a group of professionals dedicated to their work</p>
                <ul class="mb-0 list-inline mt-3">
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-facebook-f"></i>
                      <span class="visually-hidden">Facebook</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-twitter"></i>
                      <span class="visually-hidden">Twitter</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-instagram"></i>
                      <span class="visually-hidden">Instagram</span>
                    </a>
                  </li>
                  <li class="list-inline-item">
                    <a class="social-link">
                      <i class="lab la-linkedin"></i>
                      <span class="visually-hidden">Linkedin</span>
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </div>

        </div>
      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-6", {
    name: "Team 6",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-6-thumb.webp",
    html: `<section class="p-4" aria-label="team-11">
  <div class="container">
    <div class="row text-center">


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="bg-white rounded shadow-sm py-5 px-4">

          <img src="demo/img/sections/team/1.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 img-thumbnail shadow-sm" loading="lazy">

          <h5>John Doe</h5>
          <span class="small text-uppercase text-muted">CEO - Founder</span>
          <ul class="social mb-0 list-inline mt-3">
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-facebook-f-f"></i>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-twitter"></i>
                <span class="visually-hidden">Twitter</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-instagram"></i>
                <span class="visually-hidden">Instagram</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-linkedin"></i>
                <span class="visually-hidden">Linkedin</span>
              </a>
            </li>
          </ul>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="bg-white rounded shadow-sm py-5 px-4">

          <img src="demo/img/sections/team/2.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 img-thumbnail shadow-sm" loading="lazy">

          <h5>Jane Doe</h5>
          <span class="small text-uppercase text-muted">CTO - Co-Founder</span>
          <ul class="social mb-0 list-inline mt-3">
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-facebook-f"></i>
                <span class="visually-hidden">Facebook</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-twitter"></i>
                <span class="visually-hidden">Twitter</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-instagram"></i>
                <span class="visually-hidden">Instagram</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-linkedin"></i>
                <span class="visually-hidden">Linkedin</span>
              </a>
            </li>
          </ul>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="bg-white rounded shadow-sm py-5 px-4">

          <img src="demo/img/sections/team/3.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 img-thumbnail shadow-sm" loading="lazy">

          <h5>John Doe</h5>
          <span class="small text-uppercase text-muted">CMO - Operations</span>
          <ul class="social mb-0 list-inline mt-3">
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-facebook-f"></i>
                <span class="visually-hidden">Facebook</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-twitter"></i>
                <span class="visually-hidden">Twitter</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-instagram"></i>
                <span class="visually-hidden">Instagram</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-linkedin"></i>
                <span class="visually-hidden">Linkedin</span>
              </a>
            </li>
          </ul>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="bg-white rounded shadow-sm py-5 px-4">

          <img src="demo/img/sections/team/4.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 img-thumbnail shadow-sm" loading="lazy">

          <h5>Jane Doe</h5>
          <span class="small text-uppercase text-muted">CCO - Financial</span>
          <ul class="social mb-0 list-inline mt-3">
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-facebook-f"></i>
                <span class="visually-hidden">Facebook</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-twitter"></i>
                <span class="visually-hidden">Twitter</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-instagram"></i>
                <span class="visually-hidden">Instagram</span>
              </a>
            </li>
            <li class="list-inline-item">
              <a class="social-link">
                <i class="lab la-linkedin"></i>
                <span class="visually-hidden">Linkedin</span>
              </a>
            </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-7", {
    name: "Team 7",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-7-thumb.webp",
    html: `<section class="p-4" aria-label="team-7">
  <div class="container">
    <div class="row text-center pb-5 pt-3">
      <div class="col-md-12 text-center">
        <div class="lc-block">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Our Team</b>
          </h2>
          <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br>ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row pb-4">

      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/1.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Benjamin Lawrence</h4>
          <p class="small">Founder &amp; CEO</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/2.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Robert Greene</h4>
          <p class="small">UX Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/3.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Paul Mackenzie</h4>
          <p class="small">Full Stack Developer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/4.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Faith Watson</h4>
          <p class="small">Illustrator Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-8", {
    name: "Team 8",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-8-thumb.webp",
    html: `<section class="p-4" aria-label="team-7">
  <div class="container">
    <div class="row">

      <div class="col-md-12 text-center">
        <div class="lc-block mb-4">
          <span editable="inline" class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 editable="inline" class="display-2 mb-0">
            <b>Team</b>
          </h2>
          <p editable="inline"> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br> ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>

    </div>
    <div class="row">
      <div class="col-md-6 py-4">
        <div>
          <img alt="" class="rounded-circle float-start me-4" src="demo/img/sections/team/1.webp" style="width:10vh;" loading="lazy">
          <div>
            <h5>
              <strong>Neil Amstrong</strong>
            </h5>
          </div>

          <small editable="inline" class="text-secondary" style="letter-spacing:1px">SOME LIPSUM</small>

          <div>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus leo nulla, suscipit non dapibus vitae, dignissim id quam. Donec eget nulla tellus.&nbsp;</p>
          </div>
        </div>

        <div class="lc-block float-end ms-3 py-4">

          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="" lc-helper="svg-icon" fill="currentColor" width="1em" height="1em">
              <path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path>
            </svg>
          </a>
        </div>
      </div>
      <div class="col-md-6 py-4">
        <div>
          <img alt="" class="rounded-circle float-start me-4" src="demo/img/sections/team/2.webp" style="width:10vh;" loading="lazy">
          <div>
            <h5>
              <strong>Neil Amstrong</strong>
            </h5>
          </div>

          <small editable="inline" class="text-secondary" style="letter-spacing:1px">SOME LIPSUM</small>

          <div>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus leo nulla, suscipit non dapibus vitae, dignissim id quam. Donec eget nulla tellus.&nbsp;</p>
          </div>
        </div>

        <div class="lc-block float-end ms-3 py-4">

          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" lc-helper="svg-icon" fill="currentColor" width="1em" height="1em">
              <path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path>
            </svg>
          </a>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-md-6 py-4">
        <div>
          <img alt="" class="rounded-circle float-start me-4" src="demo/img/sections/team/3.webp" style="width:10vh;" loading="lazy">
          <div>
            <h5>
              <strong>Neil Amstrong</strong>
            </h5>
          </div>

          <small editable="inline" class="text-secondary" style="letter-spacing:1px">SOME LIPSUM</small>

          <div>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus leo nulla, suscipit non dapibus vitae, dignissim id quam. Donec eget nulla tellus.&nbsp;</p>
          </div>
        </div>

        <div class="lc-block float-end ms-3 py-4">

          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="" lc-helper="svg-icon" fill="currentColor" width="1em" height="1em">
              <path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path>
            </svg>
          </a>
        </div>
      </div>
      <div class="col-md-6 py-4">
        <div>
          <img alt="" class="rounded-circle float-start me-4" src="demo/img/sections/team/4.webp" style="width:10vh;" loading="lazy">
          <div>
            <h5>
              <strong>Neil Amstrong</strong>
            </h5>
          </div>

          <small editable="inline" class="text-secondary" style="letter-spacing:1px">SOME LIPSUM</small>

          <div>
            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vivamus leo nulla, suscipit non dapibus vitae, dignissim id quam. Donec eget nulla tellus.&nbsp;</p>
          </div>
        </div>

        <div class="lc-block float-end ms-3 py-4">

          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" class="" lc-helper="svg-icon" fill="currentColor" width="1em" height="1em">
              <path d="M224.1 141c-63.6 0-114.9 51.3-114.9 114.9s51.3 114.9 114.9 114.9S339 319.5 339 255.9 287.7 141 224.1 141zm0 189.6c-41.1 0-74.7-33.5-74.7-74.7s33.5-74.7 74.7-74.7 74.7 33.5 74.7 74.7-33.6 74.7-74.7 74.7zm146.4-194.3c0 14.9-12 26.8-26.8 26.8-14.9 0-26.8-12-26.8-26.8s12-26.8 26.8-26.8 26.8 12 26.8 26.8zm76.1 27.2c-1.7-35.9-9.9-67.7-36.2-93.9-26.2-26.2-58-34.4-93.9-36.2-37-2.1-147.9-2.1-184.9 0-35.8 1.7-67.6 9.9-93.9 36.1s-34.4 58-36.2 93.9c-2.1 37-2.1 147.9 0 184.9 1.7 35.9 9.9 67.7 36.2 93.9s58 34.4 93.9 36.2c37 2.1 147.9 2.1 184.9 0 35.9-1.7 67.7-9.9 93.9-36.2 26.2-26.2 34.4-58 36.2-93.9 2.1-37 2.1-147.8 0-184.8zM398.8 388c-7.8 19.6-22.9 34.7-42.6 42.6-29.5 11.7-99.5 9-132.1 9s-102.7 2.6-132.1-9c-19.6-7.8-34.7-22.9-42.6-42.6-11.7-29.5-9-99.5-9-132.1s-2.6-102.7 9-132.1c7.8-19.6 22.9-34.7 42.6-42.6 29.5-11.7 99.5-9 132.1-9s102.7-2.6 132.1 9c19.6 7.8 34.7 22.9 42.6 42.6 11.7 29.5 9 99.5 9 132.1s2.7 102.7-9 132.1z"></path>
            </svg>
          </a>
          <a class="text-dark text-decoration-none" href="#">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 496 512" width="1em" height="1em" lc-helper="svg-icon" fill="currentColor">
              <path d="M165.9 397.4c0 2-2.3 3.6-5.2 3.6-3.3.3-5.6-1.3-5.6-3.6 0-2 2.3-3.6 5.2-3.6 3-.3 5.6 1.3 5.6 3.6zm-31.1-4.5c-.7 2 1.3 4.3 4.3 4.9 2.6 1 5.6 0 6.2-2s-1.3-4.3-4.3-5.2c-2.6-.7-5.5.3-6.2 2.3zm44.2-1.7c-2.9.7-4.9 2.6-4.6 4.9.3 2 2.9 3.3 5.9 2.6 2.9-.7 4.9-2.6 4.6-4.6-.3-1.9-3-3.2-5.9-2.9zM244.8 8C106.1 8 0 113.3 0 252c0 110.9 69.8 205.8 169.5 239.2 12.8 2.3 17.3-5.6 17.3-12.1 0-6.2-.3-40.4-.3-61.4 0 0-70 15-84.7-29.8 0 0-11.4-29.1-27.8-36.6 0 0-22.9-15.7 1.6-15.4 0 0 24.9 2 38.6 25.8 21.9 38.6 58.6 27.5 72.9 20.9 2.3-16 8.8-27.1 16-33.7-55.9-6.2-112.3-14.3-112.3-110.5 0-27.5 7.6-41.3 23.6-58.9-2.6-6.5-11.1-33.3 2.6-67.9 20.9-6.5 69 27 69 27 20-5.6 41.5-8.5 62.8-8.5s42.8 2.9 62.8 8.5c0 0 48.1-33.6 69-27 13.7 34.7 5.2 61.4 2.6 67.9 16 17.7 25.8 31.5 25.8 58.9 0 96.5-58.9 104.2-114.8 110.5 9.2 7.9 17 22.9 17 46.4 0 33.7-.3 75.4-.3 83.6 0 6.5 4.6 14.4 17.3 12.1C428.2 457.8 496 362.9 496 252 496 113.3 383.5 8 244.8 8zM97.2 352.9c-1.3 1-1 3.3.7 5.2 1.6 1.6 3.9 2.3 5.2 1 1.3-1 1-3.3-.7-5.2-1.6-1.6-3.9-2.3-5.2-1zm-10.8-8.1c-.7 1.3.3 2.9 2.3 3.9 1.6 1 3.6.7 4.3-.7.7-1.3-.3-2.9-2.3-3.9-2-.6-3.6-.3-4.3.7zm32.4 35.6c-1.6 1.3-1 4.3 1.3 6.2 2.3 2.3 5.2 2.6 6.5 1 1.3-1.3.7-4.3-1.3-6.2-2.2-2.3-5.2-2.6-6.5-1zm-11.4-14.7c-1.6 1-1.6 3.6 0 5.9 1.6 2.3 4.3 3.3 5.6 2.3 1.6-1.3 1.6-3.9 0-6.2-1.4-2.3-4-3.3-5.6-2z"></path>
            </svg>
          </a>
        </div>
      </div>
    </div>


  </div>
</section>`
});Vvveb.Sections.add("team/team-9", {
    name: "Team 9",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-9-thumb.webp",
    html: `<section class="p-4" aria-label="team-7">
  <div class="container">
    <div class="row text-center pb-5 pt-3">
      <div class="col-md-12 text-center">
        <div class="lc-block">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Our Team</b>
          </h2>
          <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br>ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row pb-4">

      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/1.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Benjamin Lawrence</h4>
          <p class="small">Founder &amp; CEO</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/2.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Robert Greene</h4>
          <p class="small">UX Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/3.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Paul Mackenzie</h4>
          <p class="small">Full Stack Developer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/4.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Faith Watson</h4>
          <p class="small">Illustrator Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>`
});Vvveb.Sections.add("team/team-10", {
    name: "Team 10",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/team/team-10-thumb.webp",
    html: `<section class="p-4" aria-label="team-7">
  <div class="container">
    <div class="row text-center pb-5 pt-3">
      <div class="col-md-12 text-center">
        <div class="lc-block">
          <span class="small mt-4 d-block">LOREM IPSUM</span>
          <h2 class="display-2 mb-0">
            <b>Our Team</b>
          </h2>
          <p> Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc et metus id
            <br>ligula malesuada placerat sit amet quis enim.
          </p>
        </div>
      </div>
    </div>
    <div class="row pb-4">

      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/1.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Benjamin Lawrence</h4>
          <p class="small">Founder &amp; CEO</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/2.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Robert Greene</h4>
          <p class="small">UX Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/3.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Paul Mackenzie</h4>
          <p class="small">Full Stack Developer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>


      <div class="col-md-6 col-lg-3 my-2">
        <div class="lc-block">
          <img src="demo/img/sections/team/4.webp" title="" alt="" loading="lazy" class="img-fluid">
        </div>
        <div class="position-relative text-center mx-2 mt-n4 py-4 bg-light shadow" style="">
          <h4>Faith Watson</h4>
          <p class="small">Illustrator Designer</p>
          <div class="nav justify-content-center">
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 320 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M279.14 288l14.22-92.66h-88.91v-60.13c0-25.35 12.42-50.06 52.24-50.06h40.42V6.26S260.43 0 225.36 0c-73.22 0-121.08 44.38-121.08 124.72v70.62H22.89V288h81.39v224h100.17V288z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" width="1em" height="1em" fill="currentColor" class="me-1">
                <path d="M459.37 151.716c.325 4.548.325 9.097.325 13.645 0 138.72-105.583 298.558-298.558 298.558-59.452 0-114.68-17.219-161.137-47.106 8.447.974 16.568 1.299 25.34 1.299 49.055 0 94.213-16.568 130.274-44.832-46.132-.975-84.792-31.188-98.112-72.772 6.498.974 12.995 1.624 19.818 1.624 9.421 0 18.843-1.3 27.614-3.573-48.081-9.747-84.143-51.98-84.143-102.985v-1.299c13.969 7.797 30.214 12.67 47.431 13.319-28.264-18.843-46.781-51.005-46.781-87.391 0-19.492 5.197-37.36 14.294-52.954 51.655 63.675 129.3 105.258 216.365 109.807-1.624-7.797-2.599-15.918-2.599-24.04 0-57.828 46.782-104.934 104.934-104.934 30.213 0 57.502 12.67 76.67 33.137 23.715-4.548 46.456-13.32 66.599-25.34-7.798 24.366-24.366 44.833-46.132 57.827 21.117-2.273 41.584-8.122 60.426-16.243-14.292 20.791-32.161 39.308-52.628 54.253z"></path>
              </svg>
            </a>
            <a href="#">
              <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" width="1em" height="1em" fill="currentColor">
                <path d="M100.28 448H7.4V148.9h92.88zM53.79 108.1C24.09 108.1 0 83.5 0 53.8a53.79 53.79 0 0 1 107.58 0c0 29.7-24.1 54.3-53.79 54.3zM447.9 448h-92.68V302.4c0-34.7-.7-79.2-48.29-79.2-48.29 0-55.69 37.7-55.69 76.7V448h-92.78V148.9h89.08v40.8h1.3c12.4-23.5 42.69-48.3 87.88-48.3 94 0 111.28 61.9 111.28 142.3V448z"></path>
              </svg>
            </a>
          </div>
        </div>
      </div>

    </div>
  </div>
</section>`
});
	Vvveb.SectionsGroup["Team"] = ["team/team-1","team/team-2","team/team-3","team/team-4","team/team-5","team/team-6","team/team-7","team/team-8","team/team-9","team/team-10"];
Vvveb.Sections.add("testimonials/testimonials-1", {
    name: "Testimonials 1",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/testimonials/testimonials-1-thumb.webp",
    html: `<section class="testimonials-1 bg-alternate" aria-label="testimonials-1">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h2 class="text-center display-6 mb-1 fw-bold">Some of our users</h2>
        <p class="lead text-center text-muted mb-4">Hear what our users have to say</p>
      </div>
    </div>

    <div class="row text-center">


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="rounded border testimonial" data-aos="fade-up">

          <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g>
              <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
            </g>
          </svg>

          <p class="mt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam eu sem tempor, varius quam at, luctus dui.</p>

          <img src="demo/img/sections/team/1.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 shadow border rounded-3" loading="lazy">

          <h3>John Doe</h3>
          <span class="small text-uppercase text-muted">Company Inc.</span>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="rounded border testimonial" data-aos="fade-up" data-aos-delay="100">

          <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g>
              <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
            </g>
          </svg>


          <p class="mt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam eu sem tempor, varius quam at, luctus dui.</p>
          <img src="demo/img/sections/team/2.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 shadow border rounded-3" loading="lazy">

          <h3>Jane Doe</h3>
          <span class="small text-uppercase text-muted">Company Inc.</span>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="rounded border testimonial" data-aos="fade-up" data-aos-delay="200">

          <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g>
              <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
            </g>
          </svg>


          <p class="mt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam eu sem tempor, varius quam at, luctus dui.</p>

          <img src="demo/img/sections/team/3.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 shadow border rounded-3" loading="lazy">

          <h3>John Doe</h3>
          <span class="small text-uppercase text-muted">Company Inc.</span>
        </div>
      </div>


      <div class="col-xl-3 col-sm-6 mb-5">
        <div class="rounded border testimonial" data-aos="fade-up" data-aos-delay="300">

          <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
            <g>
              <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
            </g>
          </svg>


          <p class="mt-3">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nam eu sem tempor, varius quam at, luctus dui.</p>

          <img src="demo/img/sections/team/4.webp" alt="team" width="100" class="img-fluid rounded-circle mb-3 shadow border rounded-3" loading="lazy">

          <h3>Jane Doe</h3>
          <span class="small text-uppercase text-muted">Company Inc.</span>
        </div>
      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("testimonials/testimonials-2", {
    name: "Testimonials 2",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/testimonials/testimonials-2-thumb.webp",
    html: `<section class="py-5" aria-label="testimonials-2">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h2 class="mb-1">Some of our users</h2>
        <h3 class="lead text-muted mb-3">Hear what our users have to say</h3>
      </div>
    </div>
    <div class="row text-center">

      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <img alt="image" src="demo/img/sections/team/1.webp" class="img-fluid p-4 rounded-circle" loading="lazy">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">

              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CTO - Founder</h6>

            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <img alt="image" src="demo/img/sections/team/2.webp" class="img-fluid p-4 rounded-circle" loading="lazy">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CTO - Tech</h6>

            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <img alt="image" src="demo/img/sections/team/3.webp" class="img-fluid p-4 rounded-circle" loading="lazy">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CSO - Financial</h6>
            </div>
          </div>
        </div>

      </div>


      <div class="col-lg-3 mb-4">

        <div class="row">
          <div class="col-md-12">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <img alt="image" src="demo/img/sections/team/4.webp" class="img-fluid p-4 rounded-circle" loading="lazy">
          </div>
          <div class="col-md-12 text-center">
            <div class="pt-2">
              <h5 class="mt-4 mb-0">John Doe</h5>
              <h6 class="text-muted mb-3">CMO - Operations</h6>


            </div>
          </div>
        </div>

      </div>
    </div>
  </div>
</section>`
});Vvveb.Sections.add("testimonials/testimonials-3", {
    name: "Testimonials 3",
    image: Vvveb.themeBaseUrl + "/screenshots/sections/testimonials/testimonials-3-thumb.webp",
    html: `<section class="py-5 team-2" aria-label="testimonials-3">
  <div class="container">
    <div class="row justify-content-center mb-4">
      <div class="col-md-7 text-center">
        <h2 class="mb-1">Some of our users</h2>
        <h3 class="lead text-muted mb-3">Hear what our users have to say</h3>
      </div>
    </div>
    <div class="row justify-content-center py-5">
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body">


            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <div class="profile">
              <img src="demo/img/sections/team/1.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>Jane Doe</h4>
              <small>CEO - Founder</small>
            </div>
          </div>
        </div>
      </div>
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <div class="profile">
              <img src="demo/img/sections/team/2.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>John Doe</h4>
              <small>CTO - Co-Founder</small>
            </div>
          </div>
        </div>
      </div>
      <div class="card col-md-3">
        <div class="card-content">
          <div class="card-body">
            <svg enable-background="new 0 0 33 25" version="1.1" viewBox="0 0 33 25" width="42" height="42" fill="#0d6efd" xml:space="preserve" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
              <g>
                <path d="M18.006,6.538c0-1.973,0.662-3.554,1.988-4.743c1.326-1.19,2.977-1.785,4.947-1.785   c2.517,0,4.488,0.799,5.916,2.397C32.285,4.004,33,6.13,33,8.782c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.061,4.743c-1.188,1.258-2.43,2.244-3.723,2.958c-1.291,0.714-2.413,1.239-3.365,1.581l-3.265-5.508   c1.36-0.545,2.517-1.412,3.468-2.602c0.953-1.19,1.496-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.724-1.786   C18.566,10.09,18.006,8.509,18.006,6.538z M0.359,6.538c0-1.973,0.663-3.554,1.989-4.743C3.674,0.604,5.324,0.01,7.295,0.01   c2.518,0,4.488,0.799,5.916,2.397c1.429,1.597,2.143,3.723,2.143,6.375c0,2.719-0.424,5.032-1.275,6.936   c-0.85,1.903-1.869,3.483-3.06,4.743c-1.188,1.258-2.431,2.244-3.724,2.958C6.004,24.133,4.883,24.658,3.93,25l-3.264-5.508   c1.36-0.545,2.516-1.412,3.467-2.602c0.953-1.19,1.497-2.465,1.633-3.824c-1.359,0-2.602-0.597-3.723-1.786   C0.92,10.09,0.359,8.509,0.359,6.538z"></path>
              </g>
            </svg>


            <div class="card-subtitle mt-3">
              <p class="text-muted"> I really enjoyed working with them, they are Group of Professionals and they know what they're Doing</p>
            </div>

            <div class="profile">
              <img src="demo/img/sections/team/3.webp" loading="lazy" class="img-fluid" alt="team">
            </div>
            <div class="card-title mt-4">
              <h4>Jane Doe</h4>
              <small>CSO - Financial</small>
            </div>
          </div>
        </div>
      </div>
    </div>
</section>`
});
	Vvveb.SectionsGroup["Testimonials"] = ["testimonials/testimonials-1","testimonials/testimonials-2","testimonials/testimonials-3"];
